/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.commands;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenInput;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenOutput;
import org.eclipse.vjet.core.codegen.bootstrap.IJava2JsCodeGenTool;
import org.eclipse.vjet.core.codegen.bootstrap.IToolMonitor;
import org.eclipse.vjet.eclipse.javatojs.ui.Java2JsPlugin;
import org.eclipse.vjet.eclipse.javatojs.ui.adapters.ToolMonitor;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.ClassloaderUtils;
import org.eclipse.vjet.eclipse.javatojs.ui.markers.Java2JsMarker;

public class Java2JsGenerateJob
extends WorkspaceJob {
    private List<IJava2JsCodeGenInput> input;
    private List<IJava2JsCodeGenOutput> output;

    public Java2JsGenerateJob(List<IJava2JsCodeGenInput> input) {
        super("Java2Js Generate Job");
        this.input = input;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask("Generate ", 50);
                    MessageConsoleStream stream = Java2JsPlugin.getDefault().getConsole().newMessageStream();
                    IJava2JsCodeGenTool generator = Java2JsGenerateJob.this.getGenerator();
                    Java2JsGenerateJob.this.output = generator.generate(Java2JsGenerateJob.this.input, (IToolMonitor)new ToolMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 30), (OutputStream)stream));
                    stream.println("Generator output:");
                    for (IJava2JsCodeGenOutput item : Java2JsGenerateJob.this.output) {
                        stream.println(item.getUrl().toString());
                    }
                    Java2JsGenerateJob.this.mark((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    Java2JsGenerateJob.this.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    stream.println("Generator complete.");
                }
                finally {
                    monitor.done();
                }
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.run(runnable, monitor);
        return Status.OK_STATUS;
    }

    protected void mark(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Create markers", this.input.size() + this.output.size());
            for (IJava2JsCodeGenInput in : this.input) {
                Java2JsMarker.clearMarkers(in);
                monitor.worked(1);
            }
            for (IJava2JsCodeGenOutput out : this.output) {
                Java2JsMarker.mark(out);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void refresh(IProgressMonitor monitor) {
        try {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (IJava2JsCodeGenInput item : this.input) {
                IResource resource;
                if (!(item instanceof IAdaptable) || (resource = (IResource)((IAdaptable)item).getAdapter(IResource.class)) == null) continue;
                projects.add(resource.getProject());
            }
            monitor.beginTask("Refresh workspace", projects.size());
            for (IProject project : projects) {
                try {
                    project.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    Java2JsPlugin.logException((Exception)((Object)e));
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    public List<IJava2JsCodeGenOutput> getOutput() {
        return this.output;
    }

    protected IJava2JsCodeGenTool getGenerator() {
        Object obj = ClassloaderUtils.getWorkspaceObject("org.eclipse.vjet.eclipse.javatojs.core.JavaToJsCodeGenTool", ClassloaderUtils.ClassLoaderKey.DEFAULT);
        if (obj instanceof IJava2JsCodeGenTool) {
            return (IJava2JsCodeGenTool)obj;
        }
        return null;
    }
}

