/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences.formatting;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vjet.eclipse.internal.ui.preferences.PreferencesAccess;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.CompilationUnitPreview;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterMessages;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterModifyDialog;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterProfileManager;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.FormatterProfileStore;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.IProfileVersioner;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.JavaPreview;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ModifyDialog;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileConfigurationBlock;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileManager;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileStore;
import org.eclipse.vjet.eclipse.internal.ui.preferences.formatting.ProfileVersioner;

public class CodeFormatterConfigurationBlock
extends ProfileConfigurationBlock {
    private static final String FORMATTER_DIALOG_PREFERENCE_KEY = "formatter_page";
    private static final String DIALOGSTORE_LASTSAVELOADPATH = "org.eclipse.vjet.eclipse.ui.codeformatter";
    protected final String PREVIEW = "/**\n* " + FormatterMessages.CodingStyleConfigurationBlock_preview_title + "\n*/\n\n" + "var index=0;" + "var arr=[];" + "var obj={x:\"\",y:function(){}};" + "function foo(){var1= new Object();}" + "function pop(){return arr[index--];}" + "function push( elem){arr[index++]=elem;}" + "function isEmpty() {return index==0;}";
    private JavaPreview fJavaPreview;

    public CodeFormatterConfigurationBlock(IProject project, PreferencesAccess access) {
        super(project, access, DIALOGSTORE_LASTSAVELOADPATH);
    }

    @Override
    protected IProfileVersioner createProfileVersioner() {
        return new ProfileVersioner();
    }

    @Override
    protected ProfileStore createProfileStore(IProfileVersioner versioner) {
        return new FormatterProfileStore(versioner);
    }

    @Override
    protected ProfileManager createProfileManager(List profiles, IScopeContext context, PreferencesAccess access, IProfileVersioner profileVersioner) {
        return new FormatterProfileManager(profiles, context, access, profileVersioner);
    }

    @Override
    protected void configurePreview(Composite composite, int numColumns, ProfileManager profileManager) {
        CodeFormatterConfigurationBlock.createLabel(composite, FormatterMessages.CodingStyleConfigurationBlock_preview_label_text, numColumns);
        CompilationUnitPreview result = new CompilationUnitPreview(profileManager.getSelected().getSettings(), composite);
        result.setPreviewText(this.PREVIEW);
        this.fJavaPreview = result;
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fJavaPreview.getControl().setLayoutData((Object)gd);
        new PreviewController(profileManager);
    }

    @Override
    protected ModifyDialog createModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile) {
        return new FormatterModifyDialog(shell, profile, profileManager, profileStore, newProfile, FORMATTER_DIALOG_PREFERENCE_KEY, DIALOGSTORE_LASTSAVELOADPATH);
    }

    private class PreviewController
    implements Observer {
        public PreviewController(ProfileManager profileManager) {
            profileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(profileManager.getSelected().getSettings());
            CodeFormatterConfigurationBlock.this.fJavaPreview.update();
        }

        @Override
        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(((ProfileManager)o).getSelected().getSettings());
                    CodeFormatterConfigurationBlock.this.fJavaPreview.update();
                }
            }
        }
    }
}

