/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.dltk.mod.internal.core.IJSModelElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.util.VjoFlags;
import org.eclipse.dltk.mod.internal.corext.refactoring.Checks;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.RenameSourceModuleChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.dltk.mod.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.dltk.mod.internal.corext.refactoring.participants.RenameTypeArguments;
import org.eclipse.dltk.mod.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.mod.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.dltk.mod.internal.corext.refactoring.vjet.descriptors.RenameModelElementDescriptor;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.PatternQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.vjet.eclipse.core.IImportContainer;
import org.eclipse.vjet.eclipse.core.IImportDeclaration;
import org.eclipse.vjet.eclipse.core.IJSSourceModule;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.core.RefactoringScopeFactory;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.core.RefactoringSearchEngine;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.core.SearchResultGroup;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.rename.TextMatchUpdater;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.rename.TypeOccurrenceCollector;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.util.VjoChecks;

public class RenameVjoTypeProcessor
extends ScriptRenameProcessor
implements ITextUpdating,
IReferenceUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper {
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_MATCHING_STRATEGY = "matchStrategy";
    private static final GroupCategorySet CATEGORY_TYPE_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.type", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_type_description));
    private static final GroupCategorySet CATEGORY_METHOD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.method", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_method_description));
    private static final GroupCategorySet CATEGORY_FIELD_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.field", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_fields_description));
    private static final GroupCategorySet CATEGORY_LOCAL_RENAME = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.refactoring.rename.renameType.local", RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables, RefactoringCoreMessages.RenameTypeProcessor_changeCategory_local_variables_description));
    private IType fType;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameTypeProcessor";
    private boolean fUpdateSimilarElements;
    private Map fFinalSimilarElementToName = null;
    private int fRenamingStrategy;
    private LinkedHashMap fPreloadedElementToName = null;
    private Map fPreloadedElementToSelection = null;
    private LinkedHashMap fPreloadedElementToNameDefault = null;
    private String fCachedNewName = null;
    private boolean fCachedRenameSimilarElements = false;
    private int fCachedRenamingStrategy = -1;
    private RefactoringStatus fCachedRefactoringStatus = null;

    public RenameVjoTypeProcessor(IType type) {
        this.fType = type;
        if (type != null) {
            this.setNewElementName(type.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fUpdateSimilarElements = false;
        this.fRenamingStrategy = 1;
    }

    public IType getType() {
        return this.fType;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable((IType)this.fType);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTypeRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return ScriptProcessors.computeAffectedNatures((IModelElement)this.fType);
    }

    public Object[] getElements() {
        return new Object[]{this.fType};
    }

    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fType, new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements()), this.createParticipantDescriptorFilter());
        if (this.isPrimaryType()) {
            ISourceModule cu = this.fType.getSourceModule();
            String newCUName = this.getNewCompilationUnit().getElementName();
            result.rename(cu, new RenameArguments(newCUName, this.getUpdateReferences()));
        }
        return result;
    }

    private boolean isPrimaryType() {
        String cuName = this.fType.getSourceModule().getElementName();
        String typeName = this.fType.getElementName();
        return Checks.isTopLevel((IType)this.fType) && typeName.equals(this.removeExtension(cuName));
    }

    private String removeExtension(String cuName) {
        if (cuName == null) {
            return "";
        }
        return cuName.substring(0, cuName.lastIndexOf(".js"));
    }

    public String getCurrentElementName() {
        return this.fType.getElementName();
    }

    public String getCurrentElementQualifier() {
        return ScriptModelUtil.getTypeContainerName((IType)this.fType);
    }

    public RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = Checks.checkTypeName((String)newName);
        if (Checks.isAlreadyNamed((IModelElement)this.fType, (String)newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameTypeRefactoring_choose_another_name);
        }
        return result;
    }

    public Object getNewElement() {
        if (Checks.isTopLevel((IType)this.fType)) {
            return this.getNewCompilationUnit().getType(this.getNewElementName());
        }
        return this.fType.getDeclaringType().getType(this.getNewElementName());
    }

    private ISourceModule getNewCompilationUnit() {
        ISourceModule cu = this.fType.getSourceModule();
        if (this.isPrimaryType()) {
            IScriptFolder parent = this.fType.getScriptFolder();
            String renamedCUName = ScriptModelUtil.getRenamedCUName((ISourceModule)cu, (String)this.getNewElementName());
            return parent.getSourceModule(renamedCUName);
        }
        return cu;
    }

    protected RenameArguments createRenameArguments() {
        return new RenameTypeArguments(this.getNewElementName(), this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
    }

    protected IParticipantDescriptorFilter createParticipantDescriptorFilter() {
        if (!this.getUpdateSimilarDeclarations()) {
            return null;
        }
        return new ParticipantDescriptorFilter();
    }

    protected IFile[] getChangedFiles() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(Arrays.asList(ResourceUtil.getFiles((ISourceModule[])this.fChangeManager.getAllSourceModules())));
        if (this.fQualifiedNameSearchResult != null) {
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        if (this.willRenameCU()) {
            result.add(ResourceUtil.getFile((ISourceModule)this.fType.getSourceModule()));
        }
        return result.toArray(new IFile[result.size()]);
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fType.getScriptFolder().isRootFolder() && !(this.fType.getParent() instanceof IType);
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        this.fFilePatterns = patterns;
    }

    public boolean canEnableSimilarDeclarationUpdating() {
        String property;
        IProduct product = Platform.getProduct();
        return product == null || !"false".equalsIgnoreCase(property = product.getProperty("org.eclipse.jdt.ui.refactoring.handlesSimilarDeclarations"));
    }

    public void setUpdateSimilarDeclarations(boolean update) {
        this.fUpdateSimilarElements = update;
    }

    public boolean getUpdateSimilarDeclarations() {
        return this.fUpdateSimilarElements;
    }

    public int getMatchStrategy() {
        return this.fRenamingStrategy;
    }

    public void setMatchStrategy(int selectedStrategy) {
        this.fRenamingStrategy = selectedStrategy;
    }

    public IModelElement[] getSimilarElements() {
        if (this.fFinalSimilarElementToName == null) {
            return null;
        }
        Set keys = this.fFinalSimilarElementToName.keySet();
        return keys.toArray(new IModelElement[keys.size()]);
    }

    public IResource getRefactoredResource(IResource element) {
        if (element instanceof IFile && Checks.isTopLevel((IType)this.fType) && element.equals((Object)this.fType.getResource())) {
            return this.getNewCompilationUnit().getResource();
        }
        return element;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IType primary = (IType)this.fType.getPrimaryElement();
        if (primary == null || !primary.exists()) {
            String message = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_does_not_exist, ScriptModelUtil.getFullyQualifiedName((IType)this.fType), this.fType.getSourceModule().getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fType = primary;
        return Checks.checkIfCuBroken((IType)this.fType);
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull((Object)this.fType, (String)"type");
        Assert.isNotNull((Object)this.getNewElementName(), (String)"newName");
        RefactoringStatus result = new RefactoringStatus();
        int referenceSearchTicks = this.fUpdateReferences || this.fUpdateSimilarElements ? 15 : 0;
        int affectedCusTicks = this.fUpdateReferences || this.fUpdateSimilarElements ? 10 : 1;
        int similarElementTicks = this.fUpdateSimilarElements ? 85 : 0;
        int createChangeTicks = 5;
        int qualifiedNamesTicks = this.fUpdateQualifiedNames ? 50 : 0;
        try {
            pm.beginTask("", 12 + referenceSearchTicks + affectedCusTicks + similarElementTicks + createChangeTicks + qualifiedNamesTicks);
            pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
            this.fChangeManager = new TextChangeManager(true);
            result.merge(this.checkNewElementName(this.getNewElementName()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(Checks.checkIfCuBroken((IType)this.fType));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkTypesInCompilationUnit());
            pm.worked(1);
            result.merge(this.checkImportedTypes());
            pm.worked(1);
            if (Checks.isTopLevel((IType)this.fType) && VjoFlags.isPublic((IMember)this.fType)) {
                result.merge(Checks.checkSourceModuleNewName((ISourceModule)this.fType.getSourceModule(), (String)this.getNewElementName()));
            }
            pm.worked(1);
            if (this.isPrimaryType()) {
                result.merge(this.checkNewPathValidity());
            }
            pm.worked(1);
            result.merge(this.checkEnclosingTypes());
            pm.worked(1);
            result.merge(this.checkEnclosedTypes());
            pm.worked(1);
            result.merge(this.checkTypesInPackage());
            pm.worked(1);
            result.merge(this.checkTypesImportedInCu());
            pm.worked(1);
            result.merge(Checks.checkForMainMethods((IType)this.fType));
            pm.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.analyseEnclosedTypes());
            pm.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_searching);
                result.merge(this.initializeReferences((IProgressMonitor)new SubProgressMonitor(pm, referenceSearchTicks)));
            } else {
                this.fReferences = new SearchResultGroup[0];
            }
            pm.setTaskName(RefactoringCoreMessages.RenameTypeRefactoring_checking);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.fUpdateReferences || this.fUpdateSimilarElements) {
                result.merge(this.analyzeAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, affectedCusTicks)));
            } else {
                Checks.checkCompileErrorsInAffectedFile((RefactoringStatus)result, (IResource)this.fType.getResource());
                pm.worked(affectedCusTicks);
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, createChangeTicks));
            if (this.fUpdateQualifiedNames) {
                this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, qualifiedNamesTicks));
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus initializeReferences(IProgressMonitor monitor) throws ModelException, OperationCanceledException {
        Assert.isNotNull((Object)this.fType);
        Assert.isNotNull((Object)this.getNewElementName());
        if (this.fReferences != null && this.getNewElementName().equals(this.fCachedNewName) && this.fCachedRenameSimilarElements == this.getUpdateSimilarDeclarations() && this.fCachedRenamingStrategy == this.fRenamingStrategy) {
            return this.fCachedRefactoringStatus;
        }
        this.fCachedNewName = this.getNewElementName();
        this.fCachedRenameSimilarElements = this.fUpdateSimilarElements;
        this.fCachedRenamingStrategy = this.fRenamingStrategy;
        this.fCachedRefactoringStatus = new RefactoringStatus();
        try {
            ElementQuerySpecification elementQuerySpecification = new ElementQuerySpecification((IModelElement)this.fType, 1, RefactoringScopeFactory.create((IModelElement)this.fType), "wait...");
            this.fReferences = RefactoringSearchEngine.search((QuerySpecification)elementQuerySpecification, new TypeOccurrenceCollector(this.fType), monitor, this.fCachedRefactoringStatus);
            this.fReferences = VjoChecks.excludeSourceModules(this.fReferences, this.fCachedRefactoringStatus);
            monitor.beginTask("", this.fReferences.length);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.fReferences = null;
            throw new OperationCanceledException();
        }
        return this.fCachedRefactoringStatus;
    }

    private RefactoringStatus checkNewPathValidity() {
        IContainer c = this.fType.getSourceModule().getResource().getParent();
        String notRename = RefactoringCoreMessages.RenameTypeRefactoring_will_not_rename;
        IStatus status = c.getWorkspace().validateName(this.getNewElementName(), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        status = c.getWorkspace().validatePath(this.createNewPath(this.getNewElementName()), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        return new RefactoringStatus();
    }

    private String createNewPath(String newName) {
        return this.fType.getSourceModule().getResource().getFullPath().removeLastSegments(1).append(newName).toString();
    }

    private RefactoringStatus checkTypesImportedInCu() throws CoreException {
        IImportDeclaration imp = RenameVjoTypeProcessor.getImportedType(this.fType.getSourceModule(), this.getNewElementName());
        if (imp == null) {
            return null;
        }
        String msg = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_imported, this.getNewElementName(), this.fType.getSourceModule().getResource().getFullPath());
        IModelElement grandParent = imp.getParent().getParent();
        if (grandParent instanceof ISourceModule) {
            return RefactoringStatus.createErrorStatus((String)msg);
        }
        return null;
    }

    private RefactoringStatus checkTypesInPackage() throws CoreException {
        IType type = Checks.findTypeInScriptFolder((IScriptFolder)this.fType.getScriptFolder(), (String)this.getNewElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String msg = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_exists, this.getNewElementName(), this.fType.getScriptFolder().getElementName());
        return RefactoringStatus.createErrorStatus((String)msg);
    }

    private RefactoringStatus checkEnclosedTypes() throws CoreException {
        IType enclosedType = RenameVjoTypeProcessor.findEnclosedType(this.fType, this.getNewElementName());
        if (enclosedType == null) {
            return null;
        }
        String msg = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_encloses, ScriptModelUtil.getFullyQualifiedName((IType)this.fType), this.getNewElementName());
        return RefactoringStatus.createErrorStatus((String)msg);
    }

    private RefactoringStatus checkEnclosingTypes() {
        IType enclosingType = RenameVjoTypeProcessor.findEnclosingType(this.fType, this.getNewElementName());
        if (enclosingType == null) {
            return null;
        }
        String msg = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_enclosed, ScriptModelUtil.getFullyQualifiedName((IType)this.fType), this.getNewElementName());
        return RefactoringStatus.createErrorStatus((String)msg);
    }

    private static IType findEnclosedType(IType type, String newName) throws CoreException {
        IType[] enclosedTypes = type.getTypes();
        int i = 0;
        while (i < enclosedTypes.length) {
            if (newName.equals(enclosedTypes[i].getElementName()) || RenameVjoTypeProcessor.findEnclosedType(enclosedTypes[i], newName) != null) {
                return enclosedTypes[i];
            }
            ++i;
        }
        return null;
    }

    private static IType findEnclosingType(IType type, String newName) {
        IType enclosing = type.getDeclaringType();
        while (enclosing != null) {
            if (newName.equals(enclosing.getElementName())) {
                return enclosing;
            }
            enclosing = enclosing.getDeclaringType();
        }
        return null;
    }

    private static IImportDeclaration getImportedType(ISourceModule cu, String typeName) throws CoreException {
        IImportDeclaration[] imports = RenameVjoTypeProcessor.getImports((IJSSourceModule)cu);
        String dotTypeName = "." + typeName;
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getElementName().endsWith(dotTypeName)) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }

    private static IImportDeclaration[] getImports(IJSSourceModule jSourceModule) throws ModelException {
        IImportDeclaration[] NO_IMPORTS;
        IImportDeclaration[] imports = NO_IMPORTS = new IImportDeclaration[0];
        ArrayList<IImportDeclaration> al = new ArrayList<IImportDeclaration>();
        IImportContainer container = jSourceModule.getImportContainer();
        ModelManager manager = ModelManager.getModelManager();
        Object info = manager.getInfo((IModelElement)container);
        if (info == null) {
            return NO_IMPORTS;
        }
        imports = ((IJSModelElementInfo)info).getChildren();
        int i = 0;
        while (i < imports.length) {
            al.add(imports[i]);
            ++i;
        }
        return al.toArray(new IImportDeclaration[al.size()]);
    }

    private RefactoringStatus checkImportedTypes() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IImportDeclaration[] imports = RenameVjoTypeProcessor.getImports((IJSSourceModule)this.fType.getSourceModule());
        int i = 0;
        while (i < imports.length) {
            this.analyzeImportDeclaration(imports[i], result);
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypesInCompilationUnit() {
        IType siblingType;
        RefactoringStatus result = new RefactoringStatus();
        if (!Checks.isTopLevel((IType)this.fType) && (siblingType = this.fType.getDeclaringType().getType(this.getNewElementName())).exists()) {
            String msg = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_member_type_exists, this.getNewElementName(), ScriptModelUtil.getFullyQualifiedName((IType)this.fType.getDeclaringType()));
            result.addError(msg);
        }
        return result;
    }

    private RefactoringStatus analyseEnclosedTypes() throws CoreException {
        this.fType.getSourceRange();
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    private static ISourceModule getCompilationUnit(IImportDeclaration imp) {
        return (ISourceModule)imp.getParent().getParent();
    }

    private void analyzeImportedTypes(IType[] types, RefactoringStatus result, IImportDeclaration imp) throws CoreException {
        int i = 0;
        while (i < types.length) {
            if (VjoFlags.isPublic((IMember)types[i]) && types[i].getElementName().equals(this.getNewElementName())) {
                String msg = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_name_conflict1, ScriptModelUtil.getFullyQualifiedName((IType)types[i]), RenameVjoTypeProcessor.getFullPath(RenameVjoTypeProcessor.getCompilationUnit(imp)));
                result.addError(msg);
            }
            ++i;
        }
    }

    private static IModelElement convertFromImportDeclaration(IImportDeclaration declaration) throws CoreException {
        if (declaration.isOnDemand()) {
            String packageName = declaration.getElementName().substring(0, declaration.getElementName().length() - 2);
            return ScriptModelUtil.findTypeContainer((IScriptProject)declaration.getScriptProject(), (String)packageName);
        }
        return ScriptModelUtil.findTypeContainer((IScriptProject)declaration.getScriptProject(), (String)declaration.getElementName());
    }

    private void analyzeImportDeclaration(IImportDeclaration imp, RefactoringStatus result) throws CoreException {
        if (!imp.isOnDemand()) {
            return;
        }
        IModelElement imported = RenameVjoTypeProcessor.convertFromImportDeclaration(imp);
        if (imported == null) {
            return;
        }
        if (imported instanceof IScriptFolder) {
            ISourceModule[] cus = ((IScriptFolder)imported).getSourceModules();
            int i = 0;
            while (i < cus.length) {
                this.analyzeImportedTypes(cus[i].getTypes(), result, imp);
                ++i;
            }
        } else {
            this.analyzeImportedTypes(((IType)imported).getTypes(), result, imp);
        }
    }

    private RefactoringStatus analyzeAffectedCompilationUnits(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(VjoChecks.checkCompileErrorsInAffectedFile(this.fReferences));
        pm.beginTask("", this.fReferences.length);
        result.merge(this.checkConflictingTypes(pm));
        return result;
    }

    private RefactoringStatus checkConflictingTypes(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IDLTKSearchScope scope = RefactoringScopeFactory.create((IModelElement)this.fType);
        PatternQuerySpecification patternQuerySpecification = new PatternQuerySpecification(this.getNewElementName(), 0, true, 2, scope, "wait...");
        ISourceModule[] cusWithReferencesToConflictingTypes = RefactoringSearchEngine.findAffectedSourceModules((QuerySpecification)patternQuerySpecification, pm, result);
        if (cusWithReferencesToConflictingTypes.length == 0) {
            return result;
        }
        ISourceModule[] cusWithReferencesToRenamedType = RenameVjoTypeProcessor.getCus(this.fReferences);
        ISourceModule[] intersection = RenameVjoTypeProcessor.isIntersectionEmpty(cusWithReferencesToRenamedType, cusWithReferencesToConflictingTypes);
        if (intersection.length == 0) {
            return result;
        }
        int i = 0;
        while (i < intersection.length) {
            String message = MessageFormat.format(RefactoringCoreMessages.RenameTypeRefactoring_another_type, this.getNewElementName(), intersection[i].getElementName());
            result.addError(message);
            ++i;
        }
        return result;
    }

    private static ISourceModule[] isIntersectionEmpty(ISourceModule[] a1, ISourceModule[] a2) {
        HashSet<ISourceModule> set1 = new HashSet<ISourceModule>(Arrays.asList(a1));
        HashSet<ISourceModule> set2 = new HashSet<ISourceModule>(Arrays.asList(a2));
        set1.retainAll(set2);
        return set1.toArray(new ISourceModule[set1.size()]);
    }

    private static ISourceModule[] getCus(SearchResultGroup[] searchResultGroups) {
        ArrayList<ISourceModule> cus = new ArrayList<ISourceModule>(searchResultGroups.length);
        int i = 0;
        while (i < searchResultGroups.length) {
            ISourceModule cu = searchResultGroups[i].getSourceModule();
            if (cu != null) {
                cus.add(cu);
            }
            ++i;
        }
        return cus.toArray(new ISourceModule[cus.size()]);
    }

    private static String getFullPath(ISourceModule cu) {
        Assert.isTrue((boolean)cu.exists());
        return cu.getResource().getFullPath().toString();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            TextChange textChange;
            monitor.beginTask(RefactoringCoreMessages.RenameTypeRefactoring_creating_change, 4);
            String project = null;
            IScriptProject javaProject = this.fType.getScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 2;
            try {
                if (!Flags.isPrivate((int)this.fType.getFlags())) {
                    flags |= 4;
                }
            }
            catch (ModelException exception) {
                DLTKUIPlugin.log((Throwable)exception);
            }
            String description = MessageFormat.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description_short, this.fType.getElementName());
            String header = MessageFormat.format(RefactoringCoreMessages.RenameTypeProcessor_descriptor_description, ScriptElementLabels.getDefault().getElementLabel((IModelElement)this.fType, ScriptElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName());
            String comment = new JDTRefactoringDescriptorComment(project, (Object)this, header).asString();
            RenameModelElementDescriptor descriptor2 = new RenameModelElementDescriptor("TODO");
            descriptor2.setProject(project);
            descriptor2.setDescription(description);
            descriptor2.setComment(comment);
            descriptor2.setFlags(flags);
            descriptor2.setModelElement((IModelElement)this.fType);
            descriptor2.setNewName(this.getNewElementName());
            descriptor2.setUpdateQualifiedNames(this.fUpdateQualifiedNames);
            descriptor2.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
            descriptor2.setUpdateReferences(this.fUpdateReferences);
            if (this.fUpdateQualifiedNames && this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                descriptor2.setFileNamePatterns(this.fFilePatterns);
            }
            descriptor2.setUpdateSimilarDeclarations(this.fUpdateSimilarElements);
            descriptor2.setMatchStrategy(this.fRenamingStrategy);
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((RefactoringDescriptor)descriptor2, RefactoringCoreMessages.RenameTypeProcessor_change_name);
            if (this.fChangeManager.containsChangesIn(this.fType.getSourceModule()) && (textChange = this.fChangeManager.get(this.fType.getSourceModule())) instanceof TextFileChange) {
                ((TextFileChange)textChange).setSaveMode(2);
            }
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            if (this.willRenameCU()) {
                IResource resource = this.fType.getSourceModule().getResource();
                if (resource != null && resource.isLinked()) {
                    String ext = resource.getFileExtension();
                    String renamedResourceName = ext == null ? this.getNewElementName() : String.valueOf(this.getNewElementName()) + '.' + ext;
                    result.add((Change)new RenameResourceChange(null, this.fType.getSourceModule().getResource(), renamedResourceName, comment));
                } else {
                    String renamedCUName = ScriptModelUtil.getRenamedCUName((ISourceModule)this.fType.getSourceModule(), (String)this.getNewElementName());
                    result.add((Change)new RenameSourceModuleChange((RefactoringDescriptor)descriptor2, this.fType.getSourceModule(), renamedCUName, comment));
                }
            }
            monitor.worked(1);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            this.fChangeManager = null;
        }
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            try {
                Change change = this.fQualifiedNameSearchResult.getSingleChange(Checks.getModifiedFiles((Change[])participantChanges));
                return change;
            }
            finally {
                this.fQualifiedNameSearchResult = null;
            }
        }
        return null;
    }

    private boolean willRenameCU() throws CoreException {
        String name = this.removeExtension(this.fType.getSourceModule().getElementName());
        if (!Checks.isTopLevel((IType)this.fType) || !name.equals(this.fType.getElementName())) {
            return false;
        }
        if (!this.checkNewPathValidity().isOK()) {
            return false;
        }
        return Checks.checkSourceModuleNewName((ISourceModule)this.fType.getSourceModule(), (String)this.getNewElementName()).isOK();
    }

    private void createChanges(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 12);
            pm.setTaskName(RefactoringCoreMessages.RenameTypeProcessor_creating_changes);
            if (this.fUpdateReferences) {
                this.addReferenceUpdates(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            pm.worked(1);
            IResource resource = this.fType.getSourceModule().getResource();
            if (resource != null && resource.isLinked() || !this.willRenameCU()) {
                this.addTypeDeclarationUpdate(this.fChangeManager);
                pm.worked(1);
            } else {
                pm.worked(2);
            }
            if (this.fUpdateTextualMatches) {
                pm.subTask(RefactoringCoreMessages.RenameTypeRefactoring_searching_text);
                TextMatchUpdater.perform((IProgressMonitor)new SubProgressMonitor(pm, 1), RefactoringScopeFactory.create((IModelElement)this.fType), this, this.fChangeManager, this.fReferences);
            }
        }
        finally {
            pm.done();
        }
    }

    private void addTypeDeclarationUpdate(TextChangeManager manager) throws CoreException {
        String name = RefactoringCoreMessages.RenameTypeRefactoring_update;
        int typeNameLength = this.fType.getElementName().length();
        ISourceModule cu = this.fType.getSourceModule();
        TextChangeCompatibility.addTextEdit((TextChange)manager.get(cu), (String)name, (TextEdit)new ReplaceEdit(this.fType.getNameRange().getOffset(), typeNameLength, this.getNewElementName()));
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        int i = 0;
        while (i < this.fReferences.length) {
            ISourceModule cu = this.fReferences[i].getSourceModule();
            if (cu != null) {
                String name = RefactoringCoreMessages.RenameTypeRefactoring_update_reference;
                SearchMatch[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch match = results[j];
                    ReplaceEdit replaceEdit = new ReplaceEdit(match.getOffset(), match.getLength(), this.getNewElementName());
                    TextChangeCompatibility.addTextEdit((TextChange)manager.get(cu), (String)name, (TextEdit)replaceEdit, (GroupCategorySet)CATEGORY_TYPE_RENAME);
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws CoreException {
        IScriptFolder fragment = this.fType.getScriptFolder();
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process((QualifiedNameSearchResult)this.fQualifiedNameSearchResult, (String)this.fType.getFullyQualifiedName(), (String)(String.valueOf(fragment.getElementName()) + "." + this.getNewElementName()), (String)this.fFilePatterns, (IProject)this.fType.getScriptProject().getProject(), (IProgressMonitor)pm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (!(arguments instanceof ScriptRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        ScriptRefactoringArguments extended = (ScriptRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        IModelElement element = ScriptRefactoringDescriptor.handleToElement((String)extended.getProject(), (String)handle, (boolean)false);
        if (element == null || !element.exists() || element.getElementType() != 7) {
            return ScriptableRefactoring.createInputFatalStatus((Object)element, (String)this.getRefactoring().getName(), (String)"org.eclipse.vjet.eclipse.ui.rename.type");
        }
        this.fType = (IType)element;
        String name = extended.getAttribute("name");
        if (name != null && !"".equals(name)) {
            this.setNewElementName(name);
        } else {
            this.setNewElementName(this.fType.getElementName());
        }
        String patterns = extended.getAttribute(ATTRIBUTE_PATTERNS);
        if (patterns != null && !"".equals(patterns)) {
            this.fFilePatterns = patterns;
        }
        if ((references = extended.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_TEXTUAL_MATCHES));
        }
        this.fUpdateTextualMatches = Boolean.valueOf(matches);
        String qualified = extended.getAttribute(ATTRIBUTE_QUALIFIED);
        if (qualified == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_QUALIFIED));
        }
        this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
        String similarDeclarations = extended.getAttribute(ATTRIBUTE_SIMILAR_DECLARATIONS);
        if (similarDeclarations == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_SIMILAR_DECLARATIONS));
        }
        this.fUpdateSimilarElements = Boolean.valueOf(similarDeclarations);
        String similarDeclarationsMatchingStrategy = extended.getAttribute(ATTRIBUTE_MATCHING_STRATEGY);
        if (similarDeclarationsMatchingStrategy == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_MATCHING_STRATEGY));
        try {
            this.fRenamingStrategy = Integer.valueOf(similarDeclarationsMatchingStrategy);
            return new RefactoringStatus();
        }
        catch (NumberFormatException numberFormatException) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_illegal_argument, (Object[])new String[]{similarDeclarationsMatchingStrategy, ATTRIBUTE_QUALIFIED}));
        }
    }

    private List getProcessorsOfType(List processors, Class type) {
        ArrayList<RefactoringProcessor> tmp = new ArrayList<RefactoringProcessor>();
        for (RefactoringProcessor element : processors) {
            if (!element.getClass().equals(type)) continue;
            tmp.add(element);
        }
        return tmp;
    }

    public boolean hasSimilarElementsToRename() {
        return false;
    }

    public IModelElement getRefactoredModelElement(IModelElement element) {
        return this.fType;
    }

    private class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor monitor, int ticks) {
            super(monitor, ticks, 2);
        }

        public void setTaskName(String name) {
        }
    }

    public static final class ParticipantDescriptorFilter
    implements IParticipantDescriptorFilter {
        public boolean select(IConfigurationElement element, RefactoringStatus status) {
            IConfigurationElement[] params = element.getChildren("param");
            int i = 0;
            while (i < params.length) {
                IConfigurationElement param = params[i];
                if ("handlesSimilarDeclarations".equals(param.getAttribute("name")) && "false".equals(param.getAttribute("value"))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

