/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.text.completion.ProposalContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vjet.eclipse.core.IJSMethod;

public class VjoProposalContextInformation
extends ProposalContextInformation {
    private static final char COMMA = ',';
    private static final String SPACE = " ";
    private final String contextDisplayString;
    private final String informationDisplayString;
    private final Image image;
    private int position;

    public VjoProposalContextInformation(CompletionProposal proposal) {
        super(proposal);
        String res;
        this.informationDisplayString = res = this.createParametersList(proposal);
        this.image = null;
        this.position = proposal.getCompletion().length == 0 ? proposal.getCompletionLocation() + 1 : -1;
        this.contextDisplayString = res;
    }

    private String createParametersList(CompletionProposal proposal) {
        String res = null;
        IModelElement element = proposal.getModelElement();
        res = element instanceof IJSMethod ? this.createParameterList(element) : this.createParameterList(proposal);
        return res;
    }

    private String createParameterList(IModelElement element) {
        String res = null;
        IJSMethod method = (IJSMethod)element;
        try {
            res = this.createParameterList(method);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return res;
    }

    private String createParameterList(IJSMethod method) throws ModelException {
        String[] names = method.getParameters();
        String[] types = method.getParameterTypes();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            String name = names[i];
            builder.append(type);
            builder.append(SPACE);
            builder.append(name);
            if (i != types.length - 1) {
                builder.append(',');
            }
            ++i;
        }
        return builder.toString();
    }

    private String createParameterList(CompletionProposal proposal) {
        StringBuffer bf = new StringBuffer();
        char[][] pNames = proposal.findParameterNames(null);
        int a = 0;
        while (a < pNames.length) {
            bf.append(pNames[a]);
            if (a != pNames.length - 1) {
                bf.append(',');
            }
            ++a;
        }
        return bf.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IContextInformation) {
            IContextInformation contextInformation = (IContextInformation)object;
            boolean equals = this.getInformationDisplayString().equalsIgnoreCase(contextInformation.getInformationDisplayString());
            if (this.getContextDisplayString() != null) {
                equals = equals && this.getContextDisplayString().equalsIgnoreCase(contextInformation.getContextDisplayString());
            }
            return equals;
        }
        return false;
    }

    public String getInformationDisplayString() {
        return this.informationDisplayString;
    }

    public Image getImage() {
        return this.image;
    }

    public String getContextDisplayString() {
        return this.contextDisplayString;
    }

    public int getContextInformationPosition() {
        return this.position;
    }

    public void setContextInformationPosition(int position) {
        this.position = position;
    }
}

