/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IPackageDeclaration;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.JSSourceFieldElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.core.JSSourceMethodElementInfo;
import org.eclipse.dltk.mod.internal.core.SourceField;
import org.eclipse.dltk.mod.internal.core.VjoLocalVariable;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.internal.core.util.Util;

public class VjoElementLabels
extends ScriptElementLabels {
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;

    public void getElementLabel(IModelElement element, long flags, StringBuffer buf) {
        int type = element.getElementType();
        switch (type) {
            case 12: {
                buf.append("import declarations");
                break;
            }
            case 13: {
                buf.append(element.getElementName());
                break;
            }
            case 11: {
                buf.append("{...}");
                break;
            }
            case 8: {
                if (element instanceof VjoLocalVariable) {
                    VjoElementLabels.getLocalVariableLabel((VjoLocalVariable)element, flags, buf);
                    break;
                }
                if (!(element instanceof SourceField)) break;
                this.getJsFieldLabel((SourceField)element, flags, buf);
                break;
            }
            case 9: {
                if (!(element instanceof IJSMethod)) break;
                this.getJsMethodLabel((IJSMethod)element, flags, buf);
                break;
            }
            case 3: {
                IProjectFragment root = (IProjectFragment)element;
                if (root.isExternal() && Util.isNativeCacheDir((IPath)root.getPath()) && (root.isArchive() || Util.isNativeCacheDir((IPath)root.getPath()))) {
                    buf.append(String.valueOf(root.getPath().lastSegment()) + "[" + "VJET SDK" + "]");
                    break;
                }
            }
            default: {
                super.getElementLabel(element, flags, buf);
            }
        }
    }

    private void getJsFieldLabel(SourceField field, long flags, StringBuffer buf) {
        try {
            if (VjoElementLabels.getFlag(flags, 65536L)) {
                this.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
                buf.append('.');
            }
            this.getFieldNameAndType(field, buf);
            if (VjoElementLabels.getFlag(flags, 131072L)) {
                buf.append(" - ");
                this.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, buf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getFieldNameAndType(SourceField field, StringBuffer buf) {
        buf.append(field.getElementName());
        buf.append(" : ");
        SourceField sourceField = field;
        try {
            JSSourceFieldElementInfo elementInfo = (JSSourceFieldElementInfo)sourceField.getElementInfo();
            buf.append(elementInfo.getType());
        }
        catch (ModelException modelException) {
            buf.append("error determining type");
        }
    }

    private void getJsMethodLabel(IJSMethod method, long flags, StringBuffer buf) {
        try {
            IType declaringType;
            IType type;
            if (VjoElementLabels.getFlag(flags, 128L) && (type = method.getDeclaringType()) != null) {
                this.getTypeLabel(type, 0x40000L | flags & 0x1002000000000L, buf);
                buf.append(this.getTypeDelimiter());
            }
            buf.append(method.getElementName());
            buf.append('(');
            if (VjoElementLabels.getFlag(flags, 3L)) {
                String[] names = null;
                String[] initializers = null;
                int nParams = 0;
                if (VjoElementLabels.getFlag(flags, 1L) && method.exists()) {
                    names = method.getParameterTypes();
                    initializers = method.getParameterInitializers();
                    nParams = names.length;
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    if (names != null) {
                        buf.append(names[i]);
                        JSSourceMethodElementInfo elementInfo = (JSSourceMethodElementInfo)((JSSourceMethod)method).getElementInfo();
                        if (elementInfo.getIsVariables()[i]) {
                            buf.append("...");
                        }
                    }
                    if (VjoElementLabels.getFlag(flags, 0x2000000000000L) && initializers != null && initializers[i] != null) {
                        buf.append("=\"" + initializers[i] + "\"");
                    }
                    ++i;
                }
            } else {
                String[] params = method.getParameters();
                if (params.length > 0) {
                    buf.append("...");
                }
            }
            buf.append(')');
            if (VjoElementLabels.getFlag(flags, 256L) && (declaringType = method.getDeclaringType()) != null) {
                buf.append(" - ");
                this.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
            }
            if (method.getReturnType() != null) {
                buf.append(" : ");
                buf.append(method.getReturnType());
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    protected void getTypeLabel(IType type, long flags, StringBuffer buf) {
        String typeName;
        IPackageDeclaration pkg;
        if (type == null) {
            return;
        }
        if (VjoElementLabels.getFlag(flags, 262144L) && (pkg = this.getPackage(type)) != null) {
            if (!pkg.getElementName().equals("")) {
                buf.append(pkg.getElementName());
            } else {
                buf.append("(default package)");
            }
            buf.append('.');
        }
        if (VjoElementLabels.getFlag(flags, 786432L)) {
            IType declaringType;
            IModelElement elem = type.getParent();
            IType iType = declaringType = elem instanceof IType ? (IType)elem : null;
            if (declaringType != null) {
                this.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, buf);
                buf.append(this.getTypeDelimiter());
            } else {
                int parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8) {
                    this.getElementLabel(type.getParent(), (parentType == 9 ? 128L : 65536L) | flags & 0x1002000000000L, buf);
                    buf.append(this.getTypeDelimiter());
                }
            }
        }
        if ((typeName = type.getElementName()).length() == 0) {
            try {
                if (type.getParent() instanceof IField) {
                    typeName = "{...}";
                } else {
                    String[] superNames = type.getSuperClasses();
                    if (superNames != null) {
                        int count = 0;
                        typeName = String.valueOf(typeName) + " : ";
                        int i = 0;
                        while (i < superNames.length) {
                            if (count > 0) {
                                typeName = String.valueOf(typeName) + ",  ";
                            }
                            typeName = String.valueOf(typeName) + superNames[i];
                            ++count;
                            ++i;
                        }
                    }
                }
            }
            catch (ModelException modelException) {
                typeName = "";
            }
        }
        buf.append(typeName);
        if (VjoElementLabels.getFlag(flags, 0x100000L)) {
            int parentType;
            IType declaringType;
            IModelElement elem = type.getParent();
            IType iType = declaringType = elem instanceof IType ? (IType)elem : null;
            if (declaringType != null) {
                buf.append(" - ");
                this.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
                parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8) {
                    buf.append(this.getTypeDelimiter());
                    this.getElementLabel(type.getParent(), 0L, buf);
                }
            } else {
                IPackageDeclaration pack;
                parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8) {
                    buf.append(" - ");
                    this.getElementLabel(type.getParent(), (parentType == 9 ? 128L : 65536L) | flags & 0x1002000000000L, buf);
                }
                if ((parentType == 5 || parentType == 6) && (pack = this.getPackage(type)) != null) {
                    buf.append(" - ");
                    if (!pack.getElementName().equals("")) {
                        buf.append(pack.getElementName());
                    } else {
                        buf.append("(default package)");
                    }
                }
            }
        }
    }

    private IPackageDeclaration getPackage(IType type) {
        if (type == null) {
            return null;
        }
        ISourceModule jsModule = (ISourceModule)type.getAncestor(5);
        if (jsModule == null) {
            return null;
        }
        int parentType = jsModule.getElementType();
        if (parentType == 5 || parentType == 6) {
            IPackageDeclaration pack = null;
            try {
                IPackageDeclaration[] pkgs = jsModule.getPackageDeclarations();
                pack = pkgs.length > 0 ? pkgs[0] : null;
                return pack;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static void getLocalVariableLabel(VjoLocalVariable localVariable, long flags, StringBuffer buf) {
        buf.append(localVariable.getElementName());
        buf.append(" : ");
        buf.append(localVariable.getTypeSignature());
    }
}

