/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.actions.nature.java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.launching.ScriptRuntime;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.vjet.eclipse.core.PiggyBackClassPathUtil;
import org.eclipse.vjet.eclipse.core.sdk.VjetSdkRuntime;
import org.eclipse.vjet.eclipse.ui.actions.nature.DefaultAddVjoNaturePolicy;

public class JavaProjectAddVjoNaturePolicy
extends DefaultAddVjoNaturePolicy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accept(IProject project) {
        try {
            String[] natures = project.getDescription().getNatureIds();
            int i = 0;
            while (true) {
                if (i >= natures.length) {
                    return false;
                }
                if ("org.eclipse.jdt.core.javanature".equals(natures[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected void buildBuildPathFile(IProject project) {
        try {
            if (project.getFile(".buildpath").exists()) {
                project.getFile(".buildpath").delete(false, null);
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IBuildpathEntry[] entries = this.buildBuildpathEntry(javaProject);
            ScriptProject scriptProject = new ScriptProject(project, null);
            String buildPathContent = scriptProject.encodeBuildpath(entries, true, null);
            IFile buildPathFile = project.getFile(".buildpath");
            buildPathFile.create((InputStream)new ByteArrayInputStream(buildPathContent.getBytes()), false, null);
            PiggyBackClassPathUtil.setProjectInitialized((IProject)project);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IBuildpathEntry[] buildBuildpathEntry(IJavaProject javaProject) {
        try {
            ArrayList<IBuildpathEntry> buildpathEntryList = new ArrayList<IBuildpathEntry>();
            IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
            int i = 0;
            while (i < classPathEntries.length) {
                if (3 == classPathEntries[i].getEntryKind()) {
                    IBuildpathEntry buildpathEntry = DLTKCore.newSourceEntry((IPath)classPathEntries[i].getPath());
                    buildpathEntryList.add(buildpathEntry);
                }
                ++i;
            }
            IBuildpathEntry defaultInterpreterEntry = ScriptRuntime.getDefaultInterpreterContainerEntry();
            buildpathEntryList.add(defaultInterpreterEntry);
            IBuildpathEntry defaultSdkEntry = VjetSdkRuntime.getDefaultSdkContainerEntry();
            buildpathEntryList.add(VjetSdkRuntime.getJsSdkContainerEntry());
            buildpathEntryList.add(defaultSdkEntry);
            buildpathEntryList.addAll(PiggyBackClassPathUtil.fetchBuildEntryFromJavaProject((IJavaProject)javaProject));
            return buildpathEntryList.toArray(new IBuildpathEntry[buildpathEntryList.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new IBuildpathEntry[0];
        }
    }
}

