/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.lang.reflect.Method;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class BrowserSupport {
    public static boolean support(Method m, BrowserType type) {
        Class<?> c = m.getDeclaringClass();
        org.eclipse.vjet.dsf.jsnative.anno.BrowserSupport supportedBy = m.getAnnotation(org.eclipse.vjet.dsf.jsnative.anno.BrowserSupport.class);
        if (supportedBy == null && (supportedBy = c.getAnnotation(org.eclipse.vjet.dsf.jsnative.anno.BrowserSupport.class)) == null) {
            return true;
        }
        return BrowserSupport.support(type, supportedBy.value());
    }

    public static boolean support(BrowserType type, BrowserType[] supportedTypes) {
        BrowserType[] browserTypeArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            BrowserType supportedType = browserTypeArray[n2];
            if (supportedType.getName().equals(type.getName())) {
                int version = supportedType.getVersion();
                if (supportedType.isPlus()) {
                    return type.getVersion() >= version;
                }
                return version == type.getVersion();
            }
            ++n2;
        }
        return false;
    }

    public static BrowserType getType(String userAgent) {
        if (userAgent.indexOf("Opera") != -1) {
            if (userAgent.contains("Opera/8")) {
                return BrowserType.OPERA_8P;
            }
            if (userAgent.contains("Opera/9")) {
                return BrowserType.OPERA_9P;
            }
            return BrowserType.OPERA_7P;
        }
        if (userAgent.indexOf("Safari") != -1) {
            return BrowserType.SAFARI_3P;
        }
        if (userAgent.indexOf("Firefox") != -1) {
            if (userAgent.contains("Firefox/2")) {
                return BrowserType.FIREFOX_2P;
            }
            if (userAgent.contains("Firefox/3")) {
                return BrowserType.FIREFOX_3P;
            }
            return BrowserType.FIREFOX_1P;
        }
        if (userAgent.indexOf("MSIE") != -1) {
            if (userAgent.contains("MSIE 7")) {
                return BrowserType.IE_7P;
            }
            if (userAgent.contains("MSIE 8")) {
                return BrowserType.IE_8P;
            }
            return BrowserType.IE_6P;
        }
        return BrowserType.IE_6P;
    }
}

