/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.dap.util.DapDomHelper;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.Window;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.w3c.dom.Node;

public class DapBrowserBinding
implements IBrowserBinding {
    private final IDLCDispatcher m_dlcDispatcher;

    public DapBrowserBinding(IDLCDispatcher dlcDispatcher) {
        this.m_dlcDispatcher = dlcDispatcher;
    }

    @Override
    public String getDocumentProperty(String name) {
        return this.m_dlcDispatcher.request("document." + name, 0);
    }

    @Override
    public String getDomAttributeValue(BaseHtmlElement elem, EHtmlAttr attr) {
        return this.m_dlcDispatcher.request(String.valueOf(DapDomHelper.getPath((Node)elem)) + "." + attr.getAttributeName(), 0);
    }

    @Override
    public String getNavigatorProperty(String name) {
        return this.m_dlcDispatcher.request("navigator." + name, 0);
    }

    @Override
    public String getScreenProperty(String name) {
        return this.m_dlcDispatcher.request("screen." + name, 0);
    }

    @Override
    public int getWindowHeight() {
        int val = 0;
        String value = this.m_dlcDispatcher.request("(window.innerHeight || document.body.offsetHeight)", 0);
        if (value != null && value.length() > 0) {
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception exception) {
                val = 0;
            }
        }
        return val;
    }

    @Override
    public int getWindowWidth() {
        int val = 0;
        String value = this.m_dlcDispatcher.request("(window.innerWidth || document.body.offsetWidth)", 0);
        if (value != null && value.length() > 0) {
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception exception) {
                val = 0;
            }
        }
        return val;
    }

    @Override
    public void setDocumentProperty(String name, String value) {
        this.m_dlcDispatcher.send("document." + name + "=" + value);
    }

    @Override
    public void setDomAttributeValue(BaseHtmlElement elem, EHtmlAttr attr, String value) {
        this.m_dlcDispatcher.send(String.valueOf(DapDomHelper.getPath((Node)elem)) + "." + attr.getAttributeName() + "=" + value);
    }

    @Override
    public void setNavigatorProperty(String name, String value) {
        this.m_dlcDispatcher.send("navigator." + name + "=" + value);
    }

    @Override
    public void setScreenProperty(String name, String value) {
        this.m_dlcDispatcher.send("screen." + name + "=" + value);
    }

    @Override
    public void setWindowHeight(int heigth) {
    }

    @Override
    public void setWindowWidth(int width) {
    }

    @Override
    public void alert(String message) {
        message = message.replace("\n", " ");
        this.m_dlcDispatcher.request("alert(" + JsonObject.quote((String)message) + ")", 0);
    }

    @Override
    public void blur() {
        this.m_dlcDispatcher.send("window.blur()");
    }

    @Override
    public void focus() {
        this.m_dlcDispatcher.send("window.focus()");
    }

    @Override
    public void moveBy(int x, int y) {
        this.m_dlcDispatcher.send("window.moveBy(" + x + "," + y + ")");
    }

    @Override
    public void moveTo(int x, int y) {
        this.m_dlcDispatcher.send("window.moveTo(" + x + "," + y + ")");
    }

    @Override
    public int getPageXOffset() {
        int val = 0;
        String value = this.m_dlcDispatcher.request("(window.pageXOffset || document.body.scrollLeft)", 0);
        if (value != null && value.length() > 0) {
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception exception) {
                val = 0;
            }
        }
        return val;
    }

    @Override
    public int getPageYOffset() {
        int val = 0;
        String value = this.m_dlcDispatcher.request("(window.pageYOffset || document.body.scrollTop)", 0);
        if (value != null && value.length() > 0) {
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception exception) {
                val = 0;
            }
        }
        return val;
    }

    @Override
    public int getScreenLeft() {
        int val = 0;
        String value = this.m_dlcDispatcher.request("(window.screenLeft || window.screenX)", 0);
        if (value != null && value.length() > 0) {
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception exception) {
                val = 0;
            }
        }
        return val;
    }

    @Override
    public int getScreenTop() {
        int val = 0;
        String value = this.m_dlcDispatcher.request("(window.screenTop || window.screenY)", 0);
        if (value != null && value.length() > 0) {
            try {
                val = Integer.parseInt(value);
            }
            catch (Exception exception) {
                val = 0;
            }
        }
        return val;
    }

    @Override
    public boolean confirm(String message) {
        String ret = this.m_dlcDispatcher.request("window.confirm('" + message + "')", 0);
        return ret.equalsIgnoreCase("true");
    }

    @Override
    public void print() {
        this.m_dlcDispatcher.send("window.print()");
    }

    @Override
    public void close() {
        this.m_dlcDispatcher.send("window.close()");
    }

    @Override
    public String prompt(String message, String defaultReply) {
        return this.m_dlcDispatcher.request("window.prompt('" + message + "','" + defaultReply + "')", 0);
    }

    @Override
    public Window open(String url, String windowName, String features, boolean replace) {
        StringBuilder sb = new StringBuilder();
        sb.append("window.open(");
        if (url != null) {
            sb.append(url);
        }
        if (windowName != null) {
            sb.append(", ").append(windowName);
        }
        if (features != null) {
            sb.append(", ").append(features);
        }
        if (url != null && windowName != null && features != null) {
            sb.append(", ").append(replace);
        }
        sb.append(")");
        this.m_dlcDispatcher.send(sb.toString());
        return null;
    }

    @Override
    public void resizeBy(int width, int height) {
        this.m_dlcDispatcher.send("window.resizeBy(" + width + "," + height + ")");
    }

    @Override
    public void resizeTo(int width, int height) {
        this.m_dlcDispatcher.send("window.resizeTo(" + width + "," + height + ")");
    }

    @Override
    public void scrollBy(int x, int y) {
        this.m_dlcDispatcher.send("window.scrollBy(" + x + "," + y + ")");
    }

    @Override
    public void scrollTo(int x, int y) {
        this.m_dlcDispatcher.send("window.scrollTo(" + x + "," + y + ")");
    }

    @Override
    public void locationAssign(String url) {
        this.m_dlcDispatcher.send("location.assign('" + url + "')");
    }

    @Override
    public void locationReload(boolean forceGet) {
        this.m_dlcDispatcher.send("location.reload(" + forceGet + ")");
    }

    @Override
    public void locationReplace(String url) {
        this.m_dlcDispatcher.send("location.replace('" + url + "')");
    }

    public void resetForm(String formIdOrIndex) {
        this.m_dlcDispatcher.send("document.forms['" + formIdOrIndex + "'].reset()");
    }

    @Override
    public void clearInterval(int timerId) {
        this.m_dlcDispatcher.send("window.clearInterval(" + timerId + ");");
    }

    @Override
    public void clearTimeout(int timerId) {
        this.m_dlcDispatcher.send("window.clearTimeout(" + timerId + ");");
    }

    @Override
    public int setInterval(String code, int delay) {
        int timer = 0;
        String ret = "";
        if (code != null && code.length() > 0) {
            ret = this.m_dlcDispatcher.request("window.setInterval('" + code + "'," + delay + ");", 0);
            try {
                timer = Integer.parseInt(ret);
            }
            catch (Exception exception) {
                timer = 0;
            }
        }
        return timer;
    }

    @Override
    public int setTimeout(String code, int delay) {
        int timer = 0;
        String ret = "";
        if (code != null && code.length() > 0) {
            ret = this.m_dlcDispatcher.request("window.setTimeout('" + code + "'," + delay + ");", 0);
            try {
                timer = Integer.parseInt(ret);
            }
            catch (Exception exception) {
                timer = 0;
            }
        }
        return timer;
    }

    @Override
    public void executeDomMethod(BaseHtmlElement elem, String methodCall) {
        String js = String.valueOf(DapDomHelper.getPath((Node)elem)) + "." + methodCall;
        this.m_dlcDispatcher.send(js);
    }

    @Override
    public void back() {
        this.m_dlcDispatcher.send("window.history.back();");
    }

    @Override
    public void forward() {
        this.m_dlcDispatcher.send("window.history.forward();");
    }

    @Override
    public void go(Object o) {
        if (o instanceof Number) {
            this.m_dlcDispatcher.send("window.history.go(" + o + ");");
        } else {
            this.m_dlcDispatcher.send("window.history.go('" + o + "');");
        }
    }

    @Override
    public int historyLength() {
        String ret = this.m_dlcDispatcher.request("window.history.length", 0);
        try {
            return Integer.parseInt(ret);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public String executeJs(String code) {
        return this.m_dlcDispatcher.request(code, 0);
    }

    @Override
    public String getDomAttributeValue(BaseHtmlElement elem, String attrName) {
        return this.m_dlcDispatcher.request(String.valueOf(DapDomHelper.getPath((Node)elem)) + "." + attrName, 0);
    }

    @Override
    public String getElementCurrentStyleValue(BaseHtmlElement elem, String name) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return null;
        }
        return this.m_dlcDispatcher.request("DLC_getCurrentStyleValue(" + path + ", '" + name + "')", 0);
    }

    @Override
    public String getElementRuntimeStyleValue(BaseHtmlElement elem, String name) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return null;
        }
        return this.m_dlcDispatcher.request(String.valueOf(path) + ".runtimeStyle." + name, 0);
    }

    @Override
    public void setElementRuntimeStyleValue(BaseHtmlElement elem, String name, String value) {
        String path = DapDomHelper.getPath((Node)elem);
        if (path == null) {
            return;
        }
        this.m_dlcDispatcher.send(String.valueOf(path) + ".runtimeStyle." + name + "=" + value);
    }
}

