/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import org.eclipse.vjet.dsf.dap.rt.DapConfig;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;

public class DapConsoleHelpHandler
implements IDapConsoleHandler {
    public static final String HELP = "HELP";
    private static final String[] INPUTS = new String[]{"HELP"};

    @Override
    public String[] getSupportedInputs() {
        return INPUTS;
    }

    @Override
    public void handle(String input) {
        if (HELP.equalsIgnoreCase(input)) {
            this.printHelpMenu();
        }
    }

    private void printHelpMenu() {
        DapConfig config = DapCtx.ctx().getDapConfig();
        for (IDapConsoleHandler iDapConsoleHandler : config.getConsoleHandlers()) {
            if (iDapConsoleHandler.getSupportedInputs() == null) continue;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = iDapConsoleHandler.getSupportedInputs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(s);
                ++n2;
            }
            sb.append(" (handled by ").append(iDapConsoleHandler.getClass().getName());
            System.out.println(sb.toString());
        }
    }
}

