/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.event.listener.IBlurListener;
import org.eclipse.vjet.dsf.dap.event.listener.IChangeListener;
import org.eclipse.vjet.dsf.dap.event.listener.IClickListener;
import org.eclipse.vjet.dsf.dap.event.listener.IDapEventListener;
import org.eclipse.vjet.dsf.dap.event.listener.IDblClickListener;
import org.eclipse.vjet.dsf.dap.event.listener.IFocusListener;
import org.eclipse.vjet.dsf.dap.event.listener.IJsEventListenerProxy;
import org.eclipse.vjet.dsf.dap.event.listener.IKeyDownListener;
import org.eclipse.vjet.dsf.dap.event.listener.IKeyPressListener;
import org.eclipse.vjet.dsf.dap.event.listener.IKeyUpListener;
import org.eclipse.vjet.dsf.dap.event.listener.ILoadListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseDownListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseMoveListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseOutListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseOverListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseUpListener;
import org.eclipse.vjet.dsf.dap.event.listener.IResetListener;
import org.eclipse.vjet.dsf.dap.event.listener.IResizeListener;
import org.eclipse.vjet.dsf.dap.event.listener.IScrollListener;
import org.eclipse.vjet.dsf.dap.event.listener.ISelectListener;
import org.eclipse.vjet.dsf.dap.event.listener.ISubmitListener;
import org.eclipse.vjet.dsf.dap.event.listener.IUnloadListener;
import org.eclipse.vjet.dsf.dap.rt.DapEventHandlerAdapter;
import org.eclipse.vjet.dsf.dap.rt.DapHostEventHandler;
import org.eclipse.vjet.dsf.dap.rt.DapHostSvcHandler;
import org.eclipse.vjet.dsf.dap.rt.DapSvcHandlerAdapter;
import org.eclipse.vjet.dsf.dap.rt.JsBase;
import org.eclipse.vjet.dsf.dap.svc.IDapHostSvcCallback;
import org.eclipse.vjet.dsf.dap.svc.IDapSvcCallback;
import org.eclipse.vjet.dsf.dap.svc.IJsSvcCallbackProxy;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsContentGenerator;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.jsnative.events.Event;
import org.eclipse.vjet.dsf.jsnative.events.KeyboardEvent;
import org.eclipse.vjet.dsf.jsnative.events.MouseEvent;

public abstract class DapHandlerAdapter
extends JsBase
implements IDapEventListener,
IDapSvcCallback {
    private static final String JSR = "Jsr";
    private static final Map<EventType, IJsFunc> EMPTY_HANDLERS = new HashMap<EventType, IJsFunc>(0);
    private static final Map<String, IJsFunc> EMPTY_CALLBACKS = new HashMap<String, IJsFunc>(0);
    private static final Map<String, IJsFunc> EMPTY_ERROR_HANDLERS = new HashMap<String, IJsFunc>(0);
    private IJsContentGenerator m_jsContentGenerator = null;
    private IDapHostSvcCallback m_hostSvcHandler = null;
    private JsProxyMeta m_proxyMeta = null;

    protected DapHandlerAdapter(Object ... args) {
        this.m_proxyMeta = new JsProxyMeta(this.getClass(), args);
    }

    public void handleEvent(Event evt) {
        if (evt == null) {
            return;
        }
        if (evt.getType() == null) {
            return;
        }
        if (EventType.CHANGE.getName().equals(evt.getType()) && this instanceof IChangeListener) {
            ((IChangeListener)((Object)this)).onChange(evt);
        } else if (EventType.CLICK.getName().equals(evt.getType()) && this instanceof IClickListener) {
            ((IClickListener)((Object)this)).onClick((MouseEvent)evt);
        } else if (EventType.DBLCLICK.getName().equals(evt.getType()) && this instanceof IDblClickListener) {
            ((IDblClickListener)((Object)this)).onDblClick((MouseEvent)evt);
        } else if (EventType.BLUR.getName().equals(evt.getType()) && this instanceof IBlurListener) {
            ((IBlurListener)((Object)this)).onBlur(evt);
        } else if (EventType.FOCUS.getName().equals(evt.getType()) && this instanceof IFocusListener) {
            ((IFocusListener)((Object)this)).onFocus(evt);
        } else if (EventType.LOAD.getName().equals(evt.getType()) && this instanceof ILoadListener) {
            ((ILoadListener)((Object)this)).onLoad(evt);
        } else if (EventType.UNLOAD.getName().equals(evt.getType()) && this instanceof IUnloadListener) {
            ((IUnloadListener)((Object)this)).onUnload(evt);
        } else if (EventType.RESET.getName().equals(evt.getType()) && this instanceof IResetListener) {
            ((IResetListener)((Object)this)).onReset(evt);
        } else if (EventType.SUBMIT.getName().equals(evt.getType()) && this instanceof ISubmitListener) {
            ((ISubmitListener)((Object)this)).onSubmit(evt);
        } else if (EventType.RESIZE.getName().equals(evt.getType()) && this instanceof IResizeListener) {
            ((IResizeListener)((Object)this)).onResize(evt);
        } else if (EventType.SCROLL.getName().equals(evt.getType()) && this instanceof IScrollListener) {
            ((IScrollListener)((Object)this)).onScroll(evt);
        } else if (EventType.SELECT.getName().equals(evt.getType()) && this instanceof ISelectListener) {
            ((ISelectListener)((Object)this)).onSelect(evt);
        } else if (EventType.MOUSEDOWN.getName().equals(evt.getType()) && this instanceof IMouseDownListener) {
            ((IMouseDownListener)((Object)this)).onMouseDown((MouseEvent)evt);
        } else if (EventType.MOUSEUP.getName().equals(evt.getType()) && this instanceof IMouseUpListener) {
            ((IMouseUpListener)((Object)this)).onMouseUp((MouseEvent)evt);
        } else if (EventType.MOUSEMOVE.getName().equals(evt.getType()) && this instanceof IMouseMoveListener) {
            ((IMouseMoveListener)((Object)this)).onMouseMove((MouseEvent)evt);
        } else if (EventType.MOUSEOVER.getName().equals(evt.getType()) && this instanceof IMouseOverListener) {
            ((IMouseOverListener)((Object)this)).onMouseOver((MouseEvent)evt);
        } else if (EventType.MOUSEOUT.getName().equals(evt.getType()) && this instanceof IMouseOutListener) {
            ((IMouseOutListener)((Object)this)).onMouseOut((MouseEvent)evt);
        } else if (EventType.KEYUP.getName().equals(evt.getType()) && this instanceof IKeyUpListener) {
            ((IKeyUpListener)((Object)this)).onKeyUp((KeyboardEvent)evt);
        } else if (EventType.KEYDOWN.getName().equals(evt.getType()) && this instanceof IKeyDownListener) {
            ((IKeyDownListener)((Object)this)).onKeyDown((KeyboardEvent)evt);
        } else if (EventType.KEYPRESS.getName().equals(evt.getType()) && this instanceof IKeyPressListener) {
            ((IKeyPressListener)((Object)this)).onKeyPress((KeyboardEvent)evt);
        }
    }

    @Override
    public ISimpleJsEventHandler getEventHandlerAdapter(String elemId, int index) {
        return new DapEventHandlerAdapter(elemId, index);
    }

    @Override
    public ISimpleJsEventHandler getEventHandlerAdapter(IJsFunc func) {
        return new DapEventHandlerAdapter(func);
    }

    @Override
    public DapHostEventHandler getHostEventHandler() {
        return new DapHostEventHandler(this);
    }

    @Override
    public Map<EventType, IJsFunc> getProxyEventHandlers() {
        if (this.m_proxyMeta != null) {
            return this.m_proxyMeta.m_evtHandlers;
        }
        return EMPTY_HANDLERS;
    }

    @Override
    public IJsContentGenerator getSvcCallbackAdapter(String svcId, int index) {
        if (this.m_jsContentGenerator == null) {
            this.m_jsContentGenerator = new DapSvcHandlerAdapter(svcId, index);
        }
        return this.m_jsContentGenerator;
    }

    @Override
    public IDapHostSvcCallback getHostSvcCallback() {
        if (this.m_hostSvcHandler == null) {
            this.m_hostSvcHandler = new DapHostSvcHandler(this);
        }
        return this.m_hostSvcHandler;
    }

    @Override
    public Map<String, IJsFunc> getProxySvcCallbacks() {
        if (this.m_proxyMeta != null) {
            return this.m_proxyMeta.m_svcCallbacks;
        }
        return EMPTY_CALLBACKS;
    }

    @Override
    public Map<String, IJsFunc> getProxySvcErrorHandlers() {
        if (this.m_proxyMeta != null) {
            return this.m_proxyMeta.m_svcErrorHandlers;
        }
        return EMPTY_ERROR_HANDLERS;
    }

    static /* synthetic */ Map access$1() {
        return EMPTY_HANDLERS;
    }

    static /* synthetic */ Map access$2() {
        return EMPTY_CALLBACKS;
    }

    static /* synthetic */ Map access$3() {
        return EMPTY_ERROR_HANDLERS;
    }

    private static class ConstructorMeta {
        Constructor<?> m_cnstr;
        Class<?>[] m_paramTypes;
        private static Map<Class<?>, Class<?>> s_primitiveToWrapperMapping = new HashMap();

        static {
            s_primitiveToWrapperMapping.put(Boolean.TYPE, Boolean.class);
            s_primitiveToWrapperMapping.put(Character.TYPE, Character.class);
            s_primitiveToWrapperMapping.put(Byte.TYPE, Byte.class);
            s_primitiveToWrapperMapping.put(Short.TYPE, Short.class);
            s_primitiveToWrapperMapping.put(Integer.TYPE, Integer.class);
            s_primitiveToWrapperMapping.put(Long.TYPE, Long.class);
            s_primitiveToWrapperMapping.put(Float.TYPE, Float.class);
            s_primitiveToWrapperMapping.put(Double.TYPE, Double.class);
        }

        ConstructorMeta(Constructor<?> cnstr, Class<?>[] paramTypes) {
            this.m_cnstr = cnstr;
            this.m_paramTypes = paramTypes;
            int i = 0;
            while (i < this.m_paramTypes.length) {
                if (this.m_paramTypes[i].isPrimitive()) {
                    this.m_paramTypes[i] = s_primitiveToWrapperMapping.get(this.m_paramTypes[i]);
                }
                ++i;
            }
        }

        boolean isApplicable(Object[] args) {
            if (this.m_paramTypes.length != args.length) {
                return false;
            }
            int i = 0;
            while (i < this.m_paramTypes.length) {
                if (args[i] != null && !this.m_paramTypes[i].isInstance(args[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class JsProxyConstructorCache {
        private static Map<Class<?>, ConstructorMeta[]> s_constructors = new HashMap();

        private JsProxyConstructorCache() {
        }

        static synchronized Constructor<?> get(Class<?> clz, Object[] args) {
            ConstructorMeta[] cnstrMetas = s_constructors.get(clz);
            if (cnstrMetas == null) {
                if (s_constructors.containsKey(clz)) {
                    return null;
                }
                String jsrName = String.valueOf(clz.getName()) + DapHandlerAdapter.JSR;
                try {
                    Class<?> jsrClz = Class.forName(jsrName);
                    Constructor<?>[] cnstrs = jsrClz.getConstructors();
                    cnstrMetas = new ConstructorMeta[cnstrs.length];
                    int i = 0;
                    while (i < cnstrs.length) {
                        cnstrMetas[i] = new ConstructorMeta(cnstrs[i], cnstrs[i].getParameterTypes());
                        ++i;
                    }
                    s_constructors.put(clz, cnstrMetas);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    s_constructors.put(clz, null);
                    return null;
                }
            }
            if (cnstrMetas.length == 1) {
                return cnstrMetas[0].m_cnstr;
            }
            ConstructorMeta[] constructorMetaArray = cnstrMetas;
            int n = cnstrMetas.length;
            int n2 = 0;
            while (n2 < n) {
                ConstructorMeta cnstrMeta = constructorMetaArray[n2];
                if (cnstrMeta.isApplicable(args)) {
                    return cnstrMeta.m_cnstr;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class JsProxyMeta {
        private Object m_proxyInstance = null;
        private Map<EventType, IJsFunc> m_evtHandlers = DapHandlerAdapter.access$1();
        private Map<String, IJsFunc> m_svcCallbacks = DapHandlerAdapter.access$2();
        private Map<String, IJsFunc> m_svcErrorHandlers = DapHandlerAdapter.access$3();

        JsProxyMeta(Class<?> clz, Object ... args) {
            Constructor<?> cnstr = JsProxyConstructorCache.get(clz, args);
            if (cnstr != null) {
                try {
                    this.m_proxyInstance = cnstr.newInstance(args);
                }
                catch (Exception e) {
                    throw new DsfRuntimeException((Throwable)e);
                }
                if (this.m_proxyInstance instanceof IJsEventListenerProxy) {
                    this.m_evtHandlers = ((IJsEventListenerProxy)this.m_proxyInstance).getProxyEventHandlers();
                }
                if (this.m_proxyInstance instanceof IJsSvcCallbackProxy) {
                    this.m_svcCallbacks = ((IJsSvcCallbackProxy)this.m_proxyInstance).getProxySvcCallbacks();
                }
                if (this.m_proxyInstance instanceof IJsSvcCallbackProxy) {
                    this.m_svcErrorHandlers = ((IJsSvcCallbackProxy)this.m_proxyInstance).getProxySvcErrorHandlers();
                }
            }
        }
    }
}

