/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.dap.event.listener.IDapEventListener;
import org.eclipse.vjet.dsf.dap.event.listener.IDapHostEventHandler;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHostHandlers;
import org.eclipse.vjet.dsf.dap.rt.DapHostMessage;
import org.eclipse.vjet.dsf.dap.svc.IDapHostSvcCallback;
import org.eclipse.vjet.dsf.dap.svc.IDapSvcCallback;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public final class DapHost
extends BaseScriptable {
    public static final String DAP_HOST = "dapHost";
    public static final String DAP_HOSTED_EVENT_HANDLER = "dapHost.getEvtHandlers(\"{0}\")[{1}]";
    public static final String DAP_HOSTED_SVC_HANDLER = "dapHost.getSvcRespHandlers(\"{0}\")[{1}]";
    private Scriptable m_scope;
    private Map<String, DapHostHandlers<IDapHostEventHandler>> m_elements = new HashMap<String, DapHostHandlers<IDapHostEventHandler>>();
    private Map<String, DapHostHandlers<IDapHostSvcCallback>> m_services = new HashMap<String, DapHostHandlers<IDapHostSvcCallback>>();
    private static final String[] MTD_NAMES = new String[]{"getEvtHandlers", "getSvcRespHandlers"};

    public DapHost() {
    }

    public DapHostHandlers<IDapHostEventHandler> getEvtHandlers(String elemId) {
        return this.m_elements.get(elemId);
    }

    public DapHostHandlers<IDapHostSvcCallback> getSvcRespHandlers(String svcId) {
        return this.m_services.get(svcId);
    }

    DapHost(Scriptable scope) {
        this.m_scope = scope;
        this.defineFunctionProperties(MTD_NAMES);
    }

    void addEvtHandler(String id, DapHostHandlers<IDapHostEventHandler> handlers) {
        this.m_elements.put(id, handlers);
    }

    void addSvcRespHandler(String id, DapHostHandlers<IDapHostSvcCallback> handlers) {
        this.m_services.put(id, handlers);
    }

    void initialize() {
        try {
            ScriptableObject.defineClass((Scriptable)this.m_scope, DapHostMessage.class);
            ScriptableObject.defineClass((Scriptable)this.m_scope, DapHost.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to define host objects.", e);
        }
        Map<String, List<IDapEventListener>> evtHandlers = DapCtx.ctx().getEventListenerRegistry().getAllListeners();
        for (Map.Entry<String, List<IDapEventListener>> entry : evtHandlers.entrySet()) {
            for (IDapEventListener listener : entry.getValue()) {
                this.registerEventListener(entry.getKey(), listener);
            }
        }
        Map<String, List<IDapSvcCallback>> svcHandlers = DapCtx.ctx().getServiceEngine().getAllResponseHandlers();
        for (Map.Entry<String, List<IDapSvcCallback>> entry : svcHandlers.entrySet()) {
            for (IDapSvcCallback handler : entry.getValue()) {
                this.registerSvcHandler(entry.getKey(), handler);
            }
        }
        Object wrappedOut = Context.javaToJS((Object)((Object)this), (Scriptable)this.m_scope);
        ScriptableObject.putProperty((Scriptable)this.m_scope, (String)DAP_HOST, (Object)wrappedOut);
    }

    void registerEventListener(String elemId, IDapEventListener listener) {
        DapHostHandlers<IDapHostEventHandler> hostEvtHandlers = this.getEvtHandlers(elemId);
        if (hostEvtHandlers == null) {
            hostEvtHandlers = new DapHostHandlers();
            this.addEvtHandler(elemId, hostEvtHandlers);
        }
        hostEvtHandlers.add(listener.getHostEventHandler());
    }

    void registerSvcHandler(String svcId, IDapSvcCallback callback) {
        DapHostHandlers<IDapHostSvcCallback> hostSvcHandlers = this.getSvcRespHandlers(svcId);
        if (hostSvcHandlers == null) {
            hostSvcHandlers = new DapHostHandlers();
            this.addSvcRespHandler(svcId, hostSvcHandlers);
        }
        hostSvcHandlers.add(callback.getHostSvcCallback());
    }
}

