/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.Location;

public class DapHttpRequest {
    private static final String HTTP = "http";
    private String m_method;
    private String m_url;
    private String m_host;
    private boolean m_async = false;
    private long m_timeout = 0L;
    private String m_rawData;
    private Map<String, String> m_requestHeaders;

    public DapHttpRequest(String method, String url, boolean async) {
        if (url == null) {
            throw new RuntimeException("url is null");
        }
        String fullUrl = this.checkRelativeUrl(url);
        if (!fullUrl.toLowerCase().startsWith(HTTP) || !fullUrl.contains("://")) {
            throw new RuntimeException("Invalid protocol: " + fullUrl);
        }
        this.m_method = method;
        this.m_url = fullUrl;
        int start = fullUrl.indexOf("://") + 3;
        int end = fullUrl.indexOf("/", start);
        this.m_host = end > start ? fullUrl.substring(start, end) : fullUrl.substring(start);
        this.m_async = async;
    }

    public DapHttpRequest(String method, String url) {
        this(method, url, true);
    }

    public DapHttpRequest(String method, String url, boolean async, String user, String password) {
        this(method, url, async);
    }

    public String getHost() {
        return this.m_host;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getMethod() {
        return this.m_method;
    }

    public void setRawData(String rawData) {
        this.m_rawData = rawData;
    }

    public String getRawData() {
        return this.m_rawData;
    }

    public void setTimeout(long timeout) {
        this.m_timeout = timeout;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void setRequestHeader(String name, String value) {
        if (this.m_requestHeaders == null) {
            this.m_requestHeaders = new HashMap<String, String>();
        }
        this.m_requestHeaders.put(name, value);
    }

    public Map<String, String> getRequestHeaders() {
        if (this.m_requestHeaders == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_requestHeaders);
    }

    public boolean isAsync() {
        return this.m_async;
    }

    private String checkRelativeUrl(String url) {
        String fullUrl = url;
        if (url != null && !"".equals(url) && url.indexOf("://") <= 0) {
            String prefix = "";
            HtmlDocument doc = DapCtx.ctx().getWindow().getDocument();
            if (doc != null) {
                Location loc = doc.getLocation();
                String currentUrl = loc.getHref();
                int idx = currentUrl.indexOf("://") + 3;
                idx = currentUrl.indexOf("/", idx);
                prefix = currentUrl.substring(0, idx);
            }
            if (!url.startsWith("/")) {
                fullUrl = "/" + url;
            }
            fullUrl = String.valueOf(prefix) + fullUrl;
        }
        return fullUrl;
    }
}

