/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.ccil.cowan.tagsoup.Parser;
import org.eclipse.vjet.dsf.html.dom.DStyle;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.util.HtmlBuilder;
import org.eclipse.vjet.dsf.html.dom.util.HtmlDomHelper;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.html.js.Encoding;
import org.eclipse.vjet.dsf.html.js.JSBuilderListener;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.eclipse.vjet.dsf.html.js.URLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class JSHTMLBuilder
implements ContentHandler,
LexicalHandler,
JSBuilderListener {
    static final String BODY = HtmlTypeEnum.BODY.getName();
    private JSWindow browserWindow = null;
    private HtmlBuilder baseBuilder = null;
    private URL urlContext = null;
    private boolean isRoot = true;
    private boolean isInsideBody = false;
    private boolean isJavascript = false;
    private String javascriptSrc = null;
    private String theScript = null;
    private String bodyOnLoadScript = null;
    private int numOfNestedBodyTag = 0;
    private int encoding;
    private StringBuffer generatedContents = new StringBuffer();

    public JSHTMLBuilder(JSWindow browserWindow, boolean isRoot, int encoding) {
        this.isRoot = isRoot;
        this.browserWindow = browserWindow;
        this.baseBuilder = browserWindow.getBaseBuilder();
        this.encoding = encoding;
    }

    public static void doParse(JSWindow jsWindow, InputSource inputSource, URL urlContext, int encoding) throws SAXException, IOException {
        if (jsWindow.getURL() == null) {
            jsWindow.setURL(urlContext);
        }
        Parser parser = new Parser();
        JSHTMLBuilder builder = new JSHTMLBuilder(jsWindow, jsWindow.isRoot, encoding);
        builder.setURLContext(urlContext);
        jsWindow.isRoot = false;
        parser.setContentHandler((ContentHandler)builder);
        try {
            parser.parse(inputSource);
        }
        catch (Exception e) {
            JSDebug.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public static void doParse(JSWindow jsWindow, URL url, int encoding) throws SAXException, IOException {
        if (jsWindow.getURL() == null) {
            jsWindow.setURL(url);
        }
        Parser parser = new Parser();
        JSHTMLBuilder builder = new JSHTMLBuilder(jsWindow, jsWindow.isRoot, encoding);
        builder.setURLContext(url);
        jsWindow.isRoot = false;
        parser.setContentHandler((ContentHandler)builder);
        URLConnection urlConn = url.openConnection();
        urlConn.setUseCaches(false);
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoInput(true);
        urlConn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 4.0)");
        urlConn.setRequestProperty("Accept", "text/html, image/gif, image/jpeg, */*");
        urlConn.setRequestProperty("Accept-Language", "en-us");
        urlConn.connect();
        InputStream is = urlConn.getInputStream();
        parser.parse(new InputSource(is));
    }

    public void setURLContext(URL u) {
        this.urlContext = u;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.isRoot) {
            this.baseBuilder.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.isRoot) {
            this.baseBuilder.endDocument();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String s1 = localName.trim();
        if (!this.isRoot) {
            if (s1.equalsIgnoreCase(BODY) && !this.isInsideBody) {
                this.isInsideBody = true;
                return;
            }
            if (!this.isInsideBody) {
                return;
            }
            if (s1.equalsIgnoreCase(BODY)) {
                ++this.numOfNestedBodyTag;
            }
        }
        if (s1.equalsIgnoreCase(HtmlTypeEnum.SCRIPT.getName())) {
            this.isJavascript = true;
            this.javascriptSrc = null;
            this.theScript = null;
        }
        boolean isBodyElement = false;
        if (s1.equalsIgnoreCase(BODY)) {
            isBodyElement = true;
        }
        if (this.isJavascript || isBodyElement) {
            int i = 0;
            while (i < atts.getLength()) {
                String name = atts.getLocalName(i).trim();
                String value = atts.getValue(i).trim();
                if (this.isJavascript) {
                    if (name.equalsIgnoreCase("language") && !value.toLowerCase().startsWith("javascript")) {
                        this.isJavascript = false;
                    } else if (name.equalsIgnoreCase("src")) {
                        value.length();
                    }
                } else if (isBodyElement && name.equalsIgnoreCase("onload") && value.length() > 0) {
                    int index = value.indexOf("; return ");
                    if (index == -1) {
                        index = value.indexOf(";return ");
                    }
                    if (index != -1) {
                        value = value.substring(0, index);
                    }
                    if (isBodyElement) {
                        this.bodyOnLoadScript = value;
                    }
                }
                ++i;
            }
        }
        if (this.isRoot || !this.isRoot && !this.isJavascript) {
            this.baseBuilder.startElement(namespaceURI, localName, qName, atts);
            s1.equalsIgnoreCase(HtmlTypeEnum.FORM.getName());
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String replacement;
        localName = localName.trim();
        if (!this.isRoot) {
            if (localName.equalsIgnoreCase(BODY)) {
                if (this.numOfNestedBodyTag > 0) {
                    --this.numOfNestedBodyTag;
                } else {
                    this.isInsideBody = false;
                    return;
                }
            }
            if (!this.isInsideBody) {
                return;
            }
        }
        if (this.isRoot || !this.isRoot && !this.isJavascript) {
            this.baseBuilder.endElement(namespaceURI, localName, qName);
        }
        if (localName.equalsIgnoreCase(HtmlTypeEnum.STYLE.getName())) {
            try {
                this.browserWindow.setCssStyleSheet(HtmlDomHelper.getStyleSheet((DStyle)((DStyle)this.baseBuilder.getCurrentElement().getLastChild())));
            }
            catch (Exception exception) {}
        }
        if (this.isJavascript && ActiveJsExecutionControlCtx.ctx().needExecuteJavaScript()) {
            if (this.javascriptSrc != null && this.javascriptSrc.trim().length() > 0) {
                String pageUrl = this.urlContext.toString();
                String url = URLUtil.getAbsoluteURL(this.javascriptSrc, pageUrl);
                try {
                    InputStreamReader reader = null;
                    reader = this.encoding != 0 ? new InputStreamReader(new URL(url).openStream(), Encoding.JAVA_ENCODING[this.encoding]) : new InputStreamReader(new URL(url).openStream());
                    StringBuffer sb = new StringBuffer();
                    int c = 0;
                    while ((c = reader.read()) != -1) {
                        sb.append((char)c);
                    }
                    String scriptStr = sb.toString();
                    boolean noReplace = true;
                    int index = scriptStr.indexOf("document.all(");
                    while (index > 0) {
                        sb.setCharAt(index += 12, '[');
                        int endIndex = scriptStr.indexOf(")", index);
                        sb.setCharAt(endIndex, ']');
                        index = scriptStr.indexOf("document.all(", endIndex);
                        noReplace = false;
                    }
                    JSBuilderListener builderListener = this.browserWindow.getJsBuilderListener();
                    this.browserWindow.setJsBuilderListener(this);
                    try {
                        if (noReplace) {
                            this.browserWindow.executeScript(scriptStr);
                        } else {
                            this.browserWindow.executeScript(sb.toString());
                        }
                    }
                    catch (Exception ex) {
                        JSDebug.printJavaScriptException(ex, this.javascriptSrc);
                    }
                    this.browserWindow.setJsBuilderListener(builderListener);
                }
                catch (Exception ex) {
                    JSDebug.printJavaScriptException(ex, this.javascriptSrc);
                }
            } else if (this.theScript != null && this.theScript.trim().length() > 0) {
                JSBuilderListener builderListener = this.browserWindow.getJsBuilderListener();
                this.browserWindow.setJsBuilderListener(this);
                try {
                    this.browserWindow.executeScript(this.theScript);
                }
                catch (Exception ex) {
                    JSDebug.printJavaScriptException(ex, this.theScript);
                }
                this.browserWindow.setJsBuilderListener(builderListener);
            }
            this.isJavascript = false;
            this.javascriptSrc = null;
            this.theScript = null;
        }
        if (localName.equalsIgnoreCase(BODY) && this.bodyOnLoadScript != null && ((replacement = this.browserWindow.getJSLocation().getReplacement()) == null || replacement.trim().length() <= 0) && this.isRoot) {
            String script = this.bodyOnLoadScript;
            JSBuilderListener builderListener = this.browserWindow.getJsBuilderListener();
            this.browserWindow.setJsBuilderListener(this);
            try {
                this.browserWindow.executeScript(script);
            }
            catch (Exception ex) {
                JSDebug.printJavaScriptException(ex, this.bodyOnLoadScript);
            }
            this.browserWindow.setJsBuilderListener(builderListener);
            this.bodyOnLoadScript = null;
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
        String script = new String(ac, i, j);
        if (this.isJavascript) {
            this.theScript = this.theScript == null ? script : String.valueOf(this.theScript) + script;
        }
        if ((this.isRoot || !this.isRoot && !this.isJavascript) && !script.trim().startsWith("<![")) {
            this.baseBuilder.characters(ac, i, j);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ac, int i, int j) throws SAXException {
        this.baseBuilder.ignorableWhitespace(ac, i, j);
    }

    @Override
    public void processingInstruction(String s, String s1) throws SAXException {
        this.baseBuilder.processingInstruction(s, s1);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.baseBuilder.setDocumentLocator(locator);
    }

    @Override
    public void doneDocumentWrite() {
        String newContent = this.browserWindow.getGeneratedContentFromScript();
        if (newContent.trim().length() == 0) {
            return;
        }
        boolean parseIt = this.generatedContents.length() == 0;
        this.generatedContents.append(newContent);
        if (newContent.endsWith(">") || newContent.endsWith("\n")) {
            parseIt = true;
        } else if (newContent.startsWith("<") && !newContent.endsWith(">")) {
            parseIt = false;
        }
        if (parseIt) {
            String content = this.generatedContents.toString();
            String noLeadingSpaceContent = content.trim();
            if (noLeadingSpaceContent.startsWith("<style") || noLeadingSpaceContent.startsWith("<STYLE") || noLeadingSpaceContent.startsWith("<script") || noLeadingSpaceContent.startsWith("<SCRIPT")) {
                content = "<body> " + content + " </body>";
            }
            try {
                if (ActiveJsExecutionControlCtx.ctx().needParseGeneratedContent()) {
                    JSHTMLBuilder.doParse(this.browserWindow, new InputSource(new StringReader(content)), this.urlContext, this.encoding);
                }
            }
            catch (Exception ex) {
                JSDebug.println(ex.getMessage());
            }
            this.generatedContents.delete(0, this.generatedContents.length());
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.baseBuilder.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.baseBuilder.endPrefixMapping(prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.baseBuilder.skippedEntity(name);
    }

    @Override
    public void comment(char[] text, int start, int length) throws SAXException {
        this.baseBuilder.comment(text, start, length);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.baseBuilder.endCDATA();
    }

    @Override
    public void endDTD() throws SAXException {
        this.baseBuilder.endDTD();
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.baseBuilder.endEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.baseBuilder.startCDATA();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.baseBuilder.startDTD(name, publicId, systemId);
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.baseBuilder.startEntity(name);
    }
}

