/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import org.eclipse.vjet.dsf.html.dom.DTextArea;
import org.eclipse.vjet.dsf.html.js.JSDebug;
import org.eclipse.vjet.dsf.html.js.JSDocument;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.ScriptableObject;

public class JSTextArea
extends ScriptableObject {
    private JSWindow window = null;
    private DTextArea textArea = null;
    public String name = null;
    public String formId = null;

    private JSTextArea() {
    }

    public JSTextArea(JSWindow window, DTextArea textArea) {
        this.window = window;
        this.textArea = textArea;
        this.name = textArea.getHtmlName();
        this.formId = textArea.getAttribute("form-id");
        String[] functions = new String[]{"blur", "focus", "select"};
        this.defineFunctionProperties(functions, JSTextArea.class, 2);
        this.defineProperty("window", JSTextArea.class, 2);
        this.defineProperty("document", JSTextArea.class, 2);
        this.defineProperty("form", JSTextArea.class, 2);
        this.defineProperty("defaultValue", JSTextArea.class, 2);
        this.defineProperty("accessKey", JSTextArea.class, 2);
        this.defineProperty("cols", JSTextArea.class, 2);
        this.defineProperty("disabled", JSTextArea.class, 2);
        this.defineProperty("name", JSTextArea.class, 2);
        this.defineProperty("readOnly", JSTextArea.class, 2);
        this.defineProperty("rows", JSTextArea.class, 2);
        this.defineProperty("tabIndex", JSTextArea.class, 2);
        this.defineProperty("type", JSTextArea.class, 2);
        this.defineProperty("value", JSTextArea.class, 2);
    }

    public String getClassName() {
        return "JSTextAreaElement";
    }

    public void blur() {
        JSDebug.println("blur is invoked on " + this.name);
    }

    public void focus() {
        JSDebug.println("focus is invoked on " + this.name);
    }

    public void select() {
        JSDebug.println("select is invoked");
    }

    public JSWindow getWindow() {
        return this.window;
    }

    public JSDocument getDocument() {
        return this.window.getJSDocument();
    }

    public Object getForm() {
        return this.window.findFormElement(this.formId, null);
    }

    public String getValue() {
        String value = null;
        if (this.window.windowState != JSWindow.IN_SERVER) {
            value = this.textArea.getHtmlValue();
        }
        if (this.window.windowState != JSWindow.IN_LOADING) {
            value = this.window.getJSListener().doAction(19, this.name, value, this.formId);
        }
        return value;
    }

    public String getAccessKey() {
        return this.textArea.getHtmlAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.textArea.setHtmlAccessKey(accessKey);
    }

    public int getCols() {
        return this.textArea.getHtmlCols();
    }

    public void setCols(int cols) {
        this.textArea.setHtmlCols(cols);
    }

    public boolean getDisabled() {
        return this.textArea.getHtmlDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.textArea.setHtmlDisabled(disabled);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.textArea.setHtmlName(name);
        this.name = name;
    }

    public boolean getReadOnly() {
        return this.textArea.getHtmlReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.textArea.setHtmlReadOnly(readOnly);
    }

    public int getRows() {
        return this.textArea.getHtmlRows();
    }

    public void setRows(int rows) {
        this.textArea.setHtmlRows(rows);
    }

    public int getTabIndex() {
        return this.textArea.getHtmlTabIndex();
    }

    public void setTabIndex(int tabIndex) {
        this.textArea.setHtmlTabIndex(tabIndex);
    }

    public String getType() {
        return this.textArea.getHtmlType();
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.getValue();
        }
        if (type.equals("object")) {
            return this;
        }
        if (type.equals("number")) {
            return "0";
        }
        return null;
    }
}

