/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.eclipse.vjet.dsf.common.StringUtils;
import org.eclipse.vjet.dsf.js.dbgp.DBGPStackManager;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.NativeJavaArray;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.VMBridge;
import org.mozilla.mod.javascript.debug.DebugFrame;
import org.mozilla.mod.javascript.debug.DebuggableScript;
import org.mozilla.mod.javascript.debug.Debugger;

public final class DBGPDebugFrame
implements DebugFrame {
    private static final Logger logger = Logger.getInstance(DBGPDebugFrame.class);
    private final String m_sourceName;
    private final DBGPStackManager m_stackManager;
    private int m_lineNumber;
    private String m_where;
    private Scriptable m_thisObj;
    private Scriptable m_scope;
    private DebuggableScript m_script;
    private Context m_context;
    private boolean m_suspend;

    public boolean isSuspend() {
        return this.m_suspend;
    }

    public void setSuspend(boolean suspend) {
        this.m_suspend = suspend;
    }

    public DBGPDebugFrame(Context ct, DebuggableScript node, String fileName) {
        this.m_sourceName = fileName != null ? fileName : node.getSourceName();
        this.m_context = ct;
        this.m_stackManager = DBGPStackManager.getManager(ct);
        this.m_where = node.getFunctionName();
        this.m_script = node;
        if (this.m_where == null) {
            this.m_where = "module";
        }
    }

    public String[] getParametersAndVars() {
        String[] result = new String[this.m_script.getParamAndVarCount()];
        int a = 0;
        while (a < result.length) {
            result[a] = this.m_script.getParamOrVarName(a);
            ++a;
        }
        return result;
    }

    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        this.m_scope = activation;
        this.m_thisObj = thisObj;
        this.m_stackManager.enter(this);
    }

    public void onExceptionThrown(Context cx, Throwable ex) {
        this.m_stackManager.exceptionThrown(ex);
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        this.m_stackManager.exit(this);
    }

    public void onLineChange(Context cx, int lineNumber) {
        this.m_lineNumber = lineNumber;
        this.m_stackManager.changeLine(this, this.getLineNumber());
    }

    public String getSourceName() {
        if (this.isHtmlFrame()) {
            return this.getHtmlSourceName();
        }
        return this.m_sourceName;
    }

    public int getLineNumber() {
        if (this.isHtmlFrame()) {
            return this.getHtmlScriptOffset() + this.m_lineNumber;
        }
        return this.m_lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.m_lineNumber = lineNumber;
    }

    public String getWhere() {
        return this.m_where;
    }

    public Object getValue(int num) {
        return this.m_scope.get(this.m_script.getParamOrVarName(num), this.m_thisObj);
    }

    public Scriptable getThis() {
        return this.m_thisObj;
    }

    public void setValue(String name, String value) {
        Scriptable start;
        if (name.startsWith("this.")) {
            name = name.substring("this.".length());
            start = this.m_thisObj;
        } else {
            start = this.m_scope;
        }
        int offset = name.lastIndexOf(46);
        String propertyName = null;
        if (offset == -1) {
            propertyName = name;
        } else {
            String objName = name.substring(0, offset);
            Object obj = this.getProperty(start, objName);
            if (obj instanceof Scriptable) {
                start = (Scriptable)obj;
            }
            propertyName = name.substring(offset + 1);
        }
        try {
            start.put(propertyName, start, this.eval(value));
        }
        catch (Exception e) {
            logger.log(LogLevel.ERROR, (Throwable)e);
        }
    }

    public Object eval(Reader reader) {
        Debugger debugger = this.m_context.getDebugger();
        try {
            this.m_context.setDebugger(null, null);
            Scriptable cs = (Scriptable)this.getProperty(this.m_thisObj, "window");
            if (cs == null) {
                cs = this.m_scope;
            }
            Object helper = VMBridge.instance.getThreadContextHelper();
            VMBridge.instance.setContext(helper, this.m_context);
            Object object = this.innerEval(cs, reader);
            return object;
        }
        catch (Throwable e) {
            String string = "Error during evaluation:" + e.getMessage();
            return string;
        }
        finally {
            this.m_context.setDebugger(debugger, null);
        }
    }

    public Object eval(String value) {
        Debugger debugger = this.m_context.getDebugger();
        boolean fromThis = false;
        try {
            this.m_context.setDebugger(null, null);
            if (value.startsWith("this")) {
                int indexOf = value.indexOf(46);
                if (indexOf == -1) {
                    Scriptable scriptable = this.m_thisObj;
                    return scriptable;
                }
                value = value.substring("this.".length());
                fromThis = true;
            }
            Scriptable cs = fromThis ? this.m_thisObj : this.m_scope;
            Object helper = VMBridge.instance.getThreadContextHelper();
            VMBridge.instance.setContext(helper, this.m_context);
            Object object = this.innerEval(cs, value);
            return object;
        }
        catch (Throwable e) {
            if (!fromThis) {
                try {
                    Object object = this.innerEval(this.m_thisObj, value);
                    return object;
                }
                catch (Throwable throwable) {
                    String string = "Error during evaluation:" + e.getMessage();
                    return string;
                }
            }
            String string = "Error during evaluation:" + e.getMessage();
            return string;
        }
        finally {
            this.m_context.setDebugger(debugger, null);
        }
    }

    private Object innerEval(Scriptable cs, String value) {
        return this.m_context.evaluateString(cs, value, "eval", 0, null);
    }

    private Object innerEval(Scriptable cs, Reader reader) throws IOException {
        return this.m_context.evaluateReader(cs, reader, "eval", 0, null);
    }

    public Object getValue(String longName) {
        if (longName.startsWith("this")) {
            int indexOf = longName.indexOf(46);
            if (indexOf == -1) {
                return this.m_thisObj;
            }
            longName = longName.substring("this.".length());
            return this.getProperty(this.m_thisObj, longName);
        }
        return this.getProperty(this.m_scope, longName);
    }

    private Object getProperty(Scriptable obj, String longName) {
        int k = longName.indexOf(46);
        if (k == -1) {
            return this.shortGet(obj, longName);
        }
        String shortName = longName.substring(0, k);
        String sm = longName.substring(k + 1);
        Object property = this.shortGet(obj, shortName);
        if (property instanceof Scriptable) {
            return this.getProperty((Scriptable)property, sm);
        }
        return null;
    }

    private Object shortGet(Scriptable obj, String longName) {
        if (obj instanceof NativeJavaArray) {
            int parseInt = Integer.parseInt(longName);
            NativeJavaArray na = (NativeJavaArray)obj;
            return na.get(parseInt, (Scriptable)na);
        }
        Scriptable parent = obj;
        while (parent != null) {
            Object o = ScriptableObject.getProperty((Scriptable)parent, (String)longName);
            if (o != null && o != Scriptable.NOT_FOUND) {
                return o;
            }
            parent = parent.getParentScope();
        }
        return null;
    }

    public void onDebuggerStatement(Context cx) {
    }

    private int getHtmlScriptOffset() {
        List ss;
        String sourceName = this.m_sourceName;
        if (sourceName.indexOf("#Script#") > 0 && (ss = StringUtils.splitStr((String)sourceName, (char)'#')).size() == 5) {
            try {
                return Integer.parseInt((String)ss.get(3)) + Integer.parseInt((String)ss.get(4));
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private boolean isHtmlFrame() {
        String sourceName = this.m_sourceName;
        if (sourceName == null) {
            return false;
        }
        return sourceName.indexOf("#Script#") > 0;
    }

    private String getHtmlSourceName() {
        List ss;
        String sourceName = this.m_sourceName;
        if (sourceName.indexOf("#Script#") > 0 && (ss = StringUtils.splitStr((String)sourceName, (char)'#')).size() == 5) {
            return (String)ss.get(0);
        }
        return sourceName;
    }

    protected Context getContext() {
        return this.m_context;
    }

    private void setProperty(Scriptable scriptable, String property, Object value) {
        scriptable.put(property, scriptable, value);
    }
}

