/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.io.IOException;
import java.net.URL;
import junit.framework.Assert;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.dap.cnr.ReplaySpeed;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.vsf.dapunit.AssertionSerializationHelper;
import org.eclipse.vjet.vsf.dapunit.DapUnitConfig;
import org.eclipse.vjet.vsf.dapunit.DapUnitDriver;
import org.eclipse.vjet.vsf.dapunit.UserAgentsEnum;
import org.eclipse.vjet.vsf.dapunit.ValidationCommands;

public class BaseDapUnit {
    private URL m_dapCaptureFileName;
    private DapUnitConfig m_config;
    private int m_expectedErrorCount = 0;
    private long m_timeout = 0L;
    private static final String DAP_UNIT = "DapUnit";
    private static final String DAP_CAPTURE_DOT_XML = "DapCapture.xml";

    public BaseDapUnit() {
        DapCtx.ctx().reset();
        DsfCtx.ctx().reset();
        DapCtx.ctx().setExeMode(DapCtx.ExeMode.ACTIVE);
    }

    protected void runTest(DNode root) {
        ValidationCommands.enableAllPropertyBasedCommands();
        ValidationCommands.enableAllStyleCommands();
        AssertionSerializationHelper.enableAssertion();
        new DapUnitDriver(this.getCaptureFileName()).setUserAgents(this.getUserAgents()).addView(root, this.getTimeout()).run(this.getConfig());
        Assert.assertEquals((String)"Please find errors in console.", (int)this.m_expectedErrorCount, (int)this.getConfig().getErrorReporter().getDomErrors().size());
        this.enableTraceError();
        this.setReplaySpeed(ReplaySpeed.FAST);
    }

    protected final DapUnitConfig getConfig() {
        if (this.m_config == null) {
            this.m_config = new DapUnitConfig();
            this.getConfig().getErrorReporter().setTestName(this.getClass().getName());
        }
        return this.m_config;
    }

    protected UserAgentsEnum[] getUserAgents() {
        return null;
    }

    protected void setReplaySpeed(ReplaySpeed speed) {
        this.getConfig().setReplaySpeed(speed);
    }

    protected void enableTraceError() {
        this.getConfig().getErrorReporter().enableTraceError();
    }

    protected void disableTraceError() {
        this.getConfig().getErrorReporter().disableTraceError();
    }

    protected BaseDapUnit setExpectedErrorCount(int count) {
        this.m_expectedErrorCount = count;
        if (count == 0) {
            this.getConfig().getErrorReporter().enableTraceError();
        } else {
            this.getConfig().getErrorReporter().disableTraceError();
        }
        return this;
    }

    private URL getCaptureFileName() {
        if (this.m_dapCaptureFileName != null) {
            return this.m_dapCaptureFileName;
        }
        String simpleClassName = this.getClass().getSimpleName();
        if (simpleClassName.endsWith(DAP_UNIT)) {
            String captureResourceName = String.valueOf(simpleClassName.substring(0, simpleClassName.length() - DAP_UNIT.length())) + DAP_CAPTURE_DOT_XML;
            try {
                this.m_dapCaptureFileName = ResourceUtil.getResource(this.getClass(), (String)captureResourceName);
            }
            catch (IOException iOException) {}
        }
        if (this.m_dapCaptureFileName == null || !simpleClassName.endsWith(DAP_UNIT)) {
            throw new DsfRuntimeException("Cannot find DAP capture file in test directory: " + this.getClass().getSimpleName() + DAP_CAPTURE_DOT_XML);
        }
        return this.m_dapCaptureFileName;
    }

    protected long getTimeout() {
        return this.m_timeout;
    }

    protected void setTimeout(long m_timeout) {
        this.m_timeout = m_timeout;
    }
}

