/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsref.ctx;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.dsf.spec.export.JsExportableCompCollector;
import org.eclipse.vjet.vsf.jsref.ctx.JsResourceCtx;

public final class ResourceCtx
extends BaseSubCtx {
    private static final List<IComponentSpec> EMPTY_LIST = new ArrayList<IComponentSpec>(0);
    private JsResourceCtx m_jsResourceContext;
    private Set<IComponentSpec> m_componentSpecs = null;
    private JsExportableCompCollector m_jsInstanceCollector;

    public static ResourceCtx ctx() {
        return ResourceCtx.ctx(DsfCtx.ctx());
    }

    public static ResourceCtx ctx(DsfCtx ctx) {
        ResourceCtx context = CtxAssociator.getCtx(ctx);
        if (context == null) {
            context = new ResourceCtx();
            ResourceCtx.setCtx(context);
        }
        return context;
    }

    public static void setCtx(ResourceCtx context) {
        CtxAssociator.setCtx(context);
    }

    private ResourceCtx() {
    }

    public void register(IComponentSpec componentSpec) {
        if (this.m_componentSpecs == null) {
            this.m_componentSpecs = new HashSet<IComponentSpec>();
        }
        this.m_componentSpecs.add(componentSpec);
    }

    public JsResourceCtx getJsResourceCtx() {
        if (this.m_jsResourceContext == null) {
            this.m_jsResourceContext = new JsResourceCtx();
        }
        return this.m_jsResourceContext;
    }

    public void reset() {
        this.m_jsResourceContext = null;
        this.m_componentSpecs = null;
    }

    public Iterator<IComponentSpec> componentSpecIterator() {
        if (this.m_componentSpecs == null) {
            return EMPTY_LIST.iterator();
        }
        return this.m_componentSpecs.iterator();
    }

    public boolean hasCollectedCompSpecs() {
        return this.m_componentSpecs == null;
    }

    public JsExportableCompCollector getJsInstanceCollector() {
        if (this.m_jsInstanceCollector == null) {
            this.m_jsInstanceCollector = new JsExportableCompCollector();
        }
        return this.m_jsInstanceCollector;
    }

    public boolean hasJsInstanceCollector() {
        return this.m_jsInstanceCollector != null;
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = ResourceCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static ResourceCtx getCtx(DsfCtx ctx) {
            return (ResourceCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)ctx, (String)CTX_NAME));
        }

        protected static void setCtx(ResourceCtx ctx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME, (ISubCtx)ctx);
        }
    }
}

