/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.jsconverters;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class BooleanJsConverter
extends BaseConverter<String> {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{Boolean.class};
        VALID_CONVERSION_TYPES = BooleanJsConverter.immutableTypeList((Class[])types);
    }

    public IConversionResult<String> convert(Object toBeConverted) {
        try {
            Boolean preVal = (Boolean)toBeConverted;
            if (preVal.booleanValue()) {
                return this.setResult(toBeConverted, TRUE);
            }
            return this.setResult(toBeConverted, FALSE);
        }
        catch (Exception exception) {
            return this.setResult(toBeConverted, IConverter.UnconvertableValueConversionError);
        }
    }

    public Class<String> getTargetType() {
        return String.class;
    }

    public List getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }
}

