/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.binding;

import java.io.Serializable;
import org.eclipse.vjet.dsf.common.binding.IValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public class ManagedValue<T>
implements IValueBinding<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> m_valueType;
    private T m_value;
    private IValueBinding<T> m_delegator;
    private PreviousValue<T> m_previousValue;

    public ManagedValue(Class<T> valueType) {
        if (valueType == null) {
            throw new DsfRuntimeException("Value type must not be null");
        }
        this.m_valueType = valueType;
    }

    public ManagedValue(Class<T> valueType, T value) {
        this(valueType);
        this.setValue(value);
    }

    @Override
    public Class<T> getValueType() {
        return this.m_valueType;
    }

    public boolean hasPreviousValue() {
        if (this.m_previousValue == null) {
            return false;
        }
        return this.m_previousValue.hasValue();
    }

    public T getPreviousValue() {
        if (this.m_previousValue == null || !this.m_previousValue.hasValue()) {
            return null;
        }
        return this.m_previousValue.getValue();
    }

    @Override
    public void setValue(T value) {
        this.setPreviousValue(this.m_value);
        this.m_value = value;
        if (this.m_delegator != null) {
            this.m_delegator.setValue(value);
        }
    }

    @Override
    public T getValue() {
        T result = this.m_value;
        if (this.m_delegator != null && (result = this.m_delegator.getValue()) != this.m_value) {
            this.setPreviousValue(this.m_value);
            this.m_value = result;
        }
        return result;
    }

    public IValueBinding<T> getDelegator() {
        return this.m_delegator;
    }

    public void setDelegator(IValueBinding<T> delegator) {
        this.m_delegator = delegator;
    }

    public boolean isValueProvided() {
        return this.m_delegator != null || this.m_previousValue != null;
    }

    public void unset() {
        this.m_delegator = null;
        this.m_previousValue = null;
        this.m_value = null;
    }

    private void setPreviousValue(T value) {
        if (this.m_previousValue == null) {
            this.m_previousValue = new PreviousValue();
        } else {
            this.m_previousValue.setValue(value);
        }
    }

    public static class PreviousValue<T>
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private T m_value;
        private boolean m_set = false;

        public boolean hasValue() {
            return this.m_set;
        }

        public void setValue(T value) {
            this.m_value = value;
            this.m_set = true;
        }

        public T getValue() {
            return this.m_value;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

