/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.context;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.context.IInputParamValueProvider;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.introspect.ITraceable;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;

public class DefaultInputDataProvider
implements IInputParamValueProvider,
ITraceable {
    private Map<String, String[]> m_requestParams;

    public DefaultInputDataProvider(Map<String, String[]> inputParams) {
        this.m_requestParams = inputParams == null ? new HashMap<String, String[]>() : inputParams;
    }

    public void writeState(IXmlStreamWriter writer) {
        if (this.m_requestParams == null || this.m_requestParams.size() == 0) {
            return;
        }
        for (Map.Entry<String, String[]> entry : this.m_requestParams.entrySet()) {
            writer.writeStartElement(entry.getKey());
            String[] values = entry.getValue();
            if (values == null || values.length == 0) continue;
            if (values.length == 1) {
                writer.writeRaw(values[0]);
                writer.writeEndElement();
                continue;
            }
            StringBuilder concatenated = new StringBuilder();
            int i = 0;
            while (i < values.length) {
                concatenated.append(",").append(values[i]);
                ++i;
            }
            writer.writeRaw(concatenated.substring(1));
            writer.writeEndElement();
        }
    }

    @Override
    public String getInputParamValue(String key) {
        String[] values = this.getInputParamValues(key);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    @Override
    public String getInputParamValue(String key, String defaultValue) {
        String value = this.getInputParamValue(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public String[] getInputParamValues(String name) {
        if (name == null) {
            return null;
        }
        String key = name;
        String[] value = this.m_requestParams.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return value;
        }
        if (value instanceof String) {
            String[] values = new String[]{(String)value};
            return values;
        }
        DsfExceptionHelper.chuck((String)("Invaid value type: " + value));
        return null;
    }

    @Override
    public String[] getInputParamValues(String key, String[] defaultValues) {
        String[] values = this.getInputParamValues(key);
        return values != null ? values : defaultValues;
    }

    @Override
    public Map<String, String[]> getInputParamValues() {
        return this.m_requestParams;
    }

    public void setInputParamValue(String key, String value) {
        if (key == null) {
            DsfExceptionHelper.chuck((String)"key cannot be null");
        }
        if (value == null) {
            this.m_requestParams.put(key, null);
        } else {
            String[] values = new String[]{value};
            this.m_requestParams.put(key, values);
        }
    }
}

