/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.ovs;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.ovs.ICaptionedValue;

public final class CaptionedValue<T>
implements ICaptionedValue {
    private final T m_value;
    private String m_caption;

    public CaptionedValue(T value) {
        if (value == null) {
            throw new DsfRuntimeException("value is null");
        }
        this.m_value = value;
    }

    public CaptionedValue(T value, String caption) {
        this(value);
        this.m_caption = caption;
    }

    @Override
    public T getValue() {
        return this.m_value;
    }

    @Override
    public String getCaption() {
        return this.m_caption;
    }

    protected void setCaption(String caption) {
        this.m_caption = caption;
    }

    public int hashCode() {
        int captionHash = this.getCaption() == null ? 0 : this.getCaption().hashCode();
        T obj = this.getValue();
        if (obj == null) {
            return captionHash;
        }
        return captionHash + obj.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CaptionedValue)) {
            return false;
        }
        CaptionedValue that = (CaptionedValue)obj;
        return this.captionEquals(that.getCaption()) && this.valueEquals(that.getValue());
    }

    public String toString() {
        return Z.fmt((String)this.getCaption(), this.m_value);
    }

    private boolean captionEquals(String caption) {
        String thisCaption = this.getCaption();
        if (thisCaption == null) {
            return caption == null;
        }
        return thisCaption.equals(caption);
    }

    private boolean valueEquals(Object value) {
        T thisValue = this.getValue();
        if (thisValue == null) {
            return value == null;
        }
        return thisValue.equals(value);
    }
}

