/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.statistics;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.vjet.dsf.common.statistics.DarwinStatisticsCtx;
import org.eclipse.vjet.dsf.common.statistics.IV4Statistics;
import org.eclipse.vjet.dsf.dom.DCDATASection;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.util.XmlWriterHelper;

public class ContentHistogram
implements IV4Statistics {
    private Map<String, DarwinStatisticsCtx.DarwinStatisticsCount> m_histo = new ConcurrentHashMap<String, DarwinStatisticsCtx.DarwinStatisticsCount>();

    ContentHistogram() {
    }

    @Override
    public String getName() {
        return "v4-content";
    }

    @Override
    public void reset() {
        this.m_histo.clear();
    }

    public Map<String, DarwinStatisticsCtx.DarwinStatisticsCount> getHisto() {
        return this.m_histo;
    }

    @Override
    public DElement toXml() {
        DElement content_tag = new DElement("v4-content");
        TreeMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> sortedMap = new TreeMap<String, DarwinStatisticsCtx.DarwinStatisticsCount>(this.m_histo);
        for (Map.Entry entry : sortedMap.entrySet()) {
            String key = (String)entry.getKey();
            DarwinStatisticsCtx.DarwinStatisticsCount count = (DarwinStatisticsCtx.DarwinStatisticsCount)entry.getValue();
            DElement unit_tag = new DElement("content-unit");
            DElement guid_tag = new DElement("guid");
            guid_tag.add(new DCDATASection(String.valueOf(key)));
            DElement count_tag = new DElement("count");
            DElement usage_tag = new DElement("usage");
            DElement ref_tag = new DElement("ref");
            usage_tag.add(new DCDATASection(String.valueOf(count.getUsage())));
            ref_tag.add(new DCDATASection(String.valueOf(count.getRef())));
            count_tag.add(usage_tag);
            count_tag.add(ref_tag);
            unit_tag.add(guid_tag);
            unit_tag.add(count_tag);
            content_tag.add(unit_tag);
        }
        return content_tag;
    }

    @Override
    public String asString() {
        return XmlWriterHelper.asString(this.toXml());
    }

    public void count(String cmpId, long usage, long ref) {
        DarwinStatisticsCtx.DarwinStatisticsCount count;
        if (this.m_histo == null) {
            this.m_histo = new ConcurrentHashMap<String, DarwinStatisticsCtx.DarwinStatisticsCount>();
        }
        if ((count = this.m_histo.get(cmpId)) == null) {
            count = new DarwinStatisticsCtx.DarwinStatisticsCount();
            this.m_histo.put(cmpId, count);
        }
        count.setUsage(count.getUsage() + usage);
        count.setRef(count.getRef() + ref);
    }
}

