/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DEntity;
import org.eclipse.vjet.dsf.dom.DEntityInternal;
import org.eclipse.vjet.dsf.dom.DNamedNodeMap;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DNotation;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public class DDocumentType
extends DNode
implements DocumentType {
    private static final long serialVersionUID = -4825617330411078512L;
    private final String m_publicId;
    private final String m_systemId;
    private String m_internalSubset;
    private DNamedNodeMap m_entities = new DNamedNodeMap(2, 6);
    private DNamedNodeMap m_notations = new DNamedNodeMap(2, 12);

    public DDocumentType(String qualifiedName, String publicId, String systemId) {
        this(null, qualifiedName, publicId, systemId);
    }

    public DDocumentType(DDocument ownerDocument, String qualifiedName, String publicId, String systemId) {
        super(ownerDocument, qualifiedName);
        this.m_publicId = publicId;
        this.m_systemId = systemId;
    }

    @Override
    public final short getNodeType() {
        return 10;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild != null) {
            Class<?> clz = newChild.getClass();
            if (Entity.class.isAssignableFrom(clz)) {
                this.getEntities().setNamedItem((Entity)newChild);
                return newChild;
            }
            if (Notation.class.isAssignableFrom(clz)) {
                this.getNotations().setNamedItem((Notation)newChild);
                return newChild;
            }
        }
        throw new DOMException(16, "DocumentType does not support having children");
    }

    @Deprecated
    public String asString() {
        StringWriter out = new StringWriter();
        this.write(out);
        return out.toString();
    }

    public void write(Writer out) {
        String publicId = this.getPublicId();
        String systemId = this.getSystemId();
        String internalSubset = this.getInternalSubset();
        boolean hasPublic = false;
        try {
            Node obj;
            out.write("<!DOCTYPE ");
            out.write(super.getNodeName());
            if (publicId != null) {
                out.write(" PUBLIC \"");
                out.write(publicId);
                out.write("\"");
                hasPublic = true;
            }
            if (systemId != null) {
                if (!hasPublic) {
                    out.write(" SYSTEM");
                }
                out.write(" \"");
                out.write(systemId);
                out.write("\"");
            }
            boolean extraOutput = false;
            if (internalSubset != null && !internalSubset.equals("") || this.getEntities().getLength() > 0 || this.getNotations().getLength() > 0) {
                extraOutput = true;
            }
            if (!extraOutput) {
                out.write(">");
                return;
            }
            out.write(" [");
            if (internalSubset != null && !internalSubset.equals("")) {
                out.write(Z.NL);
                out.write(this.getInternalSubset());
            }
            int len = this.getNotations().getLength();
            int i = 0;
            while (i < len) {
                obj = this.getNotations().item(i);
                ((DNotation)obj).write(out);
                ++i;
            }
            len = this.getEntities().getLength();
            i = 0;
            while (i < len) {
                obj = this.getEntities().item(i);
                if (obj instanceof DEntity) {
                    ((DEntity)obj).write(out);
                } else {
                    ((DEntityInternal)obj).write(out);
                }
                ++i;
            }
            out.write("]");
            out.write(">");
        }
        catch (IOException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
    }

    public DEntity createEntity(String name) {
        DEntity entity = new DEntity(this.getDsfOwnerDocument(), name);
        this.getDsfEntities().add(entity);
        return entity;
    }

    public DEntity createEntity(String name, String value) {
        DEntity entity = new DEntity(this.getDsfOwnerDocument(), name, value);
        this.getDsfEntities().add(entity);
        return entity;
    }

    public DNotation createNotation(String name) {
        DNotation notation = new DNotation(this.getDsfOwnerDocument(), name);
        this.getDsfNotations().add(notation);
        return notation;
    }

    @Override
    public String getName() {
        return this.getNodeName();
    }

    @Override
    public NamedNodeMap getEntities() {
        return this.m_entities;
    }

    public DNamedNodeMap getDsfEntities() {
        return (DNamedNodeMap)this.getEntities();
    }

    @Override
    public NamedNodeMap getNotations() {
        return this.m_notations;
    }

    public DNamedNodeMap getDsfNotations() {
        return (DNamedNodeMap)this.getNotations();
    }

    @Override
    public String getPublicId() {
        return this.m_publicId;
    }

    @Override
    public String getSystemId() {
        return this.m_systemId;
    }

    @Override
    public String getInternalSubset() {
        return this.m_internalSubset;
    }

    public void setInternalSubset(String internalSubset) {
        this.m_internalSubset = internalSubset;
    }

    @Override
    void setDsfOwnerDocument(DDocument doc) {
        super.setDsfOwnerDocument(doc);
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public DDocumentType jif(String jif) {
        super.jif(jif);
        return this;
    }

    @Override
    public String toString() {
        StringWriter out = new StringWriter(100);
        this.write(out);
        return out.toString();
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (!super.isEqualNode(arg)) {
            return false;
        }
        DDocumentType argDocType = (DDocumentType)arg;
        if (!(this.isEqualString(this.getPublicId(), argDocType.getPublicId()) && this.isEqualString(this.getSystemId(), this.getSystemId()) && this.isEqualString(this.getInternalSubset(), argDocType.getInternalSubset()))) {
            return false;
        }
        if (!this.isSameNamedNodeMap(this.getEntities(), argDocType.getEntities())) {
            return false;
        }
        return this.isSameNamedNodeMap(this.getNotations(), argDocType.getNotations());
    }

    private boolean isSameNamedNodeMap(NamedNodeMap thisObj, NamedNodeMap argObj) {
        if (thisObj == null && argObj != null || thisObj != null && argObj == null) {
            return false;
        }
        if (thisObj != null && argObj != null) {
            if (thisObj.getLength() != argObj.getLength()) {
                return false;
            }
            int index = 0;
            while (thisObj.item(index) != null) {
                Node entNode2;
                Node entNode1 = thisObj.item(index);
                if (!entNode1.isEqualNode(entNode2 = argObj.getNamedItem(entNode1.getNodeName()))) {
                    return false;
                }
                ++index;
            }
        }
        return true;
    }
}

