/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.support;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.dom.support.NSNameVerifier;

public final class DNamespace
implements Serializable {
    public static final String NS_NAME_CHAR = ":";
    private static final long serialVersionUID = 1L;
    private static Map<String, DNamespace> s_nsKeyToNamespaces;
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_PREFIX = "xml";
    public static final String XMLNS_PREFIX = "xmlns";
    public static final DNamespace NO_NAMESPACE;
    public static final DNamespace XML_NAMESPACE;
    private final String m_prefix;
    private final String m_uri;
    private int hashCode = 0;

    static {
        NO_NAMESPACE = new DNamespace("", "");
        XML_NAMESPACE = new DNamespace(XML_PREFIX, XML_URI);
        s_nsKeyToNamespaces = new HashMap<String, DNamespace>();
        s_nsKeyToNamespaces.put("&", NO_NAMESPACE);
        s_nsKeyToNamespaces.put("xml&http://www.w3.org/XML/1998/namespace", XML_NAMESPACE);
    }

    private DNamespace(String prefix, String uri) {
        this.m_prefix = prefix;
        this.m_uri = uri;
    }

    public static DNamespace getNamespace(String namespaceKey) {
        return DNamespace.getNamespace(null, namespaceKey);
    }

    public static DNamespace getNamespace(String prefix, String namespaceKey) {
        DNamespace.checkNamespace(namespaceKey, prefix);
        String nsKey = DNamespace.namespaceKeyFor(prefix, namespaceKey);
        DNamespace namespace = s_nsKeyToNamespaces.get(nsKey);
        if (namespace != null) {
            return namespace;
        }
        namespace = new DNamespace(prefix, namespaceKey);
        s_nsKeyToNamespaces.put(nsKey, namespace);
        return namespace;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public String getNamespaceKey() {
        return this.m_uri;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[Namespace: prefix: \"");
        buf.append(this.m_prefix);
        buf.append("\" uri: \"");
        buf.append(this.m_uri);
        buf.append("\"]");
        return buf.toString();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    private static String namespaceKeyFor(String prefix, String uri) {
        StringBuilder buf = new StringBuilder();
        if (prefix != null) {
            buf.append(prefix);
        }
        buf.append('&');
        buf.append(uri);
        return buf.toString();
    }

    public static void checkNamespace(String namespaceKey, String prefix) {
        String reformated_nsUri = namespaceKey;
        if (namespaceKey != null) {
            reformated_nsUri = namespaceKey.trim().length() == 0 ? null : namespaceKey;
        }
        NSNameVerifier.verifyNSUriName(reformated_nsUri);
        if (DsfVerifierConfig.getInstance().isVerifyNaming()) {
            if (prefix == null) {
                return;
            }
            NSNameVerifier.verifyNSPrefix(prefix, reformated_nsUri);
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hc = 1;
            hc = 31 * hc + (this.m_prefix == null ? 0 : this.m_prefix.hashCode());
            this.hashCode = hc = 31 * hc + (this.m_uri == null ? 0 : this.m_uri.hashCode());
        }
        return this.hashCode;
    }
}

