/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dali.core.IProblem;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.impl.PersistenceModelManager;
import org.eclipse.dali.orm.impl.PersistenceProjectImpl;

public class PersistenceBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.dali.core.persistenceBuilder";
    private PersistenceProjectImpl persistenceProject;

    public static void addBuilderToProject(IProject project) {
        IProjectDescription description;
        if (!project.isOpen()) {
            return;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        ICommand[] cmds = description.getBuildSpec();
        int i = 0;
        while (i < cmds.length) {
            if (cmds[i].getBuilderName().equals(BUILDER_ID)) {
                return;
            }
            ++i;
        }
        ICommand newCommand = description.newCommand();
        newCommand.setBuilderName(BUILDER_ID);
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
        newCommands.addAll(Arrays.asList(cmds));
        newCommands.add(newCommand);
        description.setBuildSpec(newCommands.toArray(new ICommand[newCommands.size()]));
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeBuilderFromProject(IProject project) {
        IProjectDescription description;
        if (!project.isOpen()) {
            return;
        }
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        int index = -1;
        ICommand[] cmds = description.getBuildSpec();
        int i = 0;
        while (i < cmds.length) {
            if (cmds[i].getBuilderName().equals(BUILDER_ID)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        ArrayList<ICommand> newCmds = new ArrayList<ICommand>();
        newCmds.addAll(Arrays.asList(cmds));
        newCmds.remove(index);
        description.setBuildSpec(newCmds.toArray(new ICommand[newCmds.size()]));
        try {
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected IProject[] build(int kind, Map arguments, IProgressMonitor monitor) throws CoreException {
        this.persistenceProject = PersistenceModelManager.getPersistenceModelManager().getPersistenceProject(this.getProject());
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null || kind == 6) {
            this.fullBuild(monitor);
        } else {
            this.incrementalBuild(delta, monitor);
        }
        return new IProject[0];
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        monitor.subTask("Analyzing resources ...");
        ArrayList persistenceFiles = this.computePersistenceFiles();
        float workdone = 20.0f;
        monitor.worked(Math.round(workdone));
        monitor.subTask("Building persistence files ...");
        Iterator stream = persistenceFiles.iterator();
        while (stream.hasNext()) {
            PersistenceFile each = (PersistenceFile)stream.next();
            this.updateProblems(each);
            monitor.worked(Math.round(workdone += (float)(80 / persistenceFiles.size())));
        }
    }

    private ArrayList computePersistenceFiles() throws CoreException {
        ArrayList pfiles = new ArrayList(33);
        Iterator stream = this.persistenceProject.persistenceFiles();
        while (stream.hasNext()) {
            pfiles.add(stream.next());
        }
        return pfiles;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.fullBuild(monitor);
    }

    public static boolean deleteAuditMarkers(IProject project) {
        try {
            project.deleteMarkers("org.eclipse.dali.core.validationProblemMarker", false, 2);
            return true;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    void updateProblems(PersistenceFile pfile) {
        IResource resource = pfile.getResource();
        try {
            resource.deleteMarkers("org.eclipse.dali.core.validationProblemMarker", true, 0);
            Iterator stream = pfile.problems();
            while (stream.hasNext()) {
                IProblem problem = (IProblem)stream.next();
                IMarker marker = resource.createMarker("org.eclipse.dali.core.validationProblemMarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)problem.getMessage());
                marker.setAttribute("lineNumber", problem.getLineNumber());
                marker.setAttribute("charStart", problem.getCharStart());
                marker.setAttribute("charEnd", problem.getCharEnd());
            }
        }
        catch (CoreException coreException) {}
    }

    void updateProblems(IResource changedResource) {
    }
}

