/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d.events;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.events.IAncestorListener;
import org.eclipse.wb.draw2d.events.IFigureListener;

public class AncestorEventTable
implements IFigureListener {
    private final Figure m_figure;
    private List<IAncestorListener> m_listeners;

    public AncestorEventTable(Figure figure) {
        this.m_figure = figure;
        this.hookFigure(this.m_figure);
    }

    @Override
    public void figureMoved(Figure source) {
        for (IAncestorListener listener : this.m_listeners) {
            listener.ancestorMoved(source);
        }
    }

    @Override
    public void figureReparent(Figure source, Figure oldParent, Figure newParent) {
        if (oldParent != null) {
            this.unhookFigure(oldParent);
        }
        if (newParent != null) {
            this.hookFigure(newParent);
        }
    }

    private void hookFigure(Figure figure) {
        Figure ancestor = figure;
        while (ancestor != null) {
            ancestor.addFigureListener(this);
            ancestor = ancestor.getParent();
        }
    }

    private void unhookFigure(Figure figure) {
        Figure ancestor = figure;
        while (ancestor != null) {
            ancestor.removeFigureListener(this);
            ancestor = ancestor.getParent();
        }
    }

    public void unhookFigure() {
        this.unhookFigure(this.m_figure);
    }

    public boolean isEmpty() {
        return this.m_listeners.isEmpty();
    }

    public void addAncestorListener(IAncestorListener listener) {
        if (this.m_listeners == null) {
            this.m_listeners = Lists.newArrayList();
        }
        this.m_listeners.add(listener);
    }

    public void removeAncestorListener(IAncestorListener listener) {
        this.m_listeners.remove(listener);
    }
}

