/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.jface.resource;

import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.util.GlobalStateJava;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swt.model.jface.resource.RegistryContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceRegistryInfo;
import org.eclipse.wb.internal.swt.support.AbstractSupport;
import org.eclipse.wb.internal.swt.support.DisplaySupport;

public final class ResourceRegistryRootProcessor
implements IRootProcessor {
    public void process(JavaInfo root, List<JavaInfo> components) throws Exception {
        this.processRoot(root);
        this.processComponents(root, components);
    }

    private void processRoot(final JavaInfo root) {
        root.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshDispose() throws Exception {
                ResourceRegistryRootProcessor.disposeResourceRegistries(root);
            }

            public void dispose() throws Exception {
                ResourceRegistryRootProcessor.disposeResourceRegistries(root);
            }
        });
    }

    private void processComponents(JavaInfo root, List<JavaInfo> components) throws Exception {
        for (JavaInfo javaInfo : components) {
            if (!(javaInfo instanceof ResourceRegistryInfo)) continue;
            ResourceRegistryInfo resourceRegistryInfo = (ResourceRegistryInfo)javaInfo;
            RegistryContainerInfo.get(root).addChild((ObjectInfo)resourceRegistryInfo);
        }
    }

    private static void disposeResourceRegistries(JavaInfo javaInfo) throws Exception {
        block9: {
            EditorState editorState = EditorState.get((AstEditor)javaInfo.getEditor());
            ObjectInfo activeObject = GlobalState.getActiveObject();
            if (!(activeObject instanceof JavaInfo)) {
                return;
            }
            JavaInfo activeJavaInfo = (JavaInfo)activeObject;
            try {
                Object display;
                Object disposeList;
                GlobalStateJava.activate((JavaInfo)javaInfo);
                if (!AbstractSupport.is_SWT() || (disposeList = ReflectionUtils.getFieldObject((Object)(display = DisplaySupport.getDefault()), (String)"disposeList")) == null) break block9;
                int length = Array.getLength(disposeList);
                int i = 0;
                while (i < length) {
                    Object runnable = Array.get(disposeList, i);
                    if (runnable != null) {
                        try {
                            Object registry = ReflectionUtils.getFieldObject((Object)runnable, (String)"this$0");
                            Class<?> registryClass = registry.getClass();
                            if (editorState.isLoadedFrom(registryClass)) {
                                Array.set(disposeList, i, null);
                                ReflectionUtils.invokeMethod((Object)runnable, (String)"run()", (Object[])new Object[0]);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            finally {
                GlobalStateJava.activate((JavaInfo)activeJavaInfo);
            }
        }
    }
}

