/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.editor.palette.model.AbstractElementInfo;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.EntryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ToolEntryInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryMoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryRemoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.ElementVisibilityCommand;
import org.eclipse.wb.internal.core.editor.palette.command.EntryMoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.EntryRemoveCommand;
import org.eclipse.wb.internal.core.editor.palette.dialogs.AbstractPaletteElementDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.CategoryAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.CategoryEditDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.ComponentAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.ComponentEditDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.ImportArchiveDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoriesAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoryAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoryEditDialog;
import org.eclipse.wb.internal.core.editor.palette.model.entry.InstanceFactoryEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.EmptyTransfer;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;

public final class PaletteManagerDialog
extends ResizableTitleAreaDialog {
    private static final Image IMAGE_CLEAR_FILTER = DesignerPlugin.getImage((String)"palette/clear_filter.gif");
    private static final Image IMAGE_CATEGORY = DesignerPlugin.getImage((String)"palette/category.gif");
    private final AstEditor m_editor;
    private final PaletteInfo m_palette;
    private final Set<EntryInfo> m_goodEntryInfos;
    private final List<Command> m_commands = Lists.newArrayList();
    private CheckboxTreeViewer m_viewer;
    private final PaletteViewerFilter m_filter = new PaletteViewerFilter();
    private Text m_filterText;
    private ToolItem m_filterClearItem;
    private final ITreeContentProvider m_contentProvider = new ITreeContentProvider(){

        public Object[] getElements(Object inputElement) {
            return this.getCategoriesWithGoodEntries().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof CategoryInfo) {
                return ((CategoryInfo)parentElement).getEntries().toArray();
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        public Object getParent(Object element) {
            if (element instanceof EntryInfo) {
                return ((EntryInfo)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private List<CategoryInfo> getCategoriesWithGoodEntries() {
            ArrayList goodCategories = Lists.newArrayList();
            for (CategoryInfo category : PaletteManagerDialog.this.m_palette.getCategories()) {
                if (category.isOptional() && !this.hasGoodEntries(category)) continue;
                goodCategories.add(category);
            }
            return goodCategories;
        }

        private boolean hasGoodEntries(CategoryInfo category) {
            List<EntryInfo> entries = category.getEntries();
            for (EntryInfo entry : entries) {
                if (!PaletteManagerDialog.this.m_goodEntryInfos.contains(entry)) continue;
                return true;
            }
            return false;
        }
    };
    private Button m_addEntryButton;
    private Button m_editButton;
    private Button m_removeButton;
    private Button m_moveUpButton;
    private Button m_moveDownButton;
    private List<Object> m_dragElements;
    private boolean m_dragCategory;

    public PaletteManagerDialog(AstEditor editor, PaletteInfo palette, Set<EntryInfo> goodEntryInfos) {
        super(DesignerPlugin.getShell(), (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_editor = editor;
        this.m_palette = palette;
        this.m_goodEntryInfos = goodEntryInfos;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.PaletteManagerDialog_shellTitle);
        this.setTitle(Messages.PaletteManagerDialog_title);
        this.setMessage(Messages.PaletteManagerDialog_message);
    }

    protected final Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        this.createControls(container);
        return area;
    }

    private void createControls(Composite container) {
        GridLayoutFactory.create((Composite)container).columns(2);
        this.createFilterComposite(container);
        new Label(container, 0);
        this.createViewer(container);
        this.createButtonsComposite(container);
    }

    private void createFilterComposite(Composite container) {
        Composite filterComposite = new Composite(container, 0);
        GridDataFactory.create((Control)filterComposite).fillH();
        GridLayoutFactory.create((Composite)filterComposite).columns(2).noMargins().noSpacing();
        this.m_filterText = new Text(filterComposite, 2048);
        GridDataFactory.create((Control)this.m_filterText).grabH().fillH();
        this.m_filterText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.refreshFilter();
            }
        });
        ToolBar toolBar = new ToolBar(filterComposite, 0x800000);
        this.m_filterClearItem = new ToolItem(toolBar, 0);
        this.m_filterClearItem.setImage(IMAGE_CLEAR_FILTER);
        this.m_filterClearItem.setToolTipText(Messages.PaletteManagerDialog_clearItem);
        this.m_filterClearItem.setEnabled(false);
        this.m_filterClearItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.m_filterText.setText("");
            }
        });
    }

    private void refreshFilter() {
        this.m_viewer.getTree().setRedraw(false);
        try {
            String pattern = this.m_filterText.getText();
            if (pattern.length() == 0) {
                this.m_filterClearItem.setEnabled(false);
                this.m_viewer.resetFilters();
            } else {
                this.m_filterClearItem.setEnabled(true);
                this.m_filter.setPattern(pattern);
                this.m_viewer.resetFilters();
                this.m_viewer.addFilter((ViewerFilter)this.m_filter);
                this.m_viewer.expandAll();
            }
            this.refreshViewer();
        }
        finally {
            this.m_viewer.getTree().setRedraw(true);
        }
    }

    private void createViewer(Composite parent) {
        this.m_viewer = new CheckboxTreeViewer(parent, 2050);
        GridDataFactory.create((Control)this.m_viewer.getTree()).hintC(60, 20).grab().fill();
        this.m_viewer.setContentProvider((IContentProvider)this.m_contentProvider);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof EntryInfo) {
                    return ((EntryInfo)element).getIcon();
                }
                return IMAGE_CATEGORY;
            }

            public String getText(Object element) {
                return ((AbstractElementInfo)element).getName();
            }
        });
        this.m_viewer.setInput((Object)this.m_palette);
        this.refreshViewer();
        this.m_viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractElementInfo elementInfo = (AbstractElementInfo)event.getElement();
                PaletteManagerDialog.this.commands_add(new ElementVisibilityCommand(elementInfo, event.getChecked()));
            }
        });
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PaletteManagerDialog.this.updateButtons();
            }
        });
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PaletteManagerDialog.this.onEdit();
            }
        });
        this.configureDND();
    }

    private void refreshViewer() {
        this.m_viewer.refresh();
        ArrayList visibleElements = Lists.newArrayList();
        for (CategoryInfo category : this.m_palette.getCategories()) {
            if (category.isVisible()) {
                visibleElements.add(category);
            }
            for (EntryInfo entry : category.getEntries()) {
                if (!entry.isVisible()) continue;
                visibleElements.add(entry);
            }
        }
        this.m_viewer.setCheckedElements(visibleElements.toArray());
    }

    private List<Object> getSelectedElements() {
        IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
        return selection.toList();
    }

    private void createButtonsComposite(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        GridDataFactory.create((Control)buttonsComposite).grabV().fill();
        GridLayoutFactory.create((Composite)buttonsComposite).noMargins();
        PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_addCategoryButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.onAddCategory();
            }
        });
        this.m_addEntryButton = PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_addEntryButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.onAddEntry();
            }
        });
        PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_importJarButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.onImportJar();
            }
        });
        PaletteManagerDialog.createButtonSeparator(buttonsComposite);
        this.m_editButton = PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_editButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.onEdit();
            }
        });
        this.m_removeButton = PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_removeButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.onRemove();
            }
        });
        PaletteManagerDialog.createButtonSeparator(buttonsComposite);
        this.m_moveUpButton = PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_upButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.onMove(-1);
            }
        });
        this.m_moveDownButton = PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_downButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.onMove(2);
            }
        });
        PaletteManagerDialog.createButtonSeparator(buttonsComposite);
        PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_collapseAllButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.m_viewer.collapseAll();
            }
        });
        PaletteManagerDialog.createButton(buttonsComposite, Messages.PaletteManagerDialog_expandAllButton, new Listener(){

            public void handleEvent(Event event) {
                PaletteManagerDialog.this.m_viewer.expandAll();
            }
        });
        this.updateButtons();
    }

    private static Button createButton(Composite parent, String text, Listener selectionListener) {
        Button button = new Button(parent, 0);
        GridDataFactory.create((Control)button).grabH().fillH();
        button.setText(text);
        button.addListener(13, selectionListener);
        return button;
    }

    private static void createButtonSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        GridDataFactory.create((Control)separator).hintV(7);
    }

    private void updateButtons() {
        List<Object> selection = this.getSelectedElements();
        this.m_addEntryButton.setEnabled(!selection.isEmpty());
        this.m_editButton.setEnabled(selection.size() == 1);
        this.m_removeButton.setEnabled(!selection.isEmpty());
        List<CategoryInfo> categories = this.m_palette.getCategories();
        boolean upEnabled = !selection.isEmpty();
        boolean downEnabled = !selection.isEmpty();
        for (Object element : selection) {
            if (element instanceof CategoryInfo) {
                upEnabled &= categories.indexOf(element) != 0;
                downEnabled &= categories.indexOf(element) != categories.size() - 1;
                continue;
            }
            if (!(element instanceof EntryInfo)) continue;
            EntryInfo entry = (EntryInfo)element;
            List<EntryInfo> entries = entry.getCategory().getEntries();
            upEnabled &= entries.indexOf(entry) != 0;
            downEnabled &= entries.indexOf(entry) != entries.size() - 1;
        }
        this.m_moveUpButton.setEnabled(upEnabled);
        this.m_moveDownButton.setEnabled(downEnabled);
    }

    private void onAddCategory() {
        CategoryAddDialog dialog = new CategoryAddDialog(this.getShell(), this.m_palette, null);
        if (dialog.open() == 0) {
            this.commands_add(dialog.getCommand());
            this.refreshViewer();
        }
    }

    private void onAddEntry() {
        CategoryInfo targetCategory;
        Object element = this.getSelectedElements().get(0);
        if (element instanceof CategoryInfo) {
            targetCategory = (CategoryInfo)element;
        } else if (element instanceof EntryInfo) {
            targetCategory = ((EntryInfo)element).getCategory();
        } else {
            return;
        }
        MenuManager menuManager = new MenuManager();
        Action action = new Action(Messages.PaletteManagerDialog_addComponentAction){

            public void run() {
                ComponentAddDialog dialog = new ComponentAddDialog(PaletteManagerDialog.this.getShell(), PaletteManagerDialog.this.m_editor, PaletteManagerDialog.this.m_palette, targetCategory);
                if (dialog.open() == 0) {
                    PaletteManagerDialog.this.commands_add(dialog.getCommand());
                    PaletteManagerDialog.this.refreshViewer();
                }
            }
        };
        menuManager.add((IAction)action);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.onAddEntry_factory(targetCategory, true));
        menuManager.add(this.onAddEntry_factories(targetCategory, true));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.onAddEntry_factory(targetCategory, false));
        menuManager.add(this.onAddEntry_factories(targetCategory, false));
        Point location = this.m_addEntryButton.toDisplay(0, this.m_addEntryButton.getSize().y);
        Menu menu = menuManager.createContextMenu((Control)this.getShell());
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private IAction onAddEntry_factory(final CategoryInfo category, final boolean forStatic) {
        return new Action(String.valueOf(Messages.PaletteManagerDialog_addFactorySingle) + (forStatic ? Messages.PaletteManagerDialog_addFactorySingleStatic : Messages.PaletteManagerDialog_addFactorySingleInstance) + Messages.PaletteManagerDialog_addFactorySingleFactory){

            public void run() {
                FactoryAddDialog dialog = new FactoryAddDialog(PaletteManagerDialog.this.getShell(), PaletteManagerDialog.this.m_editor, forStatic, PaletteManagerDialog.this.m_palette, category);
                if (dialog.open() == 0) {
                    PaletteManagerDialog.this.commands_add(dialog.getCommand());
                    PaletteManagerDialog.this.refreshViewer();
                }
            }
        };
    }

    private IAction onAddEntry_factories(final CategoryInfo category, final boolean forStatic) {
        return new Action(String.valueOf(Messages.PaletteManagerDialog_addFactorySeveral) + (forStatic ? Messages.PaletteManagerDialog_addFactorySeveralStatic : Messages.PaletteManagerDialog_addFactorySeveralInstance) + Messages.PaletteManagerDialog_addFactorySeveralFactories){

            public void run() {
                FactoriesAddDialog dialog = new FactoriesAddDialog(PaletteManagerDialog.this.getShell(), PaletteManagerDialog.this.m_editor, PaletteManagerDialog.this.m_palette, category, forStatic);
                if (dialog.open() == 0) {
                    for (Command command : dialog.getCommands()) {
                        PaletteManagerDialog.this.commands_add(command);
                    }
                    PaletteManagerDialog.this.refreshViewer();
                }
            }
        };
    }

    private void onImportJar() {
        List<Object> allSelection = this.getSelectedElements();
        Object selection = allSelection.isEmpty() ? null : allSelection.get(0);
        CategoryInfo nextCategory = null;
        if (selection instanceof CategoryInfo) {
            nextCategory = (CategoryInfo)selection;
        } else if (selection instanceof EntryInfo) {
            EntryInfo entry = (EntryInfo)selection;
            nextCategory = entry.getCategory();
        }
        ImportArchiveDialog dialog = new ImportArchiveDialog(this.getShell(), this.m_palette, nextCategory);
        if (dialog.open() == 0) {
            for (Command command : dialog.getCommands()) {
                this.commands_add(command);
            }
            this.refreshViewer();
        }
    }

    private void onEdit() {
        Object element = this.getSelectedElements().get(0);
        if (element instanceof CategoryInfo) {
            CategoryInfo category = (CategoryInfo)element;
            CategoryEditDialog dialog = new CategoryEditDialog(this.getShell(), category);
            if (dialog.open() == 0) {
                this.commands_add(dialog.getCommand());
                this.refreshViewer();
            }
        } else if (element instanceof ToolEntryInfo) {
            AbstractPaletteElementDialog dialog = null;
            if (element instanceof ComponentEntryInfo) {
                ComponentEntryInfo entryInfo = (ComponentEntryInfo)element;
                dialog = new ComponentEditDialog(this.getShell(), this.m_editor, entryInfo);
            } else if (element instanceof StaticFactoryEntryInfo) {
                StaticFactoryEntryInfo entryInfo = (StaticFactoryEntryInfo)element;
                dialog = new FactoryEditDialog(this.getShell(), this.m_editor, true, entryInfo);
            } else if (element instanceof InstanceFactoryEntryInfo) {
                InstanceFactoryEntryInfo entryInfo = (InstanceFactoryEntryInfo)element;
                dialog = new FactoryEditDialog(this.getShell(), this.m_editor, false, entryInfo);
            }
            if (dialog != null && dialog.open() == 0) {
                this.commands_add(dialog.getCommand());
                this.refreshViewer();
            }
        }
    }

    private void onRemove() {
        List<Object> selection = this.getSelectedElements();
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.PaletteManagerDialog_removeTitle, (String)MessageFormat.format(Messages.PaletteManagerDialog_removeMessage, selection.size()))) {
            for (Object element : selection) {
                if (element instanceof CategoryInfo) {
                    this.commands_add(new CategoryRemoveCommand((CategoryInfo)element));
                    continue;
                }
                if (!(element instanceof EntryInfo)) continue;
                this.commands_add(new EntryRemoveCommand((EntryInfo)element));
            }
            this.refreshViewer();
        }
    }

    private void onMove(int delta) {
        this.m_viewer.getTree().setRedraw(false);
        try {
            for (Object element : this.getSelectedElements()) {
                if (element instanceof CategoryInfo) {
                    CategoryInfo category = (CategoryInfo)element;
                    List<CategoryInfo> categories = this.m_palette.getCategories();
                    int index = categories.indexOf(element);
                    int targetIndex = index + delta;
                    CategoryInfo nextCategory = targetIndex < categories.size() ? categories.get(targetIndex) : null;
                    this.commands_add(new CategoryMoveCommand(category, nextCategory));
                    continue;
                }
                if (!(element instanceof EntryInfo)) continue;
                EntryInfo entry = (EntryInfo)element;
                CategoryInfo category = entry.getCategory();
                List<EntryInfo> entries = category.getEntries();
                int index = entries.indexOf(entry);
                this.commands_add(new EntryMoveCommand(entry, category, entries.get(index + delta)));
            }
            this.refreshViewer();
            this.updateButtons();
        }
        finally {
            this.m_viewer.getTree().setRedraw(true);
        }
    }

    private void configureDND() {
        Transfer[] transfers = new Transfer[]{EmptyTransfer.INSTANCE};
        this.m_viewer.addDragSupport(2, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                PaletteManagerDialog.this.m_dragElements = PaletteManagerDialog.this.getSelectedElements();
                PaletteManagerDialog.this.m_dragCategory = PaletteManagerDialog.this.m_dragElements.get(0) instanceof CategoryInfo;
                for (Object element : PaletteManagerDialog.this.m_dragElements) {
                    if (PaletteManagerDialog.this.m_dragCategory == element instanceof CategoryInfo) continue;
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)this.m_viewer){

            protected int determineLocation(DropTargetEvent event) {
                if (event.item instanceof Item) {
                    Item item = (Item)event.item;
                    Point coordinates = PaletteManagerDialog.this.m_viewer.getControl().toControl(event.x, event.y);
                    Rectangle bounds = this.getBounds(item);
                    if (!PaletteManagerDialog.this.m_dragCategory && this.determineTarget(event) instanceof CategoryInfo) {
                        return 3;
                    }
                    return coordinates.y < bounds.y + bounds.height / 2 ? 1 : 2;
                }
                return 4;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (PaletteManagerDialog.this.m_dragCategory) {
                    return target instanceof CategoryInfo;
                }
                return true;
            }

            public boolean performDrop(Object data) {
                Object target = this.getCurrentTarget();
                int location = this.getCurrentLocation();
                if (PaletteManagerDialog.this.m_dragCategory) {
                    Assert.instanceOf(CategoryInfo.class, (Object)target);
                    Assert.isTrue((location == 1 || location == 2 ? 1 : 0) != 0);
                    List<CategoryInfo> categories = PaletteManagerDialog.this.m_palette.getCategories();
                    int index = categories.indexOf(target);
                    CategoryInfo nextCategory = location == 1 ? categories.get(index) : (CategoryInfo)GenericsUtils.getNextOrNull(categories, (int)index);
                    for (Object element : PaletteManagerDialog.this.m_dragElements) {
                        CategoryInfo category = (CategoryInfo)element;
                        PaletteManagerDialog.this.commands_add(new CategoryMoveCommand(category, nextCategory));
                    }
                } else if (target instanceof CategoryInfo) {
                    Assert.isTrue((location == 3 ? 1 : 0) != 0);
                    CategoryInfo targetCategory = (CategoryInfo)target;
                    for (Object element : PaletteManagerDialog.this.m_dragElements) {
                        EntryInfo entry = (EntryInfo)element;
                        PaletteManagerDialog.this.commands_add(new EntryMoveCommand(entry, targetCategory, null));
                    }
                } else {
                    EntryInfo targetEntry = (EntryInfo)target;
                    CategoryInfo targetCategory = targetEntry.getCategory();
                    List<EntryInfo> entries = targetCategory.getEntries();
                    int index = entries.indexOf(targetEntry);
                    EntryInfo nextEntry = location == 1 ? entries.get(index) : (EntryInfo)GenericsUtils.getNextOrNull(entries, (int)index);
                    for (Object element : PaletteManagerDialog.this.m_dragElements) {
                        EntryInfo entry = (EntryInfo)element;
                        PaletteManagerDialog.this.commands_add(new EntryMoveCommand(entry, targetCategory, nextEntry));
                    }
                }
                PaletteManagerDialog.this.refreshViewer();
                return true;
            }
        };
        dropAdapter.setScrollExpandEnabled(false);
        this.m_viewer.addDropSupport(2, transfers, (DropTargetListener)dropAdapter);
    }

    public List<Command> getCommands() {
        return this.m_commands;
    }

    private void commands_add(Command command) {
        try {
            command.execute(this.m_palette);
            command.addToCommandList(this.m_commands);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class PaletteViewerFilter
    extends ViewerFilter {
        private SearchPattern m_pattern;

        private PaletteViewerFilter() {
        }

        public void setPattern(String pattern) {
            if (pattern.indexOf(42) == -1) {
                pattern = String.valueOf(pattern) + '*';
            }
            this.m_pattern = new SearchPattern();
            this.m_pattern.setPattern(pattern);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof CategoryInfo) {
                CategoryInfo category = (CategoryInfo)element;
                for (EntryInfo entry : category.getEntries()) {
                    if (!this.select(viewer, category, entry)) continue;
                    return true;
                }
            } else if (element instanceof EntryInfo) {
                EntryInfo entry = (EntryInfo)element;
                return this.m_pattern.matches(entry.getName());
            }
            return false;
        }
    }
}

