/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.LabelUiContentProvider;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.ObserveCreationType;
import org.eclipse.wb.internal.swing.databinding.model.ObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanPropertyObserveInfo;
import org.eclipse.wb.internal.swing.databinding.model.beans.BeanSupport;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.ElementTypeUiContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualBindingInfo
extends BindingInfo {
    private IGenericType m_elementType;
    private final boolean m_isTargetVirtual;
    private final ObserveCreationType m_swingType;
    private static ChooseClassConfiguration m_configuration;
    private List<BindingInfo> m_bindings;

    public VirtualBindingInfo(ObserveInfo target, ObserveInfo targetProperty, PropertyInfo targetAstProperty, ObserveInfo model, ObserveInfo modelProperty, PropertyInfo modelAstProperty) {
        super(target, targetProperty, targetAstProperty, model, modelProperty, modelAstProperty);
        this.m_isTargetVirtual = target.getCreationType() == ObserveCreationType.VirtualBinding;
        this.m_swingType = this.m_isTargetVirtual ? model.getCreationType() : target.getCreationType();
    }

    public IGenericType getElementType() {
        return this.m_elementType;
    }

    public void setElementType(IGenericType elementType) {
        this.m_elementType = elementType;
    }

    public ObserveCreationType getSwingType() {
        return this.m_swingType;
    }

    @Override
    public void createContentProviders(List<BindingInfo> bindings, List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        listener.setTitle(Messages.VirtualBindingInfo_listenerTitle);
        listener.setMessage(Messages.VirtualBindingInfo_listenerMessage);
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.VirtualBindingInfo_target, this.getTargetPresentationText(false)));
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.VirtualBindingInfo_model, this.getModelPresentationText(false)));
        if (m_configuration == null) {
            m_configuration = new ChooseClassConfiguration();
            m_configuration.setDialogFieldLabel(Messages.VirtualBindingInfo_chooseTitle);
            m_configuration.setValueScope("beans");
            m_configuration.setChooseInterfaces(true);
            m_configuration.setEmptyClassErrorMessage(Messages.VirtualBindingInfo_chooseError);
            m_configuration.setErrorMessagePrefix(Messages.VirtualBindingInfo_chooseErrorPrefix);
        }
        providers.add((IUiContentProvider)new ElementTypeUiContentProvider(m_configuration, this));
    }

    public void addSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        String reference = this.m_isTargetVirtual ? this.m_model.getReference() : this.m_target.getReference();
        String index = Integer.toString(this.m_bindings.indexOf((Object)this));
        String target = this.m_isTargetVirtual ? "model" : "target";
        lines.add("// [Virtual] " + index + " " + target + " " + reference + " " + this.m_elementType.getFullTypeName());
    }

    public void setVariableIdentifier(JavaInfo javaInfoRoot, String variable, boolean field) {
    }

    @Override
    public void create(List<BindingInfo> bindings) throws Exception {
        this.m_bindings = bindings;
        super.create(bindings);
        this.preCreate();
    }

    @Override
    public void preCreate() throws Exception {
        String propertyName = this.m_swingType == ObserveCreationType.JComboBoxBinding ? "selectedItem" : "selectedElement";
        BeanPropertyObserveInfo selectedElement = BeanSupport.getProperty(this, !this.m_isTargetVirtual, propertyName);
        selectedElement.setHostedType(this.m_elementType);
    }

    @Override
    public void postDelete() throws Exception {
        super.postDelete();
        String propertyName = this.m_swingType == ObserveCreationType.JComboBoxBinding ? "selectedItem" : "selectedElement";
        BeanPropertyObserveInfo selectedElement = BeanSupport.getProperty(this, !this.m_isTargetVirtual, propertyName);
        selectedElement.setHostedType(ClassGenericType.OBJECT_CLASS);
    }

    @Override
    public AstObjectInfo parseExpression(AstEditor editor, String signature, MethodInvocation invocation, Expression[] arguments, IModelResolver resolver, IDatabindingsProvider provider) throws Exception {
        return null;
    }
}

