// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of ccscript.
// 
// The exception is that, if you link the ccscript library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccscript library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name ccscript.  If you copy code from other releases into a copy of
// ccscript, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for ccscript, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include <cc++/url.h>
#include <cc++/export.h>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include "script.h"

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

static class ccMath
{
public:
	ccMath();
	static long fPi(long *values, unsigned prec);
	static long fAbs(long *values, unsigned prec);
	static long fInt(long *values, unsigned prec);
	static long fMin(long *values, unsigned prec);
	static long fMax(long *values, unsigned prec);
	static long fRound(long *values, unsigned prec);
	static long fLimit(long *values, unsigned prec);
	static long fSqrt(long *values, unsigned prec);

} ccmath;

long ccMath::fPi(long *values, unsigned prec)
{
	char pi[10];
	strcpy(pi, "3141592653");
	pi[prec + 1] = 0;
	return atol(pi);
}

long ccMath::fAbs(long *values, unsigned prec)
{
	if(*values < 0)
		return -*values;
	else
		return *values;
}
	
long ccMath::fInt(long *values, unsigned prec)
{
	return ScriptInterp::getInteger(*values, prec) * ScriptInterp::getTens(prec);
}

long ccMath::fMin(long *values, unsigned prec)
{
	if(values[0] < values[1])
		return values[0];

	return values[1];
}

long ccMath::fMax(long *values, unsigned prec)
{
        if(values[0] > values[1])
                return values[0];
        
        return values[1];
}

long ccMath::fLimit(long *values, unsigned prec)
{
	if(values[0] < values[1])
		return values[1];

	if(values[0] > values[2])
		return values[2];

	return values[0];
}

long ccMath::fRound(long *values, unsigned prec)
{
	if(!values[1])
		return values[0];

	return (values[0] / values[1]) * values[1];
}

long ccMath::fSqrt(long *values, unsigned prec)
{
	double sq = sqrt(ScriptInterp::getDouble(*values, prec));
	return ScriptInterp::getRealValue(sq, prec);
}

ccMath::ccMath()
{
	addFunction("abs", 1, &fAbs);
	addFunction("pi", 0, &fPi);
	addFunction("int", 1, &fInt);
	addFunction("min", 2, &fMin);
	addFunction("max", 2, &fMax);
	addFunction("round", 2, &fRound);
	addFunction("limit", 3, &fLimit);
	addFunction("sqrt", 1, &fSqrt);
};

#ifdef	CCXX_NAMESPACES
};
#endif



