/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import [Ljava.lang.Integer;;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.drc.Schematic;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DRC
extends Listener {
    protected static DRC tool = new DRC();
    private static HashMap prefDRCOverride = new HashMap();
    private static HashMap cellsToCheck = new HashMap();
    private static boolean incrementalRunning = false;
    public static final Variable.Key LAST_GOOD_DRC_DATE = ElectricObject.newKey("DRC_last_good_drc_date");
    public static final Variable.Key LAST_GOOD_DRC_BIT = ElectricObject.newKey("DRC_last_good_drc_bit");
    public static final int DRC_BIT_AREA = 1;
    public static final int DRC_BIT_COVERAGE = 2;
    private static DRCRules currentRules = null;
    private static Technology currentTechnology = null;
    private static Pref cacheIncrementalDRCOn = Pref.makeBooleanPref("IncrementalDRCOn", DRC.tool.prefs, true);
    private static Pref cacheOneErrorPerCell = Pref.makeBooleanPref("OneErrorPerCell", DRC.tool.prefs, false);
    private static Pref cacheUseMultipleThreads = Pref.makeBooleanPref("UseMultipleThreads", DRC.tool.prefs, false);
    private static Pref cacheNumberOfThreads = Pref.makeIntPref("NumberOfThreads", DRC.tool.prefs, 2);
    private static Pref cacheIgnoreCenterCuts = Pref.makeBooleanPref("IgnoreCenterCuts", DRC.tool.prefs, false);
    private static Pref cacheIgnoreAreaChecking;
    private static Pref cacheIgnorePolySelectChecking;
    public static final Variable.Key POSTSCRIPT_FILEDATE;

    private DRC() {
        super("drc");
    }

    public void init() {
        this.setOn();
    }

    public static DRC getDRCTool() {
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void includeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            HashSet<Geometric> cellSet = (HashSet<Geometric>)cellsToCheck.get(cell);
            if (cellSet == null) {
                cellSet = new HashSet<Geometric>();
                cellsToCheck.put(cell, cellSet);
            }
            cellSet.add(geom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            HashSet cellSet = (HashSet)cellsToCheck.get(cell);
            if (cellSet != null) {
                cellSet.remove(geom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doIncrementalDRCTask() {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        if (incrementalRunning) {
            return;
        }
        Library curLib = Library.getCurrent();
        if (curLib == null) {
            return;
        }
        Cell cellToCheck = curLib.getCurCell();
        HashSet cellSet = null;
        HashMap hashMap = cellsToCheck;
        synchronized (hashMap) {
            if (cellToCheck != null) {
                cellSet = (HashSet)cellsToCheck.get(cellToCheck);
            }
            if (cellSet == null && cellsToCheck.size() > 0) {
                cellToCheck = (Cell)cellsToCheck.keySet().iterator().next();
                cellSet = (HashSet)cellsToCheck.get(cellToCheck);
            }
            if (cellSet != null) {
                cellsToCheck.remove(cellToCheck);
            }
        }
        if (cellToCheck == null) {
            return;
        }
        if (!cellToCheck.isLinked()) {
            return;
        }
        if (cellToCheck.getLibrary().isHidden()) {
            return;
        }
        if (cellSet != null) {
            Geometric[] objectsToCheck = new Geometric[cellSet.size()];
            int i = 0;
            Iterator it = cellSet.iterator();
            while (it.hasNext()) {
                objectsToCheck[i++] = (Geometric)it.next();
            }
            CheckLayoutIncrementally job = new CheckLayoutIncrementally(cellToCheck, objectsToCheck);
        }
    }

    public void endBatch() {
        DRC.doIncrementalDRCTask();
    }

    public void modifyNodeInst(NodeInst ni, double oCX, double oCY, double oSX, double oSY, int oRot) {
        DRC.includeGeometric(ni);
    }

    public void modifyNodeInsts(NodeInst[] nis, double[] oCX, double[] oCY, double[] oSX, double[] oSY, int[] oRot) {
        for (int i = 0; i < nis.length; ++i) {
            DRC.includeGeometric(nis[i]);
        }
    }

    public void modifyArcInst(ArcInst ai, double oHX, double oHY, double oTX, double oTY, double oWid) {
        DRC.includeGeometric(ai);
    }

    public void newObject(ElectricObject obj) {
        if (obj instanceof Geometric) {
            DRC.includeGeometric((Geometric)obj);
        }
    }

    public void killObject(ElectricObject obj) {
        if (obj instanceof Geometric) {
            DRC.removeGeometric((Geometric)obj);
        }
    }

    public static void checkHierarchically(boolean areaCheck) {
        Cell curCell = null;
        Rectangle2D bounds = null;
        if (!areaCheck) {
            curCell = WindowFrame.needCurCell();
        } else {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return;
            }
            Highlighter h = wnd.getHighlighter();
            bounds = h.getHighlightedArea(wnd);
            curCell = wnd.getCell();
        }
        if (curCell == null) {
            return;
        }
        if (curCell.isSchematic() || curCell.getTechnology() == Schematics.tech || curCell.isIcon() || curCell.getTechnology() == Artwork.tech) {
            CheckSchematicHierarchically job = new CheckSchematicHierarchically(curCell, bounds);
        } else {
            CheckLayoutHierarchically checkLayoutHierarchically = new CheckLayoutHierarchically(curCell, bounds);
        }
    }

    public static void resetDRCDates() {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                DRC.cleanDRCDateAndBits(cell);
            }
        }
    }

    public static DRCRules getRules(Technology tech) {
        if (currentRules != null && tech == currentTechnology) {
            return currentRules;
        }
        currentRules = tech.getFactoryDesignRules();
        if (currentRules != null) {
            StringBuffer override = DRC.getDRCOverrides(tech);
            currentRules.applyDRCOverrides(override.toString(), tech);
        }
        currentTechnology = tech;
        return currentRules;
    }

    public static void setRules(Technology tech, DRCRules newRules) {
        DRCRules factoryRules = tech.getFactoryDesignRules();
        StringBuffer changes = Technology.getRuleDifferences(factoryRules, newRules);
        StringBuffer override = DRC.getDRCOverrides(tech);
        if (changes.toString().equals(override.toString())) {
            return;
        }
        DRC.setDRCOverrides(changes, tech);
        tech.setRuleVariables(newRules);
        if (currentTechnology == tech) {
            currentTechnology = null;
        }
    }

    public static double getWorstSpacingDistance(Technology tech) {
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return 0.0;
        }
        return rules.getWorstSpacingDistance();
    }

    public static double getMaxSurround(Layer layer, double maxSize) {
        Technology tech = layer.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return -1.0;
        }
        return rules.getMaxSurround(tech, layer, maxSize);
    }

    public static DRCRules.DRCRule getEdgeRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getEdgeRule(tech, layer1, layer2);
    }

    public static DRCRules.DRCRule getSpacingRule(Layer layer1, Layer layer2, boolean connected, boolean multiCut, double wideS) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getSpacingRule(tech, layer1, layer2, connected, multiCut, wideS);
    }

    public static boolean isAnyRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return false;
        }
        return rules.isAnyRule(tech, layer1, layer2);
    }

    public static DRCRules.DRCRule getMinValue(Layer layer, int type) {
        Technology tech = layer.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getMinValue(layer, type);
    }

    public static NodeSizeRule getMinSize(NodeProto np) {
        if (np instanceof Cell) {
            return null;
        }
        PrimitiveNode pnp = (PrimitiveNode)np;
        if (pnp.getMinWidth() < 0.0 && pnp.getMinHeight() < 0.0) {
            return null;
        }
        return new NodeSizeRule(pnp.getMinWidth(), pnp.getMinHeight(), pnp.getMinSizeRule());
    }

    private static StringBuffer getDRCOverrides(Technology tech) {
        Pref pref = (Pref)prefDRCOverride.get(tech);
        if (pref == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pref.getString());
        return sb;
    }

    private static void setDRCOverrides(StringBuffer sb, Technology tech) {
        Pref pref;
        if (sb.length() >= 8192) {
            System.out.println("Warning: Design rule overrides are too complex to be saved (are " + sb.length() + " long which is more than the limit of " + 8192 + ")");
        }
        if ((pref = (Pref)prefDRCOverride.get(tech)) == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        pref.setString(sb.toString());
    }

    public static boolean isIncrementalDRCOn() {
        return cacheIncrementalDRCOn.getBoolean();
    }

    public static void setIncrementalDRCOn(boolean on) {
        cacheIncrementalDRCOn.setBoolean(on);
    }

    public static boolean isOneErrorPerCell() {
        return cacheOneErrorPerCell.getBoolean();
    }

    public static void setOneErrorPerCell(boolean on) {
        cacheOneErrorPerCell.setBoolean(on);
    }

    public static boolean isUseMultipleThreads() {
        return cacheUseMultipleThreads.getBoolean();
    }

    public static void setUseMultipleThreads(boolean on) {
        cacheUseMultipleThreads.setBoolean(on);
    }

    public static int getNumberOfThreads() {
        return cacheNumberOfThreads.getInt();
    }

    public static void setNumberOfThreads(int th) {
        cacheNumberOfThreads.setInt(th);
    }

    public static boolean isIgnoreCenterCuts() {
        return cacheIgnoreCenterCuts.getBoolean();
    }

    public static void setIgnoreCenterCuts(boolean on) {
        cacheIgnoreCenterCuts.setBoolean(on);
    }

    public static boolean isIgnoreAreaChecking() {
        return cacheIgnoreAreaChecking.getBoolean();
    }

    public static void setIgnoreAreaChecking(boolean on) {
        cacheIgnoreAreaChecking.setBoolean(on);
    }

    public static boolean isIgnorePolySelectChecking() {
        return cacheIgnorePolySelectChecking.getBoolean();
    }

    public static void setIgnorePolySelectChecking(boolean on) {
        cacheIgnorePolySelectChecking.setBoolean(on);
    }

    public static Date getLastDRCDateBasedOnBits(Cell cell, byte activeBits) {
        boolean coverage;
        Variable varDate = cell.getVar(LAST_GOOD_DRC_DATE, Integer;.class);
        if (varDate == null) {
            return null;
        }
        Variable varBits = cell.getVar(LAST_GOOD_DRC_BIT, Byte.class);
        byte thisByte = (Byte)varBits.getObject();
        boolean area = (thisByte & 1) == (activeBits & 1);
        boolean bl = coverage = (thisByte & 2) == (activeBits & 2);
        if (!(activeBits == 0 || area && coverage)) {
            return null;
        }
        Integer[] lastDRCDateAsInts = (Integer[])varDate.getObject();
        long lastDRCDateInSecondsHigh = lastDRCDateAsInts[0].intValue();
        long lastDRCDateInSecondsLow = lastDRCDateAsInts[1].intValue();
        long lastDRCDateInSeconds = lastDRCDateInSecondsHigh << 32 | lastDRCDateInSecondsLow & 0xFFFFFFFFL;
        Date lastDRCDate = new Date(lastDRCDateInSeconds);
        return lastDRCDate;
    }

    public static void setLastDRCDateAndBits(Cell cell, Date date, byte bits) {
        long iVal = date.getTime();
        Integer[] dateArray = new Integer[]{new Integer((int)(iVal >> 32)), new Integer((int)(iVal & 0xFFFFFFFFFFFFFFFFL))};
        cell.newVar(LAST_GOOD_DRC_DATE, (Object)dateArray);
        Byte b = new Byte(bits);
        cell.newVar(LAST_GOOD_DRC_BIT, (Object)b);
    }

    public static void cleanDRCDateAndBits(Cell cell) {
        cell.delVar(LAST_GOOD_DRC_DATE);
        cell.delVar(LAST_GOOD_DRC_BIT);
    }

    public static byte getActiveBits() {
        byte bits = 0;
        if (!DRC.isIgnoreAreaChecking()) {
            bits = (byte)(bits | 1);
        }
        if (!DRC.isIgnorePolySelectChecking()) {
            bits = (byte)(bits | 2);
        }
        return bits;
    }

    static {
        cacheIgnoreCenterCuts.attachToObject(tool, "Tools/DRC tab", "DRC ignores center cuts in large contacts");
        cacheIgnoreAreaChecking = Pref.makeBooleanPref("IgnoreAreaCheck", DRC.tool.prefs, false);
        cacheIgnoreAreaChecking.attachToObject(tool, "Tools/DRC tab", "DRC ignores area checking");
        cacheIgnorePolySelectChecking = Pref.makeBooleanPref("IgnorePolySelectCheck", DRC.tool.prefs, false);
        cacheIgnorePolySelectChecking.attachToObject(tool, "Tools/DRC tab", "DRC ignores polysilicon select rule checking");
        POSTSCRIPT_FILEDATE = ElectricObject.newKey("IO_postscript_filedate");
    }

    private static class CheckSchematicHierarchically
    extends Job {
        Cell cell;
        Rectangle2D bounds;

        protected CheckSchematicHierarchically(Cell cell, Rectangle2D bounds) {
            super("Design-Rule Check", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.bounds = bounds;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            ErrorLogger errorLog = Schematic.doCheck(this.cell);
            long endTime = System.currentTimeMillis();
            int errorCount = errorLog.getNumErrors();
            System.out.println(errorCount + " errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            return true;
        }
    }

    private static class CheckLayoutIncrementally
    extends CheckDRCLayoutJob {
        Geometric[] objectsToCheck;

        protected CheckLayoutIncrementally(Cell cell, Geometric[] objectsToCheck) {
            super("DRC in cell " + cell.describe(), cell, tool, Job.Priority.ANALYSIS);
            this.objectsToCheck = objectsToCheck;
            this.startJob();
        }

        public boolean doIt() {
            incrementalRunning = true;
            int errorsFound = Quick.checkDesignRules(this.cell, this.objectsToCheck.length, this.objectsToCheck, null, null, this);
            if (errorsFound > 0) {
                System.out.println("Incremental DRC found " + errorsFound + " errors/warnings in cell " + this.cell.describe());
            }
            incrementalRunning = false;
            DRC.doIncrementalDRCTask();
            return true;
        }
    }

    private static class CheckLayoutHierarchically
    extends CheckDRCLayoutJob {
        Rectangle2D bounds;

        protected CheckLayoutHierarchically(Cell cell, Rectangle2D bounds) {
            super("Design-Rule Check", cell, tool, Job.Priority.USER);
            this.bounds = bounds;
            this.startJob();
        }

        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            int errorCount = 0;
            int warnCount = 0;
            if (Quick.checkDesignRules(this.cell, 0, null, null, this.bounds, this) > 0) {
                errorCount = ErrorLogger.getCurrent().getNumErrors();
                warnCount = ErrorLogger.getCurrent().getNumWarnings();
            }
            long endTime = System.currentTimeMillis();
            System.out.println(errorCount + " errors and " + warnCount + " warnings found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            return true;
        }
    }

    public static class CheckDRCLayoutJob
    extends Job {
        Cell cell;

        protected CheckDRCLayoutJob(String title, Cell cell, Listener tool, Job.Priority priority) {
            super(title, tool, Job.Type.EXAMINE, null, null, priority);
            this.cell = cell;
        }

        public boolean doIt() {
            return false;
        }
    }

    public static class NodeSizeRule {
        public double sizeX;
        public double sizeY;
        public String rule;

        NodeSizeRule(double sizeX, double sizeY, String rule) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.rule = rule;
        }
    }
}

