/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.Resources;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class Layer {
    public static final LayerSort layerSort = new LayerSort();
    private String name;
    private int index;
    private Technology tech;
    private EGraphics graphics;
    private Function function;
    private int functionExtras;
    private String cifLayer;
    private String dxfLayer;
    private String gdsLayer;
    private String skillLayer;
    private double thickness;
    private double distance;
    private double areaCoverage;
    private double resistance;
    private double capacitance;
    private double edgeCapacitance;
    private Layer nonPseudoLayer;
    private boolean visible;
    private boolean dimmed;
    private PrimitiveNode pureLayerNode;
    private static HashMap cifLayerPrefs = new HashMap();
    private static HashMap gdsLayerPrefs = new HashMap();
    private static HashMap dxfLayerPrefs = new HashMap();
    private static HashMap skillLayerPrefs = new HashMap();
    private static HashMap resistanceParasiticPrefs = new HashMap();
    private static HashMap capacitanceParasiticPrefs = new HashMap();
    private static HashMap edgeCapacitanceParasiticPrefs = new HashMap();
    private static final HashMap layerVisibilityPrefs = new HashMap();
    private static final HashMap layer3DThicknessPrefs = new HashMap();
    private static final HashMap layer3DDistancePrefs = new HashMap();
    private static final HashMap areaCoveragePrefs = new HashMap();

    private Layer(String name, Technology tech, EGraphics graphics) {
        this.name = name;
        this.tech = tech;
        this.graphics = graphics;
        this.nonPseudoLayer = this;
        this.visible = true;
        this.dimmed = false;
        this.function = Function.UNKNOWN;
        this.areaCoverage = 10.0;
    }

    public static Layer newInstance(Technology tech, String name, EGraphics graphics) {
        Layer layer = new Layer(name, tech, graphics);
        graphics.setLayer(layer);
        if (tech != null) {
            tech.addLayer(layer);
        }
        return layer;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public EGraphics getGraphics() {
        return this.graphics;
    }

    public void setFunction(Function function) {
        this.function = function;
        this.functionExtras = 0;
    }

    public void setFunction(Function function, int functionExtras) {
        this.function = function;
        this.functionExtras = functionExtras;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getFunctionExtras() {
        return this.functionExtras;
    }

    public void setPureLayerNode(PrimitiveNode pln) {
        this.pureLayerNode = pln;
    }

    public PrimitiveNode getPureLayerNode() {
        return this.pureLayerNode;
    }

    public boolean isNonElectrical() {
        return (this.functionExtras & 0x2000) != 0;
    }

    public boolean isDiffusionLayer() {
        int extras = this.getFunctionExtras();
        return (extras & 0x1000) == 0 && this.getFunction().isDiff();
    }

    public Layer getNonPseudoLayer() {
        return this.nonPseudoLayer;
    }

    public void setNonPseudoLayer(Layer nonPseudoLayer) {
        this.nonPseudoLayer = nonPseudoLayer;
    }

    public boolean isVisible() {
        if (this.tech == null) {
            return true;
        }
        return this.getBooleanPref("Visibility", layerVisibilityPrefs, this.visible).getBoolean();
    }

    public void setVisible(boolean visible) {
        this.getBooleanPref("Visibility", layerVisibilityPrefs, visible).setBoolean(visible);
    }

    public boolean isDimmed() {
        return this.dimmed;
    }

    public void setDimmed(boolean dimmed) {
        this.dimmed = dimmed;
    }

    private Pref getLayerPref(String what, HashMap map, String factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            if (factory == null) {
                factory = "";
            }
            pref = Pref.makeStringPref(what + "LayerFor" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            pref.attachToObject(this.tech, "IO/" + what + " tab", what + " for layer " + this.name + " in technology " + this.tech.getTechName());
            map.put(this, pref);
        }
        return pref;
    }

    private Pref getParasiticPref(String what, HashMap map, double factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref(what + "ParasiticFor" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            pref.attachToObject(this.tech, "Tools/Spice tab", "Technology " + this.tech.getTechName() + ", " + what + " for layer " + this.name);
            map.put(this, pref);
        }
        return pref;
    }

    public Pref getBooleanPref(String what, HashMap map, boolean factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeBooleanPref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public Pref getDoublePref(String what, HashMap map, double factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public Pref getIntegerPref(String what, HashMap map, int factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeIntPref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public void setFactory3DInfo(double thickness, double distance) {
        this.thickness = thickness;
        this.distance = distance;
        this.getDoublePref("Distance", layer3DDistancePrefs, this.distance).setDouble(this.distance);
        this.getDoublePref("Thickness", layer3DThicknessPrefs, this.thickness).setDouble(this.thickness);
    }

    public double getDistance() {
        return this.getDoublePref("Distance", layer3DDistancePrefs, this.distance).getDouble();
    }

    public void setDistance(double distance) {
        try {
            Class viewClass = Resources.get3DClass("View3DWindow");
            Method setMethod = viewClass.getDeclaredMethod("setZValues", Layer.class, Double.class, Double.class, Double.class, Double.class);
            setMethod.invoke((Object)viewClass, this, new Double(this.getDistance()), new Double(this.getThickness()), new Double(distance), new Double(this.getThickness()));
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method setZValues: " + e.getMessage());
            e.printStackTrace();
        }
        this.getDoublePref("Distance", layer3DDistancePrefs, this.distance).setDouble(distance);
    }

    public double getDepth() {
        return this.getDistance() + this.getThickness();
    }

    public double getThickness() {
        return this.getDoublePref("Thickness", layer3DThicknessPrefs, this.thickness).getDouble();
    }

    public void setThickness(double thickness) {
        try {
            Class viewClass = Resources.get3DClass("View3DWindow");
            Method setMethod = viewClass.getDeclaredMethod("setZValues", Layer.class, Double.class, Double.class, Double.class, Double.class);
            setMethod.invoke((Object)viewClass, this, new Double(this.getDistance()), new Double(this.getThickness()), new Double(this.distance), new Double(thickness));
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method setZValues: " + e.getMessage());
            e.printStackTrace();
        }
        this.getDoublePref("Thickness", layer3DThicknessPrefs, thickness).setDouble(thickness);
    }

    public void setFactoryCIFLayer(String cifLayer) {
        this.getLayerPref("CIF", cifLayerPrefs, cifLayer);
    }

    public void setCIFLayer(String cifLayer) {
        this.getLayerPref("CIF", cifLayerPrefs, this.cifLayer).setString(cifLayer);
    }

    public String getCIFLayer() {
        return this.getLayerPref("CIF", cifLayerPrefs, this.cifLayer).getString();
    }

    public void setFactoryGDSLayer(String gdsLayer) {
        this.getLayerPref("GDS", gdsLayerPrefs, gdsLayer);
    }

    public void setGDSLayer(String gdsLayer) {
        this.getLayerPref("GDS", gdsLayerPrefs, this.gdsLayer).setString(gdsLayer);
    }

    public String getGDSLayer() {
        return this.getLayerPref("GDS", gdsLayerPrefs, this.gdsLayer).getString();
    }

    public void setFactoryDXFLayer(String dxfLayer) {
        this.getLayerPref("DXF", dxfLayerPrefs, dxfLayer);
    }

    public void setDXFLayer(String dxfLayer) {
        this.getLayerPref("DXF", dxfLayerPrefs, this.dxfLayer).setString(dxfLayer);
    }

    public String getDXFLayer() {
        return this.getLayerPref("DXF", dxfLayerPrefs, this.dxfLayer).getString();
    }

    public void setFactorySkillLayer(String skillLayer) {
        this.getLayerPref("Skill", skillLayerPrefs, skillLayer);
    }

    public void setSkillLayer(String skillLayer) {
        this.getLayerPref("Skill", skillLayerPrefs, this.skillLayer).setString(skillLayer);
    }

    public String getSkillLayer() {
        return this.getLayerPref("Skill", skillLayerPrefs, this.skillLayer).getString();
    }

    public void setFactoryParasitics(double resistance, double capacitance, double edgeCapacitance) {
        this.resistance = resistance;
        this.getParasiticPref("Resistance", resistanceParasiticPrefs, this.resistance);
        this.capacitance = capacitance;
        this.getParasiticPref("Capacitance", capacitanceParasiticPrefs, this.capacitance);
        this.edgeCapacitance = edgeCapacitance;
        this.getParasiticPref("EdgeCapacitance", edgeCapacitanceParasiticPrefs, this.edgeCapacitance);
    }

    public double getResistance() {
        return this.getParasiticPref("Resistance", resistanceParasiticPrefs, this.resistance).getDouble();
    }

    public void setResistance(double resistance) {
        this.getParasiticPref("Resistance", resistanceParasiticPrefs, this.resistance).setDouble(resistance);
    }

    public double getCapacitance() {
        return this.getParasiticPref("Capacitance", capacitanceParasiticPrefs, this.capacitance).getDouble();
    }

    public void setCapacitance(double capacitance) {
        this.getParasiticPref("Capacitance", capacitanceParasiticPrefs, this.capacitance).setDouble(capacitance);
    }

    public double getEdgeCapacitance() {
        return this.getParasiticPref("EdgeCapacitance", edgeCapacitanceParasiticPrefs, this.edgeCapacitance).getDouble();
    }

    public void setEdgeCapacitance(double edgeCapacitance) {
        this.getParasiticPref("EdgeCapacitance", edgeCapacitanceParasiticPrefs, this.edgeCapacitance).setDouble(edgeCapacitance);
    }

    public void setFactoryAreaCoverage(double area) {
        this.areaCoverage = area;
        this.getDoublePref("AreaCoverage", areaCoveragePrefs, this.areaCoverage).setDouble(this.areaCoverage);
    }

    public double getAreaCoverage() {
        return this.getDoublePref("AreaCoverage", areaCoveragePrefs, this.areaCoverage).getDouble();
    }

    public void setFactoryAreaCoverageInfo(double area) {
        this.getDoublePref("AreaCoverage", areaCoveragePrefs, this.areaCoverage).setDouble(area);
    }

    public String toString() {
        return "Layer " + this.name;
    }

    private static class LayerSort
    implements Comparator {
        private LayerSort() {
        }

        private static int compareStatic(Layer l1, Layer l2) {
            String s1 = l1.getName();
            String s2 = l2.getName();
            return s1.compareToIgnoreCase(s2);
        }

        public int compare(Object o1, Object o2) {
            return LayerSort.compareStatic((Layer)o1, (Layer)o2);
        }
    }

    public static class Function {
        public static final int PTYPE = 64;
        public static final int NTYPE = 128;
        public static final int DEPLETION = 256;
        public static final int ENHANCEMENT = 512;
        public static final int LIGHT = 1024;
        public static final int HEAVY = 2048;
        public static final int PSEUDO = 4096;
        public static final int NONELEC = 8192;
        public static final int CONMETAL = 16384;
        public static final int CONPOLY = 32768;
        public static final int CONDIFF = 65536;
        public static final int HLVT = 0x200000;
        public static final int INTRANS = 0x400000;
        public static final int THICK = 0x800000;
        private final String name;
        private final String constantName;
        private int level;
        private final int height;
        private final int extraBits;
        private static HashMap metalLayers = new HashMap();
        private static HashMap polyLayers = new HashMap();
        private static List allFunctions = new ArrayList();
        private static final int[] extras = new int[]{64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 0x400000, 0x800000};
        public static final Function UNKNOWN = new Function("unknown", "UNKNOWN", 0, 0, 35, 0);
        public static final Function METAL1 = new Function("metal-1", "METAL1", 1, 0, 17, 0);
        public static final Function METAL2 = new Function("metal-2", "METAL2", 2, 0, 19, 0);
        public static final Function METAL3 = new Function("metal-3", "METAL3", 3, 0, 21, 0);
        public static final Function METAL4 = new Function("metal-4", "METAL4", 4, 0, 23, 0);
        public static final Function METAL5 = new Function("metal-5", "METAL5", 5, 0, 25, 0);
        public static final Function METAL6 = new Function("metal-6", "METAL6", 6, 0, 27, 0);
        public static final Function METAL7 = new Function("metal-7", "METAL7", 7, 0, 29, 0);
        public static final Function METAL8 = new Function("metal-8", "METAL8", 8, 0, 31, 0);
        public static final Function METAL9 = new Function("metal-9", "METAL9", 9, 0, 33, 0);
        public static final Function METAL10 = new Function("metal-10", "METAL10", 10, 0, 35, 0);
        public static final Function METAL11 = new Function("metal-11", "METAL11", 11, 0, 37, 0);
        public static final Function METAL12 = new Function("metal-12", "METAL12", 12, 0, 39, 0);
        public static final Function POLY1 = new Function("poly-1", "POLY1", 0, 1, 12, 0);
        public static final Function POLY2 = new Function("poly-2", "POLY2", 0, 2, 13, 0);
        public static final Function POLY3 = new Function("poly-3", "POLY3", 0, 3, 14, 0);
        public static final Function GATE = new Function("gate", "GATE", 0, 0, 15, 0x400000);
        public static final Function DIFF = new Function("diffusion", "DIFF", 0, 0, 11, 0);
        public static final Function DIFFP = new Function("p-diffusion", "DIFF", 0, 0, 11, 64);
        public static final Function DIFFN = new Function("n-diffusion", "DIFF", 0, 0, 11, 128);
        public static final Function IMPLANT = new Function("implant", "IMPLANT", 0, 0, 2, 0);
        public static final Function IMPLANTP = new Function("p-implant", "IMPLANT", 0, 0, 2, 64);
        public static final Function IMPLANTN = new Function("n-implant", "IMPLANT", 0, 0, 2, 128);
        public static final Function CONTACT1 = new Function("contact-1", "CONTACT1", 0, 0, 16, 0);
        public static final Function CONTACT2 = new Function("contact-2", "CONTACT2", 0, 0, 18, 0);
        public static final Function CONTACT3 = new Function("contact-3", "CONTACT3", 0, 0, 20, 0);
        public static final Function CONTACT4 = new Function("contact-4", "CONTACT4", 0, 0, 22, 0);
        public static final Function CONTACT5 = new Function("contact-5", "CONTACT5", 0, 0, 24, 0);
        public static final Function CONTACT6 = new Function("contact-6", "CONTACT6", 0, 0, 26, 0);
        public static final Function CONTACT7 = new Function("contact-7", "CONTACT7", 0, 0, 28, 0);
        public static final Function CONTACT8 = new Function("contact-8", "CONTACT8", 0, 0, 30, 0);
        public static final Function CONTACT9 = new Function("contact-9", "CONTACT9", 0, 0, 32, 0);
        public static final Function CONTACT10 = new Function("contact-10", "CONTACT10", 0, 0, 34, 0);
        public static final Function CONTACT11 = new Function("contact-11", "CONTACT11", 0, 0, 36, 0);
        public static final Function CONTACT12 = new Function("contact-12", "CONTACT12", 0, 0, 38, 0);
        public static final Function PLUG = new Function("plug", "PLUG", 0, 0, 40, 0);
        public static final Function OVERGLASS = new Function("overglass", "OVERGLASS", 0, 0, 41, 0);
        public static final Function RESISTOR = new Function("resistor", "RESISTOR", 0, 0, 4, 0);
        public static final Function CAP = new Function("capacitor", "CAP", 0, 0, 5, 0);
        public static final Function TRANSISTOR = new Function("transistor", "TRANSISTOR", 0, 0, 3, 0);
        public static final Function EMITTER = new Function("emitter", "EMITTER", 0, 0, 6, 0);
        public static final Function BASE = new Function("base", "BASE", 0, 0, 7, 0);
        public static final Function COLLECTOR = new Function("collector", "COLLECTOR", 0, 0, 8, 0);
        public static final Function SUBSTRATE = new Function("substrate", "SUBSTRATE", 0, 0, 1, 0);
        public static final Function WELL = new Function("well", "WELL", 0, 0, 0, 0);
        public static final Function WELLP = new Function("p-well", "WELL", 0, 0, 0, 64);
        public static final Function WELLN = new Function("n-well", "WELL", 0, 0, 0, 128);
        public static final Function GUARD = new Function("guard", "GUARD", 0, 0, 9, 0);
        public static final Function ISOLATION = new Function("isolation", "ISOLATION", 0, 0, 10, 0);
        public static final Function BUS = new Function("bus", "BUS", 0, 0, 42, 0);
        public static final Function ART = new Function("art", "ART", 0, 0, 43, 0);
        public static final Function CONTROL = new Function("control", "CONTROL", 0, 0, 44, 0);
        public static final Function TILENOT = new Function("tileNot", "TILENOT", 0, 0, 45, 0);

        private Function(String name, String constantName, int metalLevel, int polyLevel, int height, int extraBits) {
            this.name = name;
            this.constantName = constantName;
            this.height = height;
            this.extraBits = extraBits;
            if (metalLevel != 0) {
                this.level = metalLevel;
                metalLayers.put(new Integer(this.level), this);
            }
            if (polyLevel != 0) {
                this.level = polyLevel;
                polyLayers.put(new Integer(this.level), this);
            }
            allFunctions.add(this);
        }

        public String toString() {
            String toStr = this.name;
            for (int i = 0; i < extras.length; ++i) {
                if ((this.extraBits & extras[i]) == 0) continue;
                toStr = toStr + "," + Function.getExtraName(extras[i]);
            }
            return toStr;
        }

        public String getName() {
            return this.name;
        }

        public String getConstantName() {
            return this.constantName;
        }

        public static List getFunctions() {
            return allFunctions;
        }

        public static int[] getFunctionExtras() {
            return extras;
        }

        public static String getExtraName(int extra) {
            if (extra == 64) {
                return "p-type";
            }
            if (extra == 128) {
                return "n-type";
            }
            if (extra == 256) {
                return "depletion";
            }
            if (extra == 512) {
                return "enhancement";
            }
            if (extra == 1024) {
                return "light";
            }
            if (extra == 2048) {
                return "heavy";
            }
            if (extra == 4096) {
                return "pseudo";
            }
            if (extra == 8192) {
                return "nonelectrical";
            }
            if (extra == 16384) {
                return "connects-metal";
            }
            if (extra == 32768) {
                return "connects-poly";
            }
            if (extra == 65536) {
                return "connects-diff";
            }
            if (extra == 0x400000) {
                return "inside-transistor";
            }
            if (extra == 0x800000) {
                return "thick";
            }
            if (extra == 0x200000) {
                return "vt";
            }
            return "";
        }

        public static String getExtraConstantName(int extra) {
            if (extra == 64) {
                return "PTYPE";
            }
            if (extra == 128) {
                return "NTYPE";
            }
            if (extra == 256) {
                return "DEPLETION";
            }
            if (extra == 512) {
                return "ENHANCEMENT";
            }
            if (extra == 1024) {
                return "LIGHT";
            }
            if (extra == 2048) {
                return "HEAVY";
            }
            if (extra == 4096) {
                return "PSEUDO";
            }
            if (extra == 8192) {
                return "NONELEC";
            }
            if (extra == 16384) {
                return "CONMETAL";
            }
            if (extra == 32768) {
                return "CONPOLY";
            }
            if (extra == 65536) {
                return "CONDIFF";
            }
            if (extra == 0x400000) {
                return "INTRANS";
            }
            if (extra == 0x800000) {
                return "THICK";
            }
            return "";
        }

        public static int parseExtraName(String name) {
            if (name.equalsIgnoreCase("p-type")) {
                return 64;
            }
            if (name.equalsIgnoreCase("n-type")) {
                return 128;
            }
            if (name.equalsIgnoreCase("depletion")) {
                return 256;
            }
            if (name.equalsIgnoreCase("enhancement")) {
                return 512;
            }
            if (name.equalsIgnoreCase("light")) {
                return 1024;
            }
            if (name.equalsIgnoreCase("heavy")) {
                return 2048;
            }
            if (name.equalsIgnoreCase("pseudo")) {
                return 4096;
            }
            if (name.equalsIgnoreCase("nonelectrical")) {
                return 8192;
            }
            if (name.equalsIgnoreCase("connects-metal")) {
                return 16384;
            }
            if (name.equalsIgnoreCase("connects-poly")) {
                return 32768;
            }
            if (name.equalsIgnoreCase("connects-diff")) {
                return 65536;
            }
            if (name.equalsIgnoreCase("inside-transistor")) {
                return 0x400000;
            }
            if (name.equalsIgnoreCase("thick")) {
                return 0x800000;
            }
            if (name.equalsIgnoreCase("vt")) {
                return 0x200000;
            }
            return 0;
        }

        public int getLevel() {
            return this.level;
        }

        public static Function getMetal(int level) {
            Function func = (Function)metalLayers.get(new Integer(level));
            return func;
        }

        public static Function getPoly(int level) {
            Function func = (Function)polyLayers.get(new Integer(level));
            return func;
        }

        public boolean isMetal() {
            return this == METAL1 || this == METAL2 || this == METAL3 || this == METAL4 || this == METAL5 || this == METAL6 || this == METAL7 || this == METAL8 || this == METAL9 || this == METAL10 || this == METAL11 || this == METAL12;
        }

        public boolean isDiff() {
            return this == DIFF || this == DIFFP || this == DIFFN;
        }

        public boolean isPoly() {
            return this == POLY1 || this == POLY2 || this == POLY3 || this == GATE;
        }

        public boolean isGatePoly() {
            return this.isPoly() && (this.extraBits & 0x400000) != 0;
        }

        public boolean isContact() {
            return this == CONTACT1 || this == CONTACT2 || this == CONTACT3 || this == CONTACT4 || this == CONTACT5 || this == CONTACT6 || this == CONTACT7 || this == CONTACT8 || this == CONTACT9 || this == CONTACT10 || this == CONTACT11 || this == CONTACT12;
        }

        public boolean isSubstrate() {
            return this == SUBSTRATE || this == WELL || this == WELLP || this == WELLN || this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public boolean isImplant() {
            return this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

