/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Inv2iKn {
    private static final double outLoY = -11.0;
    private static final double outBusWidth = 10.0;
    private static final double outBusSpace = 3.0;
    private static final double outY = 0.0;
    private static final double weakRatio = 10.0;
    private static final FoldedMos.GateSpace spaceLastGate = new FoldedMos.GateSpace(){

        @Override
        public double getExtraSpace(double requiredExtraSpace, int foldNdx, int nbFolds, int spaceNdx, int nbGates) {
            return foldNdx == nbFolds - 1 && spaceNdx == 1 ? 0.5 : requiredExtraSpace;
        }
    };
    private static final StdCellParams.SelectSrcDrn flipWeakPmos = new StdCellParams.SelectSrcDrn(){

        @Override
        public boolean connectThisOne(int mosNdx, int srcDrnNdx) {
            if (mosNdx == 0) {
                return srcDrnNdx % 2 == 1;
            }
            if (mosNdx == 1) {
                return srcDrnNdx % 2 == 0;
            }
            Inv2iKn.error(true, "more than two FoldedMos?");
            return false;
        }
    };

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        int i2;
        double totWidP;
        sz = stdCell.roundSize(sz);
        String nm = "inv2iKn";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double outsideSpace = 8.5;
        double insideSpace = 7.5;
        double spaceAvail = stdCell.getCellTop() - outsideSpace - insideSpace;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWidP = sz * 6.0, 1);
        Inv2iKn.error(fwP == null, "can't make " + nm + " this small: " + sz);
        totWidP = Math.max(3.0, totWidP / 10.0);
        FoldsAndWidth fwW = stdCell.calcFoldsAndWidth(spaceAvail, totWidP, 1);
        Inv2iKn.error(fwW == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = -insideSpace - (stdCell.getCellBot() + outsideSpace);
        double totWidN = sz * 3.0;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWidN, 1);
        Inv2iKn.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell inv = stdCell.findPart(nm, sz);
        if (inv != null) {
            return inv;
        }
        inv = stdCell.newPart(nm, sz);
        double inNX = 3.5;
        double inPX = inNX + 1.5 + 2.0;
        double weakX = inPX + 2.0 + 3.0 + 2.0;
        double nmosX = weakX + 2.0 + 3.0 + 2.0;
        double nmosY = -insideSpace - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, 1, fwN.gateWid, inv, stdCell);
        double weakY = insideSpace + fwW.physWid / 2.0;
        FoldedPmos pmosW = new FoldedPmos(weakX, weakY, fwW.nbFolds, 1, fwW.gateWid, spaceLastGate, 'B', inv, stdCell);
        double pmosY = insideSpace + fwP.physWid / 2.0;
        double pmosX = pmosW.getSrcDrn(fwW.nbFolds).getBounds().getCenterX();
        FoldedPmos pmos = new FoldedPmos(pmosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, inv, stdCell);
        double outX = StdCellParams.getRightDiffX(nmos, pmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(inv, "out", PortCharacteristic.OUT, Tech.m1(), 4.0, outX, 0.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, inv);
        boolean weakPmosOneFold = fwW.nbFolds == 1;
        stdCell.wireVddGnd(new FoldedMos[]{pmosW, pmos}, weakPmosOneFold ? flipWeakPmos : StdCellParams.EVEN, inv);
        TrackRouterH weakPoly = new TrackRouterH(Tech.p1(), 2.0, 0.0, inv);
        for (i2 = 0; i2 < pmosW.nbGates(); ++i2) {
            weakPoly.connect(pmosW.getGate(i2, 'B'));
        }
        for (i2 = 0; i2 < Math.min(nmos.nbGates(), pmosW.nbGates()); ++i2) {
            weakPoly.connect(nmos.getGate(i2, 'T'));
        }
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double inLoFromGnd = gndBot - 3.0 - 2.0;
        double nmosBot = nmosY - fwN.physWid / 2.0;
        double inLoFromMos = nmosBot - 2.0 - 2.5;
        double inLoY = Math.min(inLoFromGnd, inLoFromMos);
        LayoutLib.newExport(inv, "in[n]", PortCharacteristic.IN, Tech.m1(), 4.0, inNX, -11.0);
        PortInst m1pin = LayoutLib.newNodeInst(Tech.m1pin(), weakX, -11.0, 4.0, 4.0, 0.0, inv).getOnlyPortInst();
        TrackRouterH inNHi = new TrackRouterH(Tech.m2(), 3.0, -11.0, inv);
        inNHi.connect(inv.findExport("in[n]"));
        inNHi.connect(m1pin);
        TrackRouterH inLo = new TrackRouterH(Tech.m1(), 3.0, inLoY, inv);
        inLo.connect(m1pin);
        for (int i3 = 0; i3 < nmos.nbGates(); ++i3) {
            inLo.connect(nmos.getGate(i3, 'B'));
        }
        double vddTop = stdCell.getVddY() + stdCell.getVddWidth() / 2.0;
        double inHiFromVdd = vddTop + 3.0 + 2.0;
        double pmosTop = pmosY + fwP.physWid / 2.0;
        double inHiFromMos = pmosTop + 2.0 + 2.5;
        double inHiY = Math.max(inHiFromVdd, inHiFromMos);
        LayoutLib.newExport(inv, "in[p]", PortCharacteristic.IN, Tech.m1(), 4.0, inPX, inHiY);
        TrackRouterH inHi = new TrackRouterH(Tech.m1(), 3.0, inHiY, inv);
        inHi.connect(inv.findExport("in[p]"));
        for (int i4 = 0; i4 < pmos.nbGates(); ++i4) {
            inHi.connect(pmos.getGate(i4, 'T'));
        }
        TrackRouterH out = new TrackRouterH(Tech.m1(), 10.0, 0.0, inv);
        out.connect(inv.findExport("out"));
        int n = i = weakPmosOneFold ? 0 : 1;
        while (i < pmosW.nbSrcDrns()) {
            out.connect(pmosW.getSrcDrn(i));
            i += 2;
        }
        for (i = 1; i < pmos.nbSrcDrns(); i += 2) {
            out.connect(pmos.getSrcDrn(i));
        }
        for (i = 1; i < nmos.nbSrcDrns(); i += 2) {
            out.connect(nmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 5.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, inv);
        stdCell.addPmosWell(wellMinX, wellMaxX, inv);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, inv);
        stdCell.doNCC(inv, nm + "{sch}");
        return inv;
    }
}

