/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LEFDEF;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DEF
extends LEFDEF {
    private double scaleUnits;
    private LEFDEF.ViaDef firstViaDef;
    private Hashtable<String, PortInst> specialNetsHT = null;
    private Hashtable<String, PortInst> normalNetsHT = null;
    private Hashtable<Double, List<NodeInst>> PortHT = null;
    private boolean schImport = false;
    private Pattern pat_starleftbracket = Pattern.compile(".*\\\\\\[");
    private Pattern pat_leftbracket = Pattern.compile("\\\\\\[");
    private Pattern pat_starrightbracket = Pattern.compile(".*\\\\\\]");
    private Pattern pat_rightbracket = Pattern.compile("\\\\\\]");
    private static Variable.Key prXkey = Variable.newKey("ATTR_prWidth");
    private static Variable.Key prYkey = Variable.newKey("ATTR_prHeight");

    @Override
    protected boolean importALibrary(Library lib) {
        this.initKeywordParsing();
        this.scaleUnits = 1000.0;
        this.firstViaDef = null;
        try {
            this.readFile(lib);
        }
        catch (IOException e) {
            System.out.println("ERROR reading DEF libraries");
        }
        return false;
    }

    private boolean ignoreToSemicolon(String command) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command)) != null) continue;
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private String mustGetKeyword(String where) throws IOException {
        String key = this.getAKeyword();
        if (key == null) {
            this.reportError("EOF parsing " + where);
        }
        return key;
    }

    private double convertDEFString(String key) {
        double v = TextUtils.atof(key) / this.scaleUnits;
        return TextUtils.convertFromDistance(v, Technology.getCurrent(), TextUtils.UnitScale.MICRO);
    }

    private void reportError(String command) {
        System.out.println("File " + this.filePath + ", line " + this.lineReader.getLineNumber() + ": " + command);
    }

    private boolean readFile(Library lib) throws IOException {
        String key;
        Cell cell = null;
        while ((key = this.getAKeyword()) != null) {
            if (key.equalsIgnoreCase("VERSION") || key.equalsIgnoreCase("NAMESCASESENSITIVE") || key.equalsIgnoreCase("DIVIDERCHAR") || key.equalsIgnoreCase("BUSBITCHARS") || key.equalsIgnoreCase("DIEAREA") || key.equalsIgnoreCase("ROW") || key.equalsIgnoreCase("TRACKS") || key.equalsIgnoreCase("GCELLGRID") || key.equalsIgnoreCase("HISTORY") || key.equalsIgnoreCase("TECHNOLOGY")) {
                if (!this.ignoreToSemicolon(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DEFAULTCAP") || key.equalsIgnoreCase("REGIONS")) {
                if (!this.ignoreBlock(key)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("DESIGN")) {
                String cellName = this.mustGetKeyword("DESIGN");
                if (cellName == null) {
                    return true;
                }
                cell = lib.getCurCell();
                if (!Input.isNewLibraryCreated()) {
                    if (cell == null) {
                        this.reportError("A cell must be currently opened for this operation, aborting.");
                        return true;
                    }
                    if (!cell.getCellName().getName().equals(cellName)) {
                        this.reportError("Cell name in DEF file '" + cellName + "' does not equal current cell name '" + cell.getCellName().getName() + "', aborting.");
                        return true;
                    }
                    View cellView = cell.getCellName().getView();
                    if (cellView.getAbbreviation().equals("sch")) {
                        this.schImport = true;
                    }
                } else if (cell == null || !cell.getCellName().getName().equals(cellName)) {
                    cell = Cell.makeInstance(lib, cellName);
                }
                if (cell == null) {
                    this.reportError("Cannot create cell '" + cellName + "'");
                    return true;
                }
                if (!this.ignoreToSemicolon("DESIGN")) continue;
                return true;
            }
            if (key.equalsIgnoreCase("UNITS")) {
                if (!this.readUnits()) continue;
                return true;
            }
            if (key.equalsIgnoreCase("PROPERTYDEFINITIONS")) {
                if (!this.readPropertyDefinitions()) continue;
                return true;
            }
            if (key.equalsIgnoreCase("VIAS")) {
                if (!this.readVias(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("COMPONENTS")) {
                if (!this.readComponents(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("PINS")) {
                if (!this.readPins(cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("SPECIALNETS")) {
                if (!this.readNets(cell, true)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("NETS")) {
                if (!this.readNets(cell, false)) continue;
                return true;
            }
            if (!key.equalsIgnoreCase("END")) continue;
            key = this.getAKeyword();
            break;
        }
        return false;
    }

    private boolean ignoreBlock(String command) throws IOException {
        String key;
        do {
            if ((key = this.mustGetKeyword(command)) != null) continue;
            return true;
        } while (!key.equalsIgnoreCase("END"));
        this.getAKeyword();
        return false;
    }

    private Point2D readCoordinate() throws IOException {
        String key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        if (!key.equals("(")) {
            this.reportError("Expected '(' in coordinate");
            return null;
        }
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        double x = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        double y = this.convertDEFString(key);
        key = this.mustGetKeyword("coordinate");
        if (key == null) {
            return null;
        }
        if (!key.equals(")")) {
            this.reportError("Expected ')' in coordinate");
            return null;
        }
        return new Point2D.Double(x, y);
    }

    private Cell getNodeProto(String name, Library curlib, Cell parent) {
        CellName cn = this.schImport ? CellName.newName(name, View.ICON, 0) : CellName.newName(name, parent.getView(), 0);
        Cell cell = curlib.findNodeProto(cn.toString());
        if (cell != null) {
            return cell;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || lib == curlib || (cell = lib.findNodeProto(name)) == null) continue;
            return cell;
        }
        return null;
    }

    private Cell getNodeProto(String name, Library curlib) {
        Cell cell = curlib.findNodeProto(name);
        if (cell != null) {
            return cell;
        }
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || lib == curlib || (cell = lib.findNodeProto(name)) == null) continue;
            return cell;
        }
        return null;
    }

    private Orientation FetchOrientation() throws IOException {
        int angle;
        String key = this.mustGetKeyword("orientation");
        if (key == null) {
            return null;
        }
        boolean transpose = false;
        if (key.equalsIgnoreCase("N")) {
            angle = 0;
        } else if (key.equalsIgnoreCase("S")) {
            angle = 1800;
        } else if (key.equalsIgnoreCase("E")) {
            angle = 2700;
        } else if (key.equalsIgnoreCase("W")) {
            angle = 900;
        } else if (key.equalsIgnoreCase("FN")) {
            angle = 900;
            transpose = true;
        } else if (key.equalsIgnoreCase("FS")) {
            angle = 2700;
            transpose = true;
        } else if (key.equalsIgnoreCase("FE")) {
            angle = 1800;
            transpose = true;
        } else if (key.equalsIgnoreCase("FW")) {
            angle = 0;
            transpose = true;
        } else {
            this.reportError("Unknown orientation (" + key + ")");
            return null;
        }
        return Orientation.fromC(angle, transpose);
    }

    private PortInst findConnection(double x, double y, ArcProto ap, Cell cell, NodeInst noti) {
        if (this.PortHT.containsKey(x + y)) {
            List<NodeInst> pl = this.PortHT.get(x + y);
            Point2D.Double pt = new Point2D.Double(x, y);
            for (int i = 0; i < pl.size(); ++i) {
                NodeInst ni = pl.get(i);
                if (ni == noti) continue;
                Iterator<PortInst> it = ni.getPortInsts();
                while (it.hasNext()) {
                    Poly poly;
                    PortInst pi = it.next();
                    if (!pi.getPortProto().connectsTo(ap) || !(poly = pi.getPoly()).isInside(pt)) continue;
                    return pi;
                }
            }
        }
        return null;
    }

    private PortInst getPin(double x, double y, ArcProto ap, Cell cell) {
        List<Object> pl;
        double sY;
        double sX;
        PortInst pi = this.findConnection(x, y, ap, cell, null);
        if (pi != null) {
            return pi;
        }
        PrimitiveNode pin = ap.findPinProto();
        NodeInst ni = NodeInst.makeInstance(pin, new Point2D.Double(x, y), sX = pin.getDefWidth(), sY = pin.getDefHeight(), cell);
        if (ni == null) {
            this.reportError("Unable to create net pin");
            return null;
        }
        if (this.PortHT.containsKey(x + y)) {
            pl = this.PortHT.get(x + y);
        } else {
            pl = new ArrayList();
            this.PortHT.put(x + y, pl);
        }
        pl.add(ni);
        return ni.getOnlyPortInst();
    }

    private boolean readPins(Cell cell) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("PINS")) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("PINs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readPin(cell)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private String translateDefName(String name) {
        Matcher m_starleftbracket = this.pat_starleftbracket.matcher(name);
        Matcher m_starrightbracket = this.pat_starrightbracket.matcher(name);
        if (m_starleftbracket.matches() || m_starrightbracket.matches()) {
            Matcher m_leftbracket = this.pat_leftbracket.matcher(name);
            String tmpa = m_leftbracket.replaceAll("[");
            Matcher m_rightbracket = this.pat_rightbracket.matcher(tmpa);
            String tmpb = m_rightbracket.replaceAll("]");
            return tmpb;
        }
        return name;
    }

    private boolean readPin(Cell cell) throws IOException {
        String key = this.mustGetKeyword("PIN");
        if (key == null) {
            return true;
        }
        String pinName = this.translateDefName(key);
        PortCharacteristic portCharacteristic = null;
        NodeProto np = null;
        Point2D ll = null;
        Point2D ur = null;
        Point2D xy = null;
        boolean haveCoord = false;
        GetOrientation orient = null;
        while (true) {
            if ((key = this.mustGetKeyword("PIN")) == null) {
                return true;
            }
            if (key.equals("+")) {
                key = this.mustGetKeyword("PIN");
                if (key == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("NET")) {
                    key = this.mustGetKeyword("net name");
                    if (key != null) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("DIRECTION")) {
                    key = this.mustGetKeyword("DIRECTION");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("INPUT")) {
                        portCharacteristic = PortCharacteristic.IN;
                        continue;
                    }
                    if (key.equalsIgnoreCase("OUTPUT")) {
                        portCharacteristic = PortCharacteristic.OUT;
                        continue;
                    }
                    if (key.equalsIgnoreCase("INOUT")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("FEEDTHRU")) {
                        portCharacteristic = PortCharacteristic.BIDIR;
                        continue;
                    }
                    this.reportError("Unknown direction (" + key + ")");
                    return true;
                }
                if (key.equalsIgnoreCase("USE")) {
                    key = this.mustGetKeyword("USE");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("SIGNAL")) continue;
                    if (key.equalsIgnoreCase("POWER")) {
                        portCharacteristic = PortCharacteristic.PWR;
                        continue;
                    }
                    if (key.equalsIgnoreCase("GROUND")) {
                        portCharacteristic = PortCharacteristic.GND;
                        continue;
                    }
                    if (key.equalsIgnoreCase("CLOCK")) {
                        portCharacteristic = PortCharacteristic.CLK;
                        continue;
                    }
                    if (key.equalsIgnoreCase("TIEOFF") || key.equalsIgnoreCase("ANALOG")) continue;
                    this.reportError("Unknown usage (" + key + ")");
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.mustGetKeyword("LAYER");
                    if (key == null) {
                        return true;
                    }
                    if (!this.schImport) {
                        LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                        if (li.pin == null) {
                            this.reportError("Unknown layer (" + key + ")");
                            return true;
                        }
                        np = li.pin;
                    }
                    if ((ll = this.readCoordinate()) == null) {
                        return true;
                    }
                    ur = this.readCoordinate();
                    if (ur != null) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED") && !key.equalsIgnoreCase("FIXED")) continue;
                xy = this.readCoordinate();
                if (xy == null) {
                    return true;
                }
                orient = new GetOrientation();
                haveCoord = true;
                continue;
            }
            if (key.equals(";")) break;
        }
        if (this.schImport) {
            ArcProto apTry = null;
            Iterator<Comparable<ArcProto>> it = Technology.getCurrent().getArcs();
            while (it.hasNext() && !(apTry = it.next()).getName().equals("wire")) {
            }
            if (apTry == null) {
                this.reportError("Unable to resolve pin component");
                return true;
            }
            it = Technology.getCurrent().getNodes();
            while (it.hasNext()) {
                PrimitivePort pp;
                PrimitiveNode loc_np = (PrimitiveNode)it.next();
                if (loc_np.getNumPorts() != 1 || !(pp = loc_np.getPort(0)).connectsTo(apTry)) continue;
                np = loc_np;
                break;
            }
        }
        if (np != null && haveCoord) {
            AffineTransform trans = orient.orient.pureRotate();
            trans.transform(ll, ll);
            trans.transform(ur, ur);
            double sX = Math.abs(ll.getX() - ur.getX());
            double sY = Math.abs(ll.getY() - ur.getY());
            double cX = (ll.getX() + ur.getX()) / 2.0 + xy.getX();
            double cY = (ll.getY() + ur.getY()) / 2.0 + xy.getY();
            NodeInst ni = NodeInst.makeInstance(np, new Point2D.Double(cX, cY), sX, sY, cell);
            if (ni == null) {
                this.reportError("Unable to create pin");
                return true;
            }
            PortInst pi = ni.findPortInstFromProto(np.getPort(0));
            Export e = Export.newInstance(cell, pi, pinName);
            if (e == null) {
                this.reportError("Unable to create pin name");
                return true;
            }
            e.setCharacteristic(portCharacteristic);
        }
        return false;
    }

    private boolean readComponents(Cell cell) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("COMPONENTS")) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("COMPONENTs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readComponent(cell)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readComponent(Cell cell) throws IOException {
        String key = this.mustGetKeyword("COMPONENT");
        if (key == null) {
            return true;
        }
        String compName = key;
        key = this.mustGetKeyword("COMPONENT");
        if (key == null) {
            return true;
        }
        String modelName = key;
        Cell np = cell.getView() != null ? this.getNodeProto(modelName, cell.getLibrary(), cell) : this.getNodeProto(modelName, cell.getLibrary());
        if (np == null) {
            this.reportError("Unknown cell (" + modelName + ")");
            return true;
        }
        while (true) {
            if ((key = this.mustGetKeyword("COMPONENT")) == null) {
                return true;
            }
            if (key.equals("+")) {
                Point2D.Double npt;
                NodeInst ni;
                key = this.mustGetKeyword("COMPONENT");
                if (key == null) {
                    return true;
                }
                if (!key.equalsIgnoreCase("PLACED") && !key.equalsIgnoreCase("FIXED")) continue;
                Point2D pt = this.readCoordinate();
                if (pt == null) {
                    return true;
                }
                double nx = pt.getX();
                double ny = pt.getY();
                Orientation or = this.FetchOrientation();
                double sX = np.getDefWidth();
                double sY = np.getDefHeight();
                Variable prX = np.getVar(prXkey);
                double width = 0.0;
                if (prX != null) {
                    String tmps = prX.getPureValue(0);
                    int tmp = Integer.parseInt(tmps);
                    width = tmp;
                } else {
                    width = sX;
                }
                Variable prY = np.getVar(prYkey);
                double height = 0.0;
                if (prY != null) {
                    String tmps = prY.getPureValue(0);
                    int tmp = Integer.parseInt(tmps);
                    height = tmp;
                } else {
                    height = sY;
                }
                if (or.equals(Orientation.YRR)) {
                    nx += width;
                }
                if (or.equals(Orientation.Y)) {
                    ny += height;
                }
                if (or.equals(Orientation.RR)) {
                    ny += height;
                    nx += width;
                }
                if ((ni = NodeInst.makeInstance(np, npt = new Point2D.Double(nx, ny), sX, sY, cell, or, compName, 0)) != null) continue;
                this.reportError("Unable to create node");
                return true;
            }
            if (key.equals(";")) break;
        }
        return false;
    }

    private boolean readNets(Cell cell, boolean special) throws IOException {
        String key;
        block5: {
            if (special) {
                this.specialNetsHT = new Hashtable();
            } else {
                this.normalNetsHT = new Hashtable();
            }
            this.PortHT = new Hashtable();
            while (true) {
                if ((key = this.mustGetKeyword("NETs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readNet(cell, special)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block5;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        this.connectSpecialNormalNets();
        return false;
    }

    private PortInst connectGlobal(Cell cell, String portName) {
        PortInst pi = null;
        PortInst lastPi = null;
        NodeInst ni = null;
        PortProto pp = null;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            ArcProto ap;
            ArcInst ai;
            ni = it.next();
            pp = ni.getProto().findPortProto(portName);
            if (pp == null) continue;
            pi = ni.findPortInstFromProto(pp);
            if (lastPi != null && (ai = ArcInst.makeInstance(ap = Generic.tech.unrouted_arc, pi, lastPi)) == null) {
                this.reportError("Could not create unrouted arc");
                return null;
            }
            lastPi = pi;
        }
        return lastPi;
    }

    private void connectSpecialNormalNets() {
        if (this.specialNetsHT == null) {
            return;
        }
        if (this.normalNetsHT == null) {
            return;
        }
        Enumeration<String> enSpec = this.specialNetsHT.keys();
        while (enSpec.hasMoreElements()) {
            ArcProto ap;
            ArcInst ai;
            String netName = enSpec.nextElement();
            PortInst specPi = this.specialNetsHT.get(netName);
            PortInst normalPi = null;
            if (!this.normalNetsHT.containsKey(netName) || (normalPi = this.normalNetsHT.get(netName)) == null || (ai = ArcInst.makeInstance(ap = Generic.tech.unrouted_arc, specPi, normalPi)) != null) continue;
            this.reportError("Could not create unrouted arc");
            return;
        }
    }

    private LEFDEF.ViaDef checkForVia(String key) {
        LEFDEF.ViaDef vd = null;
        vd = this.firstViaDef;
        while (vd != null && !key.equalsIgnoreCase(vd.viaName)) {
            vd = vd.nextViaDef;
        }
        if (vd == null) {
            vd = firstViaDefFromLEF;
            while (vd != null && !key.equalsIgnoreCase(vd.viaName)) {
                vd = vd.nextViaDef;
            }
        }
        return vd;
    }

    private boolean readNet(Cell cell, boolean special) throws IOException {
        block96: {
            if (this.schImport && special) {
                this.ignoreToSemicolon("NET");
                return false;
            }
            String key = this.mustGetKeyword("NET");
            if (key == null) {
                return true;
            }
            String netName = this.translateDefName(key);
            key = this.mustGetKeyword("NET");
            if (key == null) {
                return true;
            }
            boolean adjustPinLocPi = false;
            boolean adjustPinLocLastPi = false;
            boolean wantPinPairs = true;
            boolean connectAllComponents = false;
            String wildcardPort = null;
            double lastX = 0.0;
            double lastY = 0.0;
            double curX = 0.0;
            double curY = 0.0;
            double specialWidth = 0.0;
            boolean pathStart = true;
            PortInst lastLogPi = null;
            PortInst lastPi = null;
            LEFDEF.GetLayerInformation li = null;
            boolean foundCoord = false;
            boolean stackedViaFlag = false;
            while (true) {
                ArcInst ai;
                PortInst nextPi;
                NodeInst ni;
                ArcProto ap;
                ArcInst ai2;
                if (key.equals(";")) {
                    if (lastPi != null) {
                        if (special) {
                            this.specialNetsHT.put(netName, lastPi);
                        } else {
                            this.normalNetsHT.put(netName, lastPi);
                        }
                    }
                    if (lastLogPi != null && lastPi != null && (ai2 = ArcInst.makeInstance(ap = Generic.tech.unrouted_arc, lastPi, lastLogPi)) == null) {
                        this.reportError("Could not create unrouted arc");
                        return true;
                    }
                    break block96;
                }
                if (key.equals("+")) {
                    wantPinPairs = false;
                    if (this.schImport) {
                        this.ignoreToSemicolon("NET");
                        break block96;
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    if (key.equalsIgnoreCase("USE")) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                    } else if (key.equalsIgnoreCase("ROUTED")) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        li = new LEFDEF.GetLayerInformation(key);
                        if (li.pin == null) {
                            this.reportError("Unknown layer (" + key + ")");
                            return true;
                        }
                        pathStart = true;
                        if (special) {
                            key = this.mustGetKeyword("NET");
                            if (key == null) {
                                return true;
                            }
                            specialWidth = this.convertDEFString(key);
                        }
                    } else if (key.equalsIgnoreCase("FIXED")) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        li = new LEFDEF.GetLayerInformation(key);
                        if (li.pin == null) {
                            this.reportError("Unknown layer (" + key + ")");
                            return true;
                        }
                        pathStart = true;
                    } else if (key.equalsIgnoreCase("SHAPE")) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                    } else {
                        this.reportError("Cannot handle '" + key + "' nets");
                        return true;
                    }
                    if ((key = this.mustGetKeyword("NET")) != null) continue;
                    return true;
                }
                if (wantPinPairs) {
                    if (!key.equals("(")) {
                        this.reportError("Expected '(' of pin pair");
                        return true;
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    PortInst pi = null;
                    if (key.equalsIgnoreCase("PIN")) {
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        Export pp = (Export)cell.findPortProto(key = this.translateDefName(key));
                        if (pp == null) {
                            this.reportError("Warning: unknown pin '" + key + "'");
                            return this.ignoreToSemicolon("NETS");
                        }
                        pi = pp.getOriginalPort();
                    } else {
                        NodeInst found = null;
                        connectAllComponents = key.equals("*");
                        Iterator<NodeInst> it = cell.getNodes();
                        while (it.hasNext()) {
                            NodeInst ni2 = it.next();
                            if (!connectAllComponents && !ni2.getName().equalsIgnoreCase(key)) continue;
                            found = ni2;
                            break;
                        }
                        if (found == null) {
                            this.reportError("Unknown component '" + key + "'");
                            return true;
                        }
                        key = this.mustGetKeyword("NET");
                        if (key == null) {
                            return true;
                        }
                        PortProto pp = found.getProto().findPortProto(key);
                        if (pp == null) {
                            this.reportError("Unknown port '" + key + "' on component " + found);
                            return true;
                        }
                        if (connectAllComponents) {
                            wildcardPort = key;
                        }
                        pi = found.findPortInstFromProto(pp);
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    if (!key.equals(")")) {
                        this.reportError("Expected ')' of pin pair");
                        return true;
                    }
                    if (IOTool.isDEFLogicalPlacement()) {
                        ArcProto ap2;
                        ArcInst ai3;
                        if (connectAllComponents) {
                            pi = this.connectGlobal(cell, wildcardPort);
                            if (pi == null) {
                                return true;
                            }
                        } else if (lastLogPi != null && (ai3 = ArcInst.makeInstance(ap2 = Generic.tech.unrouted_arc, pi, lastLogPi)) == null) {
                            this.reportError("Could not create unrouted arc");
                            return true;
                        }
                    }
                    lastLogPi = pi;
                    key = this.mustGetKeyword("NET");
                    if (key != null) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("NEW")) {
                    if (lastLogPi != null && lastPi != null && (ai2 = ArcInst.makeInstance(ap = Generic.tech.unrouted_arc, lastPi, lastLogPi)) == null) {
                        this.reportError("Could not create unrouted arc");
                        return true;
                    }
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    li = new LEFDEF.GetLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("Unknown layer (" + key + ")");
                        return true;
                    }
                    pathStart = true;
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    if (!special) continue;
                    specialWidth = this.convertDEFString(key);
                    key = this.mustGetKeyword("NET");
                    if (key != null) continue;
                    return true;
                }
                if (!stackedViaFlag) {
                    foundCoord = false;
                }
                if (key.equals("(")) {
                    foundCoord = true;
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    curX = key.equals("*") ? lastX : this.convertDEFString(key);
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    curY = key.equals("*") ? lastY : this.convertDEFString(key);
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    if (!key.equals(")")) {
                        this.reportError("Expected ')' of coordinate pair");
                        return true;
                    }
                }
                if (!stackedViaFlag && (key = this.mustGetKeyword("NET")) == null) {
                    return true;
                }
                LEFDEF.ViaDef vd = this.checkForVia(key);
                if (!IOTool.isDEFPhysicalPlacement() || this.schImport) {
                    if (vd == null || (key = this.mustGetKeyword("NET")) != null) continue;
                    return true;
                }
                PortInst pi = null;
                boolean placedVia = false;
                if (vd != null) {
                    SizeOffset so;
                    double sX = vd.sX;
                    double sY = vd.sY;
                    if (vd.via == null) {
                        this.reportError("Cannot to create via");
                        return true;
                    }
                    if (pathStart) {
                        lastPi = this.findConnection(curX, curY, li.arc, cell, null);
                    }
                    if ((ni = NodeInst.makeInstance(vd.via, new Point2D.Double(curX, curY), sX += (so = vd.via.getProtoSizeOffset()).getLowXOffset() + so.getHighXOffset(), sY += so.getLowYOffset() + so.getHighYOffset(), cell)) == null) {
                        this.reportError("Unable to create via layer");
                        return true;
                    }
                    pi = ni.getOnlyPortInst();
                    if (pathStart && lastPi != null && foundCoord) {
                        double width = li.arc.getDefaultLambdaBaseWidth();
                        if (special) {
                            width = specialWidth;
                        } else {
                            Double wid = (Double)widthsFromLEF.get(li.arc);
                            if (wid != null) {
                                width = wid;
                            }
                        }
                        ArcInst ai4 = ArcInst.makeInstanceBase(li.arc, width, lastPi, pi);
                        if (ai4 == null) {
                            this.reportError("Unable to create net starting point");
                            return true;
                        }
                    }
                    placedVia = true;
                    key = this.mustGetKeyword("NET");
                    if (key == null) {
                        return true;
                    }
                    LEFDEF.ViaDef vdStack = this.checkForVia(key);
                    stackedViaFlag = vdStack != null;
                } else {
                    pi = this.getPin(curX, curY, li.arc, cell);
                    if (pi == null) {
                        return true;
                    }
                    adjustPinLocPi = true;
                }
                if (!foundCoord) continue;
                if (!pathStart) {
                    ArcInst ai5;
                    if (!pi.getPortProto().connectsTo(li.arc)) {
                        double sY;
                        double sX;
                        PrimitiveNode np = li.arc.findPinProto();
                        ni = NodeInst.makeInstance(np, new Point2D.Double(curX, curY), sX = np.getDefWidth(), sY = np.getDefHeight(), cell);
                        if (ni == null) {
                            this.reportError("Unable to create net pin");
                            return true;
                        }
                        pi = ni.getOnlyPortInst();
                    }
                    double width = li.arc.getDefaultLambdaBaseWidth();
                    if (special) {
                        width = specialWidth;
                    } else {
                        Double wid = (Double)widthsFromLEF.get(li.arc);
                        if (wid != null) {
                            width = wid;
                        }
                    }
                    if (adjustPinLocLastPi && special) {
                        double dX = 0.0;
                        double dY = 0.0;
                        if (curX != lastX) {
                            dX = width / 2.0;
                            if (curX < lastX) {
                                dX = -dX;
                            }
                        }
                        if (curY != lastY) {
                            dY = width / 2.0;
                            if (curY < lastY) {
                                dY = -dY;
                            }
                        }
                        lastPi.getNodeInst().move(dX, dY);
                        adjustPinLocLastPi = false;
                    }
                    if (adjustPinLocPi && special) {
                        double dX = 0.0;
                        double dY = 0.0;
                        if (curX != lastX) {
                            dX = -width / 2.0;
                            if (curX < lastX) {
                                dX = -dX;
                            }
                        }
                        if (curY != lastY) {
                            dY = -width / 2.0;
                            if (curY < lastY) {
                                dY = -dY;
                            }
                        }
                        pi.getNodeInst().move(dX, dY);
                        adjustPinLocPi = false;
                    }
                    if ((ai5 = ArcInst.makeInstanceBase(li.arc, width, lastPi, pi)) == null) {
                        this.reportError("Unable to create net path");
                        return true;
                    }
                }
                lastX = curX;
                lastY = curY;
                pathStart = false;
                lastPi = pi;
                adjustPinLocLastPi = adjustPinLocPi;
                adjustPinLocPi = false;
                if (placedVia) {
                    if (li.arc == vd.lay1) {
                        li.arc = vd.lay2;
                    } else if (li.arc == vd.lay2) {
                        li.arc = vd.lay1;
                    }
                    li.pin = li.arc.findPinProto();
                }
                if (!key.equalsIgnoreCase("NEW") && !key.equals(";") || (nextPi = this.findConnection(curX, curY, li.arc, cell, pi.getNodeInst())) == null) continue;
                double width = li.arc.getDefaultLambdaBaseWidth();
                if (special) {
                    width = specialWidth;
                } else {
                    Double wid = (Double)widthsFromLEF.get(li.arc);
                    if (wid != null) {
                        width = wid;
                    }
                }
                if ((ai = ArcInst.makeInstanceBase(li.arc, width, pi, nextPi)) == null) break;
            }
            this.reportError("Unable to create net ending point");
            return true;
        }
        return false;
    }

    private boolean readVias(Cell cell) throws IOException {
        String key;
        block4: {
            if (this.ignoreToSemicolon("VIAS")) {
                return true;
            }
            while (true) {
                if ((key = this.mustGetKeyword("VIAs")) == null) {
                    return true;
                }
                if (key.equals("-")) {
                    if (!this.readVia()) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block4;
                if (this.ignoreToSemicolon(key)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readVia() throws IOException {
        if (this.schImport) {
            this.ignoreToSemicolon("VIA");
            return false;
        }
        String key = this.mustGetKeyword("VIA");
        if (key == null) {
            return true;
        }
        LEFDEF.ViaDef vd = new LEFDEF.ViaDef();
        vd.viaName = key;
        vd.sY = 0.0;
        vd.sX = 0.0;
        vd.via = null;
        vd.lay2 = null;
        vd.lay1 = null;
        vd.nextViaDef = this.firstViaDef;
        this.firstViaDef = vd;
        while (true) {
            if ((key = this.mustGetKeyword("VIA")) == null) {
                return true;
            }
            if (key.equals("+")) {
                Point2D ll;
                key = this.mustGetKeyword("VIA");
                if (key == null) {
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.mustGetKeyword("VIA");
                if (key == null) {
                    return true;
                }
                LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(key);
                if (li.pure == null) {
                    this.reportError("Layer " + key + " not in current technology");
                }
                if (key.startsWith("VIA")) {
                    if (li.pin == null) {
                        li.pin = Generic.tech.universalPinNode;
                    }
                    vd.via = li.pin;
                }
                if (key.startsWith("METAL")) {
                    if (li.arc == null) {
                        li.arc = Generic.tech.universal_arc;
                    }
                    if (vd.lay1 == null) {
                        vd.lay1 = li.arc;
                    } else {
                        vd.lay2 = li.arc;
                    }
                }
                if ((ll = this.readCoordinate()) == null) {
                    return true;
                }
                Point2D ur = this.readCoordinate();
                if (ur == null) {
                    return true;
                }
                if (ur.getX() - ll.getX() > vd.sX) {
                    vd.sX = ur.getX() - ll.getX();
                }
                if (!(ur.getY() - ll.getY() > vd.sY)) continue;
                vd.sY = ur.getY() - ll.getY();
                continue;
            }
            if (key.equals(";")) break;
        }
        if (vd.via != null) {
            if (vd.sX == 0.0) {
                vd.sX = vd.via.getDefWidth();
            }
            if (vd.sY == 0.0) {
                vd.sY = vd.via.getDefHeight();
            }
        }
        return false;
    }

    private boolean readPropertyDefinitions() throws IOException {
        String key;
        block2: {
            do {
                if ((key = this.mustGetKeyword("PROPERTYDEFINITION")) == null) {
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block2;
            } while (!this.ignoreToSemicolon(key));
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readUnits() throws IOException {
        String key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("DISTANCE")) {
            this.reportError("Expected 'DISTANCE' after 'UNITS'");
            return true;
        }
        key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        if (!key.equalsIgnoreCase("MICRONS")) {
            this.reportError("Expected 'MICRONS' after 'UNITS'");
            return true;
        }
        key = this.mustGetKeyword("UNITS");
        if (key == null) {
            return true;
        }
        this.scaleUnits = TextUtils.atof(key) * 1.0;
        return this.ignoreToSemicolon("UNITS");
    }

    private class GetOrientation {
        private Orientation orient;

        private GetOrientation() throws IOException {
            int angle;
            String key = DEF.this.mustGetKeyword("orientation");
            if (key == null) {
                return;
            }
            boolean transpose = false;
            if (key.equalsIgnoreCase("N")) {
                angle = 0;
            } else if (key.equalsIgnoreCase("S")) {
                angle = 1800;
            } else if (key.equalsIgnoreCase("E")) {
                angle = 2700;
            } else if (key.equalsIgnoreCase("W")) {
                angle = 900;
            } else if (key.equalsIgnoreCase("FN")) {
                angle = 900;
                transpose = true;
            } else if (key.equalsIgnoreCase("FS")) {
                angle = 2700;
                transpose = true;
            } else if (key.equalsIgnoreCase("FE")) {
                angle = 1800;
                transpose = true;
            } else if (key.equalsIgnoreCase("FW")) {
                angle = 0;
                transpose = true;
            } else {
                DEF.this.reportError("Unknown orientation (" + key + ")");
                return;
            }
            this.orient = Orientation.fromC(angle, transpose);
        }
    }
}

