/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.BTree;
import com.sun.electric.database.geometry.btree.CachingPageStorage;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class NodeCursor<K extends Serializable & Comparable, V extends Serializable, S extends Serializable> {
    protected boolean dirty = false;
    protected CachingPageStorage ps;
    protected static final int SIZEOF_INT = 4;
    protected final BTree<K, V, S> bt;
    protected CachingPageStorage.CachedPage cp = null;

    protected NodeCursor(BTree<K, V, S> bt) {
        this.bt = bt;
        this.ps = bt.ps;
    }

    public abstract void initBuf(CachingPageStorage.CachedPage var1, boolean var2);

    protected abstract void setNumBuckets(int var1);

    public void setBuf(CachingPageStorage.CachedPage cp) {
        assert (!this.dirty);
        this.cp = cp;
    }

    public CachingPageStorage.CachedPage getCachedPage() {
        return this.cp;
    }

    public void forgetCachedPage() {
        this.cp = null;
    }

    public void writeBack() {
        this.dirty = false;
        this.cp.setDirty();
    }

    public int split(byte[] key, int key_ofs, int splitPoint) {
        assert (this.isFull());
        int endOfBuf = this.endOfBuf();
        int ret = 0;
        for (int i = 0; i < splitPoint; ++i) {
            ret += this.getNumValsBelowBucket(i);
        }
        this.setNumBuckets(splitPoint);
        boolean wasRightMost = this.isRightMost();
        this.setRightMost(false);
        this.writeBack();
        if (key != null) {
            this.getKey(splitPoint, key, key_ofs);
        }
        byte[] oldbuf = this.cp.getBuf();
        this.initBuf(this.ps.getPage(this.ps.createPage(), false), wasRightMost);
        this.setNumBuckets(this.getMaxBuckets() - splitPoint);
        this.scoot(oldbuf, endOfBuf, splitPoint);
        this.writeBack();
        return ret;
    }

    public boolean isFull() {
        return this.getNumBuckets() >= this.getMaxBuckets();
    }

    public int getPageId() {
        return this.cp.getPageId();
    }

    public byte[] getBuf() {
        return this.cp.getBuf();
    }

    public abstract int getNumBuckets();

    public abstract int getMaxBuckets();

    public abstract int compare(byte[] var1, int var2, int var3);

    public abstract boolean isLeafNode();

    public int search(byte[] key, int key_ofs) {
        int left = -1;
        int right = this.getNumBuckets();
        while (left + 1 < right) {
            assert (this.compare(key, key_ofs, left) >= 0);
            int i = (left + right) / 2;
            int comp = this.compare(key, key_ofs, i);
            if (comp == 0) {
                return i;
            }
            if (comp > 0) {
                left = i;
                continue;
            }
            if (comp >= 0) continue;
            right = i;
        }
        return left;
    }

    protected abstract int endOfBuf();

    public abstract void getKey(int var1, byte[] var2, int var3);

    protected abstract void scoot(byte[] var1, int var2, int var3);

    public abstract int getNumValsBelowBucket(int var1);

    public abstract void getSummary(int var1, byte[] var2, int var3);

    public boolean isRightMost() {
        return this.bt.ui.deserializeInt(this.getBuf(), 0) != 0;
    }

    protected void setRightMost(boolean r) {
        this.bt.ui.serializeInt(r ? 1 : 0, this.getBuf(), 0);
    }
}

