/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.ViaStack;

public class TrackRouterH
extends TrackRouter {
    public TrackRouterH(ArcProto lay, double wid, TechType tech, Cell parnt) {
        super(lay, wid, tech, parnt);
    }

    public TrackRouterH(ArcProto lay, double wid, double centerVal, TechType tech, Cell parnt) {
        super(lay, wid, centerVal, tech, parnt);
    }

    public void connect(PortInst newPort, double viaOffset, double wireOffset) {
        ViaStack closeVia;
        TrackRouterH.error(newPort == null, "can't connect to null port");
        EPoint centerP = newPort.getCenter();
        if (this.center == null) {
            this.center = new Double(centerP.getY());
        }
        ArcProto portLyr = this.tech.closestLayer(newPort.getPortProto(), this.layer);
        double newWid = LayoutLib.widestWireWidth(newPort);
        if (newWid == Double.POSITIVE_INFINITY) {
            newWid = portLyr.getDefaultLambdaBaseWidth();
        }
        double x = centerP.getX() + viaOffset;
        PortInst lastPort = null;
        ViaStack viaStack = closeVia = portLyr == this.layer ? null : this.findSharableVia(x, portLyr);
        if (closeVia != null) {
            lastPort = closeVia.getPort2();
        } else {
            ViaStack vs = new ViaStack(this.layer, portLyr, x, this.center, newWid, this.width, this.tech, this.parent);
            this.insertVia(vs);
            lastPort = vs.getPort2();
        }
        if (wireOffset != 0.0) {
            EditingPreferences ep = newPort.getEditingPreferences();
            PrimitiveNode pin = portLyr.findOverridablePinProto(ep);
            double defSz = Double.POSITIVE_INFINITY;
            NodeInst pinInst = LayoutLib.newNodeInst(pin, LayoutLib.roundCenterX(lastPort), this.center + wireOffset, defSz, defSz, 0.0, this.parent);
            PortInst jog = pinInst.getOnlyPortInst();
            LayoutLib.newArcInst(portLyr, newWid, lastPort, jog);
            lastPort = jog;
        }
        LayoutLib.newArcInst(portLyr, newWid, lastPort, newPort);
    }
}

