/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected1.metrics.CustomMetric;
import java.awt.geom.Rectangle2D;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAMetric
extends CustomMetric {
    private Rectangle2D.Double area = new Rectangle2D.Double();

    public PAMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        super(nodesToPlace, null);
    }

    @Override
    public String getMetricName() {
        return "Placement-Area";
    }

    @Override
    public double compute() {
        if (this.nodesToPlace.size() <= 1) {
            return 0.0;
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (PlacementFrame.PlacementNode node : this.nodesToPlace) {
            double x = node.getPlacementX();
            double y = node.getPlacementY();
            double w = node.getWidth() / 2.0;
            double h = node.getHeight() / 2.0;
            minX = Math.min(x - w, minX);
            maxX = Math.max(x + w, maxX);
            minY = Math.min(y - h, minY);
            maxY = Math.max(y + h, maxY);
        }
        this.area.setRect(minX, minY, maxX - minX, maxY - minY);
        return this.getArea();
    }

    public double getX() {
        return this.area.getX();
    }

    public double getY() {
        return this.area.getY();
    }

    public double getWidth() {
        return this.area.getWidth();
    }

    public double getHeight() {
        return this.area.getHeight();
    }

    public double getArea() {
        return this.area.getWidth() * this.area.getHeight();
    }
}

