/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.io.input.SimulationData;
import com.sun.electric.tool.io.input.spicenetlist.SpiceNetlistReader;
import com.sun.electric.tool.io.input.spicenetlist.SpiceSubckt;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.SpiceExemptedNets;
import com.sun.electric.tool.io.output.SpiceParasitic;
import com.sun.electric.tool.io.output.SpiceParasiticsGeneral;
import com.sun.electric.tool.io.output.SpiceRCSimple;
import com.sun.electric.tool.io.output.SpiceSegmentedNets;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.user.Exec;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ExecDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.SwingUtilities;

public class Spice
extends Topology {
    private static final boolean DETECT_SPICE_PARAMS = true;
    private static final boolean USE_JAVA_CODE = true;
    public static final Variable.Key SPICE_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template");
    public static final Variable.Key SPICE_2_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_spice2");
    public static final Variable.Key SPICE_3_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_spice3");
    public static final Variable.Key SPICE_H_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_hspice");
    public static final Variable.Key SPICE_P_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_pspice");
    public static final Variable.Key SPICE_GC_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_gnucap");
    public static final Variable.Key SPICE_SM_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_smartspice");
    public static final Variable.Key SPICE_A_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_assura");
    public static final Variable.Key SPICE_C_TEMPLATE_KEY = Variable.newKey("ATTR_SPICE_template_calibre");
    public static final Variable.Key SPICE_NETLIST_FILE_KEY = Variable.newKey("ATTR_SPICE_netlist_file");
    public static final Variable.Key SPICE_CARD_KEY = Variable.newKey("SIM_spice_card");
    public static final Variable.Key SPICE_DECLARATION_KEY = Variable.newKey("SIM_spice_declaration");
    public static final Variable.Key SPICE_MODEL_KEY = Variable.newKey("SIM_spice_model");
    public static final Variable.Key SPICE_CODE_FLAT_KEY = Variable.newKey("SIM_spice_code_flat");
    public static final Variable.Key SPICE_MODEL_FILE_KEY = Variable.newKey("SIM_spice_behave_file");
    public static final Variable.Key CDL_TEMPLATE_KEY = Variable.newKey("ATTR_CDL_template");
    public static final String SPICE_EXTENSION_PREFIX = "Extension ";
    public static final String SPICE_NOEXTENSION_PREFIX = "N O N E ";
    private static final int SPICEMAXLENSUBCKTNAME = 70;
    private static final int CDLMAXLENSUBCKTNAME = 40;
    private static final int SPICEMAXLENLINE = 78;
    private static final String SPICELEGALCHARS = "!#$%*+-/<>[]_@";
    private static final String PSPICELEGALCHARS = "!#$%*+-/<>[]_";
    private static final String CDLNOBRACKETLEGALCHARS = "!#$%*+-/<>_";
    private static final Set<Variable.Key> UNIQUIFY_MARK = Collections.emptySet();
    private Technology layoutTechnology;
    private Technology curTech;
    private double maskScale;
    private boolean useCDL;
    private String legalSpiceChars;
    private Variable.Key preferedEngineTemplateKey;
    private boolean assuraHSpice = false;
    private SimulationTool.SpiceEngine spiceEngine;
    private Map<Cell, String> modelOverrides = new HashMap<Cell, String>();
    private Map<NodeProto, Set<Variable.Key>> allSpiceParams = new HashMap<NodeProto, Set<Variable.Key>>();
    private SpiceParasiticsGeneral parasiticInfo;
    private SpiceExemptedNets exemptedNets;
    private boolean writeEmptySubckts = true;
    private int spiceMaxLenLine = 78;
    private FlatSpiceCodeVisitor spiceCodeFlat = null;
    private Map<Cell, Cell> uniquifyCells;
    private int uniqueID;
    private Map<String, Integer> uniqueNames;
    private SpicePreferences localPrefs;
    private static final boolean CELLISEMPTYDEBUG = false;
    private Map<Cell, Boolean> checkedCells = new HashMap<Cell, Boolean>();

    Spice(SpicePreferences sp2) {
        this.localPrefs = sp2;
    }

    @Override
    protected void start() {
        String headerPath;
        this.layoutTechnology = this.topCell.getTechnology().isLayout() ? this.topCell.getTechnology() : Schematics.getDefaultSchematicTechnology();
        this.preferedEngineTemplateKey = SPICE_TEMPLATE_KEY;
        this.assuraHSpice = false;
        switch (this.spiceEngine) {
            case SPICE_ENGINE_2: {
                this.preferedEngineTemplateKey = SPICE_2_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_3: {
                this.preferedEngineTemplateKey = SPICE_3_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_H: {
                this.preferedEngineTemplateKey = SPICE_H_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_P: {
                this.preferedEngineTemplateKey = SPICE_P_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_G: {
                this.preferedEngineTemplateKey = SPICE_GC_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_S: {
                this.preferedEngineTemplateKey = SPICE_SM_TEMPLATE_KEY;
                break;
            }
            case SPICE_ENGINE_H_ASSURA: {
                this.preferedEngineTemplateKey = SPICE_A_TEMPLATE_KEY;
                this.assuraHSpice = true;
                break;
            }
            case SPICE_ENGINE_H_CALIBRE: {
                this.preferedEngineTemplateKey = SPICE_C_TEMPLATE_KEY;
                this.assuraHSpice = true;
            }
        }
        if (this.useCDL) {
            this.preferedEngineTemplateKey = CDL_TEMPLATE_KEY;
        }
        if (this.assuraHSpice || !this.localPrefs.writeEmptySubckts) {
            this.writeEmptySubckts = false;
        }
        this.maskScale = 1.0;
        this.uniquifyCells = new HashMap<Cell, Cell>();
        this.uniqueID = 0;
        this.uniqueNames = new HashMap<String, Integer>();
        this.markCellsToUniquify(this.topCell);
        this.legalSpiceChars = SPICELEGALCHARS;
        if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_P || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_G) {
            this.legalSpiceChars = PSPICELEGALCHARS;
        }
        if (this.useCDL) {
            if (this.localPrefs.cdlConvertBrackets) {
                this.legalSpiceChars = CDLNOBRACKETLEGALCHARS;
            }
            this.multiLinePrint(true, "* First line is ignored\n");
            headerPath = TextUtils.getFilePath(this.topCell.getLibrary().getLibFile());
            String filePart = this.localPrefs.cdlIncludeFile;
            if (!filePart.equals("")) {
                String fileName = headerPath + filePart;
                File test2 = new File(fileName);
                if (test2.exists()) {
                    this.multiLinePrint(true, "* Primitives described in this file:\n");
                    this.addIncludeFile(filePart, false);
                } else {
                    this.reportWarning("Warning: CDL Include file not found: " + fileName);
                }
            }
        } else {
            this.writeHeader(this.topCell);
            this.spiceCodeFlat = new FlatSpiceCodeVisitor(this.filePath + ".flatcode", this);
            HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)this.spiceCodeFlat, this.getShortResistorsFlat());
            this.spiceCodeFlat.close();
        }
        if (this.localPrefs.parasiticsUseExemptedNetsFile) {
            headerPath = TextUtils.getFilePath(this.topCell.getLibrary().getLibFile());
            this.exemptedNets = new SpiceExemptedNets(new File(headerPath + File.separator + "exemptedNets.txt"));
        }
    }

    @Override
    protected void done() {
        if (!this.useCDL) {
            this.writeTrailer(this.topCell);
            if (this.localPrefs.writeFinalDotEnd) {
                this.multiLinePrint(false, ".END\n");
            }
        }
    }

    @Override
    protected void writeCellTopology(Cell cell, String cellName, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        String message;
        Netlist netList;
        if (cell == this.topCell) {
            netList = cni.getNetList();
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            if (this.localPrefs.globalTreatment == SimulationTool.SpiceGlobal.USEGLOBALBLOCK) {
                if (globalSize > 0) {
                    StringBuffer infstr = new StringBuffer();
                    infstr.append("\n.global");
                    for (int i = 0; i < globalSize; ++i) {
                        Global global = globals.get(i);
                        String name = global.getName();
                        if (global == Global.power && this.getPowerName(null) != null) {
                            name = this.getPowerName(null);
                        }
                        if (global == Global.ground && this.getGroundName(null) != null) {
                            name = this.getGroundName(null);
                        }
                        infstr.append(" " + name);
                    }
                    infstr.append("\n");
                    this.multiLinePrint(false, infstr.toString());
                }
            } else {
                if (cni.getPowerNet() == null) {
                    System.out.println("WARNING: cannot find power at top level of circuit");
                }
                if (cni.getGroundNet() == null) {
                    System.out.println("WARNING: cannot find ground at top level of circuit");
                }
            }
        }
        netList = cni.getNetList();
        HashMap<Network, SpiceNet> spiceNetMap = new HashMap<Network, SpiceNet>();
        Iterator<Network> it = netList.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            SpiceNet spNet = new SpiceNet();
            spiceNetMap.put(net, spNet);
        }
        SimulationTool.SpiceParasitics spLevel = this.localPrefs.parasiticsLevel;
        if (this.useCDL || cell.getView() != View.LAYOUT) {
            spLevel = SimulationTool.SpiceParasitics.SIMPLE;
        }
        SpiceSegmentedNets segmentedNets = null;
        if (spLevel != SimulationTool.SpiceParasitics.SIMPLE) {
            if (this.parasiticInfo == null) {
                if (spLevel == SimulationTool.SpiceParasitics.RC_PROXIMITY) {
                    this.parasiticInfo = new SpiceParasitic(this.localPrefs);
                } else if (spLevel == SimulationTool.SpiceParasitics.RC_CONSERVATIVE) {
                    this.parasiticInfo = new SpiceRCSimple(this.localPrefs);
                }
            }
            segmentedNets = this.parasiticInfo.initializeSegments(cell, cni, this.layoutTechnology, this.exemptedNets, info);
        }
        int bipolarTrans = 0;
        int nmosTrans = 0;
        int pmosTrans = 0;
        Iterator<Geometric> aIt = cell.getNodes();
        while (aIt.hasNext()) {
            NodeInst ni = aIt.next();
            this.addNodeInformation(netList, spiceNetMap, ni);
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun == PrimitiveNode.Function.TRANPN || fun == PrimitiveNode.Function.TRA4NPN || fun == PrimitiveNode.Function.TRAPNP || fun == PrimitiveNode.Function.TRA4PNP || fun == PrimitiveNode.Function.TRANS) {
                ++bipolarTrans;
                continue;
            }
            if (fun.isNTypeTransistor()) {
                ++nmosTrans;
                continue;
            }
            if (!fun.isPTypeTransistor()) continue;
            ++pmosTrans;
        }
        aIt = cell.getArcs();
        while (aIt.hasNext()) {
            Network net;
            SpiceNet spNet;
            ArcInst ai = (ArcInst)aIt.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC || (spNet = (SpiceNet)spiceNetMap.get(net = netList.getNetwork(ai, 0))) == null) continue;
            this.addArcInformation(spNet.merge, ai);
        }
        Iterator<Network> it2 = netList.getNetworks();
        while (it2.hasNext()) {
            Network net = it2.next();
            SpiceNet spNet = (SpiceNet)spiceNetMap.get(net);
            for (Layer layer : spNet.merge.getKeySet()) {
                List<PolyBase> polyList = spNet.merge.getMergedPoints(layer, true);
                if (polyList == null) continue;
                if (polyList.size() > 1) {
                    Collections.sort(polyList, GeometryHandler.shapeSort);
                }
                for (PolyBase poly : polyList) {
                    double perim = poly.getPerimeter();
                    double area = poly.getArea();
                    double scale = this.layoutTechnology.getScale();
                    if (layer.isDiffusionLayer()) {
                        spNet.diffArea += area * this.maskScale * this.maskScale;
                        spNet.diffPerim += perim * this.maskScale;
                        continue;
                    }
                    area = area * scale * scale / 1000000.0;
                    perim = perim * scale / 1000.0;
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getCapacitance() * area * this.maskScale * this.maskScale);
                    spNet.nonDiffCapacitance = (float)((double)spNet.nonDiffCapacitance + layer.getEdgeCapacitance() * perim * this.maskScale);
                }
            }
        }
        Network groundNet = cni.getGroundNet();
        Network powerNet = cni.getPowerNet();
        if (pmosTrans != 0 && powerNet == null) {
            message = "WARNING: no power connection for P-transistor wells in " + cell;
            this.dumpMessage(message, false);
        }
        if (nmosTrans != 0 && groundNet == null) {
            message = "WARNING: no ground connection for N-transistor wells in " + cell;
            this.dumpMessage(message, false);
        }
        boolean forceEval = this.useCDL || !this.localPrefs.useCellParameters || this.detectSpiceParams(cell) == UNIQUIFY_MARK;
        String topLevelInstance = "";
        if (cell == this.topCell && !this.useCDL && !this.localPrefs.writeSubcktTopCell) {
            this.multiLinePrint(true, "\n*** TOP LEVEL CELL: " + cell.describe(false) + "\n");
        } else {
            if (!this.writeEmptySubckts && this.cellIsEmpty(cell)) {
                return;
            }
            this.multiLinePrint(true, "\n*** SUBCIRCUIT " + cellName + " FROM CELL " + cell.describe(false) + "\n");
            StringBuffer infstr = new StringBuffer();
            infstr.append(".SUBCKT " + cellName);
            Iterator<Topology.CellSignal> sIt = cni.getCellSignals();
            while (sIt.hasNext()) {
                Topology.CellSignal cs = sIt.next();
                if (this.ignoreSubcktPort(cs) || !cs.isGlobal() && cs.getExport() == null) continue;
                if (this.parasiticInfo != null && !cs.isGlobal() && cs.getExport() != null) {
                    this.parasiticInfo.writeSubcircuitHeader(cs, infstr);
                    continue;
                }
                infstr.append(" " + cs.getName());
            }
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            if (cell == this.topCell && this.localPrefs.writeSubcktTopCell && this.localPrefs.writeTopCellInstance) {
                topLevelInstance = infstr.toString().replaceFirst("\\.SUBCKT ", "X") + " " + cellName;
            }
            if (!this.useCDL && this.localPrefs.useCellParameters) {
                boolean firstParam = true;
                Set<Variable.Key> spiceParams = this.detectSpiceParams(cell);
                Iterator<Variable> it3 = cell.getParameters();
                while (it3.hasNext()) {
                    Variable paramVar = it3.next();
                    if (!spiceParams.contains(paramVar.getKey())) continue;
                    String value2 = paramVar.getPureValue(-1);
                    value2 = this.evalParam(context, info.getParentInst(), paramVar, forceEval);
                    if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_O && firstParam) {
                        infstr.append(" param:");
                        firstParam = false;
                    }
                    infstr.append(" " + paramVar.getTrueName() + "=" + value2);
                }
            }
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
            if (this.localPrefs.globalTreatment == SimulationTool.SpiceGlobal.USEGLOBALBLOCK) {
                for (int i = 0; i < globalSize; ++i) {
                    Global global = globals.get(i);
                    Network net = netList.getNetwork(global);
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    this.multiLinePrint(true, "** GLOBAL " + cs.getName() + "\n");
                }
            }
        }
        if (!this.useCDL) {
            boolean firstDecl = true;
            Iterator<NodeInst> it4 = cell.getNodes();
            while (it4.hasNext()) {
                Variable cardVar;
                NodeInst ni = it4.next();
                if (ni.getProto() != Generic.tech().invisiblePinNode || (cardVar = ni.getVar(SPICE_DECLARATION_KEY)) == null) continue;
                if (firstDecl) {
                    firstDecl = false;
                    this.multiLinePrint(true, "\n* Spice Declaration nodes in cell " + cell + "\n");
                }
                this.emitEmbeddedSpice(cardVar, context, segmentedNets, info, false, forceEval);
            }
        }
        Iterator<Nodable> nIt = netList.getNodables();
        while (nIt.hasNext()) {
            TransistorSize size2;
            Nodable no = nIt.next();
            NodeProto niProto = no.getProto();
            if (no.isCellInstance()) {
                String alternateSubCellName;
                Cell subCell = (Cell)niProto;
                Variable varTemplate = this.getEngineTemplate(subCell);
                if (varTemplate != null) {
                    if (varTemplate.getObject() instanceof Object[]) {
                        Object[] manyLines = (Object[])varTemplate.getObject();
                        for (int i = 0; i < manyLines.length; ++i) {
                            String line = manyLines[i].toString();
                            StringBuffer infstr = this.replacePortsAndVars(line, no, context, cni, segmentedNets, info, false, forceEval);
                            if (i == 0) {
                                this.writeMFactor(context, no, infstr);
                            }
                            infstr.append('\n');
                            this.multiLinePrint(false, infstr.toString());
                        }
                        continue;
                    }
                    String line = varTemplate.getObject().toString();
                    StringBuffer infstr = this.replacePortsAndVars(line, no, context, cni, segmentedNets, info, false, forceEval);
                    this.writeMFactor(context, no, infstr);
                    infstr.append('\n');
                    this.multiLinePrint(false, infstr.toString());
                    continue;
                }
                Topology.CellNetInfo subCni = this.getCellNetInfo(this.parameterizedName(no, context));
                if (subCni == null || !this.writeEmptySubckts && this.cellIsEmpty((Cell)niProto)) continue;
                String modelChar = "X";
                if (no.getName() != null) {
                    modelChar = modelChar + this.getSafeNetName(no.getName(), false);
                }
                StringBuffer infstr = new StringBuffer();
                infstr.append(modelChar);
                Iterator<Topology.CellSignal> sIt = subCni.getCellSignals();
                while (sIt.hasNext()) {
                    Network net;
                    Topology.CellSignal subCS = sIt.next();
                    if (this.ignoreSubcktPort(subCS)) continue;
                    Export pp = subCS.getExport();
                    if (!subCS.isGlobal() && pp == null) continue;
                    int exportIndex = subCS.getExportIndex();
                    if (pp != null && cell.isSchematic() && subCni.getCell().getView() == View.LAYOUT) {
                        Network subNet = subCS.getNetwork();
                        boolean found = false;
                        Iterator<Export> eIt = subCell.getExports();
                        while (eIt.hasNext()) {
                            Export ex = eIt.next();
                            for (int i = 0; i < ex.getNameKey().busWidth(); ++i) {
                                String exName = ex.getNameKey().subname(i).toString();
                                if (!exName.equals(subNet.getName())) continue;
                                pp = ex;
                                exportIndex = i;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                            break;
                        }
                        if (!found) {
                            if (pp.isGround() && pp.getName().startsWith("gnd")) {
                                infstr.append(" gnd");
                                continue;
                            }
                            if (pp.isPower() && pp.getName().startsWith("vdd")) {
                                infstr.append(" vdd");
                                continue;
                            }
                            System.out.println("No matching export on schematic/icon found for export " + subNet.getName() + " in cell " + subCni.getCell().describe(false));
                            infstr.append(" unknown");
                            continue;
                        }
                    }
                    if ((net = subCS.isGlobal() ? netList.getNetwork(no, subCS.getGlobal()) : netList.getNetwork(no, pp, exportIndex)) == null) {
                        this.reportWarning("Warning: cannot find network for signal " + subCS.getName() + " in cell " + subCni.getCell().describe(false));
                        continue;
                    }
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    SpiceSegmentedNets subSN = null;
                    if (this.parasiticInfo != null && !cs.isGlobal()) {
                        subSN = this.parasiticInfo.getSegmentedNets((Cell)no.getProto());
                    }
                    if (subSN != null) {
                        this.parasiticInfo.getParasiticName(no, subCS.getNetwork(), subSN, infstr);
                        continue;
                    }
                    String name = cs.getName();
                    if (this.parasiticInfo != null) {
                        name = segmentedNets.getNetName(no.getNodeInst().findPortInstFromEquivalentProto(pp));
                    }
                    infstr.append(" " + name);
                }
                if (this.useCDL) {
                    infstr.append(" /");
                } else {
                    infstr.append(" ");
                }
                String subCellName = subCni.getParameterizedName();
                NodeInst ni = no.getNodeInst();
                if (ni != null && (alternateSubCellName = this.getIconCellName((Cell)ni.getProto())) != null) {
                    subCellName = alternateSubCellName;
                }
                infstr.append(subCellName);
                if (!this.useCDL && this.localPrefs.useCellParameters) {
                    Set<Variable.Key> spiceParams = this.detectSpiceParams(subCell);
                    Iterator<Variable> it5 = subCell.getParameters();
                    while (it5.hasNext()) {
                        Variable paramVar = it5.next();
                        if (!spiceParams.contains(paramVar.getKey())) continue;
                        Variable instVar = no.getParameter(paramVar.getKey());
                        String paramStr = "??";
                        if (instVar != null) {
                            paramStr = this.evalParam(context, no, instVar, forceEval);
                        }
                        infstr.append(" " + paramVar.getTrueName() + "=" + paramStr);
                    }
                }
                this.writeMFactor(context, no, infstr);
                infstr.append("\n");
                this.multiLinePrint(false, infstr.toString());
                continue;
            }
            NodeInst ni = (NodeInst)no;
            String line = ((PrimitiveNode)ni.getProto()).getSpiceTemplate();
            if (line != null) {
                StringBuffer infstr = this.replacePortsAndVars(line, no, context, cni, segmentedNets, info, false, forceEval);
                this.writeMFactor(context, no, infstr);
                infstr.append('\n');
                this.multiLinePrint(false, infstr.toString());
                continue;
            }
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun.isResistor() || fun.isCapacitor() || fun == PrimitiveNode.Function.INDUCT || fun == PrimitiveNode.Function.DIODE || fun == PrimitiveNode.Function.DIODEZ) {
                String extra;
                if (fun.isResistor()) {
                    if (fun.isComplexResistor() && this.isShortExplicitResistors() || fun == PrimitiveNode.Function.RESIST && this.isShortResistors()) continue;
                    Variable resistVar = ni.getVar(Schematics.SCHEM_RESISTANCE);
                    extra = "";
                    String partName = "R";
                    if (resistVar != null) {
                        extra = this.evalParam(context, ni, resistVar, forceEval);
                    } else if (fun.isComplexResistor()) {
                        partName = "XR";
                        double width = ni.getLambdaBaseYSize();
                        double length = ni.getLambdaBaseXSize();
                        extra = this.localPrefs.writeTransSizeInLambda ? " L=" + length + " W=" + width : " L=" + this.formatParam(length + "*LAMBDA", AbstractTextDescriptor.Unit.NONE, false) + " W=" + this.formatParam(width + "*LAMBDA", AbstractTextDescriptor.Unit.NONE, false);
                        String prepend = "";
                        if (fun == PrimitiveNode.Function.RESPPOLY) {
                            prepend = "rppo1rpo";
                        } else if (fun == PrimitiveNode.Function.RESNPOLY) {
                            prepend = "rnpo1rpo";
                        } else if (fun == PrimitiveNode.Function.RESPNSPOLY) {
                            prepend = "rpponsrpo";
                        } else if (fun == PrimitiveNode.Function.RESNNSPOLY) {
                            prepend = "rnponsrpo";
                        } else if (fun == PrimitiveNode.Function.RESPWELL) {
                            prepend = "rpwod ";
                        } else if (fun == PrimitiveNode.Function.RESNWELL) {
                            prepend = "rnwod ";
                        } else if (fun == PrimitiveNode.Function.RESPACTIVE) {
                            prepend = "rpaod ";
                        } else if (fun == PrimitiveNode.Function.RESNACTIVE) {
                            prepend = "rnaod ";
                        }
                        if (this.layoutTechnology == Technology.getCMOS90Technology() || cell.getView() == View.LAYOUT && cell.getTechnology() == Technology.getCMOS90Technology()) {
                            if (fun == PrimitiveNode.Function.RESPPOLY) {
                                prepend = "GND rpporpo";
                            } else if (fun == PrimitiveNode.Function.RESNPOLY) {
                                prepend = "GND rnporpo";
                            }
                        }
                        extra = prepend + extra;
                    }
                    this.writeTwoPort(ni, partName, extra, cni, netList, context, segmentedNets);
                    continue;
                }
                if (fun.isCapacitor()) {
                    Variable capacVar = ni.getVar(Schematics.SCHEM_CAPACITANCE);
                    extra = "";
                    if (capacVar != null) {
                        extra = this.evalParam(context, no, capacVar, forceEval);
                    }
                    this.writeTwoPort(ni, "C", extra, cni, netList, context, segmentedNets);
                    continue;
                }
                if (fun == PrimitiveNode.Function.INDUCT) {
                    Variable inductVar = ni.getVar(Schematics.SCHEM_INDUCTANCE);
                    extra = "";
                    if (inductVar != null) {
                        extra = this.evalParam(context, no, inductVar, forceEval);
                    }
                    this.writeTwoPort(ni, "L", extra, cni, netList, context, segmentedNets);
                    continue;
                }
                if (fun != PrimitiveNode.Function.DIODE && fun != PrimitiveNode.Function.DIODEZ) continue;
                Variable diodeVar = ni.getVar(Schematics.SCHEM_DIODE);
                extra = "";
                if (diodeVar != null) {
                    extra = diodeVar.describe(context, ni);
                }
                if (extra.length() == 0) {
                    extra = "DIODE";
                }
                this.writeTwoPort(ni, "D", extra, cni, netList, context, segmentedNets);
                continue;
            }
            if (((PrimitiveNode)niProto).getGroupFunction() != PrimitiveNode.Function.TRANS) continue;
            Network gateNet = netList.getNetwork(ni.getTransistorGatePort());
            Topology.CellSignal gateCs = cni.getCellSignal(gateNet);
            Network sourceNet = netList.getNetwork(ni.getTransistorSourcePort());
            Topology.CellSignal sourceCs = cni.getCellSignal(sourceNet);
            Network drainNet = netList.getNetwork(ni.getTransistorDrainPort());
            Topology.CellSignal drainCs = cni.getCellSignal(drainNet);
            Topology.CellSignal biasCs = null;
            PortInst biasPort = ni.getTransistorBiasPort();
            if (biasPort != null) {
                biasCs = cni.getCellSignal(netList.getNetwork(biasPort));
            }
            if (gateCs == null || sourceCs == null || drainCs == null) {
                String message2 = "WARNING: " + ni + " not fully connected in " + cell;
                this.dumpMessage(message2, false);
            }
            String modelName = null;
            String defaultBulkName = null;
            Variable modelVar = ni.getVar(SPICE_MODEL_KEY);
            if (modelVar != null) {
                modelName = modelVar.getObject().toString();
            }
            boolean st090laytrans = false;
            boolean tsmc090laytrans = false;
            if (cell.getView() == View.LAYOUT && this.layoutTechnology == Technology.getCMOS90Technology()) {
                if (this.layoutTechnology.getSelectedFoundry().getType() == Foundry.Type.TSMC) {
                    tsmc090laytrans = true;
                } else if (this.layoutTechnology.getSelectedFoundry().getType() == Foundry.Type.ST) {
                    st090laytrans = true;
                }
            }
            String modelChar = "";
            if (fun == PrimitiveNode.Function.TRANSREF) {
                modelChar = "X";
                if (biasCs == null) {
                    biasCs = cni.getCellSignal(groundNet);
                }
                modelName = niProto.getName();
            } else if (fun == PrimitiveNode.Function.TRANMOS) {
                modelChar = "M";
                if (biasCs == null) {
                    biasCs = cni.getCellSignal(groundNet);
                }
                defaultBulkName = "gnd";
                if (modelName == null) {
                    modelName = "N";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "nsvt";
                }
                if (tsmc090laytrans) {
                    modelName = "nch";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "N";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "nsvt";
                }
                if (tsmc090laytrans) {
                    modelName = "nch";
                }
            } else if (fun == PrimitiveNode.Function.TRADMOS) {
                modelChar = "M";
                if (biasCs == null) {
                    biasCs = cni.getCellSignal(groundNet);
                }
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == PrimitiveNode.Function.TRA4DMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "D";
                }
            } else if (fun == PrimitiveNode.Function.TRAPMOS) {
                modelChar = "M";
                if (biasCs == null) {
                    biasCs = cni.getCellSignal(powerNet);
                }
                defaultBulkName = "vdd";
                if (modelName == null) {
                    modelName = "P";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "psvt";
                }
                if (tsmc090laytrans) {
                    modelName = "pch";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PMOS) {
                modelChar = "M";
                if (modelName == null) {
                    modelName = "P";
                }
                if (st090laytrans) {
                    modelChar = "XM";
                    modelName = "psvt";
                }
                if (tsmc090laytrans) {
                    modelName = "pch";
                }
            } else if (fun == PrimitiveNode.Function.TRANPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NPN) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "NBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRAPNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PNP) {
                modelChar = "Q";
                if (modelName == null) {
                    modelName = "PBJT";
                }
            } else if (fun == PrimitiveNode.Function.TRANJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRA4NJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "NJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRAPJFET) {
                modelChar = "J";
                biasCs = null;
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRA4PJFET) {
                modelChar = "J";
                if (modelName == null) {
                    modelName = "PJFET";
                }
            } else if (fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRA4DMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "DMES";
            } else if (fun == PrimitiveNode.Function.TRAEMES || fun == PrimitiveNode.Function.TRA4EMES) {
                modelChar = "Z";
                biasCs = null;
                modelName = "EMES";
            } else if (fun == PrimitiveNode.Function.TRANMOSCN) {
                modelChar = "X";
                biasCs = cni.getCellSignal(groundNet);
                defaultBulkName = "gnd";
                modelName = "NCNFET";
            } else if (fun == PrimitiveNode.Function.TRA4NMOSCN) {
                modelChar = "X";
                modelName = "NCNFET";
            } else if (fun == PrimitiveNode.Function.TRAPMOSCN) {
                modelChar = "X";
                biasCs = cni.getCellSignal(powerNet);
                defaultBulkName = "vdd";
                modelName = "PCNFET";
            } else if (fun == PrimitiveNode.Function.TRA4PMOSCN) {
                modelChar = "X";
                modelName = "PCNFET";
            } else if (fun == PrimitiveNode.Function.TRANS) {
                modelChar = "Q";
            }
            if (ni.getName() != null) {
                modelChar = modelChar + this.getSafeNetName(ni.getName(), false);
            }
            StringBuffer infstr = new StringBuffer();
            String drainName = drainCs.getName();
            String gateName = gateCs.getName();
            String sourceName = sourceCs.getName();
            if (segmentedNets != null) {
                drainName = segmentedNets.getNetName(ni.getTransistorDrainPort());
                gateName = segmentedNets.getNetName(ni.getTransistorGatePort());
                sourceName = segmentedNets.getNetName(ni.getTransistorSourcePort());
            }
            infstr.append(modelChar + " " + drainName + " " + gateName + " " + sourceName);
            if (biasCs != null) {
                String bn;
                String biasName = biasCs.getName();
                if (segmentedNets != null && ni.getTransistorBiasPort() != null && (bn = segmentedNets.getNetName(ni.getTransistorBiasPort())) != null) {
                    biasName = bn;
                }
                infstr.append(" " + biasName);
            } else if (cell.getView() == View.LAYOUT && defaultBulkName != null) {
                infstr.append(" " + defaultBulkName);
            }
            if (modelName != null) {
                infstr.append(" " + modelName);
            }
            if ((size2 = ni.getTransistorSize(context)) == null) {
                this.reportWarning("Warning: transistor has null size " + ni.describe(false));
            } else {
                Double foundLen = null;
                Variable varLen = ni.getVar(Schematics.ATTR_LENGTH);
                if (varLen != null && varLen.getCode() == CodeExpression.Code.SPICE && !this.useCDL && this.localPrefs.useCellParameters) {
                    infstr.append(" L=" + this.evalParam(context, no, varLen, forceEval));
                } else {
                    double lengthSubtraction = this.layoutTechnology.getGateLengthSubtraction() / this.layoutTechnology.getScale() * 1000.0;
                    if (size2.getDoubleLength() > 0.0) {
                        double l = this.maskScale * size2.getDoubleLength();
                        l -= lengthSubtraction;
                        if (!this.localPrefs.writeTransSizeInLambda) {
                            l *= this.layoutTechnology.getScale() / 1000.0;
                        }
                        if (fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRA4NMOS || fun == PrimitiveNode.Function.TRAPMOS || fun == PrimitiveNode.Function.TRA4PMOS || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRA4DMOS || (fun == PrimitiveNode.Function.TRANJFET || fun == PrimitiveNode.Function.TRAPJFET || fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRAEMES) && (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_H || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_H_ASSURA)) {
                            if (size2.getDoubleLength() == 0.0 && size2.getLength() instanceof String) {
                                infstr.append(" L=" + this.formatParam((String)size2.getLength(), AbstractTextDescriptor.Unit.DISTANCE, false));
                                if (lengthSubtraction != 0.0) {
                                    infstr.append(" - " + lengthSubtraction);
                                }
                            } else {
                                infstr.append(" L=" + TextUtils.formatDouble(l));
                                if (!this.localPrefs.writeTransSizeInLambda && !st090laytrans) {
                                    infstr.append("U");
                                }
                            }
                        }
                        foundLen = new Double(l);
                    } else if (size2.getDoubleLength() == 0.0 && size2.getLength() instanceof String) {
                        infstr.append(" L=" + this.formatParam((String)size2.getLength(), AbstractTextDescriptor.Unit.DISTANCE, false));
                        if (lengthSubtraction != 0.0) {
                            infstr.append(" - " + lengthSubtraction);
                        }
                    }
                }
                Double foundWid = null;
                Variable varWid = ni.getVar(Schematics.ATTR_WIDTH);
                if (varWid != null && varWid.getCode() == CodeExpression.Code.SPICE && !this.useCDL && this.localPrefs.useCellParameters) {
                    infstr.append(" W=" + this.evalParam(context, no, varWid, forceEval));
                } else if (size2.getDoubleWidth() > 0.0) {
                    double w = this.maskScale * size2.getDoubleWidth();
                    if (!this.localPrefs.writeTransSizeInLambda) {
                        w *= this.layoutTechnology.getScale() / 1000.0;
                    }
                    if (fun == PrimitiveNode.Function.TRANMOS || fun == PrimitiveNode.Function.TRA4NMOS || fun == PrimitiveNode.Function.TRAPMOS || fun == PrimitiveNode.Function.TRA4PMOS || fun == PrimitiveNode.Function.TRADMOS || fun == PrimitiveNode.Function.TRA4DMOS || (fun == PrimitiveNode.Function.TRANJFET || fun == PrimitiveNode.Function.TRAPJFET || fun == PrimitiveNode.Function.TRADMES || fun == PrimitiveNode.Function.TRAEMES) && (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_H || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_H_ASSURA)) {
                        if (size2.getDoubleWidth() == 0.0 && size2.getWidth() instanceof String) {
                            infstr.append(" W=" + this.formatParam((String)size2.getWidth(), AbstractTextDescriptor.Unit.DISTANCE, false));
                        } else {
                            infstr.append(" W=" + TextUtils.formatDouble(w));
                            if (!this.localPrefs.writeTransSizeInLambda && !st090laytrans) {
                                infstr.append("U");
                            }
                        }
                    }
                    foundWid = new Double(w);
                } else if (size2.getDoubleWidth() == 0.0 && size2.getWidth() instanceof String) {
                    infstr.append(" W=" + this.formatParam((String)size2.getWidth(), AbstractTextDescriptor.Unit.DISTANCE, false));
                }
                if (fun != PrimitiveNode.Function.TRANMOS && fun != PrimitiveNode.Function.TRA4NMOS && fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS && fun != PrimitiveNode.Function.TRADMOS && fun != PrimitiveNode.Function.TRA4DMOS && fun != PrimitiveNode.Function.TRANMOSCN && fun != PrimitiveNode.Function.TRA4NMOSCN && fun != PrimitiveNode.Function.TRAPMOSCN && fun != PrimitiveNode.Function.TRA4PMOSCN && foundLen != null && foundWid != null) {
                    infstr.append(" AREA=" + TextUtils.formatDouble(foundLen * foundWid));
                    if (!this.localPrefs.writeTransSizeInLambda) {
                        infstr.append("P");
                    }
                }
            }
            SpiceNet spNetGate = (SpiceNet)spiceNetMap.get(gateNet);
            SpiceNet spNetSource = (SpiceNet)spiceNetMap.get(sourceNet);
            SpiceNet spNetDrain = (SpiceNet)spiceNetMap.get(drainNet);
            if (spNetGate == null || spNetSource == null || spNetDrain == null) continue;
            if (!(this.useCDL || fun != PrimitiveNode.Function.TRANMOS && fun != PrimitiveNode.Function.TRA4NMOS && fun != PrimitiveNode.Function.TRAPMOS && fun != PrimitiveNode.Function.TRA4PMOS && fun != PrimitiveNode.Function.TRADMOS && fun != PrimitiveNode.Function.TRA4DMOS)) {
                double as = 0.0;
                double ad = 0.0;
                double ps = 0.0;
                double pd = 0.0;
                if (spNetSource.transistorCount != 0) {
                    as = spNetSource.diffArea / (double)spNetSource.transistorCount;
                    ps = spNetSource.diffPerim / (double)spNetSource.transistorCount;
                    if (!this.localPrefs.writeTransSizeInLambda) {
                        as *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        ps *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (spNetDrain.transistorCount != 0) {
                    ad = spNetDrain.diffArea / (double)spNetDrain.transistorCount;
                    pd = spNetDrain.diffPerim / (double)spNetDrain.transistorCount;
                    if (!this.localPrefs.writeTransSizeInLambda) {
                        ad *= this.layoutTechnology.getScale() * this.layoutTechnology.getScale() / 1000000.0;
                        pd *= this.layoutTechnology.getScale() / 1000.0;
                    }
                }
                if (as > 0.0) {
                    infstr.append(" AS=" + TextUtils.formatDouble(as));
                    if (!this.localPrefs.writeTransSizeInLambda && !st090laytrans) {
                        infstr.append("P");
                    }
                }
                if (ad > 0.0) {
                    infstr.append(" AD=" + TextUtils.formatDouble(ad));
                    if (!this.localPrefs.writeTransSizeInLambda && !st090laytrans) {
                        infstr.append("P");
                    }
                }
                if (ps > 0.0) {
                    infstr.append(" PS=" + TextUtils.formatDouble(ps));
                    if (!this.localPrefs.writeTransSizeInLambda && !st090laytrans) {
                        infstr.append("U");
                    }
                }
                if (pd > 0.0) {
                    infstr.append(" PD=" + TextUtils.formatDouble(pd));
                    if (!this.localPrefs.writeTransSizeInLambda && !st090laytrans) {
                        infstr.append("U");
                    }
                }
            }
            this.writeMFactor(context, ni, infstr);
            infstr.append("\n");
            this.multiLinePrint(false, infstr.toString());
        }
        if (segmentedNets != null) {
            if (spLevel == SimulationTool.SpiceParasitics.RC_PROXIMITY) {
                this.parasiticInfo.writeNewSpiceCode(cell, cni, this.layoutTechnology, this);
            } else {
                int capCount = 0;
                this.multiLinePrint(true, "** Extracted Parasitic Capacitors ***\n");
                for (SpiceSegmentedNets.NetInfo netInfo : segmentedNets.getUniqueSegments()) {
                    if (!(netInfo.getCap() > cell.getTechnology().getMinCapacitance()) || netInfo.getName().equals("gnd")) continue;
                    this.multiLinePrint(false, "C" + capCount + " " + netInfo.getName() + " 0 " + TextUtils.formatDouble(netInfo.getCap()) + "fF\n");
                    ++capCount;
                }
                int resCount = 0;
                this.multiLinePrint(true, "** Extracted Parasitic Resistors ***\n");
                Iterator<ArcInst> it6 = cell.getArcs();
                while (it6.hasNext()) {
                    ArcInst ai = it6.next();
                    Double res = segmentedNets.getRes(ai);
                    if (res == null) continue;
                    String n0 = segmentedNets.getNetName(ai.getHeadPortInst());
                    String n1 = segmentedNets.getNetName(ai.getTailPortInst());
                    int arcPImodels = SpiceSegmentedNets.getNumPISegments(res, this.layoutTechnology.getMaxSeriesResistance());
                    if (arcPImodels > 1) {
                        double segCap = segmentedNets.getArcCap(ai) / (double)(arcPImodels + 1);
                        double segRes = res / (double)arcPImodels;
                        String segn0 = n0;
                        String segn1 = n0;
                        for (int i = 0; i < arcPImodels; ++i) {
                            String capVal;
                            segn1 = n0 + "##" + i;
                            if (i == arcPImodels - 1) {
                                segn1 = n1;
                            }
                            this.multiLinePrint(false, "R" + resCount + " " + segn0 + " " + segn1 + " " + TextUtils.formatDouble(segRes) + "\n");
                            ++resCount;
                            if (i < arcPImodels - 1 && !segn1.equals("gnd") && segCap > this.layoutTechnology.getMinCapacitance() && !(capVal = TextUtils.formatDouble(segCap)).equals("0.00")) {
                                this.multiLinePrint(false, "C" + capCount + " " + segn1 + " 0 " + capVal + "fF\n");
                                ++capCount;
                            }
                            segn0 = segn1;
                        }
                        continue;
                    }
                    this.multiLinePrint(false, "R" + resCount + " " + n0 + " " + n1 + " " + TextUtils.formatDouble(res) + "\n");
                    ++resCount;
                }
            }
        }
        if (!this.useCDL) {
            boolean firstDecl = true;
            Iterator<NodeInst> it7 = cell.getNodes();
            while (it7.hasNext()) {
                Variable cardVar;
                NodeInst ni = it7.next();
                if (ni.getProto() != Generic.tech().invisiblePinNode || (cardVar = ni.getVar(SPICE_CARD_KEY)) == null) continue;
                if (firstDecl) {
                    firstDecl = false;
                    this.multiLinePrint(true, "\n* Spice Code nodes in cell " + cell + "\n");
                }
                this.emitEmbeddedSpice(cardVar, context, segmentedNets, info, false, forceEval);
            }
        }
        NccCellAnnotations anna = NccCellAnnotations.getAnnotations(cell);
        if (cell == this.topCell && anna != null) {
            if (anna.getExportsConnected().hasNext()) {
                this.multiLinePrint(true, "\n*** Exports shorted due to NCC annotation 'exportsConnectedByParent':\n");
            }
            Iterator<List<NccCellAnnotations.NamePattern>> it8 = anna.getExportsConnected();
            while (it8.hasNext()) {
                List<NccCellAnnotations.NamePattern> list2 = it8.next();
                ArrayList<Network> netsToConnect = new ArrayList<Network>();
                for (NccCellAnnotations.NamePattern pat : list2) {
                    Iterator<PortProto> it3 = cell.getPorts();
                    while (it3.hasNext()) {
                        Network net;
                        Export e = (Export)it3.next();
                        String name = e.getName();
                        if (!pat.matches(name) || netsToConnect.contains(net = netList.getNetwork(e, 0))) continue;
                        netsToConnect.add(net);
                    }
                }
                String name = null;
                for (Network net : netsToConnect) {
                    if (name != null) {
                        this.multiLinePrint(false, "R" + name + " " + name + " " + net.getName() + " 0.001\n");
                    }
                    name = net.getName();
                }
            }
        }
        if (cell != this.topCell || this.useCDL || this.localPrefs.writeSubcktTopCell) {
            this.multiLinePrint(false, ".ENDS " + cni.getParameterizedName() + "\n");
        }
        if (cell == this.topCell && this.localPrefs.writeSubcktTopCell) {
            this.multiLinePrint(false, "\n\n" + topLevelInstance + "\n\n");
        }
    }

    @Override
    protected String parameterizedName(Nodable no, VarContext context) {
        Cell cell = (Cell)no.getProto();
        String uniqueName = this.getUniqueCellName(cell);
        if (uniqueName == null) {
            uniqueName = cell.getName();
            String msg = "Cell " + cell.describe(true) + " is missing information. Corresponding schematic might be missing";
            msg = msg + " Taking '" + uniqueName + "' now.";
            this.dumpMessage(msg, true);
        }
        StringBuffer uniqueCellName = new StringBuffer(uniqueName);
        if (this.uniquifyCells.get(cell) != null && this.modelOverrides.get(cell) == null) {
            VarContext vc = context.push(no);
            uniqueCellName.append("_" + vc.getInstPath("."));
        } else {
            boolean useCellParams;
            boolean bl = useCellParams = !this.useCDL && this.localPrefs.useCellParameters;
            if (this.canParameterizeNames() && no.isCellInstance() && !SCLibraryGen.isStandardCell(cell)) {
                Set<Variable.Key> spiceParams = this.detectSpiceParams(cell);
                ArrayList<Variable> paramValues = new ArrayList<Variable>();
                Iterator<Variable> it = no.getDefinedParameters();
                while (it.hasNext()) {
                    Variable var = it.next();
                    if (!spiceParams.contains(var.getKey()) || useCellParams && !spiceParams.contains(null)) continue;
                    paramValues.add(var);
                }
                for (Variable var : paramValues) {
                    String eval = var.describe(context, no);
                    if (eval == null) continue;
                    uniqueCellName.append("-" + eval.toString());
                }
            }
        }
        int limit = this.maxNameLength();
        if (limit > 0 && uniqueCellName.length() > limit) {
            Integer i = this.uniqueNames.get(uniqueCellName.toString());
            if (i == null) {
                i = new Integer(this.uniqueID);
                ++this.uniqueID;
                this.uniqueNames.put(uniqueCellName.toString(), i);
            }
            uniqueCellName = uniqueCellName.delete(limit - 10, uniqueCellName.length());
            uniqueCellName.append("-ID" + i);
        }
        return this.getSafeCellName(uniqueCellName.toString());
    }

    private CodeExpression getCodeExpression(ElectricObject eObj, Variable var) {
        String parseExceptionDesc;
        CodeExpression ce = var.getCodeExpression();
        if (ce != null && (parseExceptionDesc = var.describeParseException(eObj)) != null) {
            System.out.println("WARNING: " + parseExceptionDesc);
        }
        return ce;
    }

    private boolean isNetlistableParam(ElectricObject eObj, Variable var) {
        CodeExpression ce = this.getCodeExpression(eObj, var);
        if (ce == null) {
            return true;
        }
        return ce.getHSpiceText(false) != null;
    }

    private String evalParam(VarContext context, Nodable no, Variable instParam, boolean forceEval) {
        return this.evalParam(context, no, instParam, forceEval, false, false);
    }

    private String evalParam(VarContext context, Nodable no, Variable instParam, boolean forceEval, boolean inPars, boolean wrapped) {
        CodeExpression ce;
        Object obj = null;
        if (!forceEval && (ce = this.getCodeExpression(no.getNodeInst(), instParam)) != null) {
            obj = ce.getHSpiceText(inPars);
        }
        if (obj == null) {
            obj = context.evalVar(instParam, no);
        }
        if (obj instanceof Number) {
            obj = TextUtils.formatDoublePostFix(((Number)obj).doubleValue());
        }
        return this.formatParam(String.valueOf(obj), instParam.getUnit(), wrapped);
    }

    private Set<Variable.Key> detectSpiceParams(NodeProto np) {
        Set<Variable.Key> params = this.allSpiceParams.get(np);
        if (params != null) {
            return params;
        }
        if (np instanceof PrimitiveNode) {
            params = this.getImportantVars((PrimitiveNode)np);
        } else {
            Cell cell = (Cell)np;
            params = this.getTemplateVars(cell);
            if (params == null) {
                if (cell.isIcon() && cell.contentsView() != null) {
                    Cell schCell = cell.contentsView();
                    params = this.detectSpiceParams(schCell);
                } else {
                    params = new HashSet<Variable.Key>();
                    boolean uniquify = false;
                    Iterator<NodeInst> nit = cell.getNodes();
                    while (nit.hasNext()) {
                        NodeInst ni = nit.next();
                        if (ni.isIconOfParent()) continue;
                        Set<Variable.Key> protoParams = this.detectSpiceParams(ni.getProto());
                        if (protoParams == UNIQUIFY_MARK) {
                            uniquify = true;
                        }
                        for (Variable.Key protoParam : protoParams) {
                            CodeExpression ce;
                            Variable var = ni.getParameterOrVariable(protoParam);
                            if (var == null || (ce = this.getCodeExpression(ni, var)) == null) continue;
                            if (!this.isNetlistableParam(ni, var)) {
                                uniquify = true;
                            }
                            Set<Variable.Key> depends = ce.dependsOn();
                            params.addAll(depends);
                        }
                        if (ni.getProto() != Generic.tech().invisiblePinNode) continue;
                        this.findVarsInTemplate(ni.getVar(SPICE_DECLARATION_KEY), cell, false, params);
                        this.findVarsInTemplate(ni.getVar(SPICE_CARD_KEY), cell, false, params);
                    }
                    if (uniquify) {
                        params = UNIQUIFY_MARK;
                    }
                }
            }
        }
        this.allSpiceParams.put(np, params);
        return params;
    }

    protected Set<Variable.Key> getImportantVars(PrimitiveNode pn) {
        HashSet<Variable.Key> importantVars = new HashSet<Variable.Key>();
        String line = pn.getSpiceTemplate();
        if (line != null) {
            this.findVarsInLine(line, pn, true, importantVars);
            return importantVars;
        }
        PrimitiveNode.Function fun = pn.getFunction();
        if (fun.isResistor()) {
            importantVars.add(Schematics.SCHEM_RESISTANCE);
        } else if (fun.isCapacitor()) {
            importantVars.add(Schematics.SCHEM_CAPACITANCE);
        } else if (fun == PrimitiveNode.Function.INDUCT) {
            importantVars.add(Schematics.SCHEM_INDUCTANCE);
        } else if (fun == PrimitiveNode.Function.DIODE || fun == PrimitiveNode.Function.DIODEZ) {
            importantVars.add(Schematics.SCHEM_DIODE);
        } else if (pn.getGroupFunction() == PrimitiveNode.Function.TRANS) {
            importantVars.add(SPICE_MODEL_KEY);
            if (pn.getTechnology() instanceof Schematics) {
                importantVars.add(Schematics.ATTR_LENGTH);
                importantVars.add(Schematics.ATTR_WIDTH);
                importantVars.add(Schematics.ATTR_AREA);
            } else {
                importantVars.add(NodeInst.TRACE);
            }
            importantVars.add(SimulationTool.M_FACTOR_KEY);
        } else if (pn == Generic.tech().invisiblePinNode) {
            importantVars.add(SPICE_DECLARATION_KEY);
            importantVars.add(SPICE_CARD_KEY);
        }
        return importantVars;
    }

    private void emitEmbeddedSpice(Variable cardVar, VarContext context, SpiceSegmentedNets segNets, HierarchyEnumerator.CellInfo info, boolean flatNetNames, boolean forceEval) {
        Object obj = cardVar.getObject();
        if (!(obj instanceof String) && !(obj instanceof String[])) {
            return;
        }
        if (!cardVar.isDisplay()) {
            return;
        }
        if (obj instanceof String) {
            StringBuffer buf = this.replacePortsAndVars((String)obj, context.getNodable(), context.pop(), null, segNets, info, flatNetNames, forceEval);
            buf.append('\n');
            String msg = buf.toString();
            boolean isComment = false;
            if (msg.startsWith("*")) {
                isComment = true;
            }
            this.multiLinePrint(isComment, msg);
        } else {
            String[] strings = (String[])obj;
            for (int i = 0; i < strings.length; ++i) {
                StringBuffer buf = this.replacePortsAndVars(strings[i], context.getNodable(), context.pop(), null, segNets, info, flatNetNames, forceEval);
                buf.append('\n');
                String msg = buf.toString();
                boolean isComment = false;
                if (msg.startsWith("*")) {
                    isComment = true;
                }
                this.multiLinePrint(isComment, msg);
            }
        }
    }

    private Variable getEngineTemplate(Cell cell) {
        Variable varTemplate = this.getEngineTemplateJustThis(cell);
        if (varTemplate == null) {
            if (cell.isIcon()) {
                Cell schCell = cell.contentsView();
                if (schCell != null) {
                    varTemplate = this.getEngineTemplateJustThis(schCell);
                }
            } else {
                Cell iconCell = cell.iconView();
                if (iconCell != null) {
                    varTemplate = this.getEngineTemplateJustThis(iconCell);
                }
            }
        }
        return varTemplate;
    }

    private Variable getEngineTemplateJustThis(Cell cell) {
        Variable varTemplate = cell.getVar(this.preferedEngineTemplateKey);
        if (varTemplate == null && this.preferedEngineTemplateKey != SPICE_TEMPLATE_KEY) {
            varTemplate = cell.getVar(SPICE_TEMPLATE_KEY);
        }
        return varTemplate;
    }

    private Set<Variable.Key> getTemplateVars(Cell cell) {
        Variable varTemplate = this.getEngineTemplate(cell);
        if (varTemplate == null) {
            return null;
        }
        HashSet<Variable.Key> depends = new HashSet<Variable.Key>();
        this.findVarsInTemplate(varTemplate, cell, true, depends);
        return depends;
    }

    private void findVarsInTemplate(Variable varTemplate, NodeProto cell, boolean isPortReplacement, Set<Variable.Key> vars) {
        if (varTemplate == null) {
            return;
        }
        Object value2 = varTemplate.getObject();
        if (value2 instanceof Object[]) {
            for (Object o : (Object[])value2) {
                this.findVarsInLine(o.toString(), cell, isPortReplacement, vars);
            }
        } else {
            this.findVarsInLine(value2.toString(), cell, isPortReplacement, vars);
        }
    }

    private StringBuffer replacePortsAndVars(String line, Nodable no, VarContext context, Topology.CellNetInfo cni, SpiceSegmentedNets segNets, HierarchyEnumerator.CellInfo info, boolean flatNetNames, boolean forceEval) {
        StringBufferQuoteParity infstr = new StringBufferQuoteParity();
        NodeProto prototype = null;
        PrimitiveNode prim = null;
        if (no != null && (prototype = no.getProto()) instanceof PrimitiveNode) {
            prim = (PrimitiveNode)prototype;
        }
        for (int pt = 0; pt < line.length(); ++pt) {
            Variable.Key varKey;
            PrimitiveNodeSize npSize;
            NodeInst ni;
            Network net;
            int start;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = start = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(start, pt);
            PortProto pp = null;
            int ppIndex = -1;
            if (prototype != null) {
                if (prototype instanceof Cell) {
                    Cell subCell = (Cell)prototype;
                    Netlist nl = subCell.getNetlist();
                    Iterator<Export> it = subCell.getExports();
                    while (it.hasNext()) {
                        Export e = it.next();
                        int width = nl.getBusWidth(e);
                        for (int i = 0; i < width; ++i) {
                            net = nl.getNetwork(e, i);
                            Iterator<String> nIt = net.getNames();
                            while (nIt.hasNext()) {
                                String netName = nIt.next();
                                if (!netName.equals(paramName)) continue;
                                pp = e;
                                ppIndex = i;
                                break;
                            }
                            if (ppIndex >= 0) break;
                        }
                        if (ppIndex < 0) continue;
                        break;
                    }
                } else {
                    pp = prototype.findPortProto(paramName);
                }
            }
            if (paramName.equalsIgnoreCase("node_name") && no != null) {
                String nodeName = this.getSafeNetName(no.getName(), false);
                infstr.append(nodeName);
                continue;
            }
            if (paramName.equalsIgnoreCase("width") && prim != null) {
                ni = (NodeInst)no;
                npSize = ni.getPrimitiveDependentNodeSize(context);
                if (npSize == null) continue;
                infstr.append(npSize.getWidth().toString());
                continue;
            }
            if (paramName.equalsIgnoreCase("length") && prim != null) {
                ni = (NodeInst)no;
                npSize = ni.getPrimitiveDependentNodeSize(context);
                if (npSize == null) continue;
                infstr.append(npSize.getLength().toString());
                continue;
            }
            if (cni != null && pp != null) {
                if (ppIndex < 0) {
                    ppIndex = 0;
                }
                Network net2 = cni.getNetList().getNetwork(no, pp, ppIndex);
                Topology.CellSignal cs = cni.getCellSignal(net2);
                String portName = cs.getName();
                if (segNets != null) {
                    PortInst pi = no.getNodeInst().findPortInstFromEquivalentProto(pp);
                    portName = segNets.getNetName(pi);
                }
                if (flatNetNames) {
                    portName = info.getUniqueNetName(net2, ".");
                }
                infstr.append(portName);
                continue;
            }
            if (no != null && (varKey = Variable.findKey("ATTR_" + paramName)) != null) {
                Variable attrVar = null;
                if (varKey != null) {
                    attrVar = no.getParameterOrVariable(varKey);
                }
                if (attrVar == null) {
                    infstr.append("??");
                    continue;
                }
                String pVal = "?";
                Variable parentVar = attrVar;
                if (prototype != null && prototype instanceof Cell) {
                    parentVar = ((Cell)prototype).getParameterOrVariable(attrVar.getKey());
                }
                pVal = this.evalParam(context, no, attrVar, forceEval, true, infstr.inParens());
                if (infstr.inQuotes()) {
                    pVal = this.trimSingleQuotes(pVal);
                }
                infstr.append(pVal);
                continue;
            }
            boolean found = false;
            String hierName = null;
            String[] names = paramName.split("\\.");
            if (names.length > 1 && flatNetNames) {
                Netlist thisNetlist = info.getNetlist();
                VarContext thisContext = context;
                if (no != null) {
                    thisContext = thisContext.push(no);
                }
                for (int i = 0; i < names.length - 1; ++i) {
                    boolean foundno = false;
                    Iterator<Nodable> it = thisNetlist.getNodables();
                    while (it.hasNext()) {
                        Nodable subno = it.next();
                        if (!subno.getName().equals(names[i])) continue;
                        if (subno.getProto() instanceof Cell) {
                            thisNetlist = thisNetlist.getNetlist(subno);
                            thisContext = thisContext.push(subno);
                        }
                        foundno = true;
                    }
                    if (foundno) continue;
                    System.out.println("Unable to find " + names[i] + " in " + paramName);
                    break;
                }
                if ((net = this.findNet(thisNetlist, names[names.length - 1])) != null) {
                    HierarchyEnumerator.NetNameProxy proxy = new HierarchyEnumerator.NetNameProxy(thisContext, ".x", net);
                    Global g = this.getGlobal(proxy.getNet());
                    hierName = g != null ? g.getName() : proxy.toString();
                }
            } else {
                Network net3 = this.findNet(info.getNetlist(), paramName);
                if (net3 != null) {
                    HierarchyEnumerator.NetNameProxy proxy;
                    Global g;
                    hierName = flatNetNames ? ((g = this.getGlobal((proxy = info.getUniqueNetNameProxy(net3, ".x")).getNet())) != null ? g.getName() : proxy.toString()) : cni.getCellSignal(net3).getName();
                }
            }
            if (hierName != null) {
                if (flatNetNames) {
                    int i;
                    if (hierName.indexOf(".x") > 0) {
                        hierName = "x" + hierName;
                    }
                    if ((i = hierName.lastIndexOf(".x")) > 0) {
                        hierName = hierName.substring(0, i + 1) + hierName.substring(i + 2);
                    } else {
                        i = hierName.lastIndexOf("." + paramName);
                        if (i > 0) {
                            hierName = hierName.substring(0, i) + "_" + hierName.substring(i + 1);
                        }
                    }
                }
                infstr.append(hierName);
                found = true;
            }
            if (found) continue;
            System.out.println("Cannot find parameter $(" + paramName + ") in cell " + (prototype != null ? prototype.describe(false) : context.getInstPath(".")));
        }
        return infstr.getStringBuffer();
    }

    private void findVarsInLine(String line, NodeProto prototype, boolean isPortReplacement, Set<Variable.Key> vars) {
        PrimitiveNode prim = null;
        if (prototype != null && prototype instanceof PrimitiveNode) {
            prim = (PrimitiveNode)prototype;
        }
        for (int pt = 0; pt < line.length(); ++pt) {
            Variable.Key varKey;
            int start;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') continue;
            for (pt = start = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(start, pt);
            PortProto pp = null;
            if (prototype != null) {
                pp = prototype.findPortProto(paramName);
            }
            if (paramName.equalsIgnoreCase("node_name") && prototype != null || paramName.equalsIgnoreCase("width") && prim != null || paramName.equalsIgnoreCase("length") && prim != null || isPortReplacement && pp != null || prototype == null || (varKey = Variable.findKey("ATTR_" + paramName)) == null || !(prototype instanceof PrimitiveNode) && ((Cell)prototype).getParameterOrVariable(varKey) == null) continue;
            vars.add(varKey);
        }
    }

    private Network findNet(Netlist netlist, String netName) {
        Network foundnet = null;
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.hasName(netName)) continue;
            foundnet = net;
            break;
        }
        return foundnet;
    }

    private Global getGlobal(Network net) {
        Netlist netlist = net.getNetlist();
        for (int i = 0; i < netlist.getGlobals().size(); ++i) {
            Global g = netlist.getGlobals().get(i);
            if (netlist.getNetwork(g) != net) continue;
            return g;
        }
        return null;
    }

    @Override
    protected String getSafeCellName(String name) {
        return this.getSafeNetName(name, false);
    }

    @Override
    protected String getPowerName(Network net) {
        if (net != null) {
            Iterator<String> it = net.getNames();
            while (it.hasNext()) {
                String netName = it.next();
                if (!netName.equalsIgnoreCase("vdd")) continue;
                return "vdd";
            }
        }
        return null;
    }

    @Override
    protected String getGroundName(Network net) {
        if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_2 || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_P || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_G) {
            return "0";
        }
        if (net != null) {
            Iterator<String> it = net.getNames();
            while (it.hasNext()) {
                String netName = it.next();
                if (!netName.equalsIgnoreCase("gnd")) continue;
                return "gnd";
            }
        }
        return null;
    }

    @Override
    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    @Override
    protected boolean isNetworksUseExportedNames() {
        return false;
    }

    @Override
    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    @Override
    protected boolean isAggregateNamesSupported() {
        return false;
    }

    @Override
    protected boolean isAggregateNameGapsSupported() {
        return false;
    }

    @Override
    protected boolean isSeparateInputAndOutput() {
        return false;
    }

    @Override
    protected boolean isCaseSensitive() {
        return false;
    }

    @Override
    protected String getSafeNetName(String name, boolean bus) {
        return Spice.getSafeNetName(name, bus, this.legalSpiceChars, this.spiceEngine);
    }

    @Override
    protected void enterCell(HierarchyEnumerator.CellInfo info) {
        if (this.exemptedNets != null) {
            this.exemptedNets.setExemptedNets(info);
        }
    }

    @Override
    protected boolean isChooseBestExportName() {
        return false;
    }

    @Override
    protected boolean skipCellAndSubcells(Cell cell) {
        String str;
        Object obj;
        Variable varTemplate = null;
        varTemplate = this.getEngineTemplate(cell);
        if (varTemplate != null) {
            return true;
        }
        String fileName = null;
        String unfilteredFileName = this.localPrefs.modelFiles.get(cell);
        if (CellModelPrefs.isUseModelFromFile(unfilteredFileName)) {
            fileName = CellModelPrefs.getModelFile(unfilteredFileName);
        }
        if ((varTemplate = cell.getVar(SPICE_NETLIST_FILE_KEY)) != null && (obj = varTemplate.getObject()) instanceof String && !(str = (String)obj).equals("") && !str.equals("*Undefined")) {
            fileName = str;
        }
        if (fileName != null && !this.localPrefs.ignoreModelFiles || CellModelPrefs.isUseVerilogView(unfilteredFileName)) {
            if (!this.modelOverrides.containsKey(cell)) {
                String absFileName = fileName;
                boolean isVerilog = false;
                if (absFileName == null) {
                    Cell verilogCell = cell.otherView(View.VERILOG);
                    if (verilogCell == null) {
                        System.out.println("Verilog cell for " + cell.describe(false) + " requested but it does not exist");
                        return false;
                    }
                    File spiceFile = new File(this.filePath);
                    File verilogFile = new File(spiceFile.getParent(), cell.getName() + ".va");
                    fileName = absFileName = verilogFile.getPath();
                    try {
                        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        String[] lines2 = verilogCell.getTextViewContents();
                        for (int i = 0; i < lines2.length; ++i) {
                            printWriter.println(lines2[i]);
                        }
                        printWriter.close();
                    }
                    catch (IOException e) {
                        System.out.println("Error writing Verilog file");
                    }
                    isVerilog = true;
                } else if (!fileName.startsWith("/") && !fileName.startsWith("\\")) {
                    File spiceFile = new File(this.filePath);
                    absFileName = new File(spiceFile.getParent(), fileName).getPath();
                }
                boolean alreadyIncluded = false;
                for (String includeFile : this.modelOverrides.values()) {
                    if (!absFileName.equals(includeFile)) continue;
                    alreadyIncluded = true;
                }
                if (alreadyIncluded) {
                    this.multiLinePrint(true, "\n* " + cell + " is described in this file:\n");
                    this.multiLinePrint(true, "* " + fileName + " (already included) \n");
                } else {
                    this.multiLinePrint(true, "\n* " + cell + " is described in this file:\n");
                    this.addIncludeFile(fileName, isVerilog);
                }
                this.modelOverrides.put(cell, absFileName);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isWriteCopyForEachIcon() {
        return false;
    }

    @Override
    protected void validateSkippedCell(HierarchyEnumerator.CellInfo info) {
        String fileName = this.modelOverrides.get(info.getCell());
        if (fileName != null && !fileName.endsWith(".va")) {
            SpiceNetlistReader reader = new SpiceNetlistReader();
            try {
                reader.readFile(fileName, false);
                HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
                Nodable no = info.getParentInst();
                String parameterizedName = info.getCell().getName();
                if (no != null && parentInfo != null) {
                    parameterizedName = this.parameterizedName(no, parentInfo.getContext());
                }
                Topology.CellNetInfo cni = this.getCellNetInfo(parameterizedName);
                SpiceSubckt subckt = reader.getSubckt(parameterizedName);
                if (cni != null && subckt != null) {
                    if (subckt == null) {
                        this.reportError("Error: No subckt for " + parameterizedName + " found in included file: " + fileName);
                    } else {
                        ArrayList<String> signals = new ArrayList<String>();
                        Iterator<Topology.CellSignal> sIt = cni.getCellSignals();
                        while (sIt.hasNext()) {
                            Topology.CellSignal cs = sIt.next();
                            if (this.ignoreSubcktPort(cs)) continue;
                            signals.add(cs.getName());
                        }
                        List<String> subcktSignals = subckt.getPorts();
                        if (signals.size() != subcktSignals.size()) {
                            this.reportWarning("Warning: wrong number of ports for subckt " + parameterizedName + ": expected " + signals.size() + ", but found " + subcktSignals.size() + ", in included file " + fileName);
                        }
                        int len = Math.min(signals.size(), subcktSignals.size());
                        for (int i = 0; i < len; ++i) {
                            String s2;
                            String s1 = (String)signals.get(i);
                            if (s1.equalsIgnoreCase(s2 = subcktSignals.get(i))) continue;
                            this.reportWarning("Warning: port " + i + " of subckt " + parameterizedName + " is named " + s1 + " in Electric, but " + s2 + " in included file " + fileName);
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                this.reportError("Error validating included file for cell " + info.getCell().describe(true) + ": " + e.getMessage());
            }
        }
    }

    @Override
    protected Netlist.ShortResistors getShortResistors() {
        if (this.useCDL && this.localPrefs.cdlIgnoreResistors) {
            return Netlist.ShortResistors.PARASITIC;
        }
        if (this.localPrefs.ignoreParasiticResistors) {
            return Netlist.ShortResistors.PARASITIC;
        }
        return Netlist.ShortResistors.NO;
    }

    @Override
    protected boolean canParameterizeNames() {
        return true;
    }

    @Override
    protected int maxNameLength() {
        if (this.useCDL) {
            return 40;
        }
        return 70;
    }

    @Override
    protected boolean enumerateLayoutView(Cell cell) {
        return CellModelPrefs.isUseLayoutView(this.localPrefs.modelFiles.get(cell));
    }

    private Netlist.ShortResistors getShortResistorsFlat() {
        return Netlist.ShortResistors.ALL;
    }

    private void writeMFactor(VarContext context, Nodable no, StringBuffer infstr) {
        Variable mVar = no.getVar(SimulationTool.M_FACTOR_KEY);
        if (mVar == null) {
            return;
        }
        Object value2 = context.evalVar(mVar);
        if (mVar.getObject().toString().equals("@M") || mVar.getObject().toString().equals("P(\"M\")")) {
            this.reportWarning("Warning: M=@M [eval=" + value2 + "] on " + no.getName() + " is a bad idea, not writing it out: " + context.push(no).getInstPath("."));
            return;
        }
        infstr.append(" M=" + this.formatParam(value2.toString(), AbstractTextDescriptor.Unit.NONE, false));
    }

    private void writeHeader(Cell cell) {
        String headerFile;
        boolean useParasitics;
        this.multiLinePrint(true, "*** SPICE deck for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName() + "\n");
        this.emitCopyright("*** ", "");
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.multiLinePrint(true, "*** Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + "\n");
            this.multiLinePrint(true, "*** Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + "\n");
            this.multiLinePrint(true, "*** Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + "\n");
        } else {
            this.multiLinePrint(true, "*** Written by Electric VLSI Design System\n");
        }
        String foundry = this.layoutTechnology.getSelectedFoundry() == null ? "" : ", foundry " + this.layoutTechnology.getSelectedFoundry().toString();
        this.multiLinePrint(true, "*** Layout tech: " + this.layoutTechnology.getTechName() + foundry + "\n");
        this.multiLinePrint(true, "*** UC SPICE *** , MIN_RESIST " + this.layoutTechnology.getMinResistance() + ", MIN_CAPAC " + this.layoutTechnology.getMinCapacitance() + "FF\n");
        boolean bl = useParasitics = !this.useCDL && this.localPrefs.parasiticsLevel != SimulationTool.SpiceParasitics.SIMPLE && cell.getView() == View.LAYOUT;
        if (useParasitics) {
            for (Layer layer : this.layoutTechnology.getLayersSortedByHeight()) {
                if (layer.isPseudoLayer()) continue;
                double edgecap = layer.getEdgeCapacitance();
                double areacap = layer.getCapacitance();
                double res = layer.getResistance();
                if (edgecap == 0.0 && areacap == 0.0 && res == 0.0) continue;
                this.multiLinePrint(true, "***    " + layer.getName() + ":\tareacap=" + areacap + "FF/um^2,\tedgecap=" + edgecap + "FF/um,\tres=" + res + "ohms/sq\n");
            }
        }
        if (this.localPrefs.useCellParameters) {
            this.multiLinePrint(false, ".options parhier=local\n");
        }
        if (this.localPrefs.writeTransSizeInLambda) {
            double scale = this.layoutTechnology.getScale();
            this.multiLinePrint(true, "*** Lambda Conversion ***\n");
            this.multiLinePrint(false, ".opt scale=" + TextUtils.formatDouble(scale / 1000.0) + "U\n\n");
        }
        if ((headerFile = this.localPrefs.headerCardInfo).length() > 0 && !headerFile.startsWith(SPICE_NOEXTENSION_PREFIX)) {
            if (headerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String headerPath = TextUtils.getFilePath(TextUtils.makeURLToFile(this.filePath));
                String ext = headerFile.substring(SPICE_EXTENSION_PREFIX.length());
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                String filePart = cell.getName() + "." + ext;
                String fileName = headerPath + filePart;
                File test2 = new File(fileName);
                if (test2.exists()) {
                    this.multiLinePrint(true, "* Model cards are described in this file:\n");
                    this.addIncludeFile(filePart, false);
                    System.out.println("Spice Header Card '" + fileName + "' is included");
                    return;
                }
                this.reportWarning("Spice Header Card '" + fileName + "' cannot be loaded");
            } else {
                File test3 = new File(headerFile);
                if (!test3.exists()) {
                    this.reportWarning("Warning: cannot find model file '" + headerFile + "'");
                }
                this.multiLinePrint(true, "* Model cards are described in this file:\n");
                this.addIncludeFile(headerFile, false);
                return;
            }
        }
        int level = TextUtils.atoi(this.localPrefs.level);
        String[] header = null;
        switch (level) {
            case 1: {
                header = this.layoutTechnology.getSpiceHeaderLevel1();
                break;
            }
            case 2: {
                header = this.layoutTechnology.getSpiceHeaderLevel2();
                break;
            }
            case 3: {
                header = this.layoutTechnology.getSpiceHeaderLevel3();
            }
        }
        if (header != null) {
            for (int i = 0; i < header.length; ++i) {
                this.multiLinePrint(false, header[i] + "\n");
            }
            return;
        }
    }

    private void writeTrailer(Cell cell) {
        String trailerFile = this.localPrefs.trailerCardInfo;
        if (trailerFile.length() > 0 && !trailerFile.startsWith(SPICE_NOEXTENSION_PREFIX)) {
            if (trailerFile.startsWith(SPICE_EXTENSION_PREFIX)) {
                String trailerpath = TextUtils.getFilePath(TextUtils.makeURLToFile(this.filePath));
                String ext = trailerFile.substring(SPICE_EXTENSION_PREFIX.length());
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                String filePart = cell.getName() + "." + ext;
                String fileName = trailerpath + filePart;
                File test2 = new File(fileName);
                if (test2.exists()) {
                    this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                    this.addIncludeFile(filePart, false);
                    System.out.println("Spice Trailer Card '" + fileName + "' is included");
                } else {
                    this.reportWarning("Spice Trailer Card '" + fileName + "' cannot be loaded");
                }
            } else {
                this.multiLinePrint(true, "* Trailer cards are described in this file:\n");
                this.addIncludeFile(trailerFile, false);
                System.out.println("Spice Trailer Card '" + trailerFile + "' is included");
            }
        }
    }

    private void writeTwoPort(NodeInst ni, String partName, String extra, Topology.CellNetInfo cni, Netlist netList, VarContext context, SpiceSegmentedNets segmentedNets) {
        String message;
        PortInst port0 = ni.getPortInst(0);
        PortInst port1 = ni.getPortInst(1);
        Network net0 = netList.getNetwork(port0);
        Network net1 = netList.getNetwork(port1);
        Topology.CellSignal cs0 = cni.getCellSignal(net0);
        Topology.CellSignal cs1 = cni.getCellSignal(net1);
        if (cs0 == null || cs1 == null) {
            message = "WARNING: " + ni + " component not fully connected in " + ni.getParent();
            this.dumpMessage(message, false);
        }
        if (cs0 != null && cs1 != null && cs0 == cs1) {
            message = "WARNING: " + ni + " component appears to be shorted on net " + net0.toString() + " in " + ni.getParent();
            this.dumpMessage(message, false);
            return;
        }
        if (ni.getName() != null) {
            partName = partName + this.getSafeNetName(ni.getName(), false);
        }
        StringBuffer sbExtra = new StringBuffer(extra);
        this.writeMFactor(context, ni, sbExtra);
        String name0 = cs0.getName();
        String name1 = cs1.getName();
        if (segmentedNets != null) {
            name0 = segmentedNets.getNetName(port0);
            name1 = segmentedNets.getNetName(port1);
        }
        this.multiLinePrint(false, partName + " " + name1 + " " + name0 + " " + sbExtra.toString() + "\n");
    }

    private void addNodeInformation(Netlist netList, Map<Network, SpiceNet> spiceNets, NodeInst ni) {
        if (ni.isCellInstance()) {
            return;
        }
        PrimitiveNode.Function function = ni.getFunction();
        Technology tech = ni.getProto().getTechnology();
        FixpTransform trans = ni.rotateOut();
        for (Poly poly : tech.getShapeOfNode(ni, true, true, null)) {
            Network net;
            SpiceNet spNet;
            Layer layer;
            PortProto pp = poly.getPort();
            if (pp == null || poly.isPseudoLayer() || (layer = poly.getLayer()).getTechnology() != this.curTech || !layer.isDiffusionLayer() && layer.getCapacitance() == 0.0 || layer.getFunction() == Layer.Function.GATE || (spNet = spiceNets.get(net = netList.getNetwork(ni, pp, 0))) == null) continue;
            poly.transform(trans);
            spNet.merge.addPolygon(layer, poly);
            if (!layer.isDiffusionLayer() || !function.isTransistor()) continue;
            ++spNet.transistorCount;
        }
    }

    private void addArcInformation(PolyMerge merge, ArcInst ai) {
        boolean isDiffArc = ai.isDiffusionArc();
        if (!isDiffArc) {
            return;
        }
        Technology tech = ai.getProto().getTechnology();
        for (Poly poly : tech.getShapeOfArc(ai)) {
            Layer layer;
            if (poly.getStyle().isText() || poly.isPseudoLayer() || (layer = poly.getLayer()).getTechnology() != this.curTech || !layer.isDiffusionLayer() && (isDiffArc || !(layer.getCapacitance() > 0.0))) continue;
            merge.addPolygon(layer, poly);
        }
    }

    private boolean ignoreSubcktPort(Topology.CellSignal cs) {
        Export pp;
        return this.localPrefs.globalTreatment != SimulationTool.SpiceGlobal.USESUBCKTPORTS && (pp = cs.getExport()) == null;
    }

    private boolean markCellsToUniquify(Cell cell) {
        boolean isUnique;
        if (this.uniquifyCells.containsKey(cell)) {
            return this.uniquifyCells.get(cell) != null;
        }
        boolean mark = false;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isIconOfParent()) continue;
            Set<Variable.Key> varkeys = this.detectSpiceParams(ni.getProto());
            for (Variable.Key key : varkeys) {
                Variable var = ni.getVar(key);
                if (var == null || this.isNetlistableParam(ni, var)) continue;
                mark = true;
            }
            if (!ni.isCellInstance()) continue;
            Cell proto = ((Cell)ni.getProto()).contentsView();
            if (proto == null) {
                proto = (Cell)ni.getProto();
            }
            if (this.getEngineTemplate(proto) != null || !this.markCellsToUniquify(proto)) continue;
            mark = true;
        }
        boolean bl = isUnique = this.detectSpiceParams(cell) == UNIQUIFY_MARK;
        assert (mark == isUnique);
        if (mark) {
            this.uniquifyCells.put(cell, cell);
        } else {
            this.uniquifyCells.put(cell, null);
        }
        return mark;
    }

    public boolean cellIsEmpty(Cell cell) {
        boolean useParasitics;
        Boolean b = this.checkedCells.get(cell);
        if (b != null) {
            return b;
        }
        boolean empty = true;
        boolean bl = useParasitics = !this.useCDL && this.localPrefs.parasiticsLevel != SimulationTool.SpiceParasitics.SIMPLE && cell.getView() == View.LAYOUT;
        if (useParasitics) {
            return false;
        }
        ArrayList emptyCells = new ArrayList();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance()) {
                if (ni.isIconOfParent()) continue;
                Cell iconCell = (Cell)ni.getProto();
                Cell schCell = iconCell.contentsView();
                if (schCell == null) {
                    schCell = iconCell;
                }
                if (this.cellIsEmpty(schCell)) continue;
                empty = false;
                break;
            }
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun.isResistor() || fun == PrimitiveNode.Function.INDUCT || fun.isCapacitor() || fun == PrimitiveNode.Function.DIODE || fun == PrimitiveNode.Function.DIODEZ) {
                empty = false;
                break;
            }
            if (((PrimitiveNode)ni.getProto()).getGroupFunction() == PrimitiveNode.Function.TRANS) {
                empty = false;
                break;
            }
            if (ni.getVar(SPICE_CARD_KEY) == null) continue;
            empty = false;
            break;
        }
        if (this.modelOverrides.get(cell) != null) {
            empty = false;
        }
        if (this.getEngineTemplate(cell) != null) {
            empty = false;
        }
        this.checkedCells.put(cell, empty);
        return empty;
    }

    public static String getSafeNetName(String name, SimulationTool.SpiceEngine engine) {
        String legalSpiceChars = SPICELEGALCHARS;
        if (engine == SimulationTool.SpiceEngine.SPICE_ENGINE_P) {
            legalSpiceChars = PSPICELEGALCHARS;
        }
        return Spice.getSafeNetName(name, false, legalSpiceChars, engine);
    }

    private static String getSafeNetName(String name, boolean bus, String legalSpiceChars, SimulationTool.SpiceEngine spiceEngine) {
        boolean allAlNum = true;
        int len = name.length();
        if (len <= 0) {
            return name;
        }
        for (int i = 0; i < len; ++i) {
            boolean valid = TextUtils.isLetterOrDigit(name.charAt(i));
            if (i == 0) {
                valid = Character.isLetter(name.charAt(i));
            }
            if (valid) continue;
            allAlNum = false;
            break;
        }
        if (allAlNum) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(name.charAt(0)) && spiceEngine != SimulationTool.SpiceEngine.SPICE_ENGINE_G && spiceEngine != SimulationTool.SpiceEngine.SPICE_ENGINE_P && spiceEngine != SimulationTool.SpiceEngine.SPICE_ENGINE_2) {
            sb.append('_');
        }
        for (int t = 0; t < name.length(); ++t) {
            char chr = name.charAt(t);
            boolean legalChar = TextUtils.isLetterOrDigit(chr);
            if (!legalChar) {
                for (int j = 0; j < legalSpiceChars.length(); ++j) {
                    char legalChr = legalSpiceChars.charAt(j);
                    if (chr != legalChr) continue;
                    legalChar = true;
                    break;
                }
            }
            if (!legalChar) {
                chr = '_';
            }
            sb.append(chr);
        }
        return sb.toString();
    }

    private String formatParam(String param2, AbstractTextDescriptor.Unit u, boolean wrapped) {
        String value2 = this.trimSingleQuotes(param2);
        if (TextUtils.isANumberPostFix(value2)) {
            return value2;
        }
        try {
            Double v = Double.valueOf(value2);
            if (u == AbstractTextDescriptor.Unit.DISTANCE) {
                return TextUtils.formatDoublePostFix(v);
            }
            return value2;
        }
        catch (NumberFormatException e) {
            if (!wrapped) {
                if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_2 || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_3) {
                    return value2;
                }
                value2 = this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_O ? "{" + value2 + "}" : "'" + value2 + "'";
            }
            return value2;
        }
    }

    private String trimSingleQuotes(String param2) {
        if (param2.startsWith("'") && param2.endsWith("'")) {
            return param2.substring(1, param2.length() - 1);
        }
        return param2;
    }

    private void addIncludeFile(String fileName, boolean verilog) {
        if (verilog) {
            this.multiLinePrint(false, ".hdl " + fileName + "\n");
            return;
        }
        if (this.useCDL) {
            this.multiLinePrint(false, ".include " + fileName + "\n");
            return;
        }
        if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_2 || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_3 || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_G || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_S) {
            this.multiLinePrint(false, ".include " + fileName + "\n");
        } else if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_H || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_H_ASSURA || this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_H_CALIBRE) {
            this.multiLinePrint(false, ".include '" + fileName + "'\n");
        } else if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_P) {
            this.multiLinePrint(false, ".INC " + fileName + "\n");
        }
    }

    private void dumpMessage(String message, boolean isErrorMsg) {
        this.multiLinePrint(true, "*** " + message + "\n");
        if (isErrorMsg) {
            this.reportError(message);
        } else {
            this.reportWarning(message);
        }
    }

    public void multiLinePrint(boolean isComment, String str) {
        if (this.spiceEngine == SimulationTool.SpiceEngine.SPICE_ENGINE_O) {
            str = str.replaceAll("@", "_");
        }
        char contChar = '+';
        if (isComment) {
            contChar = '*';
        }
        int lastSpace = -1;
        int count2 = 0;
        boolean insideQuotes = false;
        int lineStart = 0;
        for (int pt = 0; pt < str.length(); ++pt) {
            char chr = str.charAt(pt);
            if (chr == '\n') {
                this.printWriter.print(str.substring(lineStart, pt + 1));
                count2 = 0;
                lastSpace = -1;
                lineStart = pt + 1;
                continue;
            }
            if (chr == ' ' && !insideQuotes) {
                lastSpace = pt;
            }
            if (chr == '\'') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (++count2 < this.spiceMaxLenLine || insideQuotes || lastSpace <= -1) continue;
            String partial = str.substring(lineStart, lastSpace + 1);
            this.printWriter.print(partial + "\n" + contChar);
            count2 -= partial.length();
            lineStart = lastSpace + 1;
            lastSpace = -1;
        }
        if (lineStart < str.length()) {
            String partial = str.substring(lineStart);
            this.printWriter.print(partial);
        }
    }

    public static class FlatSpiceCodeVisitor
    extends HierarchyEnumerator.Visitor {
        private PrintWriter printWriter;
        private PrintWriter spicePrintWriter;
        private String filePath;
        Spice spice;
        SpiceSegmentedNets segNets;

        public FlatSpiceCodeVisitor(String filePath, Spice spice) {
            this.spice = spice;
            this.spicePrintWriter = spice.printWriter;
            this.filePath = filePath;
            spice.spiceMaxLenLine = 1000;
            this.segNets = null;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                Variable cardVar;
                NodeInst ni = it.next();
                if (ni.getProto() != Generic.tech().invisiblePinNode || (cardVar = ni.getVar(SPICE_CODE_FLAT_KEY)) == null) continue;
                if (this.printWriter == null) {
                    try {
                        this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.filePath)));
                    }
                    catch (IOException e) {
                        this.spice.reportWarning("Unable to open " + this.filePath + " for write.");
                        return;
                    }
                    this.spice.printWriter = this.printWriter;
                    this.segNets = new SpiceSegmentedNets(null, false, null, this.spice.localPrefs);
                }
                this.spice.emitEmbeddedSpice(cardVar, info.getContext(), this.segNets, info, true, true);
            }
        }

        @Override
        public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void close() {
            if (this.printWriter != null) {
                System.out.println(this.filePath + " written");
                this.spice.printWriter = this.spicePrintWriter;
                this.printWriter.close();
            }
            this.spice.spiceMaxLenLine = 78;
        }
    }

    private static class SpiceFinishedListener
    implements Exec.FinishedListener {
        private SpiceFinishedListener() {
        }

        @Override
        public void processFinished(Exec.FinishedEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UserInterface ui = Job.getUserInterface();
                    Cell cell = ui.needCurrentCell();
                    if (cell == null) {
                        return;
                    }
                    SimulationData.plotGuessed(cell, null);
                }
            });
        }
    }

    private static class SpiceNet {
        PolyMerge merge = new PolyMerge();
        double diffArea = 0.0;
        double diffPerim = 0.0;
        float nonDiffCapacitance = 0.0f;
        int transistorCount = 0;

        SpiceNet() {
        }
    }

    private static class StringBufferQuoteParity {
        private StringBuffer sb = new StringBuffer();
        private int quoteCount;
        private int parenDepth;

        private StringBufferQuoteParity() {
        }

        void append(String str) {
            this.sb.append(str);
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch == '\'') {
                    ++this.quoteCount;
                    continue;
                }
                if (ch == '(') {
                    ++this.parenDepth;
                    continue;
                }
                if (ch != ')') continue;
                --this.parenDepth;
            }
        }

        void append(char c) {
            this.sb.append(c);
            if (c == '\'') {
                ++this.quoteCount;
            } else if (c == '(') {
                ++this.parenDepth;
            } else if (c == ')') {
                --this.parenDepth;
            }
        }

        boolean inQuotes() {
            return (this.quoteCount & 1) != 0;
        }

        boolean inParens() {
            return this.parenDepth > 0;
        }

        StringBuffer getStringBuffer() {
            return this.sb;
        }
    }

    public static class SpicePreferences
    extends Output.OutputPreferences {
        public boolean cdl;
        public SimulationTool.SpiceEngine engine = SimulationTool.getFactorySpiceEngine();
        public String level = SimulationTool.getFactorySpiceLevel();
        public int shortResistors = SimulationTool.getFactorySpiceShortResistors();
        public String runChoice = SimulationTool.getFactorySpiceRunChoice();
        public String runDir = SimulationTool.getFactorySpiceRunDir();
        public boolean useRunDir = SimulationTool.getFactorySpiceUseRunDir();
        public boolean outputOverwrite = SimulationTool.getFactorySpiceOutputOverwrite();
        public boolean runProbe = SimulationTool.getFactorySpiceRunProbe();
        public String runProgram = SimulationTool.getFactorySpiceRunProgram();
        public String runProgramArgs = SimulationTool.getFactorySpiceRunProgramArgs();
        public String partsLibrary = SimulationTool.getFactorySpicePartsLibrary();
        public String headerCardInfo = SimulationTool.getFactorySpiceHeaderCardInfo();
        public String trailerCardInfo = SimulationTool.getFactorySpiceTrailerCardInfo();
        public SimulationTool.SpiceParasitics parasiticsLevel = SimulationTool.getFactorySpiceParasiticsLevel();
        public boolean parasiticsUseVerboseNaming = SimulationTool.isFactoryParasiticsUseVerboseNaming();
        public boolean parasiticsBackAnnotateLayout = SimulationTool.isFactoryParasiticsBackAnnotateLayout();
        public boolean parasiticsExtractPowerGround = SimulationTool.isFactoryParasiticsExtractPowerGround();
        public boolean parasiticsUseExemptedNetsFile = SimulationTool.isFactoryParasiticsUseExemptedNetsFile();
        public boolean parasiticsIgnoreExemptedNets = SimulationTool.isFactoryParasiticsIgnoreExemptedNets();
        public boolean parasiticsExtractsR = SimulationTool.isFactoryParasiticsExtractsR();
        public boolean parasiticsExtractsC = SimulationTool.isFactoryParasiticsExtractsC();
        public SimulationTool.SpiceGlobal globalTreatment = SimulationTool.getFactorySpiceGlobalTreatment();
        public boolean writePwrGndInTopCell = SimulationTool.isFactorySpiceWritePwrGndInTopCell();
        public boolean useCellParameters = SimulationTool.isFactorySpiceUseCellParameters();
        public boolean writeTransSizeInLambda = SimulationTool.isFactorySpiceWriteTransSizeInLambda();
        public boolean writeSubcktTopCell = SimulationTool.isFactorySpiceWriteSubcktTopCell();
        public boolean writeTopCellInstance = true;
        public boolean writeEmptySubckts = true;
        public boolean writeFinalDotEnd = true;
        public boolean ignoreParasiticResistors = false;
        public String extractedNetDelimiter = SimulationTool.getFactorySpiceExtractedNetDelimiter();
        public boolean ignoreModelFiles = SimulationTool.isFactorySpiceIgnoreModelFiles();
        public String cdlLibName = SimulationTool.getFactoryCDLLibName();
        public String cdlLibPath = SimulationTool.getFactoryCDLLibPath();
        public boolean cdlConvertBrackets = SimulationTool.isFactoryCDLConvertBrackets();
        public String cdlIncludeFile = SimulationTool.getFactoryCDLIncludeFile();
        public boolean cdlIgnoreResistors = false;
        public Map<Cell, String> modelFiles = Collections.emptyMap();
        public String workdir = "";

        public SpicePreferences() {
            this(false, false);
        }

        public SpicePreferences(boolean factory, boolean cdl) {
            super(factory);
            this.cdl = cdl;
            if (!factory) {
                this.fillPrefs();
            }
        }

        private void fillPrefs() {
            this.engine = SimulationTool.getSpiceEngine();
            this.level = SimulationTool.getSpiceLevel();
            this.shortResistors = SimulationTool.getSpiceShortResistors();
            this.runChoice = SimulationTool.getSpiceRunChoice();
            this.runDir = SimulationTool.getSpiceRunDir();
            this.useRunDir = SimulationTool.getSpiceUseRunDir();
            this.outputOverwrite = SimulationTool.getSpiceOutputOverwrite();
            this.runProbe = SimulationTool.getSpiceRunProbe();
            this.runProgram = SimulationTool.getSpiceRunProgram();
            this.runProgramArgs = SimulationTool.getSpiceRunProgramArgs();
            this.partsLibrary = SimulationTool.getSpicePartsLibrary();
            this.headerCardInfo = SimulationTool.getSpiceHeaderCardInfo();
            this.trailerCardInfo = SimulationTool.getSpiceTrailerCardInfo();
            this.parasiticsLevel = SimulationTool.getSpiceParasiticsLevel();
            this.parasiticsUseVerboseNaming = SimulationTool.isParasiticsUseVerboseNaming();
            this.parasiticsBackAnnotateLayout = SimulationTool.isParasiticsBackAnnotateLayout();
            this.parasiticsExtractPowerGround = SimulationTool.isParasiticsExtractPowerGround();
            this.parasiticsUseExemptedNetsFile = SimulationTool.isParasiticsUseExemptedNetsFile();
            this.parasiticsIgnoreExemptedNets = SimulationTool.isParasiticsIgnoreExemptedNets();
            this.parasiticsExtractsR = SimulationTool.isParasiticsExtractsR();
            this.parasiticsExtractsC = SimulationTool.isParasiticsExtractsC();
            this.globalTreatment = SimulationTool.getSpiceGlobalTreatment();
            this.writePwrGndInTopCell = SimulationTool.isSpiceWritePwrGndInTopCell();
            this.useCellParameters = SimulationTool.isSpiceUseCellParameters();
            this.writeTransSizeInLambda = SimulationTool.isSpiceWriteTransSizeInLambda();
            this.writeSubcktTopCell = SimulationTool.isSpiceWriteSubcktTopCell();
            this.writeTopCellInstance = SimulationTool.isSpiceWriteTopCellInstance();
            this.writeEmptySubckts = SimulationTool.isSpiceWriteEmptySubckts();
            this.writeFinalDotEnd = SimulationTool.isSpiceWriteFinalDotEnd();
            this.ignoreParasiticResistors = SimulationTool.isSpiceIgnoreParasiticResistors();
            this.extractedNetDelimiter = SimulationTool.getSpiceExtractedNetDelimiter();
            this.ignoreModelFiles = SimulationTool.isSpiceIgnoreModelFiles();
            this.cdlLibName = SimulationTool.getCDLLibName();
            this.cdlLibPath = SimulationTool.getCDLLibPath();
            this.cdlConvertBrackets = SimulationTool.isCDLConvertBrackets();
            this.cdlIncludeFile = SimulationTool.getCDLIncludeFile();
            this.cdlIgnoreResistors = SimulationTool.isCDLConvertBrackets();
            this.modelFiles = CellModelPrefs.spiceModelPrefs.getUnfilteredFileNames(EDatabase.clientDatabase());
            this.workdir = User.getWorkingDirectory();
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            String runSpice;
            Spice out = new Spice(this);
            out.useCDL = this.cdl;
            out.spiceEngine = this.engine;
            out.curTech = cell.getTechnology();
            if (out.openTextOutputStream(filePath)) {
                return out.finishWrite();
            }
            if (out.writeCell(cell, context)) {
                return out.finishWrite();
            }
            if (out.closeTextOutputStream()) {
                return out.finishWrite();
            }
            System.out.println(filePath + " written");
            if (out.useCDL) {
                String templateFile;
                String deckFile = filePath;
                String deckPath = "";
                int lastDirSep = deckFile.lastIndexOf(File.separatorChar);
                if (lastDirSep > 0) {
                    deckPath = deckFile.substring(0, lastDirSep);
                    deckFile = deckFile.substring(lastDirSep + 1);
                }
                if (out.openTextOutputStream(templateFile = deckPath + File.separator + cell.getName() + ".cdltemplate")) {
                    return out.finishWrite();
                }
                String libName = this.cdlLibName;
                String libPath = this.cdlLibPath;
                out.printWriter.print("cdlInKeys = list(nil\n");
                out.printWriter.print("    'searchPath             \"" + deckFile + "");
                if (libPath.length() > 0) {
                    out.printWriter.print("\n                             " + libPath);
                }
                out.printWriter.print("\"\n");
                out.printWriter.print("    'cdlFile                \"" + deckPath + File.separator + deckFile + "\"\n");
                out.printWriter.print("    'userSkillFile          \"\"\n");
                out.printWriter.print("    'opusLib                \"" + libName + "\"\n");
                out.printWriter.print("    'primaryCell            \"" + cell.getName() + "\"\n");
                out.printWriter.print("    'caseSensitivity        \"lower\"\n");
                out.printWriter.print("    'hierarchy              \"flatten\"\n");
                out.printWriter.print("    'cellTable              \"\"\n");
                out.printWriter.print("    'viewName               \"netlist\"\n");
                out.printWriter.print("    'viewType               \"\"\n");
                out.printWriter.print("    'pr                     nil\n");
                out.printWriter.print("    'skipDevice             nil\n");
                out.printWriter.print("    'schemaLib              \"sample\"\n");
                out.printWriter.print("    'refLib                 \"\"\n");
                out.printWriter.print("    'globalNodeExpand       \"full\"\n");
                out.printWriter.print(")\n");
                if (out.closeTextOutputStream()) {
                    return out.finishWrite();
                }
                System.out.println(templateFile + " written");
            }
            if (!(runSpice = this.runChoice).equals("Don't Run")) {
                String workdir;
                String command = this.runProgram + " " + this.runProgramArgs;
                String rundir = workdir = User.getWorkingDirectory();
                if (this.useRunDir) {
                    rundir = this.runDir;
                }
                File dir = new File(rundir);
                int start = filePath.lastIndexOf(File.separator);
                if (start == -1) {
                    start = 0;
                } else if (++start > filePath.length()) {
                    start = filePath.length();
                }
                int end = filePath.lastIndexOf(".");
                if (end == -1) {
                    end = filePath.length();
                }
                String filename_noext = filePath.substring(start, end);
                String filename = filePath.substring(start, filePath.length());
                command = command.replaceAll("\\$\\{WORKING_DIR}", Matcher.quoteReplacement(workdir));
                command = command.replaceAll("\\$\\{USE_DIR}", Matcher.quoteReplacement(rundir));
                command = command.replaceAll("\\$\\{FILEPATH}", Matcher.quoteReplacement(filePath));
                command = command.replaceAll("\\$\\{FILENAME}", Matcher.quoteReplacement(filename));
                command = command.replaceAll("\\$\\{FILENAME_NO_EXT}", Matcher.quoteReplacement(filename_noext));
                SpiceFinishedListener l = new SpiceFinishedListener();
                if (runSpice.equals("Run, Ignore Output")) {
                    Exec e = new Exec(command, null, dir, null, null);
                    if (this.runProbe) {
                        e.addFinishedListener(l);
                    }
                    e.start();
                }
                if (runSpice.equals("Run, Report Output")) {
                    ExecDialog dialog = new ExecDialog((Frame)TopLevel.getCurrentJFrame(), false);
                    if (this.runProbe) {
                        dialog.addFinishedListener(l);
                    }
                    dialog.startProcess(command, null, dir);
                }
                System.out.println("Running spice command: " + command);
            }
            if (this.parasiticsBackAnnotateLayout && out.parasiticInfo != null) {
                out.parasiticInfo.backAnnotate();
            }
            return out.finishWrite();
        }
    }
}

