/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class FCQueue<T>
extends IStructure<T> {
    final int MAX_THREADS = 512;
    AtomicInteger fc_lock;
    T[] combined_pushed_items;
    volatile int current_timestamp = 0;
    private ThreadLocal<CombiningNode<T>> combining_node = new ThreadLocal<CombiningNode<T>>(){

        @Override
        protected CombiningNode<T> initialValue() {
            return new CombiningNode();
        }
    };
    volatile CombiningNode<T> comb_list_head;
    private static final AtomicReferenceFieldUpdater<FCQueue, CombiningNode> comb_list_head_updater = AtomicReferenceFieldUpdater.newUpdater(FCQueue.class, CombiningNode.class, "comb_list_head");
    volatile QueueFatNode<T> queue_head;
    volatile QueueFatNode<T> queue_tail;
    final int COMBINING_NODE_TIMEOUT = 10000;
    final int COMBINING_NODE_TIMEOUT_CHECK_FREQUENCY = 100;
    final int MAX_COMBINING_ROUNDS = 32;
    final int NUM_ROUNDS_IS_LINKED_CHECK_FREQUENCY = 100;

    public FCQueue() {
        this.combined_pushed_items = new Object[512];
        this.fc_lock = new AtomicInteger(0);
        this.queue_head = new QueueFatNode();
        this.queue_tail = this.queue_head;
        this.queue_head.next = null;
        this.queue_head.items_left = 0;
    }

    void doFlatCombining(CombiningNode<T> combiner_thread_node) {
        int combining_rounds = 0;
        int num_pushed_items = 0;
        CombiningNode<T> cur_comb_node = null;
        CombiningNode<T> last_combining_node = null;
        int local_current_timestamp = ++this.current_timestamp;
        QueueFatNode<T> local_queue_head = this.queue_head;
        boolean check_timestamps = local_current_timestamp % 100 == 0;
        boolean have_work = false;
        do {
            if (this.abort) {
                return;
            }
            num_pushed_items = 0;
            last_combining_node = cur_comb_node = this.comb_list_head;
            have_work = false;
            while (cur_comb_node != null) {
                if (!cur_comb_node.is_request_valid) {
                    CombiningNode next_node = cur_comb_node.next;
                    if (check_timestamps && cur_comb_node != this.comb_list_head && local_current_timestamp - cur_comb_node.last_request_timestamp > 10000) {
                        last_combining_node.next = next_node;
                        cur_comb_node.is_linked = false;
                    }
                    cur_comb_node = next_node;
                    continue;
                }
                have_work = true;
                cur_comb_node.last_request_timestamp = local_current_timestamp;
                if (cur_comb_node.is_consumer) {
                    boolean consumer_satisfied = false;
                    while (local_queue_head.next != null && !consumer_satisfied) {
                        QueueFatNode head_next = local_queue_head.next;
                        if (head_next.items_left == 0) {
                            local_queue_head = head_next;
                            continue;
                        }
                        --head_next.items_left;
                        cur_comb_node.item = head_next.items[head_next.items_left];
                        consumer_satisfied = true;
                    }
                    if (!consumer_satisfied && num_pushed_items > 0) {
                        cur_comb_node.item = this.combined_pushed_items[--num_pushed_items];
                        consumer_satisfied = true;
                    }
                    if (!consumer_satisfied) {
                        cur_comb_node.item = null;
                    }
                } else {
                    this.combined_pushed_items[num_pushed_items] = cur_comb_node.item;
                    ++num_pushed_items;
                }
                cur_comb_node.is_request_valid = false;
                last_combining_node = cur_comb_node;
                cur_comb_node = cur_comb_node.next;
            }
            if (num_pushed_items <= 0) continue;
            QueueFatNode new_node = new QueueFatNode();
            new_node.items_left = num_pushed_items;
            new_node.items = new Object[num_pushed_items];
            System.arraycopy(this.combined_pushed_items, 0, new_node.items, 0, num_pushed_items);
            new_node.next = null;
            this.queue_tail.next = new_node;
            this.queue_tail = new_node;
        } while (have_work && ++combining_rounds < 32);
        this.queue_head = local_queue_head;
    }

    private void link_in_combining(CombiningNode<T> cn) {
        CombiningNode<T> cur_head;
        do {
            if (this.abort) {
                return;
            }
            cur_head = this.comb_list_head;
            cn.next = cur_head;
        } while (this.comb_list_head != cur_head || !comb_list_head_updater.compareAndSet(this, cn.next, cn));
    }

    private void wait_until_fulfilled(CombiningNode<T> comb_node) {
        int rounds = 0;
        while (!this.abort) {
            if (rounds % 100 == 0 && !comb_node.is_linked) {
                comb_node.is_linked = true;
                this.link_in_combining(comb_node);
            }
            if (this.fc_lock.get() == 0 && this.fc_lock.compareAndSet(0, 1)) {
                this.doFlatCombining(comb_node);
                this.fc_lock.set(0);
            }
            if (!comb_node.is_request_valid) {
                return;
            }
            ++rounds;
        }
        return;
    }

    @Override
    public void add(T value2) {
        CombiningNode<T> comb_node = this.combining_node.get();
        comb_node.is_consumer = false;
        comb_node.item = value2;
        comb_node.is_request_valid = true;
        this.wait_until_fulfilled(comb_node);
    }

    @Override
    public T remove() {
        CombiningNode<T> comb_node = this.combining_node.get();
        comb_node.is_consumer = true;
        comb_node.is_request_valid = true;
        this.wait_until_fulfilled(comb_node);
        return comb_node.item;
    }

    public int size() {
        return 0;
    }

    public String name() {
        return this.getClass().toString();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    static class QueueFatNode<T> {
        T[] items;
        int items_left;
        QueueFatNode<T> next;

        QueueFatNode() {
        }
    }

    static class CombiningNode<T> {
        volatile boolean is_linked = false;
        int last_request_timestamp;
        CombiningNode<T> next = null;
        volatile boolean is_request_valid = false;
        boolean is_consumer;
        T item;

        CombiningNode() {
        }
    }
}

