/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BypassJtagTester;
import com.sun.electric.tool.simulation.test.ChainControl;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.TestNode;
import com.sun.electric.tool.simulation.test.XMLIO;
import javax.imageio.metadata.IIOMetadataNode;

public class ChainControlFake
extends ChainControl {
    private ChipNode chipNode;

    public ChainControlFake(String chipName, int lengthIR, JtagTester jtagTester, float jtagVolts, int jtagKhz) {
        super(null, jtagTester, jtagVolts, jtagKhz);
        this.system = new TestNode("System", "System Top Level");
        this.chipNode = new ChipNode(chipName, lengthIR, "Chip Top Level");
        this.system.addChild(this.chipNode);
    }

    public void addScanBits(String chain, String scanElementName, int length, String access, String clears, String dataNet, String dataNet2) {
        TestNode subchainNode;
        TestNode chainNode = this.getChainNode(chain);
        if (chainNode == null) {
            chainNode = this.createTreeNodeChain(chain, "fakeChain", 0);
            if (chainNode == null) {
                return;
            }
            this.chipNode.addChild(chainNode);
        }
        IIOMetadataNode dummyXML = new IIOMetadataNode("subchain");
        dummyXML.setAttribute("name", scanElementName);
        dummyXML.setAttribute("length", String.valueOf(length));
        dummyXML.setAttribute("access", access);
        dummyXML.setAttribute("clears", clears);
        dummyXML.setAttribute("dataNet", dataNet);
        dummyXML.setAttribute("dataNet2", dataNet2);
        try {
            subchainNode = XMLIO.createTreeNode(dummyXML, chainNode);
        }
        catch (Exception e) {
            System.out.println("Exception trying to create ChainControlFake");
            e.printStackTrace(System.out);
            return;
        }
        if (subchainNode != null) {
            chainNode.addChild(subchainNode);
        }
    }

    @Override
    public boolean shift(String chainRoot, boolean readEnable, boolean writeEnable, int irBadSeverity, int noTestSeverity, int errTestSeverity) {
        if (!(this.jtag instanceof BypassJtagTester)) {
            System.out.println("Error! JtagTester must be a NanosimJtagTester or NanosimJtagSubchainTester to use a Fake ChainControl.");
            return false;
        }
        if (!((BypassJtagTester)this.jtag).isBypassScanning()) {
            System.out.println("Error! ChainControlFake can only be used in bypass scanning (direct read/write) mode. See NanosimModel.start()");
            return false;
        }
        return super.shift(chainRoot, readEnable, writeEnable, irBadSeverity, noTestSeverity, errTestSeverity);
    }

    private TestNode createTreeNodeChain(String name, String opcode, int length) {
        TestNode chainNode;
        IIOMetadataNode dummyXML = new IIOMetadataNode("chain");
        dummyXML.setAttribute("name", name);
        dummyXML.setAttribute("opcode", opcode);
        dummyXML.setAttribute("length", String.valueOf(length));
        try {
            chainNode = XMLIO.createTreeNode(dummyXML, this.chipNode);
        }
        catch (Exception e) {
            System.out.println("Exception trying to create ChainControlFake");
            e.printStackTrace(System.out);
            return null;
        }
        return chainNode;
    }

    private TestNode getChainNode(String chainName) {
        for (int i = 0; i < this.chipNode.getChildCount(); ++i) {
            TestNode chainNode = (TestNode)this.chipNode.getChildAt(i);
            if (!chainNode.getName().equals(chainName)) continue;
            return chainNode;
        }
        return null;
    }
}

