/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class View
implements Comparable<View> {
    private static final int TEXTVIEW = 1;
    private static final int PERMANENTVIEW = 4;
    private final String fullName;
    private final String abbreviation;
    private final int order;
    private final int type;
    private static TreeSet<View> views = new TreeSet();
    private static Set<View> unmodifiableViews = Collections.unmodifiableSet(views);
    private static HashMap<String, View> viewNames = new HashMap();
    private static int overallOrder = 16;
    public static final View SCHEMATIC = View.makeInstance("schematic", "sch", 4, 0);
    public static final View ICON = View.makeInstance("icon", "ic", 4, 1);
    public static final View LAYOUT = View.makeInstance("layout", "lay", 4, 2);
    public static final View LAYOUTSKEL = View.makeInstance("layout.skeleton", "lay.sk", 4, 3);
    public static final View LAYOUTCOMP = View.makeInstance("layout.compensated", "lay.comp", 4, 4);
    public static final View VHDL = View.makeInstance("VHDL", "vhdl", 5, 5);
    public static final View VERILOG = View.makeInstance("Verilog", "ver", 5, 6);
    public static final View DOC = View.makeInstance("documentation", "doc", 5, 7);
    public static final View DOCWAVE = View.makeInstance("documentation.waveform", "doc.wave", 4, 8);
    public static final View NETLIST = View.makeInstance("netlist", "net", 5, 9);
    public static final View NETLISTNETLISP = View.makeInstance("netlist.netlisp", "net.netlisp", 5, 10);
    public static final View NETLISTRSIM = View.makeInstance("netlist.rsim", "net.rsim", 5, 11);
    public static final View NETLISTSILOS = View.makeInstance("netlist.silos", "net.silos", 5, 12);
    public static final View NETLISTQUISC = View.makeInstance("netlist.quisc", "net.quisc", 5, 13);
    public static final View NETLISTALS = View.makeInstance("netlist.als", "net.als", 5, 14);
    public static final View UNKNOWN = View.makeInstance("unknown", "", 4, 15);

    public static View newInst(String fullName, String abbreviation) {
        EDatabase.serverDatabase().checkChanging();
        View view = View.makeInstance(fullName, abbreviation, 0, View.getNextOrder());
        return view;
    }

    public static View newTextInstance(String fullName, String abbreviation) {
        EDatabase.serverDatabase().checkChanging();
        View view = View.makeInstance(fullName, abbreviation, 1, View.getNextOrder());
        return view;
    }

    public void kill() {
        System.out.println("Cannot delete views");
    }

    private View(String fullName, String abbr, int type, int order) {
        this.fullName = fullName;
        this.abbreviation = abbr;
        this.type = type;
        this.order = order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static View makeInstance(String fullName, String abbreviation, int type, int order) {
        if (viewNames.containsKey(abbreviation)) {
            System.out.println("multiple views with same name: " + abbreviation);
            return null;
        }
        if (viewNames.containsKey(fullName)) {
            System.out.println("multiple views with same name: " + fullName);
            return null;
        }
        View v = new View(fullName, abbreviation, type, order);
        Class<View> clazz = View.class;
        synchronized (View.class) {
            viewNames.put(fullName, v);
            viewNames.put(abbreviation, v);
            views.add(v);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextOrder() {
        Class<View> clazz = View.class;
        synchronized (View.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return overallOrder++;
        }
    }

    public static View findView(String name) {
        return viewNames.get(name);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getAbbreviationExtension() {
        return "{" + this.getAbbreviation() + "}";
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isTextView() {
        return (this.type & 1) != 0;
    }

    public boolean isPermanentView() {
        return (this.type & 4) != 0;
    }

    public static Iterator<View> getViews() {
        return unmodifiableViews.iterator();
    }

    public static int getNumViews() {
        return views.size();
    }

    public static List<View> getOrderedViews() {
        ArrayList<View> sortedList = new ArrayList<View>(views);
        Collections.sort(sortedList, new ViewByOrder());
        return sortedList;
    }

    @Override
    public int compareTo(View that) {
        return TextUtils.STRING_NUMBER_ORDER.compare(this.getAbbreviation(), that.getAbbreviation());
    }

    public String toString() {
        return "View " + this.fullName;
    }

    private static class ViewByOrder
    implements Comparator<View> {
        private ViewByOrder() {
        }

        @Override
        public int compare(View v1, View v2) {
            return v1.getOrder() - v2.getOrder();
        }
    }
}

