/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.mesh;

import java.util.HashMap;
import java.util.Map;
import org.gnunet.construct.Construct;
import org.gnunet.mesh.ChannelEndHandler;
import org.gnunet.mesh.DataMessage;
import org.gnunet.mesh.InboundChannelHandler;
import org.gnunet.mesh.MeshRunabout;
import org.gnunet.mesh.RejectMessage;
import org.gnunet.mesh.messages.ClientConnectMessage;
import org.gnunet.mesh.messages.LocalAckMessage;
import org.gnunet.mesh.messages.TunnelCreateMessage;
import org.gnunet.mesh.messages.TunnelDestroyMessage;
import org.gnunet.mq.Envelope;
import org.gnunet.mq.MessageQueue;
import org.gnunet.mq.NotifySentHandler;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.RunaboutMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mesh {
    private static final Logger logger = LoggerFactory.getLogger(Mesh.class);
    private static final long TUNNEL_ID_CLI = 0x80000000L;
    private static final long TUNNEL_ID_SERV = 0xB0000000L;
    private static final int OPTION_NOBUFFER = 1;
    private static final int OPTION_RELIABLE = 2;
    private final Client client;
    private ChannelEndHandler channelEndHandler;
    private MeshRunabout messageReceiver;
    private int[] ports;
    private InboundChannelHandler inboundChannelHandler;
    private Map<Long, Channel> tunnelMap = new HashMap<Long, Channel>();
    private long nextTid = 1L;

    public Mesh(Configuration cfg, InboundChannelHandler inboundChannelHandler, ChannelEndHandler channelEndHandler, MeshRunabout messageReceiver, int ... ports) {
        if (null == channelEndHandler) {
            throw new AssertionError((Object)"tunnel end handler may not be null");
        }
        this.channelEndHandler = channelEndHandler;
        this.messageReceiver = messageReceiver;
        this.ports = ports;
        this.inboundChannelHandler = inboundChannelHandler;
        this.client = new Client("mesh", cfg);
        this.client.installReceiver(new MeshMessageReceiver());
        ClientConnectMessage ccm = new ClientConnectMessage();
        ccm.applicationList = ports;
        String portList = "";
        for (int p : ports) {
            portList = portList + "" + p + " ";
        }
        this.client.send(ccm);
        logger.debug("mesh handle created, listening on ports {}", (Object)portList);
    }

    public Mesh(Configuration cfg, ChannelEndHandler channelEndHandler, MeshRunabout messageReceiver) {
        this(cfg, null, channelEndHandler, messageReceiver, new int[0]);
    }

    public Mesh(Configuration cfg, ChannelEndHandler channelEndHandler) {
        this(cfg, null, channelEndHandler, null, new int[0]);
    }

    public Channel createChannel(PeerIdentity peer, int port, boolean nobuffer, boolean reliable) {
        logger.debug("creating tunnel to peer {} over port {}", (Object)peer.toString(), (Object)port);
        return new Channel(peer, port, nobuffer, reliable);
    }

    public void destroy() {
        this.client.disconnect();
    }

    private class MeshMessageReceiver
    extends RunaboutMessageReceiver {
        private MeshMessageReceiver() {
        }

        public void visit(TunnelCreateMessage m) {
            Channel t = new Channel(m.otherEnd, m.tunnelId, m.port, (m.opt & 1) != 0, (m.opt & 1) != 0);
            logger.debug("inbound tunnel {}", (Object)m.tunnelId);
            if (Mesh.this.inboundChannelHandler != null) {
                Mesh.this.inboundChannelHandler.onInboundChannel(t, m.otherEnd);
            }
        }

        public void visit(DataMessage m) {
            Channel t = (Channel)Mesh.this.tunnelMap.get(m.tid);
            if (t != null) {
                if (t.receiveDoneExpected) {
                    logger.warn("got unexpected message from service");
                }
                t.receiveDoneExpected = true;
                Mesh.this.messageReceiver.setSender(t);
                GnunetMessage gnunetMessage = Construct.parseAs(m.payload, GnunetMessage.class);
                logger.debug("received message of size {} and type {}", (Object)gnunetMessage.header.messageSize, (Object)gnunetMessage.header.messageType);
                Mesh.this.messageReceiver.visitAppropriate(gnunetMessage.body);
                Mesh.this.messageReceiver.setSender(null);
            }
        }

        public void visit(LocalAckMessage m) {
            logger.debug("got LocalAckMessage for {}", (Object)m.tid);
            Channel t = (Channel)Mesh.this.tunnelMap.get(m.tid);
            if (t != null) {
                t.handleAck();
            } else {
                logger.warn("tunnel id for local ack not found");
            }
        }

        public void visit(TunnelDestroyMessage m) {
            Channel t = (Channel)Mesh.this.tunnelMap.get(m.tunnelId);
            if (null == t) {
                logger.warn("server got confused with tunnel IDs on destroy, ignoring message");
                return;
            }
            t.destroyedByService = true;
            logger.debug("tunnel destroyed by service");
            t.destroy();
            Mesh.this.channelEndHandler.onChannelEnd(t);
        }

        public void visit(RejectMessage m) {
            Channel t = (Channel)Mesh.this.tunnelMap.get(m.tunnelId);
            if (null == t) {
                logger.warn("server got confused with tunnel IDs on destroy, ignoring message");
                return;
            }
            t.destroyedByService = true;
            logger.debug("tunnel destroyed by service (nack/reject)");
            t.destroy();
            Mesh.this.channelEndHandler.onChannelEnd(t);
        }

        @Override
        public void handleError() {
            logger.warn("lost connection to mesh service, reconnecting");
            if (null != Mesh.this.channelEndHandler) {
                for (Channel t : Mesh.this.tunnelMap.values()) {
                    Mesh.this.channelEndHandler.onChannelEnd(t);
                }
            }
            Mesh.this.tunnelMap.clear();
            Mesh.this.client.reconnect();
            ClientConnectMessage ccm = new ClientConnectMessage();
            ccm.applicationList = Mesh.this.ports;
            Mesh.this.client.send(ccm);
        }
    }

    public class Channel
    extends MessageQueue {
        private final int opt;
        final PeerIdentity peer;
        final int port;
        protected long tunnelId;
        private boolean receiveDoneExpected = false;
        int ackCount = 0;
        boolean destroyedByService;
        private Cancelable envelopeCanceler;

        public Channel(PeerIdentity peer, int port, boolean nobuffer, boolean reliable) {
            this(peer, 0L, port, nobuffer, reliable);
            TunnelCreateMessage tcm = new TunnelCreateMessage();
            tcm.otherEnd = peer;
            tcm.opt = this.opt;
            tcm.port = port;
            tcm.tunnelId = this.tunnelId;
            mesh.client.send(tcm);
        }

        public Channel(PeerIdentity peer, long tunnelId, int port, boolean nobuffer, boolean reliable) {
            int myOpt = 0;
            if (reliable) {
                myOpt |= 2;
            }
            if (nobuffer) {
                myOpt |= 1;
            }
            if (0L == tunnelId) {
                this.tunnelId = Mesh.this.nextTid++;
                this.tunnelId &= 0xFFFFFFFF4FFFFFFFL;
                this.tunnelId |= 0x80000000L;
            } else {
                this.tunnelId = tunnelId;
            }
            this.peer = peer;
            this.port = port;
            this.opt = myOpt;
            logger.debug("registering tunnel {}", (Object)this.tunnelId);
            Mesh.this.tunnelMap.put(this.tunnelId, this);
        }

        public void receiveDone() {
            if (!this.receiveDoneExpected) {
                throw new AssertionError((Object)"unexpected call to receiveDone");
            }
            LocalAckMessage am = new LocalAckMessage();
            am.tid = this.tunnelId;
            Mesh.this.client.send(am);
            this.receiveDoneExpected = false;
        }

        public void destroy() {
            if (!this.destroyedByService) {
                TunnelDestroyMessage m = new TunnelDestroyMessage();
                m.tunnelId = this.tunnelId;
                m.reserved = new byte[32];
                Mesh.this.client.send(m);
            }
            Mesh.this.tunnelMap.remove(this.tunnelId);
        }

        @Override
        protected void submit(Envelope ev) {
            logger.debug("submitting data message on tunnel {}", (Object)this.tunnelId);
            if (this.ackCount <= 0) {
                throw new AssertionError();
            }
            DataMessage m = new DataMessage();
            m.payload = Construct.toBinary(GnunetMessage.fromBody(ev.message));
            m.tid = this.tunnelId;
            Envelope meshEv = new Envelope(m);
            meshEv.notifySent(new NotifySentHandler(){

                @Override
                public void onSent() {
                    Channel.this.envelopeCanceler = null;
                    Channel.this.reportMessageSent();
                }
            });
            Mesh.this.client.send(meshEv);
            this.envelopeCanceler = meshEv;
            --this.ackCount;
        }

        @Override
        protected void retract() {
            if (this.envelopeCanceler == null) {
                throw new AssertionError();
            }
            this.envelopeCanceler.cancel();
            this.envelopeCanceler = null;
        }

        void handleAck() {
            ++this.ackCount;
            logger.debug("got ack for tunnel id " + this.tunnelId);
            if (this.ackCount == 1) {
                this.reportReadyForSubmit();
            }
        }
    }
}

