/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.testbed;

import org.gnunet.mq.Envelope;
import org.gnunet.requests.MatchingRequestContainer;
import org.gnunet.requests.Request;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.testbed.CompressedConfig;
import org.gnunet.testbed.Host;
import org.gnunet.testbed.HostRegistrationCompletion;
import org.gnunet.testbed.OperationCompletionCallback;
import org.gnunet.testbed.PeerChurnCallback;
import org.gnunet.testbed.PeerCreateCallback;
import org.gnunet.testbed.PeerInformationCallback;
import org.gnunet.testbed.ServiceAdapter;
import org.gnunet.testbed.messages.ConnectionEventMessage;
import org.gnunet.testbed.messages.ControllerInitMessage;
import org.gnunet.testbed.messages.GenericOperationSuccessMessage;
import org.gnunet.testbed.messages.ManagePeerServiceMessage;
import org.gnunet.testbed.messages.OperationFailEventMessage;
import org.gnunet.testbed.messages.OverlayConnectMessage;
import org.gnunet.testbed.messages.PeerCreateMessage;
import org.gnunet.testbed.messages.PeerCreateSuccessMessage;
import org.gnunet.testbed.messages.PeerDestroyMessage;
import org.gnunet.testbed.messages.PeerEventMessage;
import org.gnunet.testbed.messages.PeerGetInformationMessage;
import org.gnunet.testbed.messages.PeerInformationMessage;
import org.gnunet.testbed.messages.PeerReconfigureMessage;
import org.gnunet.testbed.messages.PeerStartMessage;
import org.gnunet.testbed.messages.PeerStopMessage;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.RunaboutMessageReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);
    private Client client;
    private Host host;
    private int operationCounter = 1;
    private int peerCounter;
    private MatchingRequestContainer<Long, OperationRequest> requests;

    public Controller(Host host) {
        this.host = host;
        this.client = new Client("testbed", host.cfg);
        this.client.installReceiver(new ControllerMessageReceiver());
        this.requests = new MatchingRequestContainer(this.client);
        ControllerInitMessage m = new ControllerInitMessage();
        m.eventMask = 31L;
        m.controlerHostname = host.hostname == null ? "127.0.0.1" : host.hostname;
        m.hostId = host.id;
        this.client.send(m);
    }

    public Cancelable createPeer(Host host, Configuration cfg, PeerCreateCallback cb) {
        PeerCreateRequest r = new PeerCreateRequest(host, cfg, cb);
        return this.requests.addRequest(r.operationId, r);
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public Cancelable link(Host delegated_host, Host slave_host, boolean is_subordinate) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    Cancelable registerHost(Host host, HostRegistrationCompletion cc) {
        throw new UnsupportedOperationException("not implemented");
    }

    public class Peer {
        private final int peerId;

        private Peer(int peerId) {
            this.peerId = peerId;
        }

        public Cancelable start(PeerChurnCallback peerChurnCallback) {
            PeerStartRequest r = new PeerStartRequest(this, peerChurnCallback);
            return Controller.this.requests.addRequest(r.operationId, r);
        }

        public Cancelable stop(PeerChurnCallback peerChurnCallback) {
            PeerStopRequest r = new PeerStopRequest(this, peerChurnCallback);
            return Controller.this.requests.addRequest(r.operationId, r);
        }

        public Cancelable requestInformation(PeerInformationCallback cb) {
            PeerInformationRequest r = new PeerInformationRequest(this, cb);
            return Controller.this.requests.addRequest(r.operationId, r);
        }

        public Cancelable updateConfiguration(Configuration cfg, OperationCompletionCallback cb) {
            PeerUpdateConfigurationRequest r = new PeerUpdateConfigurationRequest(this, cb, cfg);
            return Controller.this.requests.addRequest(r.operationId, r);
        }

        public Cancelable destroy(OperationCompletionCallback cb) {
            PeerDestroyRequest r = new PeerDestroyRequest(this, cb);
            return Controller.this.requests.addRequest(r.operationId, r);
        }

        public Cancelable manageService(String serviceName, boolean start, OperationCompletionCallback cb) {
            PeerManageServiceRequest r = new PeerManageServiceRequest(this, serviceName, start);
            return Controller.this.requests.addRequest(r.operationId, r);
        }

        public Cancelable connectOverlay(Peer otherPeer, OperationCompletionCallback cb) {
            PeerConnectOverlayRequest r = new PeerConnectOverlayRequest(this, otherPeer, cb);
            return Controller.this.requests.addRequest(r.operationId, r);
        }

        public Cancelable getServiceConnection(String serviceName, final ServiceAdapter serviceAdapter) {
            return this.requestInformation(new PeerInformationCallback(){

                @Override
                public void onSuccess(PeerIdentity peerIdentity, Configuration configuration) {
                    serviceAdapter.onConnect(configuration);
                }
            });
        }

        public Host getHost() {
            return Controller.this.host;
        }
    }

    public class ControllerMessageReceiver
    extends RunaboutMessageReceiver {
        public void visit(PeerEventMessage m) {
            RequestIdentifier rId = Controller.this.requests.getRequestIdentifier(m.operationId);
            OperationRequest r = (OperationRequest)rId.getRequest();
            if (null == r) {
                logger.error("no matching peer event getRequestIdentifier for op id %s", (Object)m.operationId);
                return;
            }
            if (r instanceof PeerStartRequest && m.eventType == 0) {
                PeerStartRequest psr = (PeerStartRequest)r;
                psr.peerChurnCallback.onChurnSuccess();
            } else if (r instanceof PeerStopRequest && m.eventType == 1) {
                PeerStopRequest psr = (PeerStopRequest)r;
                psr.peerChurnCallback.onChurnSuccess();
            } else {
                logger.error("unexpected peer event message, event type %s and getRequestIdentifier %s", (Object)m.eventType, (Object)r);
            }
        }

        public void visit(PeerCreateSuccessMessage m) {
            RequestIdentifier rId = Controller.this.requests.getRequestIdentifier(m.operationId);
            OperationRequest r = (OperationRequest)rId.getRequest();
            if (!(r instanceof PeerCreateRequest)) {
                logger.warn("response to peer create getRequestIdentifier does not match");
                return;
            }
            PeerCreateRequest pcr = (PeerCreateRequest)r;
            Peer p = new Peer(pcr.peerId);
            pcr.cb.onPeerCreated(p);
        }

        public void visit(PeerInformationMessage m) {
            RequestIdentifier rId = Controller.this.requests.getRequestIdentifier(m.operationId);
            OperationRequest r = (OperationRequest)rId.getRequest();
            if (null == r) {
                logger.error("unexpected peer information message (opid={})", (Object)m.operationId);
                return;
            }
            if (!(r instanceof PeerInformationRequest)) {
                logger.warn("response to peer create getRequestIdentifier does not match");
                return;
            }
            PeerInformationRequest pir = (PeerInformationRequest)r;
            CompressedConfig ccfg = new CompressedConfig(m.compressedConfig);
            pir.cb.onSuccess(m.peerIdentity, ccfg.decompress());
        }

        public void visit(GenericOperationSuccessMessage m) {
            RequestIdentifier rId = Controller.this.requests.getRequestIdentifier(m.operationId);
            OperationRequest r = (OperationRequest)rId.getRequest();
            if (null == r) {
                logger.error("unexpected generic success message (opid={})", (Object)m.operationId);
                return;
            }
            if (!(r instanceof GenericOperationRequest)) {
                logger.error(String.format("got GenericOperationSuccessMessage as response to getRequestIdentifier '%s', opid %s; event type %s", r.getClass(), m.operationId, m.eventType));
                return;
            }
            GenericOperationRequest gr = (GenericOperationRequest)r;
            gr.onSuccess();
        }

        public void visit(ConnectionEventMessage m) {
            RequestIdentifier rId = Controller.this.requests.getRequestIdentifier(m.operationId);
            OperationRequest r = (OperationRequest)rId.getRequest();
            if (null == r) {
                logger.error("unexpected connection event message (opid={})", (Object)m.operationId);
                return;
            }
            if (!(r instanceof PeerConnectOverlayRequest)) {
                logger.error("unexpected connection event message for operation {}", r.getClass());
                return;
            }
            PeerConnectOverlayRequest cr = (PeerConnectOverlayRequest)r;
            cr.cb.onCompletion();
        }

        public void visit(OperationFailEventMessage m) {
            logger.error("operation failed: " + m.errorMessage);
        }

        @Override
        public void handleError() {
            throw new AssertionError();
        }
    }

    class PeerConnectOverlayRequest
    extends OperationRequest {
        final Peer peer1;
        final Peer peer2;
        final OperationCompletionCallback cb;

        public PeerConnectOverlayRequest(Peer peer1, Peer peer2, OperationCompletionCallback cb) {
            this.peer1 = peer1;
            this.peer2 = peer2;
            this.cb = cb;
        }

        @Override
        public Envelope assembleRequest() {
            OverlayConnectMessage m = new OverlayConnectMessage();
            m.operationId = this.operationId;
            m.peer1 = this.peer1.peerId;
            m.peer2 = this.peer2.peerId;
            m.hostOfPeer2 = this.peer2.getHost().id;
            return new Envelope(m);
        }
    }

    class PeerStopRequest
    extends OperationRequest {
        final Peer peer;
        final PeerChurnCallback peerChurnCallback;

        public PeerStopRequest(Peer peer, PeerChurnCallback peerChurnCallback) {
            this.peer = peer;
            this.peerChurnCallback = peerChurnCallback;
        }

        @Override
        public Envelope assembleRequest() {
            PeerStopMessage m = new PeerStopMessage();
            m.operationId = this.operationId;
            m.peerId = this.peer.peerId;
            return new Envelope(m);
        }
    }

    class PeerStartRequest
    extends OperationRequest {
        final Peer peer;
        final PeerChurnCallback peerChurnCallback;

        public PeerStartRequest(Peer peer, PeerChurnCallback peerChurnCallback) {
            this.peer = peer;
            this.peerChurnCallback = peerChurnCallback;
        }

        @Override
        public Envelope assembleRequest() {
            PeerStartMessage m = new PeerStartMessage();
            m.operationId = this.operationId;
            m.peerId = this.peer.peerId;
            return new Envelope(m);
        }
    }

    class PeerManageServiceRequest
    extends OperationRequest {
        final Peer peer;
        final boolean start;
        final String serviceName;

        public PeerManageServiceRequest(Peer peer, String serviceName, boolean start) {
            this.peer = peer;
            this.start = start;
            this.serviceName = serviceName;
        }

        @Override
        public Envelope assembleRequest() {
            ManagePeerServiceMessage m = new ManagePeerServiceMessage();
            m.operationId = this.operationId;
            m.peerId = this.peer.peerId;
            m.serviceName = this.serviceName;
            m.start = this.start;
            return new Envelope(m);
        }
    }

    class PeerUpdateConfigurationRequest
    extends GenericOperationRequest {
        final int peerId;
        final Configuration cfg;

        public PeerUpdateConfigurationRequest(Peer peer, OperationCompletionCallback cb, Configuration cfg) {
            super(cb);
            this.peerId = peer.peerId;
            this.cfg = cfg;
        }

        @Override
        public Envelope assembleRequest() {
            PeerReconfigureMessage m = new PeerReconfigureMessage();
            m.operationId = this.operationId;
            m.peerId = this.peerId;
            CompressedConfig ccfg = new CompressedConfig(this.cfg);
            m.uncompressedConfigSize = ccfg.getUncompressedSize();
            m.compressedConfig = ccfg.compressedData;
            System.out.println("compressed config size " + m.compressedConfig.length);
            return new Envelope(m);
        }
    }

    class PeerInformationRequest
    extends OperationRequest {
        final int peerId;
        final PeerInformationCallback cb;

        public PeerInformationRequest(Peer peer, PeerInformationCallback cb) {
            this.peerId = peer.peerId;
            this.cb = cb;
        }

        @Override
        public Envelope assembleRequest() {
            PeerGetInformationMessage m = new PeerGetInformationMessage();
            m.operationId = this.operationId;
            m.peerId = this.peerId;
            return new Envelope(m);
        }
    }

    class PeerDestroyRequest
    extends GenericOperationRequest {
        final int peerId;

        public PeerDestroyRequest(Peer p, OperationCompletionCallback cb) {
            super(cb);
            this.peerId = p.peerId;
        }

        @Override
        public Envelope assembleRequest() {
            PeerDestroyMessage m = new PeerDestroyMessage();
            m.operationId = this.operationId;
            m.peerId = this.peerId;
            System.out.println("destroy getRequestIdentifier with opid " + m.operationId);
            return new Envelope(m);
        }
    }

    class PeerCreateRequest
    extends OperationRequest {
        final Host host;
        final Configuration cfg;
        final PeerCreateCallback cb;
        final int peerId;

        public PeerCreateRequest(Host host, Configuration cfg, PeerCreateCallback cb) {
            this.host = host;
            this.cfg = cfg;
            this.cb = cb;
            this.peerId = Controller.this.peerCounter++;
        }

        @Override
        public Envelope assembleRequest() {
            CompressedConfig ccfg = new CompressedConfig(this.cfg);
            PeerCreateMessage m = new PeerCreateMessage();
            m.hostId = this.host.id;
            m.operationId = this.operationId;
            m.peerId = this.peerId;
            m.compressedConfig = ccfg.compressedData;
            m.configSize = ccfg.getUncompressedSize();
            System.out.println("create getRequestIdentifier with opid " + m.operationId);
            return new Envelope(m);
        }
    }

    abstract class GenericOperationRequest
    extends OperationRequest {
        protected final OperationCompletionCallback cb;

        public GenericOperationRequest(OperationCompletionCallback cb) {
            this.cb = cb;
        }

        void onSuccess() {
            this.cb.onCompletion();
        }
    }

    abstract class OperationRequest
    extends Request {
        protected final long operationId;

        public OperationRequest() {
            this.operationId = (long)((Controller)Controller.this).host.id << 32 | (long)Controller.this.operationCounter++;
        }
    }

    public static class EventTypes {
        public static final int PEER_START = 0;
        public static final int PEER_STOP = 1;
        public static final int PEERS_CONNECT = 2;
        public static final int PEERS_DISCONNECT = 3;
        public static final int OPERATION_FINISHED = 4;
    }
}

