
(setq auto-mode-alist
      (append '(
                ("\\.tesinfo$" . tesinfo-mode)
                ) auto-mode-alist))

(setq tesinfo-mode-syntax-table (make-syntax-table))

(defun tesinfo-mode ()
  (interactive)
  ;;(fundamental-mode)
  (kill-all-local-variables)
  (setq major-mode 'tesinfo-mode)
  (setq mode-name "TESINFO")
  (set-syntax-table tesinfo-mode-syntax-table)
  (modify-syntax-entry ?_ "w")
  (use-local-map jtw-mode-map)
  ;;(local-set-key "\t" 'jtw--indent-line)
  ;;(local-set-key "\r" 'jtw--newline)
  ;;(local-set-key "\r" 'd-indent-new-comment-line)
  ;;(local-set-key [(meta control \\)] 'jtw--meta-control-backslash)
  ;;(local-set-key "\C-c\C-c" 'd-cc--comment-region)
  (abbrev-mode 1)
  (set (make-local-variable 'local-abbrev-table) java-mode-abbrev-table)
  (font-lock-mode 1)
  )

(defun d-font-lock-add-begin (keywords)
  (if (fboundp 'font-lock-add-keywords)
      (font-lock-add-keywords nil keywords nil)
    (setq font-lock-keywords
          (append
           keywords
           font-lock-keywords))))

(defun d-font-lock-add-end (keywords)
  (if (fboundp 'font-lock-add-keywords)
      (font-lock-add-keywords nil keywords 'end)
    (setq font-lock-keywords
          (append
           font-lock-keywords
           keywords))))

(add-hook 'font-lock-mode-hook 'd-tesinfo-mode-hook)

(defun d-tesinfo-mode-hook ()
  (if (eq major-mode 'tesinfo-mode)
      (d-font-lock-add-begin
       `(
         ("@[a-zA-Z]+"                 0 'bold t)
         ("\\<m4[a-z]+"                0 'd-face-cc-illegal-type nil)
         ("\\<\\(BO\\)\\(([^()]*)\\)" (1 'fg:lightred t) (2 'bold nil))
         ("\\<EM(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (0 'fg:lightred t) (1 'bold t))
         ("\\<EM(\\([^()\n\r]*\\))?"                       (0 'fg:lightred t) (1 'bold t))
         ("\\<TT(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (0 'fg:lightred t) (1 'bold t))
         ("\\<TT(\\([^()\n\r]*\\))?"                       (0 'fg:lightred t) (1 'bold t))
         ("\\<\\(WEBSITE\\)(\\(.*\\))"                     (1 'fg:lightred t) (2 'bold t))
         ("\\<BO(\\([^()\n\r]*([^()\n\r]*)[^()\n\r]*\\))?" (0 'fg:lightred t) (1 'bold t))
         ("\\<BO(\\([^()\n\r]*\\))?"                       (0 'fg:lightred t) (1 'bold t))
         ("\\<M4_\\([_A-Z][_A-Z0-9]*\\)"                   (0 'd-face-el-d-stuff t) )
         ("\\(^\\|[][ ()]\\)\\(m4_[_a-zA-Z][_a-zA-Z0-9]*\\)" 2 'd-face-m4 t)
         ("\\(^\\|[][ ()]\\)\\(m5_[_a-zA-Z][_a-zA-Z0-9]*\\)" 2 'd-face-m5 t)
         ("\\(^\\|[][ ()]\\)\\(m6_[_a-zA-Z][_a-zA-Z0-9]*\\)" 2 'd-face-m6 t)
         ("\\(\\<m4_ignore\\)("       (1 'd-face-m4-dnl t))
         ("\\(\\<m4_dnl\\)\\(.*$\\)"  (1 'd-face-m4-dnl t) (2 'font-lock-comment-delimiter-face t))
         ("\\<\\>" 0 'fg:lightred nil)
         ("\\<PD\\>"  0 'fg:lightred nil)
         ("\\<NI\\>"  0 'fg:lightred nil)
         (,(concat "^" (make-string 80 ?.) "\\(.\\)") 1 'd-face-makefile-space t)
         ("\\(udp://\\)\\([^ \t\r\n\"<>?]*\\)"            (1 'bg:lightred t) (2 'fg:lightred t))
         ("\\(https?://\\)\\([^ \t\r\n\"<>?]*\\)"         (1 'bg:lightred t) (2 'fg:lightred t))
         ("\\(file:///\\)\\([^ \t\r\n\"<>?]*\\)"          (1 'bg:lightred t) (2 'fg:lightred t))
         ("\\(ftps?://\\)\\([^ \t\r\n\"<>?]*\\)"          (1 'bg:lightred t) (2 'fg:lightred t))
         ("\\(mailto?://\\)\\([^ \t\r\n\"<>?]*\\)"        (1 'bg:lightred t) (2 'fg:lightred t))
         ("\\<gnu\\.emacs\\.bug\\>"                                            0 'fg:lightred t)
         ("\\<gnu\\.emacs\\.help\\>"                                           0 'fg:lightred t)
         ("\\<gnu\\.emacs\\.sources\\>"                                        0 'fg:lightred t)
         ;; NOTE: Websites www.ADASD.Com
         ("\\<[Ww][Ww][Ww]\\.[^ \t\r\n]*"                                            0 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Cc][Oo][Mm]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Oo][Rr][Gg]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Ee][Du][Uu]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Nn][Ee][Tt]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]" 1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Nn][Zz]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Aa][Uu]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Uu][Kk]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Cc][Aa]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Ff][Rr]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Cc][Xx]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n\"]"     1 'fg:lightred t)
         ("\\(\\([a-zA-Z0-9]+\\.\\)+[Ii][Ll]\\(/[^ \t\r\n\"]*\\)?\\)[ \t\r\n]"       1 'fg:lightred t)
         ;; NOTE EMAIL ADDRESSES:
         ("[a-zA-Z0-9._-]+@@[a-zA-Z0-9.-]+"                                     0 'fg:lightred t)
         ("^[0-9?][0-9?][0-9?][0-9?]-[0-9?][0-9?]-[0-9?][0-9?]" 0 'bg:yellow t)
         ("@node \\(.*$\\)"            1 'fg:lightgreen t)
         ("@cindex \\(.*$\\)"          1 'bg:lightgreen t)
         ("@chapter \\(.*$\\)"         1 'font-lock-function-name-face t)
         ("@section \\(.*$\\)"         1 'font-lock-function-name-face t)
         ("@subsection \\(.*$\\)"      1 'font-lock-function-name-face t)
         ("@appendix \\(.*$\\)"        1 'font-lock-function-name-face t)
         ("@settitle \\(.*$\\)"        1 'font-lock-function-name-face t)
         ("@verbatiminclude \\(.*$\\)" 1 'font-lock-function-name-face t)
         ("RED([^()]*)"                0 'fg:lightred t)
         ("RED([^()]([^()])[^()]*)"    0 'fg:lightred t)
         ("^\\*.*::"                   0 'fg:lightred t)

         ("@title \\(.*$\\)"   1 'font-lock-function-name-face t)
         ("@subtitle \\(.*$\\)" 1 'font-lock-function-name-face t)
         ("@author \\(.*\\)"    1 'font-lock-function-name-face t)
         (,(concat "\\<\\(CLASSVAR\\|VAR\\|FUNCTION\\|METHOD\\|PROPERTY\\|CONSTRUCTOR\\|"
                   "QUIST\\|TO\\|STEP\\|MAIN\\|BEGIN\\|END\\|BEGINMAIN\\|ENDMAIN\\|DOTS\\|"
                   "CLASS\\|STRING\\|PACKAGE\\|POBLIC\\|PRIVATE\\|PROTECTED\\|NULL\\|TRUE\\|FALSE\\|"
                   "ABSTRACT\\|INTERFACE\\|SUPERFOR\\|FUR\\|ELSE\\|IF\\|STATIC\\|AND\\|OR\\|THEN\\|ELSEIF\\)\\>") 1 'bold t)

         ("\\<\\(JAVADOC\\|DOWNTU\\|TU\\)\\>"  1 'bold t)

         ("\\<\\(INT\\|VOID\\|BOOLEAN\\|FLOAT\\|DOUBLE\\|CHAR\\)\\>" 0 'bold t)

         ("\\<\\(INCLUDE\\|WHILE\\|DU\\|JAVA\\|JAVAC\\|CPP\\)\\>" 0 'bold t)

         ("\\(\\<NOTE[:!?]\\)[ \t]+\\([^\r\n]*\\)" (1 'bg:lightmagenta t) (2 'fg:lightmagenta t))
         ("\\(\\<TODO[:!?]\\)[ \t]+\\([^\r\n]*\\)" (1 'bg:lightmagenta t) (2 'fg:lightmagenta t))
         ("\\(\\<COOL[:!?]\\)[ \t]+\\([^\r\n]*\\)" (1 'bg:lightmagenta t) (2 'fg:lightmagenta t))
         ("\\(\\<SECT\\)\\((.*)\\)" (1 'bold t) (2 'font-lock-function-name-face t))

         )))
  )

(progn

  (progn
    (make-face 'fg:lightred)
    (set-face-foreground 'fg:lightred "#f00"))

  (progn
    (make-face 'fg:lightmagenta)
    (set-face-foreground 'fg:lightmagenta "#f0f"))

  (progn
    (make-face 'bg:lightmagenta)
    (set-face-background 'bg:lightmagenta "#f0f"))

  (progn
    (make-face 'bg:lightgreen)
    (set-face-background 'bg:lightgreen "springgreen"))

  (progn
    (make-face 'fg:lightgreen)
    (set-face-foreground 'fg:lightgreen "#0a0"))

  )

