/* @(#)s_rint.c 5.1 93/09/24 */
/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

/*
 * rint(x)
 * Return x rounded to integral value according to the prevailing
 * rounding mode.
 * Method:
 *	Using floating addition.
 * Exception:
 *	Inexact flag raised if x not equal to rint(x).
 */

#include <math.h>
#include <math_private.h>

static const double
  TWO52[2] = {
  4.50359962737049600000e+15, /* 0x43300000, 0x00000000 */
 -4.50359962737049600000e+15, /* 0xC3300000, 0x00000000 */
};

double
__rint (double x)
{
  int32_t i0, j0, sx;
  double w, t;
  GET_HIGH_WORD (i0, x);
  sx = (i0 >> 31) & 1;
  j0 = ((i0 >> 20) & 0x7ff) - 0x3ff;
  if (j0 < 52)
    {
      if (j0 < 0)
	{
	  w = TWO52[sx] + x;
	  t = w - TWO52[sx];
	  GET_HIGH_WORD (i0, t);
	  SET_HIGH_WORD (t, (i0 & 0x7fffffff) | (sx << 31));
	  return t;
	}
    }
  else
    {
      if (j0 == 0x400)
	return x + x;                   /* inf or NaN */
      else
	return x;                       /* x is integral */
    }
  w = TWO52[sx] + x;
  return w - TWO52[sx];
}
#ifndef __rint
weak_alias (__rint, rint)
# ifdef NO_LONG_DOUBLE
strong_alias (__rint, __rintl)
weak_alias (__rint, rintl)
# endif
#endif
