dnl I'd like this to be edited in -*- Autoconf -*- mode...
dnl
AC_DEFUN(GST_HAVE_TCLTK, [

AC_ARG_WITH(tcl, 
	[  --with-tcl=path         set path to tclConfig.sh [default=ask tclsh]])

AC_ARG_WITH(tk, 
	[  --with-tk=path          set path to tkConfig.sh [default=same as Tcl]])

if test "x$with_tcl" = x || test "$with_tcl" = yes; then
  AC_MSG_CHECKING(for tclsh)
  exec AS_MESSAGE_FD([])>/dev/null
  AC_PATH_PROG(TCLSH, tclsh)
  test "$silent" != yes && exec AS_MESSAGE_FD([])>&1
  if test -n "$TCLSH"; then
    for i in ${TCLSH}*; do
      if test -x $i; then
        with_tcl=`echo 'puts $tcl_library' | $i 2> /dev/null`
        if test "x$with_tcl" = x; then
	  with_tcl=no
	  TCLSH=no
	else
          # Assign the name we found to the TCLSH variable, and
	  # remove the last component from the path
	  TCLSH=$i
          test -f "$with_tcl/tclConfig.sh" || with_tcl=`echo "$with_tcl" | sed 's,\(.*\)/.*,\1,'`
          break
        fi
      fi
    done
  else
    with_tcl=no
    TCLSH=no
  fi
  AC_MSG_RESULT($TCLSH)
fi
if test "x$with_tk" = x || test "$with_tk" = yes; then
  with_tk=$with_tcl
fi
test -f "$with_tcl/tclConfig.sh" || with_tcl=no
test -f "$with_tk/tkConfig.sh" || with_tk=no

AC_MSG_CHECKING(for Tcl 8.x)
AC_MSG_RESULT($with_tcl)
AC_MSG_CHECKING(for Tk 8.x)
AC_MSG_RESULT($with_tk)

AC_CACHE_CHECK(how to link with Tcl/Tk 8.x, gst_cv_tcltk_libs, [
  exec AS_MESSAGE_FD([])>/dev/null

  gst_cv_tcltk_libs="not found"

  if test "$with_tcl" != no -a "$with_tk" != no; then
    # Get the values we need from the Tcl/Tk configuration files
    . $with_tcl/tclConfig.sh
    . $with_tk/tkConfig.sh

    # The indirection is required by Tcl/Tk
    gst_cv_tcltk_libs="$TCL_LIBS $TK_XLIBSW $TCL_LIB_SPEC $TK_LIB_SPEC"
    gst_cv_tcltk_libs=`eval echo $gst_cv_tcltk_libs`
    gst_cv_tcltk_includes="$TK_XINCLUDES -I$TCL_PREFIX/include"

    save_cppflags="$CPPFLAGS"
    save_libs="$LIBS"
    CPPFLAGS="$CPPFLAGS $gst_cv_tcltk_includes"
    LIBS="$LIBS $gst_cv_tcltk_libs"

    # search for the header files, because some implementations of tclConfig.sh
    # do not deliver correct header includes
    save_cppflags2="$CPPFLAGS"
    for trial in 1 2 3 4 5; do
      found_so_far=no
      case $trial in
        1) TCL_INCLUDES=""
	   test "$TCL_PREFIX" != "$TK_PREFIX" &&
	     TCL_INCLUDES="$TCL_INCLUDES -I$TK_PREFIX/include" ;;
	2) TCL_INCLUDES="-I$TCL_SRC_DIR/.."
	   test "$TCL_SRC_DIR" != "$TK_SRC_DIR" &&
	     TCL_INCLUDES="$TCL_INCLUDES -I$TK_SRC_DIR/.." ;;
	3) TCL_INCLUDES="-I$TCL_SRC_DIR/include"
	   test "$TCL_SRC_DIR" != "$TK_SRC_DIR" &&
	     TCL_INCLUDES="$TCL_INCLUDES -I$TK_SRC_DIR/include" ;;
	4) TCL_INCLUDES="-I$TCL_EXEC_PREFIX/include"
	   test "$TCL_EXEC_PREFIX" != "$TK_EXEC_PREFIX" &&
	     TCL_INCLUDES="$TCL_INCLUDES -I$TK_EXEC_PREFIX/include" ;;
	5) TCL_INCLUDES="-I$TCL_EXEC_PREFIX/include/tcl$TCL_MAJOR_VERSION.$TCL_MINOR_VERSION -I$TK_EXEC_PREFIX/include/tk$TK_MAJOR_VERSION.$TK_MINOR_VERSION" ;;
      esac
      CPPFLAGS="$save_cppflags2 $TCL_INCLUDES"
      AC_CHECK_HEADER(tcl.h,[found_so_far=yes])
      test $found_so_far = yes && break
    done
    
    gst_cv_tcltk_includes="$gst_cv_tcltk_includes $TCL_INCLUDES"

    # Check the headers & libraries
    AC_EGREP_CPP(everything_fine, [
#include <tcl.h>
#include <tk.h>
#ifdef TCL_MAJOR_VERSION
#ifdef TK_MAJOR_VERSION
#if ((TCL_MAJOR_VERSION == $TCL_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
#if ((TK_MAJOR_VERSION == $TK_MAJOR_VERSION) && (TCL_MINOR_VERSION == $TCL_MINOR_VERSION))
    everything_fine
#endif
#endif
#endif
#endif], , gst_cv_tcltk_libs="not found")

    AC_CHECK_FUNC(Tcl_ObjSetVar2, , gst_cv_tcltk_libs="not found")
    AC_CHECK_FUNC(Tk_CreatePhotoImageFormat, , gst_cv_tcltk_libs="not found")
    CPPFLAGS="$save_cppflags"
    LIBS="$save_libs"
  fi
  test "$silent" != yes && exec AS_MESSAGE_FD([])>&1
])

if test "$gst_cv_tcltk_libs" != "not found"; then
  AC_MSG_CHECKING(include path for Tcl/Tk)
  AC_MSG_RESULT($gst_cv_tcltk_includes)
  LIBTCLTK="$gst_cv_tcltk_libs"
  INCTCLTK="$gst_cv_tcltk_includes"
  AC_DEFINE(HAVE_TCLTK, 1,
      [Define if your system has Tcl/Tk, 8.0 or later, installed.])
fi

AC_SUBST(LIBTCLTK)
AC_SUBST(INCTCLTK)
])dnl
