/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _STARTAPP_H
#define _STARTAPP_H

class CharTranslator;

class StartApp
{
 protected:
  char *inputFileName, *outputFileName; /* what we're reading  */
  
  int entire_doc; // we want a real html doc
  short verbose;
  char *cssUrl;
  int use_css; // Use CSS instead of font-tags
  int is_cgi;   // set if in CGI mode (and therefore has to add CGI-header)
  
  char *programName;
  char *programVersion;

  virtual void print_copyright();
  virtual void print_reportbugs();
  virtual void print_version(char *progname, char *progversion);

  // factory method
  virtual CharTranslator *createCharTranslator() = 0;

 public:
  StartApp(char *prog_name, char *prog_ver);

  virtual int start(int argc, char * argv[]);
} ;

#endif /* _STARTAPP_H */
