unit AddEditUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Inifiles, OleCtrls, MOZILLACONTROLLib_TLB,
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdAntiFreezeBase, IdException, IdAntiFreeze, ShellAPI;

type
  TFormAddEdit = class(TForm)
    EditName: TEdit;
    EditBegAnch: TEdit;
    EditEndAnch: TEdit;
    EditURL: TEdit;
    EditImgURL: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    ButtonSaveExit: TButton;
    ButtonHelp: TButton;
    ButtonSaveAdd: TButton;
    ButtonTestComic: TButton;
    MozillaBrowserTest: TMozillaBrowser;
    IdHTTPTest: TIdHTTP;
    IdAntiFreeze2: TIdAntiFreeze;
    LabelBegAnchor: TLabel;
    LabelEndAnchor: TLabel;
    LabelFinalURL: TLabel;
    LabelImageURLDesc: TLabel;
    CheckBoxStartPoint: TCheckBox;
    EditStartPoint: TEdit;
    CheckBoxAltURL: TCheckBox;
    procedure ButtonSaveExitClick(Sender: TObject);
    procedure ButtonSaveAddClick(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure ButtonTestComicClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ButtonHelpClick(Sender: TObject);
    procedure CheckBoxStartPointClick(Sender: TObject);
    procedure CheckBoxAltURLClick(Sender: TObject);
    procedure EditNameEnter(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormAddEdit: TFormAddEdit;
  editing: integer;
  oldcomicname: string;

implementation

{$R *.dfm}

uses ManageUnit;

//The following function returns the position of a given string in another string,
//when the search needs to start at a specified position in the second string
function PosFromPos (const s1, s2: string;
                  pos, max: Integer): Integer;
// s1 = the string that must be found
// s2 = the string to search
// pos = start position
// max = maximum search length
var s, l1, l2, j: Integer;
begin
 Result:= -1;
 l1:= Length (s1);
 l2:= Length (s2);
 if max <= 0 then max:= l2; // maximum length
 // we can not search befor the first char
 if pos < 0 then pos:= 0;
 // maybe we're ready at all?
 if (l1 <= 0) or (pos > max) then Exit;
 for s:= pos to (max - l1) do begin
  for j:= 1 to l2 do begin
   if (s1[j] <> s2[s+j]) then BREAK; // Diffrence detectet
   // we have it found
   if (j = l1) then begin Result:= s; Exit; end;
  end;
 end;
end;

procedure TFormAddEdit.ButtonSaveExitClick(Sender: TObject);
var ctr,startpos,endpos: integer;
    comicname, allcomics: string;
    ini: TIniFile;
begin
  ini := TIniFile.Create( ChangeFileExt( Application.ExeName, '.ini' ) );
  allcomics := ini.ReadString('DailyComics','All Comics','');
  if editing = 0 then
  begin
    for ctr := 1 to length(allcomics) do
    begin
      if allcomics[ctr] <> ',' then
      begin
        comicname := comicname+allcomics[ctr]
      end else
      begin
        if comicname = EditName.Text then
        begin
          MessageDlg('Your comic''s name already exists in the current comics list!', mtError, [mbOK], 0);
          editName.SetFocus;
          exit;
        end;
        comicname := '';
      end;
    end;
    allcomics := allcomics + ',' + EditName.Text;
    ini.WriteString('DailyComics','All Comics',allcomics);
  end;
  ini.WriteString(EditName.Text,'URL',EditURL.Text);
  ini.WriteString(EditName.Text,'StartPoint',EditStartPoint.Text);
  ini.WriteString(EditName.Text,'BegAnch',EditBegAnch.Text);
  ini.WriteString(EditName.Text,'EndAnch',EditEndAnch.Text);
  ini.WriteString(EditName.Text,'ImgURL',EditImgURL.Text);
//we set oldcomicname when the user enters the EditName.text field,
//assuming they are going to change the name.  Here we check to see if they really did
//change the name, and if yes, we delete the old comic's name and section from the ini file
  allcomics := allcomics + ',' + EditName.Text;
  if (oldcomicname <> EditName.Text) and (oldcomicname <> '') then
  begin
    ini.EraseSection(oldcomicname);

//this for loop erases the old comic's name from the allcomics list in the ini file
    endpos := 1;
    for ctr := 1 to length(allcomics) do
    begin
      if allcomics[ctr] <> ',' then
      begin
        if allcomics[ctr] = oldcomicname[endpos] then
        begin
          endpos := endpos+1;
          comicname := comicname+allcomics[ctr]
        end else
          endpos := 1;
      end else
      begin
        if endpos > 1 then
        begin
          startpos := ctr-endpos+1;
          Delete(allcomics,startpos,endpos);
        end; //if endpos > 1 then
        comicname := '';
      end; // if allcomics[ctr] <> ',' then
    end; // for ctr := 1 to length(allcomics) do
  end; // if (oldcomicname <> EditName.Text) and (oldcomicname <> '') then
  ini.WriteString('DailyComics','All Comics',allcomics);
  FormAddEdit.Close;
  FormManageComics.FormCreate(nil);
  oldcomicname := '';
end;

procedure TFormAddEdit.ButtonSaveAddClick(Sender: TObject);
var ctr,startpos,endpos: integer;
    comicname, allcomics: string;
    ini: TIniFile;
begin
  ini := TIniFile.Create(ChangeFileExt(Application.ExeName,'.ini'));
  allcomics := ini.ReadString('DailyComics','All Comics','');
  if editing = 0 then
  begin
    for ctr := 1 to length(allcomics) do
    begin
      if allcomics[ctr] <> ',' then
      begin
        comicname := comicname+allcomics[ctr]
      end else
      begin
        if comicname = EditName.Text then
        begin
          MessageDlg('Your comic''s name already exists in the current comics list!', mtError, [mbOK], 0);
          editName.SetFocus;
          exit;
        end;
        comicname := '';
      end;
    end;
    allcomics := allcomics + ',' +  EditName.Text;
    ini.WriteString('DailyComics','All Comics',allcomics);
  end;
  ini.WriteString(EditName.Text,'URL',EditURL.Text);
  ini.WriteString(EditName.Text,'StartPoint',EditStartPoint.Text);
  ini.WriteString(EditName.Text,'BegAnch',EditBegAnch.Text);
  ini.WriteString(EditName.Text,'EndAnch',EditEndAnch.Text);
  ini.WriteString(EditName.Text,'ImgURL',EditImgURL.Text);

//we set oldcomicname when the user enters the EditName.text field,
//assuming they are going to change the name.  Here we check to see if they really did
//change the name, and if yes, we delete the old comic's name and section from the ini file
  if (oldcomicname <> EditName.Text) and (oldcomicname <> '') then
  begin
    ini.EraseSection(oldcomicname);

//this for loop erases the old comic's name from the allcomics list in the ini file
    endpos := 1;
    for ctr := 1 to length(allcomics) do
    begin
      if allcomics[ctr] <> ',' then
      begin
        if allcomics[ctr] = oldcomicname[endpos] then
        begin
          endpos := endpos+1;
          comicname := comicname+allcomics[ctr]
        end else
          endpos := 1;
      end else
      begin
        if endpos > 1 then
        begin
          startpos := ctr-endpos+1;
          Delete(allcomics,startpos,endpos);
        end; //if startpos > 0 then
        comicname := '';
      end; // if allcomics[ctr] <> ',' then
    end; // for ctr := 1 to length(allcomics) do
    allcomics := allcomics + ',' + EditName.Text;
    ini.WriteString('DailyComics','All Comics',allcomics);
  end; // if (oldcomicname <> EditName.Text) and (oldcomicname <> '') then

  FormDeactivate(nil);
  CheckBoxAltURL.Checked := false;
  EditImgURL.Color := clBtnFace;
  EditImgURL.Enabled := false;
  CheckBoxStartPoint.Checked := false;
  EditStartPoint.Color := clBtnFace;
  EditStartPoint.Enabled := false;
  EditName.SetFocus;
  FormManageComics.FormCreate(nil);
end;

procedure TFormAddEdit.FormDeactivate(Sender: TObject);
var exepath: string;
begin
  EditName.Clear;
  EditURL.Clear;
  EditStartPoint.Clear;
  EditBegAnch.Clear;
  EditEndAnch.Clear;
  EditImgURL.Clear;
  exepath := ExtractFilePath(application.exename);
  DeleteFile(exepath+'comicstest.html');
  LabelBegAnchor.Visible := false;
  LabelEndAnchor.Visible := false;
  LabelFinalURL.Visible := false;
  LabelImageURLDesc.Visible := false;
//The following code loads the about:blank page into the mozilla control,
//so that if the user comes back into this form after testing a comic,
//they won't see the last tested comic still loaded in the browser
  MozillaBrowserTest.Navigate('about:blank');
end;

procedure TFormAddEdit.ButtonTestComicClick(Sender: TObject);
var comicsrc: TextFile;
    prestartpos,startpos,endpos: integer;
    comicname,exepath,comicwebsrc,imgsrc: string;
    comicurl,comicstartpoint,comicbeganch,comicendanch,comicimgurl: string;
begin
  if EditName.Text = '' then
  begin
    MessageDlg('Please enter a name first', mtError, [mbOK], 0);
    EditName.SetFocus;
    exit
  end else if EditURL.Text = '' then
  begin
    MessageDlg('Please enter a URL first', mtError, [mbOK], 0);
    EditURL.SetFocus;
    exit
  end else if EditBegAnch.Text = '' then
  begin
    MessageDlg('Please enter a beginning anchor first', mtError, [mbOK], 0);
    EditBegAnch.SetFocus;
    exit
  end else if EditEndAnch.Text = '' then
  begin
    MessageDlg('Please enter an ending anchor first', mtError, [mbOK], 0);
    EditEndAnch.SetFocus;
    exit
  end;

  exepath := ExtractFilePath(application.exename);
  DeleteFile(exepath+'comicstest.html');
  AssignFile(comicsrc,exepath+'comicstest.html');
  ReWrite(comicsrc);
  Writeln(comicsrc,'<html><body><center>');

  comicName := EditName.Text;
  comicURL := EditURL.Text;
  comicStartPoint := EditStartPoint.Text;
  comicBegAnch := EditBegAnch.Text;
  comicEndAnch := EditEndAnch.Text;
  comicImgURL := EditImgURL.Text;
  try
    comicwebsrc := idhttpTest.Get(comicURL);
  except
    on EIDSocketError do comicwebsrc := 'failed';
    on EInOutError do comicwebsrc := 'failed';
    on EIDHTTPProtocolException do comicwebsrc := 'failed';
  end;
  if comicwebsrc <> 'failed' then
  begin
    if comicStartPoint <> '' then
    begin
      prestartpos := Pos(comicStartPoint,comicwebsrc);
      startpos := PosFromPos(comicBegAnch,comicwebsrc,prestartpos,length(comicwebsrc));
      endpos := PosFromPos(comicEndAnch,comicwebsrc,startpos,length(comicwebsrc));
    end else
    begin
      startpos := Pos(comicBegAnch,comicwebsrc);
      endpos := PosFromPos(comicEndAnch,comicwebsrc,startpos,length(comicwebsrc));
    end;
    imgsrc := copy(comicwebsrc,startpos,(endPos+4)-startpos);
    comicwebsrc := '<img src="'+comicImgURL+imgsrc+'">';
    Writeln(comicsrc,'<strong>'+comicName+'</strong>');
    Writeln(comicsrc,'<br>');
    Writeln(comicsrc,comicwebsrc);
  end else
  begin
    MessageDlg('Sorry, I recieved a network error while trying to reach '+comicName, mtError, [mbOK], 0);
    exit; 
  end;

  Writeln(comicsrc,'</center></body></html>');
  flush(comicsrc);
  CloseFile(comicsrc);
  LabelBegAnchor.Caption := 'Beginning anchor: '+IntToStr(startpos);
  LabelEndAnchor.Caption := 'Ending anchor: '+IntToStr(endpos);
  LabelFinalURL.Caption := comicImgURL+imgsrc;
  LabelBegAnchor.Visible := true;
  LabelEndAnchor.Visible := true;
  LabelFinalURL.Visible := true;
  LabelImageURLDesc.Visible := true;
  MozillaBrowserTest.Enabled := true;
  MozillaBrowserTest.Show;
  MozillaBrowserTest.Navigate(exepath+'comicstest.html');
end;

procedure TFormAddEdit.FormActivate(Sender: TObject);
begin
  MozillaBrowserTest.Enabled := false;
  if EditStartPoint.Text = '' then
  begin
    CheckBoxStartPoint.Checked := false;
    EditStartPoint.Color := clBtnFace;
    EditStartPoint.Enabled := false
  end else
  begin
    CheckBoxStartPoint.Checked := true;
    EditStartPoint.Color := clWindow;
    EditStartPoint.Enabled := true
  end;
  if EditImgURL.Text = '' then
  begin
    CheckBoxAltURL.Checked := false;
    EditImgURL.Color := clBtnFace;
    EditImgURL.Enabled := false
  end else
  begin
    CheckBoxAltURL.Checked := true;
    EditImgURL.Color := clWindow;
    EditImgURL.Enabled := true
  end;
  ButtonSaveExit.SetFocus;
end;

procedure TFormAddEdit.ButtonHelpClick(Sender: TObject);
var exepath: string;
begin
  exepath := ExtractFilePath(application.exename);
  ShellExecute(FormAddEdit.Handle, 'Open', PChar(exepath+'Help\AddEdit.html'), nil, nil, SW_SHOW);
end;

procedure TFormAddEdit.CheckBoxStartPointClick(Sender: TObject);
begin
  if EditStartPoint.Enabled = true then
  begin
    EditStartPoint.Enabled := false;
    EditStartPoint.Color := clBtnFace
  end else
  begin
    EditStartPoint.Enabled := true;
    EditStartPoint.Color := clWindow;
    EditStartPoint.SetFocus;
  end;
end;

procedure TFormAddEdit.CheckBoxAltURLClick(Sender: TObject);
begin
  if EditImgURL.Enabled = true then
  begin
    EditImgURL.Enabled := false;
    EditImgURL.Color := clBtnFace
  end else
  begin
    EditImgURL.Enabled := true;
    EditImgURL.Color := clWindow;
    EditImgURL.SetFocus;
  end;
end;

procedure TFormAddEdit.EditNameEnter(Sender: TObject);
begin
  if editing = 1 then
  begin
    oldcomicname := EditName.Text;
  end;
end;

end.
