const XUL_FILE = "chrome://firefly/content/firefly.xul"
const APP_NAME = "Firefly"
var starterArray=new Array();

var treeView = {
	visibleData : starterArray,
	childData : function (idx) {
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
		var showHiddenFiles=prefs.getBoolPref('extensions.firefly.hidden_files');
		
		var dirs=new Array();
		var path=this.visibleData[idx][0];
		var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
		if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
		aFolder.initWithPath(path);
		try {
			var folderEntries=aFolder.directoryEntries;
		} catch (err) {
			return new Array();
		}
		while (folderEntries.hasMoreElements()) {
			next=folderEntries.getNext().QueryInterface(Components.interfaces.nsILocalFile);
			if (next.isDirectory()) {
				if ((next.isHidden() && showHiddenFiles) || !next.isHidden()) {
					dirs.push(next);
				}
			}
		}
		dirs.sort(nameSort);
		return dirs;
	},
	treeBox: null,
	selection: null,
	getSelectedElement: function(idx) {
		return this.visibleData[idx];
	},
	get rowCount()                     { return this.visibleData.length; },
	setTree: function(treeBox)         { this.treeBox = treeBox; },
	getCellText: function(idx, column) { return this.visibleData[idx][3]; },
	isContainer: function(idx)         { return true; },
	isContainerOpen: function(idx)     { return this.visibleData[idx][2]; },
	isContainerEmpty: function(idx)    { 
		if (this.visibleData[idx][1]!=0) {
			return this.visibleData[idx][4]; 
		} else {
			var children=this.childData(idx);
			if (children.length>0) {
				return false;
			} else {
				if (this.isContainerOpen(idx)) {
					this.toggleOpenState(idx);
				}
				return true;
			}
		}
	},
	isSeparator: function(idx)         { return false; },
	isSorted: function(path) { return false;},
	isEditable: function(idx, column)  { return true; },
	getParentIndex: function(idx) {
		var currentLevel=this.visibleData[idx][1];
		if (currentLevel==0) return -1;
		for (var i=idx-1;i>=0;i--) {
			if (this.visibleData[i][1]<currentLevel) {
				return i;
			}
		}
		return -1;
	},
	getLevel: function(idx) { return this.visibleData[idx][1]; },
	hasNextSibling: function(idx, after) {
		var currentLevel=this.visibleData[idx][1];
		if (idx==this.rowCount-1) {
			return false;
		}
		if (this.visibleData[idx+1][1]==currentLevel) {
			return true;
		}
		return false;
	},
	toggleOpenState: function(idx) {
		if (this.visibleData[idx][2]) {
			this.visibleData[idx][2]=false;
			var currentLevel=this.visibleData[idx][1];
			var deletecount = 0;
			for (var t = idx + 1; t < this.visibleData.length; t++) {
				if (this.visibleData[t][1] > currentLevel) deletecount++;
				else break;
			}
			if (deletecount) {
				this.visibleData.splice(idx + 1, deletecount);
				this.treeBox.rowCountChanged(idx + 1, -deletecount);
			}
		} else {
			this.visibleData[idx][2]=true;
			var currentLevel=this.visibleData[idx][1];
			var toinsert = this.childData(idx);
			var empty;
			for (var i = 0; i < toinsert.length; i++) {
				empty=isEmpty(toinsert[i].path);
				this.visibleData.splice(idx + i + 1, 0, [toinsert[i].path,(currentLevel+1), false,toinsert[i].leafName,empty,toinsert[i].isHidden()]);
			}
			this.treeBox.rowCountChanged(idx + 1, toinsert.length);
		}
	},
	getImageSrc: function(idx, column) {
		var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
		if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
		aFolder.initWithPath(this.visibleData[idx][0]);
		return "moz-icon:file://"+aFolder.path+'?size=16';/*return null;*/ 
	},
	getProgressMode : function(idx,column) {},
	getCellValue: function(idx, column) {},
	cycleHeader: function(col, elem) {},
	//selectionChanged: function() {},
	selectionChanged: function() {
		var currentElement=this.getSelectedElement(this.selection.currentIndex);
		var doc=selectedTabDocument().wrappedJSObject;
		
		var addressElement=doc.getElementById('firefly_addresbox');
		addressElement.value=currentElement[0];
		var deckElement=doc.getElementById('containing_deck');
		var currentSubwindow=doc.getElementById(deckElement.getAttribute('currentSubwindow'));
		currentSubwindow.path=currentElement[0];
		currentSubwindow.refresh();
	},
	cycleCell: function(idx, column) {},
	performAction: function(path) {
		var searchedIndex=0;
		
		var length=this.visibleData.length;
		var i=0;
		//for (var i=0;i<length;i++) {
		while(length>i) {
			path1=this.visibleData[i][0];
			if (path1.toLowerCase()==path.toLowerCase()) {
				searchedIndex=i;
				break;
			} else if (path.toLowerCase().indexOf(path1.toLowerCase())!=-1) {
					if (!this.isContainerEmpty(i) && !this.isContainerOpen(i)) {
						this.toggleOpenState(i);
						length=this.visibleData.length;
					}
			} else {
				searchedIndex=-1;
			}
			i++;
		}
		
		this.selection.select(searchedIndex);
		dump('\r\n');
		
	},
	performActionOnCell: function(action, index, column) {},
	performActionOnRow: function (action, row) {},
	getRowProperties: function(idx, column, prop) {},
	getCellProperties: function(idx, column, prop) {
		var aserv=Components.classes["@mozilla.org/atom-service;1"].getService(Components.interfaces.nsIAtomService);
		if (this.visibleData[idx][5]) {
			prop.AppendElement(aserv.getAtom('hidden'));
		}
	},
	getColumnProperties: function(column, element, prop) {}
};
function selectedTabDocument() {
	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
	var win = wm.getMostRecentWindow('navigator:browser');
	var gBrowser=win.gBrowser;
	return gBrowser.getBrowserAtIndex(gBrowser.mTabContainer.selectedIndex).contentDocument;
}
function nameSort(el1,el2) {
	var sortDir='asc'
	if (el1.leafName.toUpperCase()>el2.leafName.toUpperCase()) {
		return 1;
	} else if (el2.leafName.toUpperCase()>el1.leafName.toUpperCase()) {
		return -1;
	} else {
		return 0;
	}
}
function init() {
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var starterString=prefs.getCharPref('extensions.firefly.tree_options');
	var tempArray=starterString.split('|');
	var leafName='';
	for (var i=0;i<tempArray.length;i++) {
	
		var path=tempArray[i];
		var pos=path.lastIndexOf('\\');
		var pos2=path.lastIndexOf('/');
		if (pos!=-1) {
			leafName=path.slice(pos+1);
		} else if (pos2!=-1) {
			leafName=path.slice(pos2+1);
		} else {
			leafName=tempArray[i];
		}
		
		var empty=isEmpty(path);
		
						/*	path	,	level	,	open	,	name	,	has children	,	hidden	*/		
		starterArray[i]=new Array(tempArray[i],0,false,leafName,empty,false);
	}
	//dump(starterArray+'\r\n');
	document.getElementById("elementList").view = treeView;
}

function isEmpty(path) {
	//var path=this.visibleData[idx][0];
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	aFolder.initWithPath(path);
	try {
		var folderEntries=aFolder.directoryEntries;
	} catch (err) {
		return true;
	}
	while (folderEntries.hasMoreElements()) {
		var next=folderEntries.getNext().QueryInterface(Components.interfaces.nsILocalFile);
		if (next.isDirectory()) {
			return false;
		}
	}
	return true;
}
function folderClicked(event) {
	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
	var win = wm.getMostRecentWindow('navigator:browser');
	var gBrowser=win.gBrowser;
	if ((gBrowser.currentURI.prePath+gBrowser.currentURI.path)!="chrome://firefly/content/firefly.xul") {
		var newTab = gBrowser.addTab(XUL_FILE);
		newTab.setAttribute(APP_NAME, 'true');
		newTab.setAttribute('class','tabbrowser-tab');
		newTab.label = APP_NAME;
		gBrowser.selectedTab = newTab;
		
		//var doc=newTab.contentDocument;//gBrowser.getBrowserAtIndex(gBrowser.mTabContainer.selectedIndex).contentDocument;
		//alert(doc);
	}
	setTimeout("document.getElementById('elementList').view.selectionChanged()",500);
	//event.target.parentNode.view.selectionChanged();
}
function pausecomp(millis) {
	date = new Date();
	var curDate = null;
	do { 
		var curDate = new Date(); }
	while(curDate-date < millis);
} 
function debug(aMsg) {
	setTimeout(function() { throw new Error("[debug] " + aMsg); }, 0);
}
function eraseContent(el) {		// erases all children of a tag
	var cycles=el.childNodes.length;
	for (var p=0;p<cycles;p++) {
		el.removeChild(el.childNodes[0]);
	}
}