const XUL_FILE = "chrome://firefly/content/firefly.xul"
const APP_NAME = "Firefly"
var idNum=1;
var the_timeout;
var dirSize;
var dirName;
var mode=Array('tree','list','tiles','thumbnails');
Array.prototype.inArray = function (value) {
// Returns true if the passed value is found in the
// array.  Returns false if it is not.
    var i;
    for (i=0; i < this.length; i++) {
        // Matches identical (===), not just similar (==).
        if (this[i] === value) {
            return true;
        }
    }
    return false;
}

function newSampleTab() {			// creating the new tab that will host Firefly
	var newTab = gBrowser.addTab(XUL_FILE);
	newTab.setAttribute(APP_NAME, 'true');
	newTab.setAttribute('class','tabbrowser-tab');
	newTab.label = APP_NAME;
	getBrowser().selectedTab = newTab;
}

function openTreeSidebar() {	// opens the sidebar with the directory tree in it
	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
	var win = wm.getMostRecentWindow('navigator:browser');
	win.toggleSidebar('viewFoldersSidebar');
}

function nameSort(el1,el2) {
	if (getCurrent()) {
		var sortDir=getCurrent().getAttribute('sortDir');
	} else {
		var sortDir='asc'
	}
	if (el1.leafName.toUpperCase()>el2.leafName.toUpperCase()) {
		if (sortDir=='asc') {
			return -1;
		} else {
			return 1;
		}
	} else if (el2.leafName.toUpperCase()>el1.leafName.toUpperCase()) {
		if (sortDir=='asc') {
			return 1;
		} else {
			return -1;
		}
	} else {
		return 0;
	}
}
function extSort(el1,el2) {
	if (getCurrent()) {
		var sortDir=getCurrent().getAttribute('sortDir');
	} else {
		var sortDir='asc'
	}
	el1Ext=el1.leafName.substring(el1.leafName.lastIndexOf('.')+1).toUpperCase();
	el2Ext=el2.leafName.substring(el2.leafName.lastIndexOf('.')+1).toUpperCase();
	if (el1Ext>el2Ext) {
		if (sortDir=='asc') {
			return 1;
		} else {
			return -1;
		}
	} else if (el2Ext>el1Ext) {
		if (sortDir=='asc') {
			return -1;
		} else {
			return 1;
		}
	} else {
		return 0;
	}
}
function sizeSort(el1,el2) {
	if (getCurrent()) {
		var sortDir=getCurrent().getAttribute('sortDir');
	} else {
		var sortDir='asc'
	}
	if (el1.fileSize>el2.fileSize) {
		if (sortDir=='asc') {
			return 1;
		} else {
			return -1;
		}
	} else if (el2.fileSize>el1.fileSize) {
		if (sortDir=='asc') {
			return -1;
		} else {
			return 1;
		}
	} else {
		return 0;
	}
}
function dateSort(el1,el2) {
	if (getCurrent()) {
		var sortDir=getCurrent().getAttribute('sortDir');
	} else {
		var sortDir='asc'
	}
	if (el1.lastModifiedTime>el2.lastModifiedTime) {
		if (sortDir=='asc') {
			return 1;
		} else {
			return -1;
		}
	} else if (el2.lastModifiedTime>el1.lastModifiedTime) {
		if (sortDir=='asc') {
			return -1;
		} else {
			return 1;
		}
	} else {
		return 0;
	}
}

function getFiles(path,useSort) {			// gets the files from a directory
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var showHiddenFiles=prefs.getBoolPref('extensions.firefly.hidden_files');

	var filter=getCurrent().getAttribute('filter');
	if (!prefs.getBoolPref('extensions.firefly.regex_filter')) {
		// convert *.* and similar to a valid regular expression
		var s='';
		s+='^';
		for (var i = 0; i<filter.length; i++) {
		    var c = filter.charAt(i);
		    switch(c) {
			case '*':
			    s+=".*";
			    break;
			case '?':
			    s+=".";
			    break;
			    // escape special regexp-characters
			case '(': case ')': case '[': case ']': case '$':
			case '^': case '.': case '{': case '}': case '|':
			case '\\':
			    s+="\\";
			    s+=c;
			    break;
			default:
			    s+=c;
			    break;
		    }
		}
		s+='$';
		filter=s;
	}
	if (filter=='' || filter=='^$') {
		filter='^.*$';
	}
	var filesANDdirs=new Array();
	var files=new Array();
	var dirs=new Array();
	var next;
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	aFolder.initWithPath(path);
	var folderEntries=aFolder.directoryEntries;
	while (folderEntries.hasMoreElements()) {
		next=folderEntries.getNext().QueryInterface(Components.interfaces.nsILocalFile);

		if (next.leafName.toLowerCase().match(filter.toLowerCase())) {

			if ((next.isHidden() && showHiddenFiles) || (!next.isHidden())) {
				if (next.isDirectory()) {
					dirs.push(next);
				} else {
					files.push(next);
				}
			}

		}
	}
	
	if (useSort==null) {
		var sortBy=getCurrent().getAttribute('sortby');
	} else {
		var sortBy=useSort;
	}
	switch (sortBy) {
	 	case 'name':
			dirs.sort(nameSort);
			files.sort(nameSort);
	 		break;
		case 'extension':
			dirs.sort(nameSort);
			files.sort(extSort);
			break;
		case 'size':
			dirs.sort(nameSort);
			files.sort(sizeSort);
			break;
		case 'date':
			dirs.sort(dateSort);
			files.sort(dateSort);
			break;
		default :
			dirs.sort(nameSort);
			files.sort(nameSort);
			break;
	}
	
				// sorted dirs
	
	filesANDdirs=Array.concat(dirs,files);
	/*for (var i=0;i<dirs.length;i++) {
		alert(dirs[i].leafName);
	}*/
	return filesANDdirs;
}



function eraseContent(el) {		// erases all children of a tag
	var cycles=el.childNodes.length;
	for (var p=0;p<cycles;p++) {
		el.removeChild(el.childNodes[0]);
	}
}

function setUpHoveredElement(el) {		// sets the file path to an attribute of the tooltip
	var tooltipEl=document.getElementById('fileInfo');
	var path=getCurrent().path;
	var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFile) aFile.QueryInterface(Components.interfaces.nsILocalFile);
	aFile.initWithPath(path);
	aFile.append(el.firstChild.nextSibling.value);
	tooltipEl.setAttribute('filePath',aFile.path);
}


function treeMouseover(event,tree) {
	var tooltipEl=document.getElementById('fileInfo');
	var row=tree.boxObject.getRowAt(event.clientX,event.clientY);
	if (row!=-1) {
		var path=tree.parentNode.parentNode.parentNode.getAttribute('path');
		var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();
		if (aFile) aFile.QueryInterface(Components.interfaces.nsILocalFile);
		aFile.initWithPath(path);
		aFile.append(tree.view.getCellText(row,tree.columns['treename']));
		tooltipEl.setAttribute('filePath',aFile.path);
	} else {
		tooltipEl.setAttribute('filePath','');
	}
//	window.status=path;
}


function createTooltip(el) {		// creates the content of the tooltip takin the path from the attribute
	var path=el.getAttribute('filePath');
	if (path!='') {
		var newDescription;
		var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();
		if (aFile) aFile.QueryInterface(Components.interfaces.nsILocalFile);
		aFile.initWithPath(path);
		var extension=aFile.leafName.substring(aFile.leafName.lastIndexOf('.')+1).toLowerCase();
		
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
		var MOVIE_TYPES=prefs.getCharPref('extensions.firefly.movie_types').toLowerCase();
		var MUSIC_TYPES=prefs.getCharPref('extensions.firefly.music_types').toLowerCase();
		var IMAGE_TYPES=prefs.getCharPref('extensions.firefly.image_types').toLowerCase();
		
		var filePath='file://'+aFile.path;
		if (IMAGE_TYPES.indexOf(extension)!=-1) {						// if the File is an Image File the Image will be shown else the icon
			/*var newImg=new Image();
			newImg.src=filePath;
			var width=newImg.width;
			var height=newImg.height;
			var aspectRatio=width/height;
			var newH=Math.ceil(200/aspectRatio);*/
			var newImage=document.createElement('image');
			newImage.setAttribute('flex','1');
			newImage.setAttribute('src',filePath);
			//newImage.setAttribute('style','max-width:200px;max-height:200px;');
			el.appendChild(newImage);		
		}
		if (MOVIE_TYPES.indexOf(extension)!=-1 && pluginExists('VLC multimedia plugin')) {
			var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
			var autoPlayFiles=prefs.getBoolPref('extensions.firefly.auto_play');
			if (autoPlayFiles) {
				var newMovie=document.createElementNS('http://www.w3.org/1999/xhtml','embed');
				newMovie.setAttribute('type','application/x-vlc-plugin');
				newMovie.setAttribute('id','tooltipVideo');
				//newMovie.setAttribute('autoplay','true');
				newMovie.setAttribute('width','400');
				newMovie.setAttribute('height','300');
				newMovie.setAttribute('src',filePath);
				newMovie.setAttribute('loop','yes');
				el.appendChild(newMovie);
				document.getElementById('firefly_addresbox').focus();
				document.getElementById('fileInfo').focus();
				document.getElementById('tooltipVideo').play();
				
				
				/*document.getElementById('tooltipVideo').set_str_variable('sub-autodetect-path','.');
				document.getElementById('tooltipVideo').set_bool_variable('sub-autodetect-file',true);
				document.getElementById('tooltipVideo').set_int_variable('sub-track','1');*/ // subtitles how to make them work ???
				
				
				var newProgress=document.createElement('progressmeter');
				newProgress.setAttribute('id','tooltipProgress');
				newProgress.setAttribute('style','width:400px;');
				el.appendChild(newProgress);
				doTimer();
			}
		}
		if (MUSIC_TYPES.indexOf(extension)!=-1 && pluginExists('VLC multimedia plugin')) {
			var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
			var autoPlayFiles=prefs.getBoolPref('extensions.firefly.auto_play');
			if (autoPlayFiles) {
				var newMusic=document.createElementNS('http://www.w3.org/1999/xhtml','embed');
				newMusic.setAttribute('type','application/x-vlc-plugin');
				newMusic.setAttribute('id','tooltipVideo');
				//newMusic.setAttribute('autoplay','true');
				newMusic.setAttribute('width','0');
				newMusic.setAttribute('height','0');
				newMusic.setAttribute('src',filePath);
				newMusic.setAttribute('loop','yes');
				el.appendChild(newMusic);
				document.getElementById('firefly_addresbox').focus();
				document.getElementById('fileInfo').focus();
				document.getElementById('tooltipVideo').play();
				var newProgress=document.createElement('progressmeter');
				newProgress.setAttribute('id','tooltipProgress');
				el.appendChild(newProgress);
				doTimer();
			}
		}

		var newBox=document.createElement('vbox');
		
		newDescription=document.createElement('description');
		newDescription.setAttribute('value','Name: '+aFile.leafName);
		newBox.appendChild(newDescription);
		newDescription=document.createElement('description');
		newDescription.id='tooltipPath';
		newDescription.setAttribute('value','Path: '+aFile.path);
		newBox.appendChild(newDescription);
		el.setAttribute('currentPath',aFile.path);

		if (aFile.isDirectory() && prefs.getBoolPref('extensions.firefly.calculate_dir_size')) {
			dirSize=0;
			/*dirSizeCalc(aFile.path);*/
			
		} else {
			dirSize=aFile.fileSize;
		}
		
		newDescription=document.createElement('description');
		newDescription.setAttribute('id','fileSize');
		newDescription.setAttribute('size',dirSize);
		newDescription.setAttribute('value','Size: '+Math.ceil(dirSize/1024)+' kB');
		newBox.appendChild(newDescription);
		
		el.appendChild(newBox);
		if (aFile.isDirectory() && prefs.getBoolPref('extensions.firefly.calculate_dir_size')) {
			dirSizeCalc(aFile.path,0);
		}
	}
}

function split(el,direction) {
	var parent=el.parentNode;
	var splittedBox=el;
	var newBox=null;
	var newSplit=null;
	var newEl=null;
	// saving properties before cloning
	var path=splittedBox.getAttribute('path');				//getPath(document.getAnonymousNodes(splittedBox)[0].firstChild);
	var deckValue=splittedBox.getAttribute('deck');		//document.getAnonymousNodes(splittedBox)[0].firstChild.nextSibling.getAttribute('selectedIndex');
	// end saving
	if (direction=='horizontal') {
		newBox=document.createElement('hbox');
	} else if (direction=='vertical') {
		newBox=document.createElement('vbox');
	}
	newBox.setAttribute('flex',1);
	newSplit=document.createElement('splitter');
	newEl=document.createElement('box');

	newEl.setAttribute('deck',deckValue);
	newEl.setAttribute('path',path);
	newEl.setAttribute('persist','path deck width height');

	newEl.setAttribute('class','filebox');
	newEl.setAttribute('flex',1);
	idNum++;
	newEl.setAttribute('id','id'+idNum);
	newEl.setAttribute('onfocus',"focus_tasks(this);");
	newEl.setAttribute('onclick','unfoldTree(this)');
	newEl.setAttribute('changeDeck',"setDeck(1,document.getElementById('containing_deck'));");
	parent.insertBefore(newBox,splittedBox.nextSibling);
	newBox.appendChild(splittedBox);
	newBox.appendChild(newSplit);
	newBox.appendChild(newEl);
}

function close_split(el) {
	var parent=el.parentNode;
	var toRemove=el;
	var idToStay;
	var path;
	var deck;
	var parentParent=parent.parentNode;
	if (toRemove.id!='firstBox') {
		if (toRemove.previousSibling!=null) {
			parent.removeChild(toRemove.previousSibling);
			parentParent.insertBefore(toRemove.previousSibling,parent.nextSibling);
		} else if (toRemove.nextSibling!=null) {
			parent.removeChild(toRemove.nextSibling);
			parentParent.insertBefore(toRemove.nextSibling,parent.nextSibling);
		}
		//dump('aaa');
		parent.removeChild(toRemove);
		parentParent.removeChild(parent);
	}
}

function setDeck(index,el) {
	el.setAttribute("selectedIndex",index);
	if (el.id!='containing_deck'){
		el.parentNode.setAttribute('deck',index);
		el.parentNode.refresh();
	} else {
		if (index==1) {
			getContent(el);
		} else {
			setContent(el);
		}
	}
}

function getContent(el) {
	var currentSubwindow=el.getAttribute('currentSubwindow');
	var pathValue=document.getElementById(currentSubwindow).getAttribute('path');
	var deckValue=document.getElementById(currentSubwindow).getAttribute('deck');
	el.firstChild.nextSibling.setAttribute('path',pathValue);
	el.firstChild.nextSibling.setAttribute('deck',deckValue);
	el.firstChild.nextSibling.refresh();
}

function setContent(el) {
	var currentSubwindow=el.getAttribute('currentSubwindow');
	var pathValue=el.firstChild.nextSibling.getAttribute('path');
	var deckValue=el.firstChild.nextSibling.getAttribute('deck');
	document.getElementById(currentSubwindow).setAttribute('path',pathValue);
	document.getElementById(currentSubwindow).setAttribute('deck',deckValue);
	document.getElementById(currentSubwindow).refresh();
}
function focus_tasks(el) {
	var oldEl=document.getElementById('containing_deck').getAttribute('currentSubwindow');
	//dump("oldEl="+oldEl+"\n");
	
	
	var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFile) aFile.QueryInterface(Components.interfaces.nsILocalFile);
	aFile.initWithPath(el.path);
	var diskSpaceAvailable=aFile.diskSpaceAvailable;
	if ((diskSpaceAvailable/1024)<1024) {
		var space=Math.ceil(aFile.diskSpaceAvailable/1024);
		var statusMessage=space+' KB free';
	} else if (((diskSpaceAvailable/1024)/1024)<1024) {
		var space=((aFile.diskSpaceAvailable/1024)/1024);
		var statusMessage=space.toFixed(2)+' MB free';
	} else {
		var space=(((aFile.diskSpaceAvailable/1024)/1024)/1024);
		var statusMessage=space.toFixed(2)+' GB free';
	}
	window.status=statusMessage;
	
	
	document.getElementById('firefly_addresbox').value=el.path;
	document.getElementById('containing_deck').setAttribute('currentSubwindow',el.id);
	if (document.getElementById(oldEl)) document.getElementById(oldEl).setAttribute('style','border:2px solid grey;');
	el.setAttribute('style','border:2px solid black;');
	unfoldTree(el);
}
function unfoldTree(el) {
	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
	var win = wm.getMostRecentWindow('navigator:browser');
	var a = win.document.getElementById("sidebar-box");
	
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var auto_open_sidebar=prefs.getBoolPref('extensions.firefly.auto_open_sidebar');
	if (auto_open_sidebar) {
		if (a.hidden) win.toggleSidebar('viewFoldersSidebar');
	}
	var tree=win.document.getElementById('sidebar').contentDocument.getElementById('elementList');
	var path=document.getElementById('firefly_addresbox').value;
	tree.view.performAction(path);
}
function refreshMenu(el) {
	var deckValue=document.getElementById(document.getElementById('containing_deck').getAttribute('currentSubwindow')).deck;
	for (var i=0;i<el.childNodes.length;i++) {
		if (i==5) {
			if (!pluginExists('PCMan\'s IE Tab Plug-in for Mozilla/Firefox')){
				el.childNodes[i].setAttribute('disabled','true');
			}
		}
		if (i==deckValue) {
			el.childNodes[i].setAttribute('checked',true);
		} else {
			el.childNodes[i].setAttribute('checked',false);
		}
	}
}
function fullscreen() {
	var deck=document.getElementById('containing_deck');
	if (deck.selectedIndex==0 || deck.selectedIndex=="") {
		setDeck(1,deck);
		document.getElementById('firefly_splith').hidden=true;
		document.getElementById('firefly_splitv').hidden=true;
		document.getElementById('firefly_close').hidden=true;
		document.getElementById('firefly_fullscreen').setAttribute('style',"list-style-image: url('chrome://firefly/skin/from_fullscreen-20.gif');-moz-image-region: rect(0px 18px 20px -3px);");
	} else {
		setDeck(0,deck);		
		document.getElementById('firefly_splith').hidden=false;
		document.getElementById('firefly_splitv').hidden=false;
		document.getElementById('firefly_close').hidden=false;
		document.getElementById('firefly_fullscreen').setAttribute('style',"list-style-image: url('chrome://firefly/skin/to_fullscreen-20.gif');-moz-image-region: rect(0px 18px 20px -3px);");
	}
}
function getCurrent() {
	return document.getElementById(document.getElementById('containing_deck').getAttribute('currentSubwindow'));
}

function doTimer() {
	var progress=Math.ceil(((document.getElementById('tooltipVideo').get_time())/(document.getElementById('tooltipVideo').get_length()))*100);
	document.getElementById('tooltipProgress').setAttribute('value',progress);
	the_timeout = setTimeout("doTimer();", 1000);
}

function sortby(what) {
	getCurrent().setAttribute('sortby',what);
	var sortDir=getCurrent().getAttribute('sortDir');
	if (sortDir=='' || sortDir=='desc') {
		getCurrent().setAttribute('sortDir','asc');
	} else {
		getCurrent().setAttribute('sortDir','desc');
	}
	getCurrent().refresh();
}

function doMetronome() {
	/*var currentTick=document.getElementById('metronome').getAttribute('tick');
	if (currentTick=='1') {
		document.getElementById('metronome').setAttribute('tick','0');
	} else {
		document.getElementById('metronome').setAttribute('tick','1');
	}*/
	
}

function createFile(type) {
	var path=getCurrent().path;
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	aFolder.initWithPath(path);
	if (type==0) {
		aFolder.append('New file');
		aFolder.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0664);
	} else {
		aFolder.append('New folder');
		aFolder.createUnique(Components.interfaces.nsIFile.DIRECTORY_TYPE, 0664);
	}
	getCurrent().refresh();
}

function fileDelete() {
	var path=getCurrent().path;
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	//aFolder.initWithPath(path);
	//aFolder.append(document.getElementById('filePopup').getAttribute('name'));
	//aFolder.remove(true);
	var filesToDelete=getCurrent().selectedFiles;
	var message='Delete these?\r\n';
	for (var i=0;i<filesToDelete.length;i++) {
		message+=filesToDelete[i]+'\r\n';
	}
	if(confirm(message)) {
		if (filesToDelete.length>0) {
			for (var i=0;i<filesToDelete.length;i++) {
				aFolder.initWithPath(path);
				aFolder.append(filesToDelete[i]);
				aFolder.remove(true);
			}
		}
	}
	
	getCurrent().refresh();
}
function fileRename() {
	var path=getCurrent().path;
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	aFolder.initWithPath(path);
	aFolder.append(document.getElementById('filePopup').getAttribute('name'));
	
	window.openDialog('chrome://firefly/content/renameDialog.xul',"showmore","chrome,modal",aFolder);
}

function dirSizeCalc(dir,multiplier) {
	var sizeDesc=document.getElementById('fileSize');
	
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	var dirScanInterval=prefs.getIntPref('extensions.firefly.dir_scan_interval');
	var dirs=new Array();
	var files=new Array();
	var next;
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	aFolder.initWithPath(dir);
	var folderEntries=aFolder.directoryEntries;
	while (folderEntries.hasMoreElements()) {
		next=folderEntries.getNext().QueryInterface(Components.interfaces.nsILocalFile);
		if (next.isDirectory()) {
			dirs.push(next);
		} else {
			files.push(next);
		}
	}
	dirs.sort(nameSort);
	files.sort(nameSort);
	var filesANDdirs=Array.concat(dirs,files);
	multiplier++;
	for (var i=0;i<filesANDdirs.length;i++) {
		if (filesANDdirs[i].isDirectory()) {
			dirName=filesANDdirs[i].path;
			dirName=dirName.replace(/\\/g,'\\\\');
			setTimeout('dirSizeCalc("'+dirName+'",'+multiplier+')',(multiplier+i)*dirScanInterval);
		} else {
			try {
				sizeDesc.setAttribute('size',(Math.ceil(sizeDesc.getAttribute('size'))+Math.ceil(filesANDdirs[i].fileSize)));
				//debug(sizeDesc.getAttribute('size'));
				sizeDesc.value='Size: '+Math.ceil(sizeDesc.getAttribute('size')/1024).toLocaleString()+' kB';
			} catch (e) {
				return null;
			}
		}
	}
	return null;
}

function checkPopup(event) {
	var deck=getCurrent().deck;
	if (deck==0) {
		var treeElement=event.rangeParent;
		var row = new Object();
		var col = new Object();
		var childElement = new Object();
		if (treeElement && treeElement.treeBoxObject) {
			treeElement.treeBoxObject.getCellAt(event.clientX, event.clientY, row, col, childElement);
			if (row.value==-1) {
				setTimeout('document.getElementById("filePopup").hidePopup()',1);
				document.getElementById('contextPopup').showPopup(event.target,-1,-1,'context');
			} else {
				
			}
		}
	}
}
function showSendTo(menu) {
	var newSubMenu;
	//var menu=document.getElementById('sendToMenu');
	
	eraseContent(menu);
	
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	//dump('\r\n'+prefs+'\r\n');
	//prefs = prefs.getBranch("extensions.firefly.");
	var openWithVal=prefs.getCharPref('extensions.firefly.send_to_string');

	var openWithArray=new Array();
	openWithArray=openWithVal.split('|');
	for (var i=0;i<openWithArray.length;i++) {
		newSubMenu=document.createElement('menuitem');
		newSubMenu.setAttribute('label',openWithArray[i]);
		menu.appendChild(newSubMenu);
	}
	menu.appendChild(document.createElement('menuseparator'));
	newSubMenu=document.createElement('menuitem');
	newSubMenu.setAttribute('label','Choose...');
	newSubMenu.setAttribute('id','chooseDir');
	menu.appendChild(newSubMenu);
}
function sendTo(event) {
	var target=event.target;
	//here will be the sending to code after i make copy/paste work
	if (target.id=='chooseDir') {
		var nsIFilePicker = Components.interfaces.nsIFilePicker;
		var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
		fp.init(window, "Select a Folder", nsIFilePicker.modeGetFolder);//#  Available modes: modeOpen, modeSave, modeGetFolder, modeOpenMultiple.
		
		
		var res = fp.show();
		if (res == nsIFilePicker.returnOK){
			var file = fp.file;
		}
	} else {
		var file = Components.classes["@mozilla.org/file/local;1"]
			     .createInstance(Components.interfaces.nsILocalFile);
		file.initWithPath(target.label);
	}
	if (file) {
		copyFiles();
		pasteFiles(file.path);
	}
}
function openWith(event) {
	var target=event.target;
	
	if (target.id=='chooseApp') {
		var nsIFilePicker = Components.interfaces.nsIFilePicker;
		var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
		fp.init(window, "Select a File", nsIFilePicker.modeOpen);//#  Available modes: modeOpen, modeSave, modeGetFolder, modeOpenMultiple.
		fp.appendFilters(nsIFilePicker.filterApps);//# Available filters: filterAll, filterHTML, filterText, filterImages, filterXML, filterXUL, filterApps. 
		fp.filterIndex=nsIFilePicker.filterApps;
		
		var res = fp.show();
		if (res == nsIFilePicker.returnOK){
			var file = fp.file;
		}
	} else {
		var file = Components.classes["@mozilla.org/file/local;1"]
			     .createInstance(Components.interfaces.nsILocalFile);
		file.initWithPath(target.label);
	}
	if (file) {
		// create an nsIProcess
		var process = Components.classes["@mozilla.org/process/util;1"]
					.createInstance(Components.interfaces.nsIProcess);
		process.init(file);

		var path=getCurrent().path;
		var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
		if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
		aFolder.initWithPath(path);
		aFolder.append(document.getElementById('filePopup').getAttribute('name'));

		// Run the process.
		// If first param is true, calling process will be blocked until
		// called process terminates. 
		// Second and third params are used to pass command-line arguments
		// to the process.
		var args = [aFolder.path];
		process.run(false, args, args.length);
	}
}
function showOpenWith() {
	var newSubMenu;
	var menu=document.getElementById('openWithMenu');
	
	eraseContent(menu);
	
	var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
	//dump('\r\n'+prefs+'\r\n');
	//prefs = prefs.getBranch("extensions.firefly.");
	var openWithVal=prefs.getCharPref('extensions.firefly.open_with_string');

	var openWithArray=new Array();
	openWithArray=openWithVal.split('|');
	for (var i=0;i<openWithArray.length;i++) {
		newSubMenu=document.createElement('menuitem');
		newSubMenu.setAttribute('label',openWithArray[i]);
		menu.appendChild(newSubMenu);
	}
	menu.appendChild(document.createElement('menuseparator'));
	newSubMenu=document.createElement('menuitem');
	newSubMenu.setAttribute('label','Choose...');
	newSubMenu.setAttribute('id','chooseApp');
	menu.appendChild(newSubMenu);
}
function createShortcut() {
	var path=getCurrent().path;
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	aFolder.initWithPath(path);
	aFolder.append(document.getElementById('filePopup').getAttribute('name'));
	//aFolder.
}
function showProperties() {
	var path=getCurrent().path;
	var aFolder = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFolder) aFolder.QueryInterface(Components.interfaces.nsILocalFile);
	aFolder.initWithPath(path);
	aFolder.append(document.getElementById('filePopup').getAttribute('name'));
	
	window.openDialog('chrome://firefly/content/fileProperties.xul',"showmore","chrome",aFolder);
}
function pluginExists(pluginName) {
	var plugins=navigator.plugins;
	for (var i=0;i<plugins.length;i++) {
		if (plugins[i].name==pluginName) {
			return true;
		}
	}
	return false;
}
function doFilter(value,add) {
	if (add) {
		var FormHistory = Components.classes["@mozilla.org/satchel/form-history;1"].getService(Components.interfaces.nsIFormHistory);
		if (!FormHistory.entryExists('firefly_filter',value)) {
			FormHistory.addEntry('firefly_filter',value);
		}
	}
	getCurrent().setAttribute('filter',value);
	getCurrent().refresh();
}
function debug(aMsg) {
	setTimeout(function() { throw new Error("[debug] " + aMsg); }, 0);
}
function copyFiles() {
	document.getElementById('containing_deck').setAttribute('copiedFiles',getCurrent().selectedFiles);
	document.getElementById('containing_deck').setAttribute('sourceDir',getCurrent().path);
	document.getElementById('containing_deck').setAttribute('operation','copy');
	document.getElementById('cmd_paste').setAttribute('disabled',false);
}
function cutFiles() {
	document.getElementById('containing_deck').setAttribute('copiedFiles',getCurrent().selectedFiles);
	document.getElementById('containing_deck').setAttribute('sourceDir',getCurrent().path);
	document.getElementById('containing_deck').setAttribute('operation','cut');
	document.getElementById('cmd_paste').setAttribute('disabled',false);
}
function pasteFiles(destinationDir) {
	if (destinationDir=='') {
		destinationDir=getCurrent().path;
	} 
	var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].getService(Components.interfaces.nsIWindowMediator);
	var win = wm.getMostRecentWindow('navigator:browser');
	//alert(win.document.getElementById('status-bar'));
	var mainDoc=win.document;
	var transferSpacer=mainDoc.createElement('label');
	transferSpacer.setAttribute('class','hiddenTransfer');
	
	transferSpacer.sourceDir=document.getElementById('containing_deck').getAttribute('sourceDir');
	transferSpacer.destinationDir=destinationDir;
	transferSpacer.operation=document.getElementById('containing_deck').getAttribute('operation');
	transferSpacer.filesAndDirs=document.getElementById('containing_deck').getAttribute('copiedFiles');
	
	document.getElementById('containing_deck').setAttribute('sourceDir','');
	document.getElementById('containing_deck').setAttribute('operation','');
	document.getElementById('containing_deck').setAttribute('copiedFiles','');
	
	win.document.getElementById('fireflyTransferStatus').appendChild(transferSpacer);
	document.getElementById('cmd_paste').setAttribute('disabled',true);
}

/*
function readFromStream(file,listener,newPath,transferEl){
	try {

		var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();
		if (aFile) aFile.QueryInterface(Components.interfaces.nsILocalFile);
		aFile.initWithPath(file);
		//aFile.initWithNativePath(file);

		var inStream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance( Components.interfaces.nsIFileInputStream );
		inStream.init(aFile,0x01, 00004, null);

		var transportService =Components.classes["@mozilla.org/network/stream-transport-service;1"].getService(Components.interfaces.nsIStreamTransportService);
		//var transport = transportService.createInputTransport(inStream,pos,1024,true);
		var transport = transportService.createInputTransport(inStream,-1,-1,true);

		var stream = transport.openInputStream(0,0,0);

		//var instream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);
		//instream.init(stream);
		var instream = Components.classes["@mozilla.org/binaryinputstream;1"].createInstance(Components.interfaces.nsIBinaryInputStream);
		instream.setInputStream (stream);
		
		var dataListener = {
			data : '',
			onStartRequest: function(request, context){},
			onStopRequest: function(request, context, status){
				instream.close();
				//outstream.close();
				listener.finished(this.data,context);
			},
			onDataAvailable: function(request, context, inputStream, offset, count){
				//this.data += instream.read(count);
				this.data=instream.readBytes(count);
				writeFile(newPath,this.data);
			}
		};

		var pump = Components.classes["@mozilla.org/network/input-stream-pump;1"].createInstance(Components.interfaces.nsIInputStreamPump);
		pump.init(stream, -1, -1, 0, 0, false);
		pump.asyncRead(dataListener,transferEl);
		//instream.close();
	} catch (ex){
		return ex;
	}
	return null;
}

function writeFile(path,data) {
	var aFile = Components.classes["@mozilla.org/file/local;1"].createInstance();
	if (aFile) aFile.QueryInterface(Components.interfaces.nsILocalFile);
	aFile.initWithPath(path);
	//aFile.initWithNativePath(path);
	
	var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);

	var outstream = Components.classes["@mozilla.org/binaryoutputstream;1"].createInstance(Components.interfaces.nsIBinaryOutputStream);
	outstream.setOutputStream (foStream);

	// use 0x02 | 0x10 to open file for appending.
	foStream.init(aFile, 0x02 | 0x10, 0664, 0); // write, append
	//foStream.write(data, data.length);
	outstream.writeBytes(data, data.length);
	foStream.close();
}*/